/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public abstract class WLDeploymentConfiguration
implements DeploymentConfiguration {
    protected DeployableObject deplObj;
    protected DataObject dataObject;

    public WLDeploymentConfiguration(DeployableObject deplObj) {
        this.deplObj = deplObj;
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    public DeployableObject getDeployableObject() {
        return this.deplObj;
    }

    public DConfigBeanRoot getDConfigBeanRoot(DDBeanRoot dDBeanRoot) throws ConfigurationException {
        return null;
    }

    public void removeDConfigBean(DConfigBeanRoot dConfigBeanRoot) throws BeanNotFoundException {
        throw new BeanNotFoundException("bean not found " + dConfigBeanRoot);
    }

    public void restore(InputStream is) throws ConfigurationException {
    }

    public DConfigBeanRoot restoreDConfigBean(InputStream is, DDBeanRoot dDBeanRoot) throws ConfigurationException {
        return null;
    }

    public void saveDConfigBean(OutputStream os, DConfigBeanRoot dConfigBeanRoot) throws ConfigurationException {
    }

    protected void writefile(final File file, final BaseBean bean) throws ConfigurationException {
        try {
            FileObject cfolder = FileUtil.toFileObject((File)file.getParentFile());
            if (cfolder == null) {
                File parentFile = file.getParentFile();
                try {
                    cfolder = FileUtil.toFileObject((File)parentFile.getParentFile()).createFolder(parentFile.getName());
                }
                catch (IOException ioe) {
                    throw new ConfigurationException(NbBundle.getMessage(WLDeploymentConfiguration.class, (String)"MSG_FailedToCreateConfigFolder", (Object)parentFile.getAbsolutePath()));
                }
            }
            final FileObject folder = cfolder;
            FileSystem fs = folder.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        String name = file.getName();
                        FileObject configFO = folder.getFileObject(name);
                        if (configFO == null) {
                            configFO = folder.createData(name);
                        }
                        lock = configFO.lock();
                        os = new BufferedOutputStream(configFO.getOutputStream(lock), 4086);
                        if (bean != null) {
                            bean.write(os);
                        }
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getLocalizedMessage());
        }
    }
}

