/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public final class IndentedWriter
extends PrintWriter {
    private boolean needIndent = true;
    private String indent = "";

    public IndentedWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public IndentedWriter(Writer out) {
        super(out);
    }

    public IndentedWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public IndentedWriter(OutputStream out) {
        super(out);
    }

    public void println() {
        super.println();
        this.needIndent = true;
    }

    public void write(String s) {
        if (this.needIndent) {
            super.write(this.indent);
            this.needIndent = false;
        }
        super.write(s);
    }

    public void indent() {
        this.indent = this.indent + "    ";
    }

    public void unindent() {
        this.indent = this.indent.substring(4);
    }
}

