/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.netbeans.modules.tasklist.core.filter.AppliedFilterCondition;
import org.netbeans.modules.tasklist.core.filter.ConditionPanel;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.filter.FilterSubpanel;
import org.netbeans.modules.tasklist.core.filter.FilteredTopComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class FilterPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private FilteredTopComponent view;
    private Filter filter;
    private FilterSubpanel subpanel;
    final JPanel buttonsPanel = new JPanel();
    final JPanel conditionsPanel = new JPanel();
    final JScrollPane conditionsScrollPane = new JScrollPane();
    final JButton fewerButton = new JButton();
    final JTextField filterName = new JTextField();
    final JLabel filterNameLabel = new JLabel();
    final JRadioButton matchAllRadio = new JRadioButton();
    final JRadioButton matchAnyRadio = new JRadioButton();
    final ButtonGroup matchGroup = new ButtonGroup();
    final JButton moreButton = new JButton();
    final JPanel namePanel = new JPanel();
    final ButtonGroup subtaskGroup = new ButtonGroup();
    static final /* synthetic */ boolean $assertionsDisabled;

    public FilterPanel(FilteredTopComponent view, Filter filter) {
        this.view = view;
        this.filter = filter;
        this.initComponents();
        this.initA11y();
        JPanel topAlign = new JPanel();
        topAlign.setLayout(new BorderLayout());
        topAlign.add((Component)this.conditionsPanel, "North");
        this.conditionsScrollPane.setViewportView(topAlign);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int width = fm.charWidth('n') * 80;
        int height = fm.getHeight() * 10;
        this.conditionsScrollPane.setPreferredSize(new Dimension(width, height));
        Color background = (Color)UIManager.get("Table.background");
        this.conditionsPanel.setBackground(background);
        topAlign.setBackground(background);
        this.moreButton.addActionListener(this);
        this.fewerButton.addActionListener(this);
        this.matchAllRadio.addActionListener(this);
        this.matchAnyRadio.addActionListener(this);
        this.showFilter(filter);
        this.updateSensitivity();
    }

    public void initSubpanel(FilterSubpanel next) {
        if (!$assertionsDisabled && this.subpanel != null) {
            throw new AssertionError();
        }
        this.subpanel = next;
    }

    private void showFilter(Filter filter) {
        if (filter != null) {
            if (filter.matchAll()) {
                this.matchAllRadio.setSelected(true);
            } else {
                this.matchAnyRadio.setSelected(true);
            }
            this.conditionsPanel.removeAll();
            List conditions = filter.getConditions();
            if (conditions.size() > 0) {
                Iterator it = conditions.iterator();
                while (it.hasNext()) {
                    AppliedFilterCondition cond = (AppliedFilterCondition)it.next();
                    this.addCondition(false, cond);
                }
            } else {
                this.addCondition(false, null);
            }
            this.filterName.setText(filter.getName());
        } else {
            this.setEnabled(false);
            this.namePanel.setEnabled(false);
            this.filterName.setEnabled(false);
            this.filterName.setText(NbBundle.getMessage((Class)FilterPanel.class, (String)"no-filter"));
            this.matchAnyRadio.setEnabled(false);
            this.matchAllRadio.setEnabled(false);
            this.conditionsPanel.setEnabled(false);
            this.moreButton.setEnabled(false);
            this.fewerButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.addFocusListener(this);
        this.namePanel.setLayout(new GridBagLayout());
        this.filterNameLabel.setLabelFor(this.filterName);
        this.filterNameLabel.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/filter/Bundle").getString("LBL_Filter_Name_Hint"));
        this.filterNameLabel.setAlignmentY(0.0f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.namePanel.add((Component)this.filterNameLabel, gridBagConstraints);
        this.filterNameLabel.getAccessibleContext().setAccessibleName("<Name>");
        this.filterName.setText("jTextField1");
        this.filterName.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/filter/Bundle").getString("LBL_Filter_Name_Hint"));
        this.filterName.setAlignmentX(0.0f);
        this.filterName.setAlignmentY(0.0f);
        this.filterName.setPreferredSize(new Dimension(Short.MAX_VALUE, 20));
        this.filterName.addFocusListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.namePanel.add((Component)this.filterName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.namePanel, gridBagConstraints);
        this.matchGroup.add(this.matchAllRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.matchAllRadio, gridBagConstraints);
        this.matchGroup.add(this.matchAnyRadio);
        this.matchAnyRadio.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.matchAnyRadio, gridBagConstraints);
        this.conditionsScrollPane.setVerticalScrollBarPolicy(22);
        this.conditionsScrollPane.setAlignmentX(0.0f);
        this.conditionsScrollPane.setAlignmentY(0.0f);
        this.conditionsScrollPane.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.conditionsPanel.setLayout(new GridBagLayout());
        this.conditionsScrollPane.setViewportView(this.conditionsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)this.conditionsScrollPane, gridBagConstraints);
        this.conditionsScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)FilterPanel.class).getString("LBL_Conditions"));
        this.conditionsScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)FilterPanel.class).getString("HNT_Conditions"));
        this.buttonsPanel.setLayout(new FlowLayout(0));
        this.buttonsPanel.add(this.moreButton);
        this.buttonsPanel.add(this.fewerButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.buttonsPanel, gridBagConstraints);
    }

    public void focusGained(FocusEvent evt) {
        if (evt.getSource() == this) {
            this.formFocusGained(evt);
        } else if (evt.getSource() == this.filterName) {
            this.filterNameFocusGained(evt);
        }
    }

    public void focusLost(FocusEvent evt) {
    }

    private void filterNameFocusGained(FocusEvent evt) {
        this.filterName.selectAll();
    }

    private void formFocusGained(FocusEvent evt) {
        this.filterName.requestFocus();
    }

    private void initA11y() {
        Mnemonics.setLocalizedText((AbstractButton)this.matchAllRadio, (String)NbBundle.getMessage((Class)FilterPanel.class, (String)"MatchAll"));
        this.matchAllRadio.setToolTipText(NbBundle.getMessage((Class)FilterPanel.class, (String)"HINT_MatchAll"));
        Mnemonics.setLocalizedText((AbstractButton)this.matchAnyRadio, (String)NbBundle.getMessage((Class)FilterPanel.class, (String)"MatchAny"));
        this.matchAnyRadio.setToolTipText(NbBundle.getMessage((Class)FilterPanel.class, (String)"HINT_MatchAny"));
        Mnemonics.setLocalizedText((AbstractButton)this.moreButton, (String)NbBundle.getMessage((Class)FilterPanel.class, (String)"More"));
        this.moreButton.setToolTipText(NbBundle.getMessage((Class)FilterPanel.class, (String)"HINT_More"));
        Mnemonics.setLocalizedText((AbstractButton)this.fewerButton, (String)NbBundle.getMessage((Class)FilterPanel.class, (String)"Fewer"));
        this.fewerButton.setToolTipText(NbBundle.getMessage((Class)FilterPanel.class, (String)"HINT_Fewer"));
        Mnemonics.setLocalizedText((JLabel)this.filterNameLabel, (String)NbBundle.getMessage((Class)FilterPanel.class, (String)"LBL_Filter_Name"));
        this.filterNameLabel.setToolTipText(NbBundle.getMessage((Class)FilterPanel.class, (String)"LBL_Filter_Name_Hint"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FilterPanel.class, (String)"ACSD_Filter"));
        this.conditionsPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)FilterPanel.class, (String)"ACSN_Conditions"));
        this.conditionsPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FilterPanel.class, (String)"ACSD_Conditions"));
    }

    private ConditionPanel addCondition(boolean revalidate, AppliedFilterCondition condition) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        ConditionPanel panel = new ConditionPanel(this.filter, condition);
        panel.addPropertyChangeListener("value-valid", this);
        panel.setBackground((Color)UIManager.get("Table.background"));
        this.conditionsPanel.add((Component)panel, gridBagConstraints);
        if (revalidate) {
            this.invalidate();
            this.getParent().validate();
            this.repaint();
        }
        this.putClientProperty("value-valid", this.isValueValid());
        return panel;
    }

    public final boolean isValueValid() {
        Component[] cps = this.conditionsPanel.getComponents();
        for (int i = 0; i < cps.length; ++i) {
            ConditionPanel condition = (ConditionPanel)cps[i];
            if (condition == null || condition.isValueValid()) continue;
            return false;
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.putClientProperty("value-valid", this.isValueValid());
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.moreButton) {
            ConditionPanel comp = this.addCondition(true, null);
            JScrollBar vsb = this.conditionsScrollPane.getVerticalScrollBar();
            vsb.setValue(vsb.getMaximum());
            comp.focusPropertyCombo();
        } else if (source == this.fewerButton) {
            this.conditionsPanel.remove(this.conditionsPanel.getComponentCount() - 1);
            this.invalidate();
            this.getParent().validate();
            this.repaint();
        }
        this.updateSensitivity();
    }

    private void updateSensitivity() {
        int n = this.conditionsPanel.getComponentCount();
        this.fewerButton.setEnabled(n > 0);
    }

    public Filter getFilter() {
        if (this.filter != null) {
            Component[] cps = this.conditionsPanel.getComponents();
            ArrayList<AppliedFilterCondition> conditions = new ArrayList<AppliedFilterCondition>(cps.length);
            for (int i = 0; i < cps.length; ++i) {
                AppliedFilterCondition condition = ((ConditionPanel)cps[i]).getCondition();
                if (condition == null) continue;
                conditions.add(condition);
            }
            this.filter.setName(this.filterName.getText());
            this.filter.setConditions(conditions);
            this.filter.setMatchAll(this.matchAllRadio.isSelected());
            this.filter.setFlattened(true);
            if (this.subpanel != null) {
                this.subpanel.updateFilter(this.filter);
            }
        }
        return this.filter;
    }

    public JTextField getFilterNameField() {
        return this.filterName;
    }

    static {
        $assertionsDisabled = !FilterPanel.class.desiredAssertionStatus();
    }
}

