/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.editors;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import javax.swing.JLabel;
import org.netbeans.modules.tasklist.client.SuggestionPriority;
import org.netbeans.modules.tasklist.core.PriorityListCellRenderer;

public final class PriorityPropertyEditor
extends PropertyEditorSupport {
    private static final String[] TAGS = SuggestionPriority.getPriorityNames();
    private static final JLabel LABEL = new JLabel();

    public String getAsText() {
        Object v = this.getValue();
        if (v instanceof SuggestionPriority) {
            int value = ((SuggestionPriority)v).intValue();
            return TAGS[value - 1];
        }
        return "";
    }

    public void setAsText(String text) throws IllegalArgumentException {
        int index = -1;
        for (int i = 0; i < TAGS.length; ++i) {
            if (!text.equals(TAGS[i])) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new IllegalArgumentException("Unknown priority");
        }
        this.setValue(SuggestionPriority.getPriority((int)(index + 1)));
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        Object v = this.getValue();
        if (v instanceof SuggestionPriority) {
            gfx.translate(box.x, box.y);
            int value = ((SuggestionPriority)v).intValue();
            LABEL.setForeground(PriorityListCellRenderer.COLORS[value - 1]);
            LABEL.setText(this.getAsText());
            LABEL.setSize(box.width, box.height);
            LABEL.paint(gfx);
            gfx.translate(-box.x, -box.y);
        }
    }

    public String[] getTags() {
        return TAGS;
    }
}

