/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Central;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceHandler;
import org.netbeans.core.windows.RecentViewList;
import org.netbeans.core.windows.RegistryImpl;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.TopComponentGroupImpl;
import org.netbeans.core.windows.UIModeHandler;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.persistence.PersistenceObserver;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class WindowManagerImpl
extends WindowManager
implements Workspace {
    public static final String PROP_ACTIVE_MODE = "activeMode";
    public static final String PROP_MAXIMIZED_MODE = "maximizedMode";
    public static final String PROP_EDITOR_AREA_STATE = "editorAreaState";
    private static final Object LOCK_INIT;
    private static WindowManagerImpl defaultInstance;
    private final Central central = new Central();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport((Object)this);
    private final RecentViewList recentViewList = new RecentViewList(this);
    private final UIModeHandler uiModeHandler = new UIModeHandler();
    private TopComponent persistenceShowingTC;
    private static final boolean NAME_HACK;
    private static final String ASSERTION_ERROR_MESSAGE = "WindowsAPI is required to be called from AWT thread only, see http://www.netbeans.org/download/dev/javadoc/OpenAPIs/org/openide/doc-files/threading.html";
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowManagerImpl() {
        Object object = LOCK_INIT;
        synchronized (object) {
            if (defaultInstance != null) {
                throw new IllegalStateException("Instance already exists");
            }
            defaultInstance = this;
        }
    }

    public static WindowManagerImpl getInstance() {
        if (defaultInstance != null) {
            return defaultInstance;
        }
        return (WindowManagerImpl)((Object)Lookup.getDefault().lookup(WindowManager.class));
    }

    public void topComponentRequestAttention(TopComponent tc) {
        ModeImpl mode = (ModeImpl)this.findMode(tc);
        this.central.topComponentRequestAttention(mode, tc);
    }

    public void topComponentCancelRequestAttention(TopComponent tc) {
        ModeImpl mode = (ModeImpl)this.findMode(tc);
        this.central.topComponentCancelRequestAttention(mode, tc);
    }

    public Frame getMainWindow() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this.central.getMainWindow();
    }

    public void updateUI() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        this.central.updateUI();
    }

    protected synchronized WindowManager.Component createTopComponentManager(TopComponent c) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return null;
    }

    public Workspace createWorkspace(String name, String displayName) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this;
    }

    public Workspace findWorkspace(String name) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this;
    }

    public Workspace[] getWorkspaces() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return new Workspace[]{this};
    }

    public void setWorkspaces(Workspace[] workspaces) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
    }

    public Workspace getCurrentWorkspace() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this;
    }

    public TopComponentGroup findTopComponentGroup(String name) {
        WindowManagerImpl.assertEventDispatchThread();
        Iterator it = this.getTopComponentGroups().iterator();
        while (it.hasNext()) {
            TopComponentGroupImpl group = (TopComponentGroupImpl)it.next();
            if (!group.getName().equals(name)) continue;
            return group;
        }
        return null;
    }

    public TopComponent findTopComponent(String tcID) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this.getTopComponentForID(tcID);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    public String getName() {
        return "FakeWorkspace";
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)WindowManagerImpl.class, (String)"LBL_FakeWorkspace");
    }

    public Set getModes() {
        return this.central.getModes();
    }

    public Rectangle getBounds() {
        if (this.getEditorAreaState() == 0) {
            return this.getMainWindowBoundsJoined();
        }
        return this.getMainWindowBoundsSeparated();
    }

    public void activate() {
    }

    public Mode createMode(String name, String displayName, URL icon) {
        if (this.getEditorAreaState() == 0) {
            return new WrapMode(this.createMode(name, 1, false, null));
        }
        return this.createMode(name, 0, false, new SplitConstraint[]{new SplitConstraint(1, 1, 0.2)});
    }

    public Mode findMode(String name) {
        return this.findModeImpl(name);
    }

    public Mode findMode(TopComponent tc) {
        if (tc == null) {
            return null;
        }
        Iterator it = this.getModes().iterator();
        while (it.hasNext()) {
            ModeImpl mode = (ModeImpl)it.next();
            if (!mode.containsTopComponent(tc)) continue;
            return mode;
        }
        return null;
    }

    public void remove() {
    }

    public void addTopComponentGroup(TopComponentGroupImpl tcGroup) {
        this.central.addTopComponentGroup(tcGroup);
    }

    public void removeTopComponentGroup(TopComponentGroupImpl tcGroup) {
        this.central.removeTopComponentGroup(tcGroup);
    }

    public Set getTopComponentGroups() {
        return this.central.getTopComponentGroups();
    }

    public ModeImpl createMode(String name, int kind, boolean permanent, SplitConstraint[] constraints) {
        ModeImpl mode = (ModeImpl)this.findMode(name);
        if (mode != null) {
            return mode;
        }
        if (constraints == null && kind != 2) {
            if (kind == 1) {
                return this.getDefaultEditorMode();
            }
            return this.getDefaultViewMode();
        }
        mode = this.createModeImpl(name, kind, permanent);
        this.addMode(mode, constraints);
        return mode;
    }

    public ModeImpl createSlidingMode(String name, boolean permanent, String side) {
        ModeImpl mode = (ModeImpl)this.findMode(name);
        if (mode != null) {
            return mode;
        }
        mode = this.createModeImpl(name, 2, permanent);
        this.central.addSlidingMode(mode, null, side);
        return mode;
    }

    ModeImpl createModeImpl(String name, int kind, boolean permanent) {
        if (name == null) {
            name = ModeImpl.getUnusedModeName();
        }
        int state = this.getEditorAreaState() == 0 ? 0 : 1;
        ModeImpl toReturn = ModeImpl.createModeImpl(name, state, kind, permanent);
        return toReturn;
    }

    ModeImpl getDefaultEditorMode() {
        ModeImpl mode = this.findModeImpl("editor");
        if (mode == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Creating default editor mode. It shouldn't happen this way"));
            ModeImpl newMode = this.createModeImpl("editor", 1, true);
            this.addMode(newMode, new SplitConstraint[0]);
            return newMode;
        }
        return mode;
    }

    ModeImpl getDefaultViewMode() {
        ModeImpl mode = this.findModeImpl("explorer");
        if (mode == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Creating default view mode. It shouldn't happen this way"));
            ModeImpl newMode = this.createModeImpl("explorer", 0, true);
            this.addMode(newMode, new SplitConstraint[]{new SplitConstraint(0, 0, 0.7), new SplitConstraint(1, 0, 0.25)});
            return newMode;
        }
        return mode;
    }

    ModeImpl getDefaultSlidingMode() {
        ModeImpl mode = this.findModeImpl("sliding");
        if (mode == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Creating default sliding mode. It shouldn't happen this way"));
            ModeImpl newMode = this.createModeImpl("sliding", 2, true);
            this.addMode(newMode, new SplitConstraint[]{new SplitConstraint(0, 0, 0.7), new SplitConstraint(1, 0, 0.25)});
            return newMode;
        }
        return mode;
    }

    private ModeImpl findModeImpl(String name) {
        if (name == null) {
            return null;
        }
        Iterator it = this.getModes().iterator();
        while (it.hasNext()) {
            ModeImpl mode = (ModeImpl)it.next();
            if (!name.equals(mode.getName())) continue;
            return mode;
        }
        return null;
    }

    public TopComponent getSelectedTopComponent(Mode mode) {
        return this.central.getModeSelectedTopComponent((ModeImpl)mode);
    }

    public Rectangle getMainWindowBoundsJoined() {
        return this.central.getMainWindowBoundsJoined();
    }

    public void setMainWindowBoundsJoined(Rectangle bounds) {
        this.central.setMainWindowBoundsJoined(bounds);
    }

    public Rectangle getMainWindowBoundsSeparated() {
        return this.central.getMainWindowBoundsSeparated();
    }

    public void setMainWindowBoundsSeparated(Rectangle bounds) {
        this.central.setMainWindowBoundsSeparated(bounds);
    }

    public int getMainWindowFrameStateJoined() {
        return this.central.getMainWindowFrameStateJoined();
    }

    public void setMainWindowFrameStateJoined(int frameState) {
        this.central.setMainWindowFrameStateJoined(frameState);
    }

    public int getMainWindowFrameStateSeparated() {
        return this.central.getMainWindowFrameStateSeparated();
    }

    public void setMainWindowFrameStateSeparated(int frameState) {
        this.central.setMainWindowFrameStateSeparated(frameState);
    }

    public ModeImpl getActiveMode() {
        return this.central.getActiveMode();
    }

    public void setActiveMode(ModeImpl activeMode) {
        this.central.setActiveMode(activeMode);
    }

    public void setEditorAreaBounds(Rectangle editorAreaBounds) {
        this.central.setEditorAreaBounds(editorAreaBounds);
    }

    public Rectangle getEditorAreaBounds() {
        return this.central.getEditorAreaBounds();
    }

    public void setEditorAreaConstraints(SplitConstraint[] editorAreaConstraints) {
        this.central.setEditorAreaConstraints(editorAreaConstraints);
    }

    public SplitConstraint[] getEditorAreaConstraints() {
        return this.central.getEditorAreaConstraints();
    }

    public void setEditorAreaState(int editorAreaState) {
        this.setEditorAreaStateImpl(editorAreaState);
        this.uiModeHandler.setUIMode(editorAreaState);
    }

    void setEditorAreaStateImpl(int editorAreaState) {
        this.central.setEditorAreaState(editorAreaState);
    }

    public int getEditorAreaState() {
        return this.central.getEditorAreaState();
    }

    public void setEditorAreaFrameState(int editorAreaFrameState) {
        this.central.setEditorAreaFrameState(editorAreaFrameState);
    }

    public int getEditorAreaFrameState() {
        return this.central.getEditorAreaFrameState();
    }

    public void setMaximizedMode(ModeImpl maximizedMode) {
        this.central.setMaximizedMode(maximizedMode);
    }

    public ModeImpl getMaximizedMode() {
        return this.central.getMaximizedMode();
    }

    public void setModeConstraints(ModeImpl mode, SplitConstraint[] modeConstraints) {
        this.central.setModeConstraints(mode, modeConstraints);
    }

    public SplitConstraint[] getModeConstraints(ModeImpl mode) {
        return this.central.getModeConstraints(mode);
    }

    private void addMode(ModeImpl mode, SplitConstraint[] modeConstraints) {
        if (mode.getKind() == 2) {
            this.central.addSlidingMode(mode, null, "left");
        } else {
            this.central.addMode(mode, modeConstraints);
        }
    }

    public void removeMode(ModeImpl mode) {
        if (mode.getKind() != 2) {
            this.central.removeMode(mode);
        }
    }

    public void setToolbarConfigName(String toolbarConfigName) {
        this.central.setToolbarConfigName(toolbarConfigName);
    }

    public String getToolbarConfigName() {
        return this.central.getToolbarConfigName();
    }

    public void setVisible(boolean visible) {
        this.central.setVisible(visible);
    }

    public boolean isVisible() {
        return this.central.isVisible();
    }

    public void attachTopComponentToSide(TopComponent tc, ModeImpl attachMode, String side) {
        this.central.attachTopComponentsToSide(new TopComponent[]{tc}, attachMode, side);
    }

    boolean isTopComponentPersistentWhenClosed(TopComponent tc) {
        return PersistenceHandler.getDefault().isTopComponentPersistentWhenClosed(tc);
    }

    public TopComponent getTopComponentForID(String tcID) {
        return PersistenceHandler.getDefault().getTopComponentForID(tcID);
    }

    public boolean isTopComponentAllowedToMoveAnywhere(TopComponent tc) {
        return Boolean.TRUE.equals(tc.getClientProperty((Object)"TopComponentAllowDockAnywhere"));
    }

    public ModeImpl findModeForOpenedID(String tcID) {
        if (tcID == null) {
            return null;
        }
        Iterator it = this.getModes().iterator();
        while (it.hasNext()) {
            ModeImpl mode = (ModeImpl)it.next();
            if (!mode.getOpenedTopComponentsIDs().contains(tcID)) continue;
            return mode;
        }
        return null;
    }

    public ModeImpl findModeForClosedID(String tcID) {
        if (tcID == null) {
            return null;
        }
        Iterator it = this.getModes().iterator();
        while (it.hasNext()) {
            ModeImpl mode = (ModeImpl)it.next();
            if (!mode.getClosedTopComponentsIDs().contains(tcID)) continue;
            return mode;
        }
        return null;
    }

    public void setProjectName(String projectName) {
        this.central.setProjectName(projectName);
    }

    public String getTopComponentDisplayName(TopComponent tc) {
        if (tc == null) {
            return null;
        }
        String displayName = tc.getHtmlDisplayName();
        if (displayName == null) {
            displayName = tc.getDisplayName();
        }
        if (displayName == null) {
            displayName = tc.getName();
        }
        if (NAME_HACK && displayName != null) {
            if (displayName.endsWith("*")) {
                if (displayName.startsWith("<html>")) {
                    displayName = displayName.substring(6);
                }
                displayName = "<html><b>" + displayName.substring(0, displayName.length() - 2);
            } else {
                int i = displayName.indexOf("[r/o]");
                if (i > 0) {
                    if (displayName.startsWith("<html>")) {
                        displayName = displayName.substring(6);
                        i -= 6;
                    }
                    int roLength = "[r/o]".length();
                    String nuName = "<html><font color='#555555'><i>" + displayName.substring(0, i - 1);
                    if (i + roLength < displayName.length()) {
                        nuName = nuName + displayName.substring(i + roLength);
                    }
                    displayName = nuName;
                }
            }
        }
        return displayName;
    }

    Central getCentral() {
        return this.central;
    }

    public boolean isDragInProgress() {
        return this.central.isDragInProgress();
    }

    public String guessSlideSide(TopComponent tc) {
        return this.central.guessSlideSide(tc);
    }

    public void setRecentViewList(TopComponent[] tcs) {
        this.recentViewList.setTopComponents(tcs);
    }

    public TopComponent[] getRecentViewList() {
        return this.recentViewList.getTopComponents();
    }

    void doFirePropertyChange(final String propName, final Object oldValue, final Object newValue) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.changeSupport.firePropertyChange(propName, oldValue, newValue);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowManagerImpl.this.changeSupport.firePropertyChange(propName, oldValue, newValue);
                }
            });
        }
    }

    public PersistenceObserver getPersistenceObserver() {
        return PersistenceHandler.getDefault();
    }

    public void notifyTopComponentOpened(TopComponent tc) {
        this.componentOpenNotify(tc);
        WindowManagerImpl.notifyRegistryTopComponentOpened(tc);
    }

    public void notifyTopComponentClosed(TopComponent tc) {
        this.componentCloseNotify(tc);
        WindowManagerImpl.notifyRegistryTopComponentClosed(tc);
    }

    static void notifyRegistryTopComponentActivated(final TopComponent tc) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).topComponentActivated(tc);
        if (SwingUtilities.isEventDispatchThread()) {
            WindowManagerImpl.getInstance().activateComponent(tc);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowManagerImpl.getInstance().activateComponent(tc);
                }
            });
        }
    }

    private static void notifyRegistryTopComponentOpened(TopComponent tc) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).topComponentOpened(tc);
    }

    private static void notifyRegistryTopComponentClosed(TopComponent tc) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).topComponentClosed(tc);
    }

    private static void notifyRegistrySelectedNodesChanged(TopComponent tc, Node[] nodes) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).selectedNodesChanged(tc, nodes);
    }

    public void componentShowing(TopComponent tc) {
        if (tc != null && tc != this.persistenceShowingTC) {
            super.componentShowing(tc);
        }
    }

    void specialPersistenceCompShow(TopComponent tc) {
        this.componentShowing(tc);
        this.persistenceShowingTC = tc;
    }

    public void componentHidden(TopComponent tc) {
        if (tc != null) {
            super.componentHidden(tc);
            if (tc == this.persistenceShowingTC) {
                this.persistenceShowingTC = null;
            }
        }
    }

    protected void topComponentOpen(TopComponent tc) {
        ModeImpl maximizedMode;
        WindowManagerImpl.assertEventDispatchThreadWeak();
        if (tc == null) {
            throw new IllegalArgumentException("Cannot open a null TopComponent");
        }
        ModeImpl mode = this.getMode(tc);
        if (mode == null) {
            mode = this.getDefaultEditorMode();
            if (tc.getClientProperty((Object)"TopComponentAllowDockAnywhere") == null) {
                tc.putClientProperty((Object)"TopComponentAllowDockAnywhere", (Object)Boolean.TRUE);
            }
        }
        if ((maximizedMode = this.getMaximizedMode()) != null && mode != maximizedMode && mode.getKind() != 2) {
            this.setMaximizedMode(null);
        }
        mode.addOpenedTopComponent(tc);
    }

    protected void topComponentClose(TopComponent tc) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        boolean opened = this.topComponentIsOpened(tc);
        if (!opened) {
            return;
        }
        ModeImpl mode = this.getModeForOpenedTopComponent(tc);
        if (mode != null) {
            mode.close(tc);
        }
    }

    protected void topComponentRequestActive(TopComponent tc) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl mode = this.getModeForOpenedTopComponent(tc);
        if (mode != null) {
            this.central.activateModeTopComponent(mode, tc);
        }
    }

    protected void topComponentRequestVisible(TopComponent tc) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl mode = this.getModeForOpenedTopComponent(tc);
        if (mode != null) {
            this.central.setModeSelectedTopComponent(mode, tc);
        }
    }

    protected void topComponentDisplayNameChanged(TopComponent tc, String displayName) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl mode = this.getModeForOpenedTopComponent(tc);
        if (mode != null) {
            this.central.topComponentDisplayNameChanged(mode, tc);
        }
    }

    protected void topComponentHtmlDisplayNameChanged(TopComponent tc, String htmlDisplayName) {
        this.topComponentDisplayNameChanged(tc, null);
    }

    protected void topComponentToolTipChanged(TopComponent tc, String toolTip) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl mode = this.getModeForOpenedTopComponent(tc);
        if (mode != null) {
            this.central.topComponentToolTipChanged(mode, tc);
        }
    }

    protected void topComponentIconChanged(TopComponent tc, Image icon) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl mode = this.getModeForOpenedTopComponent(tc);
        if (mode != null) {
            this.central.topComponentIconChanged(mode, tc);
        }
    }

    protected void topComponentActivatedNodesChanged(TopComponent tc, Node[] activatedNodes) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        WindowManagerImpl.notifyRegistrySelectedNodesChanged(tc, activatedNodes);
    }

    protected boolean topComponentIsOpened(TopComponent tc) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this.getModeForOpenedTopComponent(tc) != null;
    }

    protected Action[] topComponentDefaultActions(TopComponent tc) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return ActionUtils.createDefaultPopupActions(tc);
    }

    protected String topComponentID(TopComponent tc, String preferredID) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        if (preferredID == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Assertion failed. " + tc.getClass().getName() + ".preferredID method shouldn't be overriden to return null. " + "Please change your impl to return non-null string."));
        }
        return PersistenceManager.getDefault().getGlobalTopComponentID(tc, preferredID);
    }

    private ModeImpl getMode(TopComponent tc) {
        return (ModeImpl)this.findMode(tc);
    }

    private ModeImpl getModeForOpenedTopComponent(TopComponent tc) {
        if (tc == null) {
            return null;
        }
        Iterator it = this.getModes().iterator();
        while (it.hasNext()) {
            ModeImpl mode = (ModeImpl)it.next();
            if (!mode.getOpenedTopComponents().contains(tc)) continue;
            return mode;
        }
        return null;
    }

    public ModeImpl getPreviousModeForTopComponent(String tcID, ModeImpl slidingMode) {
        return this.getCentral().getModeTopComponentPreviousMode(tcID, slidingMode);
    }

    public void setPreviousModeForTopComponent(String tcID, ModeImpl slidingMode, ModeImpl prevMode) {
        this.getCentral().setModeTopComponentPreviousMode(tcID, slidingMode, prevMode);
    }

    static void assertEventDispatchThread() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)ASSERTION_ERROR_MESSAGE);
        }
    }

    static void assertEventDispatchThreadWeak() {
        if (!SwingUtilities.isEventDispatchThread()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Assertion failed. WindowsAPI is required to be called from AWT thread only, see http://www.netbeans.org/download/dev/javadoc/OpenAPIs/org/openide/doc-files/threading.html"));
        }
    }

    static {
        $assertionsDisabled = !WindowManagerImpl.class.desiredAssertionStatus();
        LOCK_INIT = new Object();
        NAME_HACK = Boolean.getBoolean("nb.tabnames.html");
    }

    private static class WrapMode
    implements Mode {
        private Mode wrap;

        public WrapMode(Mode wrap) {
            this.wrap = wrap;
        }

        public void addPropertyChangeListener(PropertyChangeListener list) {
            this.wrap.addPropertyChangeListener(list);
        }

        public boolean canDock(TopComponent tc) {
            return this.wrap.canDock(tc);
        }

        public boolean dockInto(TopComponent c) {
            if (c.getClientProperty((Object)"TopComponentAllowDockAnywhere") == null) {
                c.putClientProperty((Object)"TopComponentAllowDockAnywhere", (Object)Boolean.TRUE);
            }
            return this.wrap.dockInto(c);
        }

        public Rectangle getBounds() {
            return this.wrap.getBounds();
        }

        public String getDisplayName() {
            return this.wrap.getDisplayName();
        }

        public Image getIcon() {
            return this.wrap.getIcon();
        }

        public String getName() {
            return this.wrap.getName();
        }

        public TopComponent getSelectedTopComponent() {
            return this.wrap.getSelectedTopComponent();
        }

        public TopComponent[] getTopComponents() {
            return this.wrap.getTopComponents();
        }

        public Workspace getWorkspace() {
            return this.wrap.getWorkspace();
        }

        public void removePropertyChangeListener(PropertyChangeListener list) {
            this.wrap.removePropertyChangeListener(list);
        }

        public void setBounds(Rectangle s) {
            this.wrap.setBounds(s);
        }
    }
}

