/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.updater.UpdateTracking;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.windows.WindowManager;

class Autoupdater {
    private static boolean isRunning = false;
    private static WindowListener l;
    private static Object settingsInstance;
    private static Method mGetProxyType;
    private static Method mSetProxyType;
    private static Method mGetProxyHost;
    private static Method mSetProxyHost;
    private static Method mGetProxyPort;
    private static Method mSetProxyPort;
    private static boolean reflectionAlreadyTried;
    private static final String PROXY_HOST = "http.proxyHost";
    private static final String PROXY_PORT = "http.proxyPort";
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$Autoupdater;

    Autoupdater() {
    }

    static boolean isRunning() {
        return isRunning;
    }

    static void setRunning(boolean isRunning) {
        Autoupdater.isRunning = isRunning;
    }

    static void restart() {
        LifecycleManager.getDefault().exit();
    }

    static void installUpdateChecker(final Runnable updateChecker) {
        if (!Boolean.getBoolean("netbeans.full.hack") && !Boolean.getBoolean("netbeans.close")) {
            l = new WindowListener(){

                public void windowOpened(WindowEvent e) {
                    Autoupdater.doInstallUpdateChecker(updateChecker);
                }

                public void windowClosing(WindowEvent e) {
                }

                public void windowClosed(WindowEvent e) {
                }

                public void windowIconified(WindowEvent e) {
                }

                public void windowDeiconified(WindowEvent e) {
                }

                public void windowActivated(WindowEvent e) {
                }

                public void windowDeactivated(WindowEvent e) {
                }
            };
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowManager.getDefault().getMainWindow().addWindowListener(l);
                }
            });
        }
    }

    private static void doInstallUpdateChecker(Runnable updateChecker) {
        RequestProcessor.getDefault().post(updateChecker, 5000);
        WindowManager.getDefault().getMainWindow().removeWindowListener(l);
    }

    private static boolean useReflection() {
        Autoupdater.initProxyMethodsMaybe();
        return mSetProxyPort != null;
    }

    private static synchronized void initProxyMethodsMaybe() {
        if (reflectionAlreadyTried) {
            return;
        }
        reflectionAlreadyTried = true;
        try {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> clazz = l.loadClass("org.netbeans.core.IDESettings");
            settingsInstance = SharedClassObject.findObject(clazz, (boolean)true);
            mGetProxyType = clazz.getMethod("getProxyType", null);
            mSetProxyType = clazz.getMethod("setProxyType", Integer.TYPE);
            mGetProxyHost = clazz.getMethod("getUserProxyHost", null);
            mSetProxyHost = clazz.getMethod("setUserProxyHost", String.class);
            mGetProxyPort = clazz.getMethod("getUserProxyPort", null);
            mSetProxyPort = clazz.getMethod("setUserProxyPort", String.class);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    static int getProxyType() {
        if (Autoupdater.useReflection()) {
            try {
                return (Integer)mGetProxyType.invoke(settingsInstance, new Object[0]);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return 1;
            }
        }
        return 1;
    }

    static String getUserProxyHost() {
        if (Autoupdater.useReflection()) {
            try {
                return (String)mGetProxyHost.invoke(settingsInstance, new Object[0]);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return null;
            }
        }
        return System.getProperty(PROXY_HOST);
    }

    static String getUserProxyPort() {
        if (Autoupdater.useReflection()) {
            try {
                return (String)mGetProxyPort.invoke(settingsInstance, new Object[0]);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return null;
            }
        }
        return System.getProperty(PROXY_PORT);
    }

    static void setProxyConfiguration(int proxyType, String host, String port) {
        if (Autoupdater.useReflection()) {
            try {
                mSetProxyType.invoke(settingsInstance, new Integer(proxyType));
                mSetProxyHost.invoke(settingsInstance, host);
                mSetProxyPort.invoke(settingsInstance, port);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        } else if (proxyType == 0) {
            System.setProperty(PROXY_HOST, "");
            System.setProperty(PROXY_PORT, "");
        } else {
            System.setProperty(PROXY_HOST, host);
            System.setProperty(PROXY_PORT, port);
        }
    }

    static {
        reflectionAlreadyTried = false;
    }

    static class Support {
        private static final String FILE_SEPARATOR;
        private static final String UPDATE_DIR = "update";
        private static final String DOWNLOAD_DIR;
        private static final String PATCH_DIR;
        private static final String KS_FILE;
        public static final String LOG_FILE_NAME = "update.log";
        public static final String LATER_FILE_NAME = "install_later.xml";
        private static final String UPDATE_TEMP = "autoupdateTemp";
        private static FileObject tempDir;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Support() {
        }

        public static ModuleInfo[] getModuleDescriptions() {
            Collection descs = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = Autoupdater.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo)).allInstances();
            return descs.toArray(new ModuleInfo[descs.size()]);
        }

        public static File getDownloadDirectory(File base) {
            File downloadDirectory;
            if (base == null) {
                base = new File(System.getProperty("netbeans.user"));
            }
            if (!(downloadDirectory = new File(base, DOWNLOAD_DIR)).isDirectory()) {
                downloadDirectory.mkdirs();
            }
            return downloadDirectory;
        }

        public static List getPatchDirectories() {
            ArrayList<File> patches = new ArrayList<File>();
            List clusters = UpdateTracking.clusters(true);
            if (!$assertionsDisabled && clusters == null) {
                throw new AssertionError((Object)"Clusters cannot be empty.");
            }
            Iterator it = clusters.iterator();
            while (it.hasNext()) {
                File dir = (File)it.next();
                if (!$assertionsDisabled && !dir.isDirectory()) {
                    throw new AssertionError((Object)("Cluster " + dir + " is directory."));
                }
                patches.add(new File(dir.getPath() + FILE_SEPARATOR + PATCH_DIR));
            }
            return patches;
        }

        static File getKSFile() {
            File ksFileLocated = InstalledFileLocator.getDefault().locate(KS_FILE, null, true);
            return ksFileLocated;
        }

        static File getInstall_Later(File root) {
            File file = new File(root.getPath() + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + LATER_FILE_NAME);
            return file;
        }

        static File getTempCopyFile(FileObject original) {
            File f = null;
            if (tempDir == null) {
                FileSystem fs = Repository.getDefault().getDefaultFileSystem();
                tempDir = fs.getRoot().getFileObject(UPDATE_TEMP);
                try {
                    if (tempDir == null) {
                        tempDir = fs.getRoot().createFolder(UPDATE_TEMP);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (tempDir != null) {
                try {
                    FileObject fo = tempDir.getFileObject(original.getName(), "nbm");
                    if (fo == null) {
                        fo = FileUtil.copyFile((FileObject)original, (FileObject)tempDir, (String)original.getName());
                    }
                    f = FileUtil.toFile((FileObject)fo);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return f;
        }

        static void deleteTempDir() {
            if (tempDir == null) {
                FileSystem fs = Repository.getDefault().getDefaultFileSystem();
                tempDir = fs.getRoot().getFileObject(UPDATE_TEMP);
            }
            if (tempDir != null) {
                try {
                    tempDir.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$autoupdate$Autoupdater == null ? (class$org$netbeans$modules$autoupdate$Autoupdater = Autoupdater.class$("org.netbeans.modules.autoupdate.Autoupdater")) : class$org$netbeans$modules$autoupdate$Autoupdater).desiredAssertionStatus();
            FILE_SEPARATOR = System.getProperty("file.separator");
            DOWNLOAD_DIR = UPDATE_DIR + FILE_SEPARATOR + "download";
            PATCH_DIR = "lib" + FILE_SEPARATOR + "patches";
            KS_FILE = "core" + FILE_SEPARATOR + "ide.ks";
            tempDir = null;
        }
    }
}

