/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public abstract class AbstractRefactoringPlugin
implements RefactoringPlugin {
    protected static ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.apisupport.refactoring");
    protected AbstractRefactoring refactoring;
    protected Pattern orderingLayerAttrPattern = Pattern.compile("([\\S]+)/([\\S]+)");

    public AbstractRefactoringPlugin(AbstractRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int checkContentOfFile(FileObject fo, String classToLookFor) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(fo.getInputStream(), "UTF-8"));
            String line = reader.readLine();
            int counter = 0;
            while (line != null) {
                if (line.indexOf(classToLookFor) != -1) {
                    int n = counter;
                    return n;
                }
                ++counter;
                line = reader.readLine();
            }
        }
        catch (IOException exc) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException x) {}
            }
        }
        return -1;
    }

    protected final void checkManifest(NbModuleProject project, JavaClass clzz, RefactoringElementsBag refactoringElements) {
        String name = clzz.getName();
        String pathName = name.replace('.', '/') + ".class";
        Manifest mf = project.getManifest();
        if (mf == null) {
            return;
        }
        Attributes attrs = mf.getMainAttributes();
        Iterator<Map.Entry<Object, Object>> it = attrs.entrySet().iterator();
        while (it.hasNext()) {
            RefactoringElementImplementation elem;
            Map.Entry<Object, Object> entry = it.next();
            String val = (String)entry.getValue();
            if (val.indexOf(name) == -1 && val.indexOf(pathName) == -1 || (elem = this.createManifestRefactoring(clzz, project.getManifestFile(), ((Attributes.Name)entry.getKey()).toString(), val, null)) == null) continue;
            refactoringElements.add(this.refactoring, elem);
        }
        Map<String, Attributes> entries = mf.getEntries();
        if (entries != null) {
            it = entries.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> secEnt = it.next();
                attrs = (Attributes)secEnt.getValue();
                String val = (String)secEnt.getKey();
                if (val.indexOf(name) == -1 && val.indexOf(pathName) == -1) continue;
                String section = attrs.getValue("OpenIDE-Module-Class");
                RefactoringElementImplementation elem = this.createManifestRefactoring(clzz, project.getManifestFile(), null, val, section);
                if (elem == null) continue;
                refactoringElements.add(this.refactoring, elem);
            }
        }
    }

    protected final void checkMetaInfServices(Project project, JavaClass clzz, RefactoringElementsBag refactoringElements) {
        FileObject services = Utility.findMetaInfServices(project);
        if (services == null) {
            return;
        }
        String name = clzz.getName();
        FileObject[] files = services.getChildren();
        for (int i = 0; i < files.length; ++i) {
            RefactoringElementImplementation elem;
            int line = this.checkContentOfFile(files[i], name);
            if (line == -1 || (elem = this.createMetaInfServicesRefactoring(clzz, files[i], line)) == null) continue;
            refactoringElements.add(this.refactoring, elem);
        }
    }

    protected final void checkLayer(NbModuleProject project, JavaClass clzz, RefactoringElementsBag refactoringElements) {
        LayerUtils.LayerHandle handle = LayerUtils.layerForProject((NbModuleProject)project);
        FileSystem fs = handle.layer(false);
        if (fs != null) {
            this.checkFileObject(fs.getRoot(), clzz, refactoringElements, handle);
        }
    }

    private void checkFileObject(FileObject fo, JavaClass clzz, RefactoringElementsBag refactoringElements, LayerUtils.LayerHandle handle) {
        if (fo.isFolder()) {
            FileObject[] childs = fo.getChildren();
            for (int i = 0; i < childs.length; ++i) {
                this.checkFileObject(childs[i], clzz, refactoringElements, handle);
            }
            Enumeration en = fo.getAttributes();
            while (en.hasMoreElements()) {
                RefactoringElementImplementation elem;
                String name;
                String second;
                RefactoringElementImplementation elem2;
                String name2;
                String attrKey = (String)en.nextElement();
                Matcher match = this.orderingLayerAttrPattern.matcher(attrKey);
                if (!match.matches()) continue;
                String first = match.group(1);
                if (first.endsWith(".instance") && (name2 = first.substring(0, first.length() - ".instance".length()).replace('-', '.')).equals(clzz.getName()) && (elem2 = this.createLayerRefactoring(clzz, handle, fo, attrKey)) != null) {
                    refactoringElements.add(this.refactoring, elem2);
                }
                if (!(second = match.group(2)).endsWith(".instance") || !(name = second.substring(0, second.length() - ".instance".length()).replace('-', '.')).equals(clzz.getName()) || (elem = this.createLayerRefactoring(clzz, handle, fo, attrKey)) == null) continue;
                refactoringElements.add(this.refactoring, elem);
            }
        } else if (fo.isData()) {
            RefactoringElementImplementation elem;
            String name;
            Enumeration en = fo.getAttributes();
            while (en.hasMoreElements()) {
                RefactoringElementImplementation elem3;
                int index;
                String attrKey = (String)en.nextElement();
                Object val = fo.getAttribute("literal:" + attrKey);
                if (!(val instanceof String)) continue;
                String attrValue = (String)val;
                boolean check = false;
                String value = attrValue;
                if (attrValue.startsWith("new:")) {
                    value = attrValue.substring("new:".length());
                }
                if (attrValue.startsWith("method:") && (index = (value = attrValue.substring("method:".length())).lastIndexOf(46)) > 0) {
                    value = value.substring(0, index);
                }
                String pattern1 = clzz.getName().replaceAll("\\.", "\\.");
                String pattern2 = "[a-zA-Z0-9/-]*" + clzz.getName().replaceAll("\\.", "-") + "\\.instance";
                if (!value.matches(pattern1) && !value.matches(pattern2) || (elem3 = this.createLayerRefactoring(clzz, handle, fo, attrKey)) == null) continue;
                refactoringElements.add(this.refactoring, elem3);
            }
            if ("instance".equals(fo.getExt()) && (name = fo.getName().replace('-', '.')).equals(clzz.getName()) && (elem = this.createLayerRefactoring(clzz, handle, fo, null)) != null) {
                refactoringElements.add(this.refactoring, elem);
            }
            if ("settings".equals(fo.getExt())) {
                // empty if block
            }
        }
    }

    protected final Problem checkLayer(Method method, RefactoringElementsBag refactoringElements) {
        LayerUtils.LayerHandle handle;
        FileSystem fs;
        Problem problem = null;
        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) {
            return problem;
        }
        List params = method.getParameters();
        if (params.size() > 1) {
            return problem;
        }
        Iterator it = params.iterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            if ("org.openide.filesystems.FileObject".equals(param.getType().getName())) continue;
            return problem;
        }
        Resource res = method.getResource();
        FileObject fo = JavaModel.getFileObject((Resource)res);
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project != null && project instanceof NbModuleProject && (fs = (handle = LayerUtils.layerForProject((NbModuleProject)((NbModuleProject)project))).layer(false)) != null) {
            this.checkFileObject(fs.getRoot(), method, null, refactoringElements, handle);
        }
        return problem;
    }

    protected final Problem checkLayer(Constructor constructor, RefactoringElementsBag refactoringElements) {
        LayerUtils.LayerHandle handle;
        FileSystem fs;
        Problem problem = null;
        if (!Modifier.isPublic(constructor.getModifiers())) {
            return problem;
        }
        List params = constructor.getParameters();
        if (params.size() > 0) {
            return problem;
        }
        Resource res = constructor.getResource();
        FileObject fo = JavaModel.getFileObject((Resource)res);
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project != null && project instanceof NbModuleProject && (fs = (handle = LayerUtils.layerForProject((NbModuleProject)((NbModuleProject)project))).layer(false)) != null) {
            this.checkFileObject(fs.getRoot(), null, constructor, refactoringElements, handle);
        }
        return problem;
    }

    private void checkFileObject(FileObject fo, Method method, Constructor constructor, RefactoringElementsBag refactoringElements, LayerUtils.LayerHandle handle) {
        block7: {
            block6: {
                if (!fo.isFolder()) break block6;
                FileObject[] childs = fo.getChildren();
                for (int i = 0; i < childs.length; ++i) {
                    this.checkFileObject(childs[i], method, constructor, refactoringElements, handle);
                }
                break block7;
            }
            if (!fo.isData()) break block7;
            if ("settings".equals(fo.getExt())) {
                // empty if block
            }
            Enumeration en = fo.getAttributes();
            while (en.hasMoreElements()) {
                RefactoringElementImplementation elem;
                String clazz;
                String attrKey = (String)en.nextElement();
                Object val = fo.getAttribute("literal:" + attrKey);
                if (!(val instanceof String)) continue;
                String attrValue = (String)val;
                if (method != null && attrValue.startsWith("method:") && attrValue.endsWith(method.getName())) {
                    RefactoringElementImplementation elem2;
                    clazz = attrValue.substring("method:".length());
                    String methodString = null;
                    int index = clazz.lastIndexOf(46);
                    if (index > 0) {
                        methodString = clazz.substring(index + 1);
                        clazz = clazz.substring(0, index);
                    }
                    if (methodString != null && methodString.equals(method.getName()) && clazz.equals(method.getDeclaringClass().getName()) && (elem2 = this.createLayerRefactoring(method, handle, fo, attrKey)) != null) {
                        refactoringElements.add(this.refactoring, elem2);
                    }
                }
                if (constructor == null || !attrValue.startsWith("new:") || !(clazz = attrValue.substring("new:".length())).equals(constructor.getDeclaringClass().getName()) || (elem = this.createLayerRefactoring(constructor, handle, fo, attrKey)) == null) continue;
                refactoringElements.add(this.refactoring, elem);
            }
        }
    }

    protected abstract RefactoringElementImplementation createMetaInfServicesRefactoring(JavaClass var1, FileObject var2, int var3);

    protected abstract RefactoringElementImplementation createManifestRefactoring(JavaClass var1, FileObject var2, String var3, String var4, String var5);

    protected RefactoringElementImplementation createLayerRefactoring(JavaClass clazz, LayerUtils.LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        throw new AssertionError((Object)"if you call checkLayer(), you need to implement this method");
    }

    protected RefactoringElementImplementation createLayerRefactoring(Method method, LayerUtils.LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        throw new AssertionError((Object)"if you call checkLayer(), you need to implement this method");
    }

    protected RefactoringElementImplementation createLayerRefactoring(Constructor constructor, LayerUtils.LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        throw new AssertionError((Object)"if you call checkLayer(), you need to implement this method");
    }
}

