/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.lib.cvsclient.util.Logger;

public class LoggedDataOutputStream
extends FilterOutputStream {
    private long counter;

    public LoggedDataOutputStream(OutputStream out) {
        super(out);
    }

    public void writeChars(String line) throws IOException {
        this.writeBytes(line);
    }

    public void writeBytes(String line) throws IOException {
        byte[] bytes = line.getBytes();
        this.out.write(bytes);
        Logger.logOutput(bytes);
        this.counter += (long)bytes.length;
    }

    public void writeBytes(String line, String encoding) throws IOException {
        byte[] bytes = line.getBytes(encoding);
        this.out.write(bytes);
        Logger.logOutput(bytes);
        this.counter += (long)bytes.length;
    }

    public void write(int b) throws IOException {
        super.write(b);
        ++this.counter;
    }

    public void write(byte[] b) throws IOException {
        super.write(b);
        this.counter += (long)b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.counter += (long)len;
    }

    public void close() throws IOException {
        this.out.close();
    }

    public OutputStream getUnderlyingStream() {
        return this.out;
    }

    public void setUnderlyingStream(OutputStream os) {
        this.out = os;
    }

    public long getCounter() {
        return this.counter;
    }
}

