/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.safedelete;

import java.util.LinkedList;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.safedelete.AbstractSafeDeleteRefactoringElement;
import org.netbeans.modules.j2ee.refactoring.safedelete.BaseRefactoring;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.util.NbBundle;

public class EjbClassSafeDeleteRefactoring
extends BaseRefactoring {
    private final Ejb ejb;
    private JavaClass javaClass;
    private boolean removeLocal;
    private boolean removeRemote;

    public EjbClassSafeDeleteRefactoring(BaseRefactoring.EjbHelper helper, Ejb ejb, JavaClass javaClass) {
        super(helper);
        this.ejb = ejb;
        this.javaClass = javaClass;
    }

    protected Problem preCheckThis() {
        this.removeLocal = false;
        this.removeRemote = false;
        String ejbName = this.ejb.getEjbName();
        if (EjbClassSafeDeleteRefactoring.isEqualClass(this.ejb.getEjbClass(), this.javaClass)) {
            return new Problem(false, NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class, (String)"TXT_EjbJarBeanClassSafeDelete", (Object)this.javaClass.getName(), (Object)ejbName));
        }
        if (this.ejb instanceof EntityAndSession) {
            EntityAndSession entityAndSession = (EntityAndSession)this.ejb;
            JavaClass localHome = Utility.resolveClass(entityAndSession.getLocalHome());
            JavaClass local = Utility.resolveClass(entityAndSession.getLocal());
            JavaClass home = Utility.resolveClass(entityAndSession.getHome());
            JavaClass remote = Utility.resolveClass(entityAndSession.getRemote());
            if (this.javaClass.equals(localHome)) {
                return new Problem(false, NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class, (String)"TXT_EjbJarInterfaceClassSafeDelete", (Object)this.javaClass.getName(), (Object)ejbName));
            }
            if (this.javaClass.equals(local)) {
                return new Problem(false, NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class, (String)"TXT_EjbJarInterfaceClassSafeDelete", (Object)this.javaClass.getName(), (Object)ejbName));
            }
            if (this.javaClass.equals(home)) {
                return new Problem(false, NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class, (String)"TXT_EjbJarInterfaceClassSafeDelete", (Object)this.javaClass.getName(), (Object)ejbName));
            }
            if (this.javaClass.equals(remote)) {
                return new Problem(false, NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class, (String)"TXT_EjbJarInterfaceClassSafeDelete", (Object)this.javaClass.getName(), (Object)ejbName));
            }
            if (this.removeLocal) {
                this.addChildRefactoring(this.getBusinessInterface(entityAndSession.getLocal()));
                String msg = NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class, (String)"TXT_EjbJarLocalInterfacesSafeDelete", (Object)ejbName);
                return new Problem(false, msg);
            }
            if (this.removeRemote) {
                this.addChildRefactoring(this.getBusinessInterface(entityAndSession.getRemote()));
                String msg = NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class, (String)"TXT_EjbJarRemoteInterfacesSafeDelete", (Object)ejbName);
                return new Problem(false, msg);
            }
        }
        return null;
    }

    private JavaClass getBusinessInterface(String compInterfaceName) {
        JavaClass compInterface = Utility.resolveClass(compInterfaceName);
        JavaClass beanClass = Utility.resolveClass(this.ejb.getEjbClass());
        if (compInterface == null || beanClass == null) {
            return null;
        }
        LinkedList compInterfaces = new LinkedList(compInterface.getInterfaces());
        compInterfaces.retainAll(beanClass.getInterfaces());
        return !compInterfaces.isEmpty() ? Utility.resolveClass(((JavaClass)compInterfaces.get(0)).getName()) : null;
    }

    protected Problem prepareThis(RefactoringElementsBag refactoringElementsBag) {
        if (this.removeLocal) {
            this.helper.addRefactoringElement(refactoringElementsBag, new EjbJarRefactoringElement(true));
        } else if (this.removeRemote) {
            this.helper.addRefactoringElement(refactoringElementsBag, new EjbJarRefactoringElement(false));
        }
        return null;
    }

    private void addChildRefactoring(JavaClass javaClass) {
        if (javaClass != null && !(javaClass instanceof UnresolvedClass)) {
            this.addChildRefactoring((AbstractRefactoring)new SafeDeleteRefactoring(new Element[]{javaClass}));
        }
    }

    private static boolean isEqualClass(String className, JavaClass javaClass) {
        return Utility.resolveClass(className).equals(javaClass);
    }

    public final class EjbJarRefactoringElement
    extends AbstractSafeDeleteRefactoringElement
    implements ExternalChange {
        private final boolean local;
        private EntityAndSession entityAndSession;
        private String homeInterface;
        private String componentInterface;

        public EjbJarRefactoringElement(boolean local) {
            super(EjbClassSafeDeleteRefactoring.this.helper.getFileObject());
            this.local = local;
            this.entityAndSession = (EntityAndSession)EjbClassSafeDeleteRefactoring.this.ejb;
            this.homeInterface = local ? this.entityAndSession.getLocalHome() : this.entityAndSession.getHome();
            this.componentInterface = local ? this.entityAndSession.getLocal() : this.entityAndSession.getRemote();
        }

        public String getDisplayText() {
            String resName = this.local ? "TXT_EjbJarLocalInterfacesSafeDeleteDisplayText" : "TXT_EjbJarRemoteInterfacesSafeDeleteDisplayText";
            return NbBundle.getMessage(EjbClassSafeDeleteRefactoring.class, (String)resName);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            if (this.local) {
                this.entityAndSession.setLocalHome(null);
                this.entityAndSession.setLocal(null);
            } else {
                this.entityAndSession.setHome(null);
                this.entityAndSession.setRemote(null);
            }
            EjbClassSafeDeleteRefactoring.this.helper.writeDD();
        }

        public void undoExternalChange() {
            if (this.local) {
                this.entityAndSession.setLocalHome(this.homeInterface);
                this.entityAndSession.setLocal(this.componentInterface);
            } else {
                this.entityAndSession.setHome(this.homeInterface);
                this.entityAndSession.setRemote(this.componentInterface);
            }
            EjbClassSafeDeleteRefactoring.this.helper.writeDD();
        }
    }
}

