/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.moveclass;

import java.text.MessageFormat;
import java.util.Collection;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.JaxWsXmlRefactoringElementSupport;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.JaxWsXmlRefactoringSupport;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JaxWsXmlMoveClassRefactoring
extends JaxWsXmlRefactoringSupport {
    public Problem prepare(MoveClassRefactoring moveClassRefactor, Collection resources, RefactoringElementsBag refactoringElements) {
        for (Resource elem : resources) {
            for (JavaClass javaClass : elem.getClassifiers()) {
                JaxWsModel model = this.getModel(javaClass);
                if (model == null) {
                    return null;
                }
                if (!this.isWebSvcFromWsdl(javaClass)) continue;
                String newName = moveClassRefactor.getTargetPackageName(elem) + "." + javaClass.getSimpleName();
                Service service = model.findServiceByImplementationClass(javaClass.getName());
                if (service == null) continue;
                JaxWsXmlMoveClassRefactoringElement refactoringElem = new JaxWsXmlMoveClassRefactoringElement(javaClass.getName(), newName, model, service, model.getJaxWsFile());
                refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)refactoringElem);
            }
        }
        return null;
    }

    private static class JaxWsXmlMoveClassRefactoringElement
    extends JaxWsXmlRefactoringElementSupport {
        public JaxWsXmlMoveClassRefactoringElement(String oldName, String newName, JaxWsModel model, Service service, FileObject parentFile) {
            super(oldName, newName, model, service, parentFile);
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(JaxWsXmlMoveClassRefactoring.class, (String)"TXT_JaxWsXmlMoveClass"), args);
        }
    }
}

