/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FreeformProjectGenerator {
    private static final String[] rootElementsOrder;
    private static final String[] viewElementsOrder;
    private static final String[] folderElementsOrder;
    private static final String[] viewItemElementsOrder;
    private static final String[] contextMenuElementsOrder;
    static /* synthetic */ Class class$org$netbeans$spi$project$AuxiliaryConfiguration;
    static final /* synthetic */ boolean $assertionsDisabled;

    private FreeformProjectGenerator() {
    }

    public static AntProjectHelper createProject(File location, File dir, String name, File antScript) throws IOException {
        FileObject dirFO = FreeformProjectGenerator.createProjectDir(dir);
        FileObject locationFO = FileUtil.toFileObject((File)location);
        AntProjectHelper h = FreeformProjectGenerator.createProject(locationFO, dirFO, name, antScript);
        Project p = ProjectManager.getDefault().findProject(dirFO);
        ProjectManager.getDefault().saveProject(p);
        return h;
    }

    private static AntProjectHelper createProject(final FileObject locationFO, final FileObject dirFO, final String name, final File antScript) throws IOException {
        final AntProjectHelper[] h = new AntProjectHelper[1];
        final IOException[] ioe = new IOException[1];
        ProjectManager.mutex().writeAccess(new Runnable(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void run() {
                Project p;
                try {
                    h[0] = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.ant.freeform");
                    p = ProjectManager.getDefault().findProject(dirFO);
                }
                catch (IOException e) {
                    ioe[0] = e;
                    return;
                }
                AuxiliaryConfiguration aux = (AuxiliaryConfiguration)p.getLookup().lookup(class$org$netbeans$spi$project$AuxiliaryConfiguration == null ? (class$org$netbeans$spi$project$AuxiliaryConfiguration = FreeformProjectGenerator.class$("org.netbeans.spi.project.AuxiliaryConfiguration")) : class$org$netbeans$spi$project$AuxiliaryConfiguration);
                if (!$assertionsDisabled && aux == null) {
                    throw new AssertionError();
                }
                Element data = h[0].getPrimaryConfigurationData(true);
                Document doc = data.getOwnerDocument();
                Comment comment = doc.createComment(" " + NbBundle.getMessage((Class)(class$org$netbeans$modules$ant$freeform$FreeformProjectGenerator == null ? (class$org$netbeans$modules$ant$freeform$FreeformProjectGenerator = FreeformProjectGenerator.class$("org.netbeans.modules.ant.freeform.FreeformProjectGenerator")) : class$org$netbeans$modules$ant$freeform$FreeformProjectGenerator), (String)"LBL_Manual_Editing_Warning") + " ");
                data.appendChild(comment);
                Element nm = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "name");
                nm.appendChild(doc.createTextNode(name));
                data.appendChild(nm);
                Element props = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "properties");
                File locationF = FileUtil.toFile((FileObject)locationFO);
                File dirF = FileUtil.toFile((FileObject)dirFO);
                HashMap<String, String> properties = new HashMap<String, String>();
                if (!locationFO.equals(dirFO)) {
                    Element property = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "property");
                    property.setAttribute("name", "project.dir");
                    String path = CollocationQuery.areCollocated((File)dirF, (File)locationF) ? PropertyUtils.relativizeFile((File)dirF, (File)locationF) : locationF.getAbsolutePath();
                    property.appendChild(doc.createTextNode(path));
                    props.appendChild(property);
                    properties.put("project.dir", path);
                }
                String antPath = "build.xml";
                if (antScript != null) {
                    Element property = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "property");
                    property.setAttribute("name", "ant.script");
                    antPath = Util.relativizeLocation(locationF, dirF, antScript);
                    property.appendChild(doc.createTextNode(antPath));
                    properties.put("ant.script", antPath);
                    antPath = "${ant.script}";
                    props.appendChild(property);
                }
                PropertyEvaluator evaluator = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{PropertyUtils.fixedPropertyProvider(properties)});
                data.appendChild(props);
                h[0].putPrimaryConfigurationData(data, true);
                FreeformProjectGenerator.putBuildXMLSourceFile(h[0], antPath);
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$ant$freeform$FreeformProjectGenerator == null ? (class$org$netbeans$modules$ant$freeform$FreeformProjectGenerator = FreeformProjectGenerator.class$("org.netbeans.modules.ant.freeform.FreeformProjectGenerator")) : class$org$netbeans$modules$ant$freeform$FreeformProjectGenerator).desiredAssertionStatus();
            }
        });
        if (ioe[0] != null) {
            throw ioe[0];
        }
        return h[0];
    }

    private static FileObject createProjectDir(File dir) throws IOException {
        if (!dir.exists()) {
            FreeformProjectGenerator.refreshFileSystem(dir);
            dir.mkdirs();
            FreeformProjectGenerator.refreshFileSystem(dir);
        }
        FileObject dirFO = FileUtil.toFileObject((File)dir);
        if (!$assertionsDisabled && dirFO == null) {
            throw new AssertionError((Object)("No such dir on disk: " + dir));
        }
        if (!$assertionsDisabled && !dirFO.isFolder()) {
            throw new AssertionError((Object)("Not really a dir: " + dir));
        }
        return dirFO;
    }

    private static void refreshFileSystem(File dir) throws FileStateInvalidException {
        File rootF = dir;
        while (rootF.getParentFile() != null) {
            rootF = rootF.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)rootF);
        if (!$assertionsDisabled && dirFO == null) {
            throw new AssertionError((Object)("At least disk roots must be mounted! " + rootF));
        }
        dirFO.getFileSystem().refresh(false);
    }

    public static List getTargetMappings(AntProjectHelper helper) {
        ArrayList<TargetMapping> list = new ArrayList<TargetMapping>();
        Element genldata = helper.getPrimaryConfigurationData(true);
        Element actionsEl = Util.findElement(genldata, "ide-actions", "http://www.netbeans.org/ns/freeform-project/1");
        if (actionsEl == null) {
            return list;
        }
        List actions = Util.findSubElements(actionsEl);
        Iterator it = actions.iterator();
        while (it.hasNext()) {
            Element actionEl = (Element)it.next();
            TargetMapping tm = new TargetMapping();
            tm.name = actionEl.getAttribute("name");
            List subElems = Util.findSubElements(actionEl);
            ArrayList<String> targetNames = new ArrayList<String>(subElems.size());
            EditableProperties props = new EditableProperties(false);
            Iterator it2 = subElems.iterator();
            while (it2.hasNext()) {
                Element subEl = (Element)it2.next();
                if (subEl.getLocalName().equals("target")) {
                    targetNames.add(Util.findText(subEl));
                    continue;
                }
                if (subEl.getLocalName().equals("script")) {
                    tm.script = Util.findText(subEl);
                    continue;
                }
                if (subEl.getLocalName().equals("context")) {
                    TargetMapping.Context ctx = new TargetMapping.Context();
                    Iterator it3 = Util.findSubElements(subEl).iterator();
                    while (it3.hasNext()) {
                        Element sepFilesEl;
                        Element contextSubEl = (Element)it3.next();
                        if (contextSubEl.getLocalName().equals("property")) {
                            ctx.property = Util.findText(contextSubEl);
                            continue;
                        }
                        if (contextSubEl.getLocalName().equals("format")) {
                            ctx.format = Util.findText(contextSubEl);
                            continue;
                        }
                        if (contextSubEl.getLocalName().equals("folder")) {
                            ctx.folder = Util.findText(contextSubEl);
                            continue;
                        }
                        if (contextSubEl.getLocalName().equals("pattern")) {
                            ctx.pattern = Util.findText(contextSubEl);
                            continue;
                        }
                        if (!contextSubEl.getLocalName().equals("arity") || (sepFilesEl = Util.findElement(contextSubEl, "separated-files", "http://www.netbeans.org/ns/freeform-project/1")) == null) continue;
                        ctx.separator = Util.findText(sepFilesEl);
                    }
                    tm.context = ctx;
                }
                if (!subEl.getLocalName().equals("property")) continue;
                FreeformProjectGenerator.readProperty(subEl, props);
            }
            tm.targets = targetNames;
            if (props.keySet().size() > 0) {
                tm.properties = props;
            }
            list.add(tm);
        }
        return list;
    }

    private static void readProperty(Element propertyElement, EditableProperties props) {
        String key = propertyElement.getAttribute("name");
        String value = Util.findText(propertyElement);
        props.setProperty(key, value);
    }

    public static void putTargetMappings(AntProjectHelper helper, List mappings) {
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element actions = Util.findElement(data, "ide-actions", "http://www.netbeans.org/ns/freeform-project/1");
        if (actions != null) {
            data.removeChild(actions);
        }
        actions = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "ide-actions");
        Iterator it = mappings.iterator();
        while (it.hasNext()) {
            TargetMapping tm = (TargetMapping)it.next();
            Element action = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "action");
            action.setAttribute("name", tm.name);
            if (tm.script != null) {
                Element script = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "script");
                script.appendChild(doc.createTextNode(tm.script));
                action.appendChild(script);
            }
            if (tm.targets != null) {
                Iterator it2 = tm.targets.iterator();
                while (it2.hasNext()) {
                    String targetName = (String)it2.next();
                    Element target = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "target");
                    target.appendChild(doc.createTextNode(targetName));
                    action.appendChild(target);
                }
            }
            if (tm.properties != null) {
                FreeformProjectGenerator.writeProperties(tm.properties, doc, action);
            }
            if (tm.context != null) {
                Element context = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "context");
                TargetMapping.Context ctx = tm.context;
                if (!$assertionsDisabled && ctx.property == null) {
                    throw new AssertionError();
                }
                Element property = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "property");
                property.appendChild(doc.createTextNode(ctx.property));
                context.appendChild(property);
                if (!$assertionsDisabled && ctx.folder == null) {
                    throw new AssertionError();
                }
                Element folder = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "folder");
                folder.appendChild(doc.createTextNode(ctx.folder));
                context.appendChild(folder);
                if (ctx.pattern != null) {
                    Element pattern = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "pattern");
                    pattern.appendChild(doc.createTextNode(ctx.pattern));
                    context.appendChild(pattern);
                }
                if (!$assertionsDisabled && ctx.format == null) {
                    throw new AssertionError();
                }
                Element format = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "format");
                format.appendChild(doc.createTextNode(ctx.format));
                context.appendChild(format);
                Element arity = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "arity");
                if (ctx.separator != null) {
                    Element sepFilesEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "separated-files");
                    sepFilesEl.appendChild(doc.createTextNode(ctx.separator));
                    arity.appendChild(sepFilesEl);
                } else {
                    arity.appendChild(doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "one-file-only"));
                }
                context.appendChild(arity);
                action.appendChild(context);
            }
            actions.appendChild(action);
        }
        Util.appendChildElement(data, actions, rootElementsOrder);
        helper.putPrimaryConfigurationData(data, true);
    }

    private static void writeProperties(EditableProperties props, Document doc, Element element) {
        Iterator it2 = props.keySet().iterator();
        while (it2.hasNext()) {
            String key = (String)it2.next();
            String value = props.getProperty(key);
            Element property = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "property");
            property.setAttribute("name", key);
            property.appendChild(doc.createTextNode(value));
            element.appendChild(property);
        }
    }

    public static void putContextMenuAction(AntProjectHelper helper, List mappings) {
        Element contextMenuEl;
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element viewEl = Util.findElement(data, "view", "http://www.netbeans.org/ns/freeform-project/1");
        if (viewEl == null) {
            viewEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "view");
            Util.appendChildElement(data, viewEl, rootElementsOrder);
        }
        if ((contextMenuEl = Util.findElement(viewEl, "context-menu", "http://www.netbeans.org/ns/freeform-project/1")) == null) {
            contextMenuEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "context-menu");
            Util.appendChildElement(viewEl, contextMenuEl, viewElementsOrder);
        }
        List contextMenuElements = Util.findSubElements(contextMenuEl);
        Iterator it = contextMenuElements.iterator();
        while (it.hasNext()) {
            Element ideActionEl = (Element)it.next();
            if (!ideActionEl.getLocalName().equals("ide-action")) continue;
            contextMenuEl.removeChild(ideActionEl);
        }
        it = mappings.iterator();
        while (it.hasNext()) {
            TargetMapping tm = (TargetMapping)it.next();
            if (tm.context != null) continue;
            Element ideAction = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "ide-action");
            ideAction.setAttribute("name", tm.name);
            Util.appendChildElement(contextMenuEl, ideAction, contextMenuElementsOrder);
        }
        helper.putPrimaryConfigurationData(data, true);
    }

    public static List getCustomContextMenuActions(AntProjectHelper helper) {
        ArrayList<CustomTarget> list = new ArrayList<CustomTarget>();
        Element genldata = helper.getPrimaryConfigurationData(true);
        Element viewEl = Util.findElement(genldata, "view", "http://www.netbeans.org/ns/freeform-project/1");
        if (viewEl == null) {
            return list;
        }
        Element contextMenuEl = Util.findElement(viewEl, "context-menu", "http://www.netbeans.org/ns/freeform-project/1");
        if (contextMenuEl == null) {
            return list;
        }
        List actions = Util.findSubElements(contextMenuEl);
        Iterator it = actions.iterator();
        while (it.hasNext()) {
            Element actionEl = (Element)it.next();
            if (!actionEl.getLocalName().equals("action")) continue;
            CustomTarget ct = new CustomTarget();
            List subElems = Util.findSubElements(actionEl);
            ArrayList<String> targetNames = new ArrayList<String>(subElems.size());
            EditableProperties props = new EditableProperties(false);
            Iterator it2 = subElems.iterator();
            while (it2.hasNext()) {
                Element subEl = (Element)it2.next();
                if (subEl.getLocalName().equals("target")) {
                    targetNames.add(Util.findText(subEl));
                    continue;
                }
                if (subEl.getLocalName().equals("script")) {
                    ct.script = Util.findText(subEl);
                    continue;
                }
                if (subEl.getLocalName().equals("label")) {
                    ct.label = Util.findText(subEl);
                    continue;
                }
                if (!subEl.getLocalName().equals("property")) continue;
                FreeformProjectGenerator.readProperty(subEl, props);
            }
            ct.targets = targetNames;
            if (props.keySet().size() > 0) {
                ct.properties = props;
            }
            list.add(ct);
        }
        return list;
    }

    public static void putCustomContextMenuActions(AntProjectHelper helper, List customTargets) {
        Element contextMenuEl;
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element viewEl = Util.findElement(data, "view", "http://www.netbeans.org/ns/freeform-project/1");
        if (viewEl == null) {
            viewEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "view");
            Util.appendChildElement(data, viewEl, rootElementsOrder);
        }
        if ((contextMenuEl = Util.findElement(viewEl, "context-menu", "http://www.netbeans.org/ns/freeform-project/1")) == null) {
            contextMenuEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "context-menu");
            Util.appendChildElement(viewEl, contextMenuEl, viewElementsOrder);
        }
        List contextMenuElements = Util.findSubElements(contextMenuEl);
        Iterator it = contextMenuElements.iterator();
        while (it.hasNext()) {
            Element actionEl = (Element)it.next();
            if (!actionEl.getLocalName().equals("action")) continue;
            contextMenuEl.removeChild(actionEl);
        }
        it = customTargets.iterator();
        while (it.hasNext()) {
            CustomTarget ct = (CustomTarget)it.next();
            Element action = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "action");
            if (ct.script != null) {
                Element script = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "script");
                script.appendChild(doc.createTextNode(ct.script));
                action.appendChild(script);
            }
            Element label = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "label");
            label.appendChild(doc.createTextNode(ct.label));
            action.appendChild(label);
            if (ct.targets != null) {
                Iterator it2 = ct.targets.iterator();
                while (it2.hasNext()) {
                    String targetName = (String)it2.next();
                    Element target = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "target");
                    target.appendChild(doc.createTextNode(targetName));
                    action.appendChild(target);
                }
            }
            if (ct.properties != null) {
                FreeformProjectGenerator.writeProperties(ct.properties, doc, action);
            }
            Util.appendChildElement(contextMenuEl, action, contextMenuElementsOrder);
        }
        helper.putPrimaryConfigurationData(data, true);
    }

    private static void putBuildXMLSourceFile(AntProjectHelper helper, String antPath) {
        Element itemsEl;
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element viewEl = Util.findElement(data, "view", "http://www.netbeans.org/ns/freeform-project/1");
        if (viewEl == null) {
            viewEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "view");
            Util.appendChildElement(data, viewEl, rootElementsOrder);
        }
        if ((itemsEl = Util.findElement(viewEl, "items", "http://www.netbeans.org/ns/freeform-project/1")) == null) {
            itemsEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "items");
            Util.appendChildElement(viewEl, itemsEl, viewElementsOrder);
        }
        Element fileEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "source-file");
        Element el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/1", "location");
        el.appendChild(doc.createTextNode(antPath));
        fileEl.appendChild(el);
        Util.appendChildElement(itemsEl, fileEl, viewItemElementsOrder);
        helper.putPrimaryConfigurationData(data, true);
    }

    public static FileObject getAntScript(AntProjectHelper helper, PropertyEvaluator ev) {
        String antScript = ev.getProperty("ant.script");
        if (antScript != null) {
            File f = helper.resolveFile(antScript);
            if (!f.exists()) {
                return null;
            }
            FileObject fo = FileUtil.toFileObject((File)f);
            return fo;
        }
        FileObject fo = helper.getProjectDirectory().getFileObject("build.xml");
        return fo;
    }

    static {
        $assertionsDisabled = !FreeformProjectGenerator.class.desiredAssertionStatus();
        rootElementsOrder = new String[]{"name", "properties", "folders", "ide-actions", "export", "view", "subprojects"};
        viewElementsOrder = new String[]{"items", "context-menu"};
        folderElementsOrder = new String[]{"source-folder", "build-folder"};
        viewItemElementsOrder = new String[]{"source-folder", "source-file"};
        contextMenuElementsOrder = new String[]{"ide-action", "separator", "action"};
    }

    public static final class TargetMapping {
        public String script;
        public List targets;
        public String name;
        public EditableProperties properties;
        public Context context;

        public static final class Context {
            public String property;
            public String format;
            public String folder;
            public String pattern;
            public String separator;
        }
    }

    public static final class CustomTarget {
        public List targets;
        public String label;
        public String script;
        public EditableProperties properties;
    }
}

