/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.weaving;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.StringTokenizer;
import javax.persistence.spi.ClassTransformer;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.weaving.ClassDetails;
import oracle.toplink.essentials.internal.weaving.TopLinkClassWeaver;
import oracle.toplink.essentials.sessions.Session;
import oracle.toplink.libraries.asm.ClassReader;
import oracle.toplink.libraries.asm.ClassWriter;
import oracle.toplink.libraries.asm.attrs.Attributes;

public class TopLinkWeaver
implements ClassTransformer {
    public static final String WEAVING_OUTPUT_PATH = "toplink.weaving.output.path";
    public static final String WEAVING_SHOULD_OVERWRITE = "toplink.weaving.overwrite.existing";
    public static final String WEAVER_NOT_OVERWRITING = "weaver_not_overwriting";
    public static final String WEAVER_COULD_NOT_WRITE = "weaver_could_not_write";
    protected Session session;
    protected Map classDetailsMap;

    public TopLinkWeaver(Session session, Map classDetailsMap) {
        this.session = session;
        this.classDetailsMap = classDetailsMap;
    }

    public Map getClassDetailsMap() {
        return this.classDetailsMap;
    }

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        ClassDetails classDetails = (ClassDetails)this.classDetailsMap.get(className);
        if (classDetails != null) {
            ClassReader cr = new ClassReader(classfileBuffer);
            ClassWriter cw = new ClassWriter(true, true);
            TopLinkClassWeaver tcw = new TopLinkClassWeaver(cw, classDetails);
            cr.accept(tcw, Attributes.getDefaultAttributes(), false);
            if (tcw.alreadyWeaved) {
                return null;
            }
            byte[] bytes = cw.toByteArray();
            String outputPath = System.getProperty(WEAVING_OUTPUT_PATH, "");
            if (!outputPath.equals("")) {
                this.outputFile(className, bytes, outputPath);
            }
            if (tcw.weavedVH) {
                return bytes;
            }
        }
        return null;
    }

    protected void outputFile(String className, byte[] classBytes, String outputPath) {
        StringBuffer directoryName = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(className, "\n\\/");
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            directoryName.append(token + File.separator);
        }
        try {
            String usedOutputPath = outputPath;
            if (!outputPath.endsWith(File.separator)) {
                usedOutputPath = outputPath + File.separator;
            }
            File file = new File(usedOutputPath + directoryName);
            file.mkdirs();
            file = new File(file, token + ".class");
            if (!file.exists()) {
                file.createNewFile();
            } else if (!System.getProperty(WEAVING_SHOULD_OVERWRITE, "false").equalsIgnoreCase("true")) {
                ((AbstractSession)this.session).log(6, "weaver", WEAVER_NOT_OVERWRITING, className);
                return;
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(classBytes);
            fos.close();
        }
        catch (Exception e) {
            ((AbstractSession)this.session).log(6, "weaver", WEAVER_COULD_NOT_WRITE, className, e);
        }
    }

    protected static String getShortName(String name) {
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            if ((name = name.substring(pos + 1)).endsWith(";")) {
                name = name.substring(0, name.length() - 1);
            }
            return name;
        }
        return "";
    }
}

