/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.indirection;

import java.util.Vector;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.IntegrityChecker;
import oracle.toplink.essentials.indirection.IndirectContainer;
import oracle.toplink.essentials.indirection.ValueHolder;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import oracle.toplink.essentials.internal.descriptors.DescriptorIterator;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.indirection.BackupValueHolder;
import oracle.toplink.essentials.internal.indirection.DatabaseValueHolder;
import oracle.toplink.essentials.internal.indirection.IndirectionPolicy;
import oracle.toplink.essentials.internal.indirection.QueryBasedValueHolder;
import oracle.toplink.essentials.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.essentials.internal.queryframework.ContainerPolicy;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.queryframework.ReadQuery;

public class TransparentIndirectionPolicy
extends IndirectionPolicy {
    protected static Integer defaultContainerSize;

    public Object backupCloneAttribute(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        if (!(attributeValue instanceof IndirectContainer) || this.objectIsInstantiated(attributeValue)) {
            return super.backupCloneAttribute(attributeValue, clone, backup, unitOfWork);
        }
        return this.buildBackupClone((IndirectContainer)attributeValue);
    }

    protected Object buildBackupClone(IndirectContainer container) {
        UnitOfWorkValueHolder containerValueHolder = (UnitOfWorkValueHolder)container.getValueHolder();
        BackupValueHolder backupValueHolder = new BackupValueHolder(containerValueHolder);
        containerValueHolder.setBackupValueHolder(backupValueHolder);
        return this.buildIndirectContainer(backupValueHolder);
    }

    protected IndirectContainer buildIndirectContainer() {
        if (defaultContainerSize != null) {
            return (IndirectContainer)this.getContainerPolicy().containerInstance(TransparentIndirectionPolicy.getDefaultContainerSize());
        }
        return (IndirectContainer)this.getContainerPolicy().containerInstance();
    }

    protected Object buildIndirectContainer(ValueHolderInterface valueHolder) {
        IndirectContainer result = this.buildIndirectContainer();
        result.setValueHolder(valueHolder);
        return result;
    }

    public Object cloneAttribute(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean buildDirectlyFromRow) {
        ValueHolderInterface valueHolder = null;
        Object container = null;
        if (attributeValue instanceof IndirectContainer) {
            valueHolder = ((IndirectContainer)attributeValue).getValueHolder();
        }
        if (!buildDirectlyFromRow && unitOfWork.isOriginalNewObject(original)) {
            if (valueHolder instanceof DatabaseValueHolder && !((DatabaseValueHolder)valueHolder).isInstantiated() && ((DatabaseValueHolder)valueHolder).getSession() == null && !((DatabaseValueHolder)valueHolder).isSerializedRemoteUnitOfWorkValueHolder()) {
                throw DescriptorException.attemptToRegisterDeadIndirection(original, this.getMapping());
            }
            if (this.getMapping().getRelationshipPartner() == null) {
                container = this.getMapping().buildCloneForPartObject(attributeValue, original, clone, unitOfWork, false);
            } else {
                if (!(attributeValue instanceof IndirectContainer)) {
                    valueHolder = new ValueHolder(attributeValue);
                }
                AbstractRecord row = null;
                if (valueHolder instanceof DatabaseValueHolder) {
                    row = ((DatabaseValueHolder)valueHolder).getRow();
                }
                UnitOfWorkValueHolder newValueHolder = this.getMapping().createUnitOfWorkValueHolder(valueHolder, original, clone, row, unitOfWork, buildDirectlyFromRow);
                container = this.buildIndirectContainer(newValueHolder);
                Object cloneCollection = this.getMapping().buildCloneForPartObject(attributeValue, original, clone, unitOfWork, false);
                newValueHolder.privilegedSetValue(cloneCollection);
                newValueHolder.setInstantiated();
            }
        } else {
            if (!(attributeValue instanceof IndirectContainer)) {
                valueHolder = new ValueHolder(attributeValue);
            }
            AbstractRecord row = null;
            if (valueHolder instanceof DatabaseValueHolder) {
                row = ((DatabaseValueHolder)valueHolder).getRow();
            }
            container = this.buildIndirectContainer(this.getMapping().createUnitOfWorkValueHolder(valueHolder, original, clone, row, unitOfWork, buildDirectlyFromRow));
        }
        return container;
    }

    protected boolean containerPolicyIsValid() {
        return Helper.classImplementsInterface(this.getContainerClass(), ClassConstants.IndirectContainer_Class);
    }

    public Vector extractPrimaryKeyForReferenceObject(Object referenceObject, AbstractSession session) {
        throw DescriptorException.invalidUseOfTransparentIndirection(this.getMapping());
    }

    public AbstractRecord extractReferenceRow(Object referenceObject) {
        if (this.objectIsInstantiated(referenceObject)) {
            return null;
        }
        return ((DatabaseValueHolder)((IndirectContainer)referenceObject).getValueHolder()).getRow();
    }

    protected Class getContainerClass() {
        return this.getContainerPolicy().getContainerClass();
    }

    protected ContainerPolicy getContainerPolicy() {
        return this.getCollectionMapping().getContainerPolicy();
    }

    protected static int getDefaultContainerSize() {
        return defaultContainerSize;
    }

    public Object getOriginalIndirectionObject(Object unitOfWorkIndirectionObject, AbstractSession session) {
        IndirectContainer container = (IndirectContainer)unitOfWorkIndirectionObject;
        if (container.getValueHolder() instanceof UnitOfWorkValueHolder) {
            ValueHolderInterface valueHolder = ((UnitOfWorkValueHolder)container.getValueHolder()).getWrappedValueHolder();
            return this.buildIndirectContainer(valueHolder);
        }
        return container;
    }

    public Object getRealAttributeValueFromObject(Object object) {
        this.getContainerPolicy().sizeFor(object);
        return object;
    }

    public void setRealAttributeValueInObject(Object target, Object attributeValue) {
        super.setRealAttributeValueInObject(target, attributeValue);
    }

    public void iterateOnAttributeValue(DescriptorIterator iterator, Object attributeValue) {
        if (attributeValue instanceof IndirectContainer) {
            iterator.iterateIndirectContainerForMapping((IndirectContainer)attributeValue, this.getMapping());
        } else {
            super.iterateOnAttributeValue(iterator, attributeValue);
        }
    }

    public Object nullValueFromRow() {
        throw DescriptorException.invalidUseOfTransparentIndirection(this.getMapping());
    }

    public boolean objectIsInstantiated(Object object) {
        if (object instanceof IndirectContainer) {
            return ((IndirectContainer)object).isInstantiated();
        }
        return true;
    }

    public static void setDefaultContainerSize(int defaultSize) {
        defaultContainerSize = new Integer(defaultSize);
    }

    protected boolean typeIsValid(Class declaredType) {
        if (Helper.classIsSubclass(this.getContainerClass(), declaredType)) {
            return true;
        }
        return Helper.classImplementsInterface(this.getContainerClass(), declaredType);
    }

    public boolean usesTransparentIndirection() {
        return true;
    }

    public Object validateAttributeOfInstantiatedObject(Object attributeValue) {
        if (attributeValue == null) {
            return this.buildIndirectContainer();
        }
        if (!this.getContainerPolicy().isValidContainer(attributeValue)) {
            throw DescriptorException.indirectContainerInstantiationMismatch(attributeValue, this.getMapping());
        }
        return attributeValue;
    }

    public void validateContainerPolicy(IntegrityChecker checker) throws DescriptorException {
        super.validateContainerPolicy(checker);
        if (!this.containerPolicyIsValid()) {
            checker.handleError(DescriptorException.invalidContainerPolicyWithTransparentIndirection(this.getMapping(), this.getContainerPolicy()));
        }
        if (this.getContainerPolicy().isMapPolicy() && (((ForeignReferenceMapping)this.getMapping()).getRelationshipPartnerAttributeName() != null || this.getMapping().getRelationshipPartner() != null)) {
            checker.handleError(DescriptorException.unsupportedTypeForBidirectionalRelationshipMaintenance(this.getMapping(), this.getContainerPolicy()));
        }
    }

    public void validateDeclaredAttributeType(Class attributeType, IntegrityChecker checker) throws DescriptorException {
        super.validateDeclaredAttributeType(attributeType, checker);
        if (!this.typeIsValid(attributeType)) {
            checker.handleError(DescriptorException.attributeAndMappingWithTransparentIndirectionMismatch(this.getMapping(), this.validTypeName()));
        }
    }

    public void validateGetMethodReturnType(Class returnType, IntegrityChecker checker) throws DescriptorException {
        super.validateGetMethodReturnType(returnType, checker);
        if (!this.typeIsValid(returnType)) {
            checker.handleError(DescriptorException.returnAndMappingWithTransparentIndirectionMismatch(this.getMapping(), this.validTypeName()));
        }
    }

    public void validateSetMethodParameterType(Class parameterType, IntegrityChecker checker) throws DescriptorException {
        super.validateSetMethodParameterType(parameterType, checker);
        if (!this.typeIsValid(parameterType)) {
            checker.handleError(DescriptorException.parameterAndMappingWithTransparentIndirectionMismatch(this.getMapping(), this.validTypeName()));
        }
    }

    protected String validTypeName() {
        return Helper.getShortClassName(this.getContainerClass());
    }

    public Object valueFromMethod(Object object, AbstractRecord row, AbstractSession session) {
        throw DescriptorException.invalidUseOfTransparentIndirection(this.getMapping());
    }

    public Object valueFromQuery(ReadQuery query, AbstractRecord row, AbstractSession session) {
        return this.buildIndirectContainer(new QueryBasedValueHolder(query, row, session));
    }

    public Object valueFromQuery(ReadQuery query, AbstractRecord row, Object object, AbstractSession session) {
        return this.valueFromQuery(query, row, session);
    }

    public Object valueFromRow(Object object) {
        return object;
    }
}

