/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Dictionary;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.expressions.ExpressionIterator;
import oracle.toplink.essentials.internal.expressions.ExpressionNormalizer;
import oracle.toplink.essentials.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.essentials.internal.expressions.LogicalExpression;
import oracle.toplink.essentials.internal.expressions.QueryKeyExpression;
import oracle.toplink.essentials.internal.expressions.RelationExpression;
import oracle.toplink.essentials.internal.expressions.SQLSelectStatement;
import oracle.toplink.essentials.internal.queryframework.ExpressionQueryMechanism;
import oracle.toplink.essentials.internal.queryframework.StatementQueryMechanism;
import oracle.toplink.essentials.queryframework.ReportQuery;
import oracle.toplink.essentials.queryframework.SQLCall;

public class SubSelectExpression
extends Expression {
    protected Expression baseExpression;
    protected ReportQuery subQuery;

    public SubSelectExpression() {
    }

    public SubSelectExpression(ReportQuery query, Expression baseExpression) {
        this();
        this.subQuery = query;
        this.baseExpression = baseExpression;
    }

    public String descriptionOfNodeType() {
        return "SubSelect";
    }

    public Expression getBaseExpression() {
        return this.baseExpression;
    }

    public ExpressionBuilder getBuilder() {
        return this.getBaseExpression().getBuilder();
    }

    public ReportQuery getSubQuery() {
        return this.subQuery;
    }

    public void iterateOn(ExpressionIterator iterator) {
        super.iterateOn(iterator);
        if (this.baseExpression != null) {
            this.baseExpression.iterateOn(iterator);
        }
        if (iterator.shouldIterateOverSubSelects()) {
            if (this.getSubQuery().getSelectionCriteria() != null) {
                this.getSubQuery().getSelectionCriteria().iterateOn(iterator);
            } else {
                this.getSubQuery().getExpressionBuilder().iterateOn(iterator);
            }
        }
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        this.validateNode();
        normalizer.addSubSelectExpression(this);
        normalizer.getStatement().setRequiresAliases(true);
        return this;
    }

    public Expression normalizeSubSelect(ExpressionNormalizer normalizer, Dictionary clonedExpressions) {
        if (!this.getSubQuery().isCallQuery() && this.getSubQuery().getReferenceClass() == null) {
            Expression rightChild;
            ReportQuery subQuery = this.getSubQuery();
            Expression criteria = subQuery.getSelectionCriteria();
            if (criteria instanceof LogicalExpression) {
                criteria = ((LogicalExpression)criteria).getFirstChild();
            }
            if (criteria instanceof RelationExpression && (rightChild = ((RelationExpression)criteria).getSecondChild()) instanceof QueryKeyExpression) {
                subQuery.setReferenceClass(((QueryKeyExpression)rightChild).getDescriptor().getJavaClass());
            }
        }
        this.validateNode();
        this.getSubQuery().prepareSubSelect(normalizer.getSession(), null, clonedExpressions);
        if (!this.getSubQuery().isCallQuery()) {
            SQLSelectStatement statement = (SQLSelectStatement)((StatementQueryMechanism)this.getSubQuery().getQueryMechanism()).getSQLStatement();
            statement.setRequiresAliases(true);
            statement.setParentStatement(normalizer.getStatement());
            statement.normalize(normalizer.getSession(), this.getSubQuery().getDescriptor(), clonedExpressions);
        }
        return this;
    }

    protected void postCopyIn(Dictionary alreadyDone) {
        super.postCopyIn(alreadyDone);
        this.setBaseExpression(this.getBaseExpression().copiedVersionFrom(alreadyDone));
        ReportQuery clonedQuery = (ReportQuery)this.getSubQuery().clone();
        if (!clonedQuery.isCallQuery() && clonedQuery.getSelectionCriteria() != null) {
            clonedQuery.setSelectionCriteria(this.getSubQuery().getSelectionCriteria().copiedVersionFrom(alreadyDone));
            if (alreadyDone.get(alreadyDone) != null) {
                clonedQuery.copyReportItems(alreadyDone);
            }
        }
        this.setSubQuery(clonedQuery);
    }

    protected void printCustomSQL(ExpressionSQLPrinter printer) {
        SQLCall call = (SQLCall)this.getSubQuery().getCall();
        call.translateCustomQuery();
        printer.getCall().getParameters().addAll(call.getParameters());
        printer.getCall().getParameterTypes().addAll(call.getParameterTypes());
        printer.printString(call.getCallString());
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        ReportQuery query = this.getSubQuery();
        printer.printString("(");
        if (query.isCallQuery()) {
            this.printCustomSQL(printer);
        } else {
            SQLSelectStatement statement = (SQLSelectStatement)((ExpressionQueryMechanism)query.getQueryMechanism()).getSQLStatement();
            boolean isFirstElementPrinted = printer.isFirstElementPrinted();
            printer.setIsFirstElementPrinted(false);
            boolean requiresDistinct = printer.requiresDistinct();
            statement.printSQL(printer);
            printer.setIsFirstElementPrinted(isFirstElementPrinted);
            printer.setRequiresDistinct(requiresDistinct);
        }
        printer.printString(")");
    }

    public Expression rebuildOn(Expression newBase) {
        return this;
    }

    protected void setBaseExpression(Expression baseExpression) {
        this.baseExpression = baseExpression;
    }

    public void setSubQuery(ReportQuery subQuery) {
        this.subQuery = subQuery;
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(String.valueOf(this.getSubQuery()));
    }

    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.getSubQuery().getSelectionCriteria() != null) {
            this.getSubQuery().getSelectionCriteria().toString(writer, indent);
        }
    }
}

