/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.base;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public class ExceptionFactory {
    protected String stackTraceString(Exception ex) {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)swriter, true);
        ex.printStackTrace(writer);
        writer.close();
        return swriter.toString();
    }

    public SystemException newSystemException(String str) {
        return new SystemException(str);
    }

    public SystemException newSystemException(Exception ex) {
        return new SystemException("Real nested exception: " + this.stackTraceString(ex));
    }

    public RollbackException rollbackException(SQLException sqlEx) {
        return new RollbackException(sqlEx.toString());
    }

    public SystemException txMarkedForRollbackException() {
        return this.newSystemException("Transaction marked for rollback");
    }

    public SystemException txActiveException() {
        return this.newSystemException("Transaction is already active");
    }

    public SystemException txNotActiveException() {
        return this.newSystemException("No transaction is active");
    }

    public SystemException invalidStateException(int state) {
        return this.newSystemException("Cannot complete operation, invalid state: " + state);
    }
}

