/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.sync;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.text.Document;
import org.netbeans.modules.xml.core.XMLDataObjectLook;
import org.netbeans.modules.xml.core.cookies.CookieManagerCookie;
import org.netbeans.modules.xml.core.sync.FileRepresentation;
import org.netbeans.modules.xml.core.sync.Representation;
import org.netbeans.modules.xml.core.sync.SyncSupport;
import org.netbeans.modules.xml.core.sync.Synchronizator;
import org.netbeans.modules.xml.core.sync.Util;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class DataObjectSyncSupport
extends SyncSupport
implements Synchronizator {
    private final Vector reps = new Vector(3);
    private final CookieManagerCookie cookieMgr;

    public DataObjectSyncSupport(XMLDataObjectLook dobj) {
        super((DataObject)dobj);
        this.cookieMgr = dobj.getCookieManager();
        FileRepresentation basic = new FileRepresentation(this.getDO(), this);
        this.reps.add(basic);
    }

    public void representationChanged(Class type) {
        super.representationChanged(type);
    }

    protected Representation[] getRepresentations() {
        return this.reps.toArray(new Representation[0]);
    }

    public Representation getPrimaryRepresentation() {
        Class[] priority = new Class[]{Document.class, FileObject.class};
        Representation[] all = this.getRepresentations();
        for (int i = 0; i < priority.length; ++i) {
            for (int r = 0; r < all.length; ++r) {
                Representation rep = all[r];
                if (!rep.isValid() || !rep.represents(priority[i])) continue;
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("Primary rep = " + rep);
                }
                return rep;
            }
        }
        throw new IllegalStateException("No primary representation found: " + this.reps);
    }

    public void addRepresentation(Representation rep) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Sync addRepresentation " + rep);
        }
        if (rep.represents(Document.class)) {
            Iterator it = this.reps.iterator();
            while (it.hasNext()) {
                Representation next = (Representation)it.next();
                if (!next.represents(class$org$openide$filesystems$FileObject == null ? DataObjectSyncSupport.class$("org.openide.filesystems.FileObject") : class$org$openide$filesystems$FileObject)) continue;
                it.remove();
            }
        } else if (rep.level() > 1) {
            this.loadTextRepresentation();
        }
        this.reps.add(rep);
    }

    public void removeRepresentation(Representation rep) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Sync removeRepresentation " + rep);
        }
        boolean modelLoaded = false;
        if (rep.represents(Document.class)) {
            Iterator it = this.reps.iterator();
            while (it.hasNext()) {
                Representation next = (Representation)it.next();
                if (next.level() <= 1) continue;
                modelLoaded = true;
            }
            if (!modelLoaded) {
                FileRepresentation basic = new FileRepresentation(this.getDO(), this);
                this.reps.add(basic);
            } else {
                this.loadTextRepresentation();
            }
        }
        this.reps.remove(rep);
        if (modelLoaded) {
            this.representationChanged(Document.class);
        }
    }

    private void loadTextRepresentation() {
        if (this.getDO().isValid()) {
            try {
                EditorCookie editor = (EditorCookie)this.getDO().getCookie(EditorCookie.class);
                editor.openDocument();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

