/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.hints.HintsUI;
import org.netbeans.modules.editor.hints.spi.Hint;
import org.netbeans.modules.editor.hints.spi.HintsProvider;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class HintsOperator
implements CaretListener,
ChangeListener,
PropertyChangeListener,
ComponentListener,
FocusListener,
KeyListener {
    private static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.hints");
    private static RequestProcessor HINTS_REQUEST_PROCESSOR = new RequestProcessor("Hints RP", 1);
    private Reference componentRef = null;
    private RequestProcessor.Task hintTask;
    private RequestProcessor.Task hintPopupTask;
    private List hintsProviders;
    private int hintsType;
    private int lastOffset = -1;
    private int lineOffset;
    private int lastLineOffset;
    private HintsUI ui = new HintsUI();
    private static HintsOperator instance = new HintsOperator();

    private HintsOperator() {
        this.hintTask = HINTS_REQUEST_PROCESSOR.create((Runnable)new HintPopupTaskImpl(false));
        this.hintPopupTask = HINTS_REQUEST_PROCESSOR.create((Runnable)new HintPopupTaskImpl(true));
        this.hintTask.setPriority(1);
        Registry.addChangeListener((ChangeListener)this);
    }

    public static HintsOperator getDefault() {
        return instance;
    }

    public synchronized void caretUpdate(CaretEvent e) {
        JTextComponent component = this.getComponent();
        if (component == null) {
            return;
        }
        if (!component.isFocusOwner()) {
            return;
        }
        this.lastOffset = component.getCaretPosition();
        BaseDocument doc = Utilities.getDocument((JTextComponent)component);
        if (doc != null) {
            try {
                this.lineOffset = Utilities.getLineOffset((BaseDocument)doc, (int)this.lastOffset);
                if (this.lineOffset != this.lastLineOffset && this.ui.isActive()) {
                    this.ui.setHints(null, null, false);
                }
                this.lastLineOffset = this.lineOffset;
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
        this.hintTask.schedule(200);
    }

    private void setCurrentHints(final List currentHints, final int hintsType, final boolean showPopup) {
        JTextComponent component = this.getComponent();
        if (component == null || !component.hasFocus()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JTextComponent component = HintsOperator.this.getComponent();
                if (component == null) {
                    return;
                }
                component.getDocument().render(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        HintsOperator hintsOperator = HintsOperator.this;
                        synchronized (hintsOperator) {
                            JTextComponent component = HintsOperator.this.getComponent();
                            if (component == null) {
                                return;
                            }
                            HintsOperator.this.hintsType = hintsType;
                            if (currentHints != null && currentHints.size() > 0) {
                                HintsOperator.this.ui.setHints(currentHints, component, showPopup);
                            } else {
                                HintsOperator.this.ui.setHints(null, null, false);
                            }
                        }
                    }
                });
            }
        });
    }

    public void componentHidden(ComponentEvent e) {
        this.ui.setHints(null, null, false);
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
        this.ui.setHints(null, null, false);
        this.hintTask.schedule(500);
    }

    public void componentResized(ComponentEvent e) {
        this.componentMoved(e);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && e.getModifiersEx() == 512 && !this.ui.isActive()) {
            if (!this.hintTask.isFinished()) {
                this.hintTask.cancel();
            }
            if (!this.hintPopupTask.isFinished()) {
                this.hintPopupTask.cancel();
            }
            this.hintPopupTask.schedule(0);
            e.consume();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        JTextComponent active = Registry.getMostActiveComponent();
        if (this.ui.getComponent() != active) {
            this.ui.setHints(null, null, false);
            this.unregisterFromComponent();
            this.registerNewComponent(active);
        }
    }

    private synchronized void unregisterFromComponent() {
        JTextComponent component = this.getComponent();
        if (component == null) {
            return;
        }
        if (component != null) {
            component.removeCaretListener(this);
            component.removeComponentListener(this);
            component.removeFocusListener(this);
            component.removeKeyListener(this);
        }
        this.removeListenersFromProviders();
        this.componentRef = null;
    }

    private synchronized void registerNewComponent(JTextComponent c) {
        if (c == null) {
            return;
        }
        this.hintTask.cancel();
        this.componentRef = new WeakReference<JTextComponent>(c);
        this.lastOffset = c.getCaretPosition();
        this.gatherProviders();
        this.addListenersToProviders();
        c.addCaretListener(this);
        c.addComponentListener(this);
        c.addFocusListener(this);
        c.addKeyListener(this);
        this.hintTask.schedule(500);
    }

    private JTextComponent getComponent() {
        return this.componentRef != null ? (JTextComponent)this.componentRef.get() : null;
    }

    private void gatherProviders() {
        BaseKit kit = Utilities.getKit((JTextComponent)this.getComponent());
        if (kit == null) {
            this.hintsProviders = Collections.EMPTY_LIST;
            return;
        }
        MimeLookup lookup = MimeLookup.getMimeLookup((String)kit.getContentType());
        Lookup.Result result = lookup.lookup(new Lookup.Template(HintsProvider.class));
        this.hintsProviders = new ArrayList(result.allInstances());
    }

    private void addListenersToProviders() {
        if (this.hintsProviders == null) {
            return;
        }
        Iterator i = this.hintsProviders.iterator();
        while (i.hasNext()) {
            HintsProvider provider = (HintsProvider)i.next();
            provider.addPropertyChangeListener(this);
        }
    }

    private void removeListenersFromProviders() {
        if (this.hintsProviders == null) {
            return;
        }
        Iterator i = this.hintsProviders.iterator();
        while (i.hasNext()) {
            HintsProvider provider = (HintsProvider)i.next();
            provider.removePropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        JTextComponent component = this.getComponent();
        if (component != null && (evt.getNewValue() == component || evt.getNewValue() == component.getDocument())) {
            this.hintTask.schedule(100);
        }
    }

    public void focusGained(FocusEvent fe) {
        if (!this.ui.isActive()) {
            this.hintTask.schedule(500);
        }
    }

    public void focusLost(FocusEvent fe) {
        if (!this.hintTask.isFinished()) {
            this.hintTask.cancel();
        }
        if (!this.hintPopupTask.isFinished()) {
            this.hintPopupTask.cancel();
        }
        if (!this.ui.isKnownComponent(fe.getOppositeComponent())) {
            this.ui.setHints(null, null, false);
            this.lineOffset = -1;
            this.lastOffset = -2;
            this.lastLineOffset = -2;
        }
    }

    private class HintPopupTaskImpl
    implements Runnable {
        private boolean showPopup;
        private Throwable lastCatched;

        public HintPopupTaskImpl(boolean showPopup) {
            this.showPopup = showPopup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int position = -1;
            JTextComponent component = null;
            HintsOperator hintsOperator = HintsOperator.this;
            synchronized (hintsOperator) {
                position = HintsOperator.this.lastOffset;
                component = HintsOperator.this.getComponent();
            }
            if (this.showPopup && HintsOperator.this.ui.isPopupActive()) {
                return;
            }
            if (component == null || position == -1) {
                return;
            }
            try {
                Rectangle r = component.modelToView(position);
                Rectangle visible = component.getVisibleRect();
                if (r == null || visible == null) {
                    return;
                }
                if (r.y <= visible.y) {
                    return;
                }
                if (r.y + r.height > visible.y + visible.height) {
                    return;
                }
                if (r.x < visible.x) {
                    return;
                }
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
            ArrayList result = new ArrayList();
            if (ERR.isLoggable(1)) {
                ERR.log("hintsProviders = " + HintsOperator.this.hintsProviders);
            }
            Iterator i = HintsOperator.this.hintsProviders.iterator();
            while (i.hasNext()) {
                block17: {
                    HintsProvider provider = (HintsProvider)i.next();
                    if (ERR.isLoggable(1)) {
                        ERR.log("provider = " + provider);
                        ERR.log("result = " + result);
                    }
                    try {
                        result.addAll(provider.getHints(component.getDocument(), position));
                    }
                    catch (Throwable e) {
                        if (this.equalsException(this.lastCatched, e)) break block17;
                        this.lastCatched = e;
                        ErrorManager.getDefault().notify(4096, e);
                    }
                }
                if (!ERR.isLoggable(1)) continue;
                ERR.log("result = " + result);
            }
            int hintsType = 3;
            Iterator i2 = result.iterator();
            while (i2.hasNext()) {
                Hint h = (Hint)i2.next();
                if (h.getType() >= hintsType) continue;
                hintsType = h.getType();
            }
            HintsOperator.this.setCurrentHints(result, hintsType, this.showPopup);
        }

        private boolean equalsException(Throwable e1, Throwable e2) {
            if (e1 == null) {
                return false;
            }
            return Arrays.equals(e1.getStackTrace(), e2.getStackTrace());
        }
    }
}

