// -*- c++ -*-
/*
 *  MICO --- an Open Source CORBA implementation
 *  Copyright (c) 1997-2001 by The Mico Team
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  For more information, visit the MICO Home Page at
 *  http://www.mico.org/
 */

#ifndef __corba_h__
#define __corba_h__


/***************************** C headers ****************************/

#include <mico/assert.h>
#include <stddef.h> // for wchar_t
#ifndef _POCKET_PC
#include <sys/types.h>
#endif

/***************************** config *******************************/

#ifdef _WINDOWS
#include <mico/config-win32.h>
#elif defined (_POCKET_PC)
#include <mico/config-ppc.h>
#else
#include <mico/config.h>
#endif


#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif


#if (defined(PIC) && defined(HAVE_SHARED_EXCEPTS)) || \
    (!defined(PIC) && defined(HAVE_EXCEPTS))
#define HAVE_EXCEPTIONS 1
#endif

#ifdef MICO_CONF_NO_EXCEPTIONS
#undef HAVE_EXCEPTS
#undef HAVE_SHARED_EXCEPTS
#undef HAVE_EXCEPTIONS
#endif


#ifdef HAVE_NAMESPACE
#define MICO_NAMESPACE_DECL namespace
#define MICO_NAMESPACE_END_DECL 
#define MICO_EXPORT_DECL extern
#define MICO_EXPORT_FCT_DECL extern
#define MICO_INLINE_FCT_DECL static inline
#define MICO_EXPORT_VAR_DECL extern
#define MICO_EXPORT_TYPEVAR_DECL extern
#else
#error "no namespaces"
#endif

#define MICO_EXPORT_CONST_DECL MICO_EXPORT_VAR_DECL
#define MICO_SCOPE(S,V) S::V


// This Macro is used in the idl compiler even on unix
#define _VC_NAMESPACE_HACK "_VCHACK__"

// Assume that Namespace handling is buggy in Visual-C++
#define _VC_NAMESPACE_BUG

#if defined (_WINDOWS) || defined (_POCKET_PC)
#undef environ

#undef MICO_SCOPE
#define MICO_SCOPE(S,V) V
    
#ifdef BUILD_MICO_DLL
#undef  MICO_EXPORT_VAR_DECL
#undef  MICO_EXPORT_CONST_DECL
#define MICO_EXPORT_VAR_DECL extern
#define MICO_EXPORT_CONST_DECL extern
#define MICO_EXPORT_TYPEVAR_DECL extern
#else
#undef  MICO_EXPORT_VAR_DECL
#undef  MICO_EXPORT_CONST_DECL
#define MICO_EXPORT_VAR_DECL __declspec(dllimport) 
#define MICO_EXPORT_CONST_DECL extern __declspec(dllimport) 
#define MICO_EXPORT_TYPEVAR_DECL extern
#endif
#endif


/***************************** STL headers **************************/


#ifdef HAVE_MINI_STL
#include <ministl/string>
#include <ministl/vector>
#include <ministl/map>
#include <ministl/set>
#include <ministl/list>

#else

#ifdef _WINDOWS
#include <string>
#include <vector>
#include <map>
#include <set>
#include <list>
#if !defined(__MINGW32__)
#include <limits>
#endif

#else

#include <string>
#include <vector>
#include <map>
#include <set>
#include <list>
#endif

#ifdef HAVE_NAMESPACE
namespace std {
    typedef int ____foo____;
};
using namespace std;
#endif

#endif


typedef vector<int>::size_type mico_vec_size_type;


/************************** MICO templates **************************/

#include <mico/version.h>
#include <mico/types.h>
#include <mico/sequence.h>
#include <mico/sequence_special.h>
#include <mico/array.h>
#include <mico/template.h>
#include <mico/fixed.h>
#include <mico/native.h>

/*
 * VC++ insanity
 */

#if defined(_WINDOWS) && !defined(__MINGW32__)
namespace CORBA {
	using namespace CORBA;
}
#ifndef MICO_CONF_NO_POA
namespace PortableServer {
	using namespace PortableServer;
}
#endif
#endif

/*************************** module CORBA ***************************/

#include <mico/basic.h>
#include <mico/magic.h>
#include <mico/address.h>
#include <mico/ioptypes.h>
#include <mico/ior.h>
#include <mico/transport.h>
#include <mico/buffer.h>
#include <mico/codeset.h>
#include <mico/string.h>
#include <mico/codec.h>
#include <mico/except.h>
#include <mico/orb_excepts.h>
#include <mico/any.h>
#include <mico/object.h>
#include <mico/value.h>
#include <mico/basic_seq.h>
#include <mico/orb_fwd.h>

#include <mico/dii.h>
#include <mico/dsi.h>
#include <mico/static.h>
#include <mico/tcconst.h>

#include <mico/policy.h>
#include <mico/current.h>

#include <mico/boa.h>

#ifndef MICO_CONF_NO_POA
namespace PortableServer {
  class ServantBase;
}
#include <mico/poa.h>
#include <mico/poa_base.h>
#include <mico/poa_stubs.h>
#endif

#include <mico/tckind.h>
#include <mico/ir_base.h>
#include <mico/typecode.h>
#include <mico/valuetype.h>

#ifndef MICO_CONF_NO_IR
#include <mico/ir.h>
#endif
#include <mico/service_info.h>
#include <mico/orb_mico.h>
#ifndef MICO_CONF_NO_IMR
#include <mico/imr.h>
#endif
#include <mico/valuetype_impl.h>

/********************** Global ******************************************/

#ifndef MICO_CONF_NO_DYNANY
#include <mico/dynany.h>
#endif

#ifndef MICO_CONF_NO_INTERCEPT
#include <mico/intercept.h>
#endif

#include <mico/operators.h>
#include <mico/policy2.h>

// used in skeletons
CORBA::ULong mico_string_hash (const char *, CORBA::ULong);

#include <mico/throw.h>
#include <mico/template_impl.h>

#endif // __corba_h__
