/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.key;

import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SecretKeyGeneratorImpl
extends KeyGeneratorSpi {
    protected final int defaultKeySize;
    protected final List keySizes;
    protected final String algorithm;
    protected boolean init;
    protected int currentKeySize;
    protected SecureRandom random;

    protected SecretKey engineGenerateKey() {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        byte[] byArray = new byte[this.currentKeySize];
        this.random.nextBytes(byArray);
        return new SecretKeySpec(byArray, this.algorithm);
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException(this.algorithm + " does not support algorithm paramaters");
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        if (!this.keySizes.contains(new Integer(n >>>= 3))) {
            throw new InvalidParameterException("unsupported key size: " + n);
        }
        this.currentKeySize = n;
        this.random = secureRandom;
        this.init = true;
    }

    protected void engineInit(SecureRandom secureRandom) {
        this.engineInit(this.defaultKeySize << 3, secureRandom);
    }

    protected SecretKeyGeneratorImpl(String string) {
        this.algorithm = string;
        IBlockCipher iBlockCipher = CipherFactory.getInstance(string);
        if (iBlockCipher == null) {
            throw new IllegalArgumentException("no such cipher: " + string);
        }
        this.defaultKeySize = iBlockCipher.defaultKeySize();
        this.keySizes = new LinkedList();
        Iterator iterator = iBlockCipher.keySizes();
        while (iterator.hasNext()) {
            this.keySizes.add(iterator.next());
        }
        this.init = false;
    }
}

