/*
 * Decompiled with CFR 0.152.
 */
package junit.tests.framework;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.tests.framework.DoublePrecisionAssertTest;
import junit.tests.framework.InheritedTestCase;
import junit.tests.framework.NoTestCaseClass;
import junit.tests.framework.NoTestCases;
import junit.tests.framework.NotPublicTestCase;
import junit.tests.framework.NotVoidTestCase;
import junit.tests.framework.OneTestCase;
import junit.tests.framework.OverrideTestCase;

public class SuiteTest
extends TestCase {
    protected TestResult fResult;

    public SuiteTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.fResult = new TestResult();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Suite Tests");
        suite.addTest(new SuiteTest("testNoTestCaseClass"));
        suite.addTest(new SuiteTest("testNoTestCases"));
        suite.addTest(new SuiteTest("testOneTestCase"));
        suite.addTest(new SuiteTest("testNotPublicTestCase"));
        suite.addTest(new SuiteTest("testNotVoidTestCase"));
        suite.addTest(new SuiteTest("testNotExistingTestCase"));
        suite.addTest(new SuiteTest("testInheritedTests"));
        suite.addTest(new SuiteTest("testShadowedTests"));
        suite.addTest(new SuiteTest("testAddTestSuite"));
        suite.addTest(new SuiteTest("testCreateSuiteFromArray"));
        return suite;
    }

    public void testInheritedTests() {
        TestSuite suite = new TestSuite(InheritedTestCase.class);
        suite.run(this.fResult);
        SuiteTest.assertTrue(this.fResult.wasSuccessful());
        SuiteTest.assertEquals(2, this.fResult.runCount());
    }

    public void testNoTestCaseClass() {
        TestSuite t = new TestSuite(NoTestCaseClass.class);
        t.run(this.fResult);
        SuiteTest.assertEquals(1, this.fResult.runCount());
        SuiteTest.assertTrue(!this.fResult.wasSuccessful());
    }

    public void testNoTestCases() {
        TestSuite t = new TestSuite(NoTestCases.class);
        t.run(this.fResult);
        SuiteTest.assertTrue(this.fResult.runCount() == 1);
        SuiteTest.assertTrue(this.fResult.failureCount() == 1);
        SuiteTest.assertTrue(!this.fResult.wasSuccessful());
    }

    public void testNotExistingTestCase() {
        SuiteTest t = new SuiteTest("notExistingMethod");
        t.run(this.fResult);
        SuiteTest.assertTrue(this.fResult.runCount() == 1);
        SuiteTest.assertTrue(this.fResult.failureCount() == 1);
        SuiteTest.assertTrue(this.fResult.errorCount() == 0);
    }

    public void testNotPublicTestCase() {
        TestSuite suite = new TestSuite(NotPublicTestCase.class);
        SuiteTest.assertEquals(2, suite.countTestCases());
    }

    public void testNotVoidTestCase() {
        TestSuite suite = new TestSuite(NotVoidTestCase.class);
        SuiteTest.assertTrue(suite.countTestCases() == 1);
    }

    public void testOneTestCase() {
        TestSuite t = new TestSuite(OneTestCase.class);
        t.run(this.fResult);
        SuiteTest.assertTrue(this.fResult.runCount() == 1);
        SuiteTest.assertTrue(this.fResult.failureCount() == 0);
        SuiteTest.assertTrue(this.fResult.errorCount() == 0);
        SuiteTest.assertTrue(this.fResult.wasSuccessful());
    }

    public void testShadowedTests() {
        TestSuite suite = new TestSuite(OverrideTestCase.class);
        suite.run(this.fResult);
        SuiteTest.assertEquals(1, this.fResult.runCount());
    }

    public void testAddTestSuite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(OneTestCase.class);
        suite.run(this.fResult);
        SuiteTest.assertEquals(1, this.fResult.runCount());
    }

    public void testCreateSuiteFromArray() {
        Class[] testClassArray = new Class[]{OneTestCase.class, DoublePrecisionAssertTest.class};
        TestSuite suite = new TestSuite(testClassArray);
        SuiteTest.assertEquals(2, suite.testCount());
        SuiteTest.assertEquals("junit.tests.framework.DoublePrecisionAssertTest", ((TestSuite)suite.testAt(1)).getName());
        SuiteTest.assertEquals("junit.tests.framework.OneTestCase", ((TestSuite)suite.testAt(0)).getName());
    }
}

