/*
 * Decompiled with CFR 0.152.
 */
package junit.samples.money;

import junit.samples.money.IMoney;
import junit.samples.money.MoneyBag;

public class Money
implements IMoney {
    private int fAmount;
    private String fCurrency;

    public Money(int amount, String currency) {
        this.fAmount = amount;
        this.fCurrency = currency;
    }

    public IMoney add(IMoney m) {
        return m.addMoney(this);
    }

    public IMoney addMoney(Money m) {
        if (m.currency().equals(this.currency())) {
            return new Money(this.amount() + m.amount(), this.currency());
        }
        return MoneyBag.create(this, m);
    }

    public IMoney addMoneyBag(MoneyBag s) {
        return s.addMoney(this);
    }

    public int amount() {
        return this.fAmount;
    }

    public String currency() {
        return this.fCurrency;
    }

    public boolean equals(Object anObject) {
        if (this.isZero() && anObject instanceof IMoney) {
            return ((IMoney)anObject).isZero();
        }
        if (anObject instanceof Money) {
            Money aMoney = (Money)anObject;
            return aMoney.currency().equals(this.currency()) && this.amount() == aMoney.amount();
        }
        return false;
    }

    public int hashCode() {
        return this.fCurrency.hashCode() + this.fAmount;
    }

    public boolean isZero() {
        return this.amount() == 0;
    }

    public IMoney multiply(int factor) {
        return new Money(this.amount() * factor, this.currency());
    }

    public IMoney negate() {
        return new Money(-this.amount(), this.currency());
    }

    public IMoney subtract(IMoney m) {
        return this.add(m.negate());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[" + this.amount() + " " + this.currency() + "]");
        return buffer.toString();
    }

    public void appendTo(MoneyBag m) {
        m.appendMoney(this);
    }
}

