/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgsPushNode
extends Node {
    private Node firstNode;
    private Node secondNode;

    public ArgsPushNode(ISourcePosition position, Node firstNode, Node secondNode) {
        super(position, NodeType.ARGSPUSHNODE);
        assert (firstNode != null) : "ArgsPushNode.first == null";
        assert (secondNode != null) : "ArgsPushNode.second == null";
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }

    @Override
    public Instruction accept(NodeVisitor visitor) {
        return visitor.visitArgsPushNode(this);
    }

    public Node getFirstNode() {
        return this.firstNode;
    }

    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyArray args = (RubyArray)this.firstNode.interpret(runtime, context, self, aBlock).dup();
        return args.append(this.secondNode.interpret(runtime, context, self, aBlock));
    }
}

