/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.PageEventAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.keys.IBindingService;

public class CyclePartAction
extends PageEventAction {
    private TriggerSequence[] backwardTriggerSequences = null;
    private ParameterizedCommand commandBackward = null;
    private ParameterizedCommand commandForward = null;
    protected boolean forward;
    private TriggerSequence[] forwardTriggerSequences = null;
    private Object selection;

    public CyclePartAction(IWorkbenchWindow window, boolean next) {
        super("", window);
        this.forward = next;
        this.setText();
        this.updateState();
    }

    public void activate(IWorkbenchPage page, Object selectedItem) {
        if (selectedItem != null) {
            IWorkbenchPart part;
            if (selectedItem instanceof IEditorReference) {
                page.setEditorAreaVisible(true);
            }
            if ((part = ((IWorkbenchPartReference)selectedItem).getPart(true)) != null) {
                page.activate(part);
            }
        }
    }

    protected void addItems(Table table, WorkbenchPage page) {
        IWorkbenchPartReference[] refs = page.getSortedParts();
        boolean includeEditor = true;
        int i = refs.length - 1;
        while (i >= 0) {
            if (refs[i] instanceof IEditorReference) {
                if (includeEditor) {
                    IEditorReference activeEditor = (IEditorReference)refs[i];
                    TableItem item = new TableItem(table, 0);
                    item.setText(WorkbenchMessages.CyclePartAction_editor);
                    item.setImage(activeEditor.getTitleImage());
                    item.setData((Object)activeEditor);
                    includeEditor = false;
                }
            } else {
                TableItem item = new TableItem(table, 0);
                item.setText(refs[i].getTitle());
                item.setImage(refs[i].getTitleImage());
                item.setData((Object)refs[i]);
            }
            --i;
        }
    }

    private void addKeyListener(final Table table, final Shell dialog) {
        table.addKeyListener(new KeyListener(){
            private boolean firstKey = true;
            private boolean quickReleaseMode = false;

            public void keyPressed(KeyEvent e) {
                int index;
                int triggersLength;
                Trigger[] triggers;
                TriggerSequence triggerSequence;
                int i;
                int keyCode = e.keyCode;
                char character = e.character;
                int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                KeyStroke keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator);
                boolean acceleratorForward = false;
                boolean acceleratorBackward = false;
                if (CyclePartAction.this.commandForward != null && CyclePartAction.this.forwardTriggerSequences != null) {
                    int forwardCount = CyclePartAction.this.forwardTriggerSequences.length;
                    i = 0;
                    while (i < forwardCount) {
                        triggerSequence = CyclePartAction.this.forwardTriggerSequences[i];
                        triggers = triggerSequence.getTriggers();
                        triggersLength = triggers.length;
                        if (triggersLength > 0 && triggers[triggersLength - 1].equals((Object)keyStroke)) {
                            acceleratorForward = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (CyclePartAction.this.commandBackward != null && CyclePartAction.this.backwardTriggerSequences != null) {
                    int backwardCount = CyclePartAction.this.backwardTriggerSequences.length;
                    i = 0;
                    while (i < backwardCount) {
                        triggerSequence = CyclePartAction.this.backwardTriggerSequences[i];
                        triggers = triggerSequence.getTriggers();
                        triggersLength = triggers.length;
                        if (triggersLength > 0 && triggers[triggersLength - 1].equals((Object)keyStroke)) {
                            acceleratorBackward = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (character == '\r' || character == '\n') {
                    CyclePartAction.this.ok(dialog, table);
                } else if (acceleratorForward) {
                    if (this.firstKey && e.stateMask != 0) {
                        this.quickReleaseMode = true;
                    }
                    index = table.getSelectionIndex();
                    table.setSelection((index + 1) % table.getItemCount());
                } else if (acceleratorBackward) {
                    if (this.firstKey && e.stateMask != 0) {
                        this.quickReleaseMode = true;
                    }
                    table.setSelection((index = table.getSelectionIndex()) >= 1 ? index - 1 : table.getItemCount() - 1);
                } else if (keyCode != 65536 && keyCode != 0x400000 && keyCode != 262144 && keyCode != 131072 && keyCode != 0x1000002 && keyCode != 0x1000001 && keyCode != 0x1000003 && keyCode != 0x1000004) {
                    CyclePartAction.this.cancel(dialog);
                }
                this.firstKey = false;
            }

            public void keyReleased(KeyEvent e) {
                int keyCode = e.keyCode;
                int stateMask = e.stateMask;
                IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
                boolean stickyCycle = store.getBoolean("STICKY_CYCLE");
                if (!stickyCycle && (this.firstKey || this.quickReleaseMode) && keyCode == stateMask) {
                    CyclePartAction.this.ok(dialog, table);
                }
            }
        });
    }

    private void addMouseListener(final Table table, final Shell dialog) {
        table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                CyclePartAction.this.ok(dialog, table);
            }

            public void mouseDown(MouseEvent e) {
                CyclePartAction.this.ok(dialog, table);
            }

            public void mouseUp(MouseEvent e) {
                CyclePartAction.this.ok(dialog, table);
            }
        });
    }

    private final void addTraverseListener(Table table) {
        table.addTraverseListener(new TraverseListener(){

            public final void keyTraversed(TraverseEvent event) {
                event.doit = false;
            }
        });
    }

    private void cancel(Shell dialog) {
        this.selection = null;
        dialog.close();
    }

    public String getBackwardActionDefinitionId() {
        return this.commandBackward.getCommand().getId();
    }

    public String getForwardActionDefinitionId() {
        return this.commandForward.getCommand().getId();
    }

    protected String getTableHeader() {
        return WorkbenchMessages.CyclePartAction_header;
    }

    private void ok(Shell dialog, Table table) {
        TableItem[] items = table.getSelection();
        if (items != null && items.length == 1) {
            this.selection = items[0].getData();
        }
        dialog.close();
    }

    private void openDialog(WorkbenchPage page) {
        this.selection = null;
        final Shell dialog = new Shell(this.getWorkbenchWindow().getShell(), 0);
        Display display = dialog.getDisplay();
        dialog.setLayout((Layout)new FillLayout());
        Table table = new Table((Composite)dialog, 65540);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tc = new TableColumn(table, 0);
        tc.setResizable(false);
        tc.setText(this.getTableHeader());
        this.addItems(table, page);
        int tableItemCount = table.getItemCount();
        switch (tableItemCount) {
            case 0: {
                break;
            }
            case 1: {
                table.setSelection(0);
                break;
            }
            default: {
                table.setSelection(this.forward ? 1 : table.getItemCount() - 1);
            }
        }
        tc.pack();
        table.pack();
        dialog.pack();
        Rectangle tableBounds = table.getBounds();
        tableBounds.height = Math.min(tableBounds.height, table.getItemHeight() * 22);
        table.setBounds(tableBounds);
        dialog.setBounds(dialog.computeTrim(tableBounds.x, tableBounds.y, tableBounds.width, tableBounds.height));
        tc.setWidth(table.getClientArea().width);
        table.setFocus();
        table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                CyclePartAction.this.cancel(dialog);
            }
        });
        Rectangle dialogBounds = dialog.getBounds();
        Rectangle displayBounds = display.getClientArea();
        Rectangle parentBounds = dialog.getParent().getBounds();
        dialogBounds.x = parentBounds.x + (parentBounds.width - dialogBounds.width) / 2;
        dialogBounds.y = parentBounds.y + (parentBounds.height - dialogBounds.height) / 2;
        if (!displayBounds.contains(dialogBounds.x, dialogBounds.y) || !displayBounds.contains(dialogBounds.x + dialogBounds.width, dialogBounds.y + dialogBounds.height)) {
            dialogBounds.x = (displayBounds.width - dialogBounds.width) / 2;
            dialogBounds.y = (displayBounds.height - dialogBounds.height) / 2;
        }
        dialog.setLocation(dialogBounds.x, dialogBounds.y);
        table.removeHelpListener(this.getHelpListener());
        table.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
            }
        });
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        this.forwardTriggerSequences = bindingService.getActiveBindingsFor(this.commandForward);
        this.backwardTriggerSequences = bindingService.getActiveBindingsFor(this.commandBackward);
        IContextService contextService = (IContextService)page.getWorkbenchWindow().getWorkbench().getAdapter(IContextService.class);
        try {
            dialog.open();
            this.addMouseListener(table, dialog);
            contextService.registerShell(dialog, 1);
            this.addKeyListener(table, dialog);
            this.addTraverseListener(table);
            while (!dialog.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            if (!dialog.isDisposed()) {
                this.cancel(dialog);
            }
            contextService.unregisterShell(dialog);
            this.forwardTriggerSequences = null;
            this.backwardTriggerSequences = null;
        }
    }

    public void pageActivated(IWorkbenchPage page) {
        super.pageActivated(page);
        this.updateState();
    }

    public void pageClosed(IWorkbenchPage page) {
        super.pageClosed(page);
        this.updateState();
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        this.updateState();
    }

    public void partOpened(IWorkbenchPart part) {
        super.partOpened(part);
        this.updateState();
    }

    public void runWithEvent(Event e) {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        IWorkbenchPage page = this.getActivePage();
        this.openDialog((WorkbenchPage)page);
        this.activate(page, this.selection);
    }

    public void setBackwardActionDefinitionId(String actionDefinitionId) {
        ICommandService commandService = (ICommandService)this.getWorkbenchWindow().getWorkbench().getAdapter(ICommandService.class);
        Command command = commandService.getCommand(actionDefinitionId);
        this.commandBackward = new ParameterizedCommand(command, null);
    }

    public void setForwardActionDefinitionId(String actionDefinitionId) {
        ICommandService commandService = (ICommandService)this.getWorkbenchWindow().getWorkbench().getAdapter(ICommandService.class);
        Command command = commandService.getCommand(actionDefinitionId);
        this.commandForward = new ParameterizedCommand(command, null);
    }

    protected void setText() {
        if (this.forward) {
            this.setText(WorkbenchMessages.CyclePartAction_next_text);
            this.setToolTipText(WorkbenchMessages.CyclePartAction_next_toolTip);
            this.getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.cycle_part_forward_action_context");
            this.setActionDefinitionId("org.eclipse.ui.window.nextView");
        } else {
            this.setText(WorkbenchMessages.CyclePartAction_prev_text);
            this.setToolTipText(WorkbenchMessages.CyclePartAction_prev_toolTip);
            this.getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.cycle_part_backward_action_context");
            this.setActionDefinitionId("org.eclipse.ui.window.previousView");
        }
    }

    protected void updateState() {
        IWorkbenchPage page = this.getActivePage();
        if (page == null) {
            this.setEnabled(false);
            return;
        }
        int count = page.getViewReferences().length;
        if (page.getEditorReferences().length > 0) {
            ++count;
        }
        this.setEnabled(count >= 1);
    }
}

