/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import org.eclipse.jdt.internal.ui.workingsets.OpenCloseWorkingSetAction;
import org.eclipse.jdt.internal.ui.workingsets.OpenPropertiesWorkingSetAction;
import org.eclipse.jdt.internal.ui.workingsets.RemoveWorkingSetElementAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;

public class WorkingSetActionGroup
extends ActionGroup {
    private static final String GROUP_WORKINGSETS = "group.workingSets";
    private IViewSite fSite;
    private ISelectionChangedListener fLazyInitializer = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ISelectionProvider selectionProvider = WorkingSetActionGroup.this.fSite.getSelectionProvider();
            selectionProvider.removeSelectionChangedListener(WorkingSetActionGroup.this.fLazyInitializer);
            ISelection selection = event.getSelection();
            WorkingSetActionGroup.this.fRemoveAction = new RemoveWorkingSetElementAction((IWorkbenchSite)WorkingSetActionGroup.this.fSite);
            WorkingSetActionGroup.this.fRemoveAction.update(selection);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)WorkingSetActionGroup.this.fRemoveAction);
            WorkingSetActionGroup.this.fEditAction = new OpenPropertiesWorkingSetAction((IWorkbenchSite)WorkingSetActionGroup.this.fSite);
            WorkingSetActionGroup.this.fEditAction.update(selection);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)WorkingSetActionGroup.this.fEditAction);
            WorkingSetActionGroup.this.fCloseAction = OpenCloseWorkingSetAction.createCloseAction((IWorkbenchSite)WorkingSetActionGroup.this.fSite);
            WorkingSetActionGroup.this.fCloseAction.update(selection);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)WorkingSetActionGroup.this.fCloseAction);
            WorkingSetActionGroup.this.fOpenAction = OpenCloseWorkingSetAction.createOpenAction((IWorkbenchSite)WorkingSetActionGroup.this.fSite);
            WorkingSetActionGroup.this.fOpenAction.update(selection);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)WorkingSetActionGroup.this.fOpenAction);
        }
    };
    private RemoveWorkingSetElementAction fRemoveAction;
    private OpenPropertiesWorkingSetAction fEditAction;
    private OpenCloseWorkingSetAction fCloseAction;
    private OpenCloseWorkingSetAction fOpenAction;

    public WorkingSetActionGroup(IViewPart part) {
        this.fSite = part.getViewSite();
        this.fSite.getSelectionProvider().addSelectionChangedListener(this.fLazyInitializer);
    }

    public void dispose() {
        ISelectionProvider selectionProvider = this.fSite.getSelectionProvider();
        if (this.fRemoveAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fRemoveAction);
        }
        if (this.fEditAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fEditAction);
        }
        if (this.fCloseAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fCloseAction);
            this.fCloseAction.dispose();
        }
        if (this.fOpenAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenAction);
            this.fOpenAction.dispose();
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.appendToGroup("group.reorganize", (IContributionItem)new Separator(GROUP_WORKINGSETS));
        if (this.fRemoveAction != null && this.fRemoveAction.isEnabled()) {
            menu.appendToGroup(GROUP_WORKINGSETS, (IAction)this.fRemoveAction);
        }
        if (this.fCloseAction != null && this.fCloseAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.fCloseAction);
        }
        if (this.fOpenAction != null && this.fOpenAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.fOpenAction);
        }
        if (this.fEditAction != null && this.fEditAction.isEnabled()) {
            menu.appendToGroup("group.properties", (IAction)this.fEditAction);
        }
    }
}

