/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable.mapping;

import java.util.Iterator;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.AbstractObservableMapping;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IObservableMappingWithDomain;
import org.eclipse.jface.internal.databinding.provisional.observable.set.IObservableSet;
import org.eclipse.jface.internal.databinding.provisional.observable.set.ISetChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.set.SetDiff;

public abstract class ObservableMappingWithDomain
extends AbstractObservableMapping
implements IObservableMappingWithDomain {
    private ISetChangeListener listener = new ISetChangeListener(){

        public void handleSetChange(IObservableSet source, SetDiff diff) {
            Iterator it = diff.getAdditions().iterator();
            while (it.hasNext()) {
                ObservableMappingWithDomain.this.addListenerTo(it.next());
            }
            it = diff.getRemovals().iterator();
            while (it.hasNext()) {
                ObservableMappingWithDomain.this.removeListenerFrom(it.next());
            }
        }
    };
    private IObservableSet domain;

    protected void initDomain(IObservableSet domain) {
        this.domain = domain;
        domain.addSetChangeListener(this.listener);
        Iterator it = domain.iterator();
        while (it.hasNext()) {
            this.addListenerTo(it.next());
        }
    }

    public IObservableSet getDomain() {
        return this.domain;
    }

    protected abstract void addListenerTo(Object var1);

    protected abstract void removeListenerFrom(Object var1);

    public void dispose() {
        Iterator iter = this.domain.iterator();
        while (iter.hasNext()) {
            this.removeListenerFrom(iter.next());
        }
        this.domain.removeSetChangeListener(this.listener);
        super.dispose();
    }
}

