/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import com.ibm.icu.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.internal.core.DebugCoreMessages;

public class ContributedDelegate {
    private IConfigurationElement fElement;
    private Set fModes;
    private ILaunchConfigurationDelegate fDelegate;

    protected ContributedDelegate(IConfigurationElement element) {
        this.setConfigurationElement(element);
    }

    private void setConfigurationElement(IConfigurationElement element) {
        this.fElement = element;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }

    protected Set getModes() {
        if (this.fModes == null) {
            String modes = this.getConfigurationElement().getAttribute("modes");
            if (modes == null) {
                return new HashSet(0);
            }
            String[] strings = modes.split(",");
            this.fModes = new HashSet(3);
            int i = 0;
            while (i < strings.length) {
                String string = strings[i];
                this.fModes.add(string.trim());
                ++i;
            }
        }
        return this.fModes;
    }

    protected String getLaunchConfigurationType() {
        return this.getConfigurationElement().getAttribute("type");
    }

    protected ILaunchConfigurationDelegate getDelegate() throws CoreException {
        if (this.fDelegate == null) {
            Object object = this.getConfigurationElement().createExecutableExtension("delegate");
            if (object instanceof ILaunchConfigurationDelegate) {
                this.fDelegate = (ILaunchConfigurationDelegate)object;
            } else {
                throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 120, MessageFormat.format((String)DebugCoreMessages.LaunchConfigurationType_Launch_delegate_for__0__does_not_implement_required_interface_ILaunchConfigurationDelegate__1, (Object[])new String[]{this.getIdentifier()}), null));
            }
        }
        return this.fDelegate;
    }

    protected String getIdentifier() {
        return this.getConfigurationElement().getAttribute("id");
    }

    protected String getSourcePathComputerId() {
        return this.getConfigurationElement().getAttribute("sourcePathComputerId");
    }

    protected String getSourceLocaterId() {
        return this.getConfigurationElement().getAttribute("sourceLocatorId");
    }
}

