/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filebuffers.AbstractFileBuffer;
import org.eclipse.core.internal.filebuffers.FileBuffersPlugin;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class JavaFileBuffer
extends AbstractFileBuffer {
    protected IPath fLocation;
    protected IFileStore fFileStore;
    protected int fReferenceCount;
    protected boolean fCanBeSaved = false;
    protected IStatus fStatus;
    protected long fSynchronizationStamp = -1L;
    protected int fSynchronizationContextCount;
    protected TextFileBufferManager fManager;

    public JavaFileBuffer(TextFileBufferManager manager) {
        this.fManager = manager;
    }

    protected abstract void addFileBufferContentListeners();

    protected abstract void removeFileBufferContentListeners();

    protected abstract void initializeFileBufferContent(IProgressMonitor var1) throws CoreException;

    protected abstract void commitFileBufferContent(IProgressMonitor var1, boolean var2) throws CoreException;

    public void create(IPath location, IProgressMonitor monitor) throws CoreException {
        this.fLocation = location;
        IFileStore fileStore = FileBuffers.getFileStoreAtLocation(location);
        IFileInfo info = fileStore.fetchInfo();
        if (info.exists()) {
            this.fFileStore = fileStore;
        }
        this.initializeFileBufferContent(monitor);
        if (this.fFileStore != null) {
            this.fSynchronizationStamp = info.getLastModified();
        }
        this.addFileBufferContentListeners();
    }

    public void connect() {
        ++this.fReferenceCount;
        if (this.fReferenceCount == 1) {
            this.connected();
        }
    }

    protected void connected() {
    }

    public void disconnect() throws CoreException {
        --this.fReferenceCount;
        if (this.fReferenceCount <= 0) {
            this.disconnected();
        }
    }

    protected void disconnected() {
    }

    protected boolean isDisconnected() {
        return this.fReferenceCount <= 0;
    }

    public IPath getLocation() {
        return this.fLocation;
    }

    public void commit(IProgressMonitor monitor, boolean overwrite) throws CoreException {
        if (!this.isDisconnected() && this.fCanBeSaved) {
            this.fManager.fireStateChanging(this);
            try {
                this.commitFileBufferContent(monitor, overwrite);
            }
            catch (CoreException x) {
                this.fManager.fireStateChangeFailed(this);
                throw x;
            }
            catch (RuntimeException x) {
                this.fManager.fireStateChangeFailed(this);
                throw x;
            }
            this.fCanBeSaved = false;
            this.addFileBufferContentListeners();
            this.fManager.fireDirtyStateChanged(this, this.fCanBeSaved);
        }
    }

    public ISchedulingRule computeCommitRule() {
        return null;
    }

    public boolean isDirty() {
        return this.fCanBeSaved;
    }

    public void setDirty(boolean isDirty) {
        this.fCanBeSaved = isDirty;
    }

    public boolean isShared() {
        return this.fReferenceCount > 1;
    }

    public ISchedulingRule computeValidateStateRule() {
        return null;
    }

    public void validateState(IProgressMonitor monitor, Object computationContext) throws CoreException {
    }

    public boolean isStateValidated() {
        return true;
    }

    public void resetStateValidation() {
    }

    protected void handleFileMoved(IPath newLocation) {
        this.fManager.fireUnderlyingFileMoved(this, newLocation);
    }

    protected void handleCoreException(CoreException exception) {
        ILog log = FileBuffersPlugin.getDefault().getLog();
        log.log(exception.getStatus());
    }

    public boolean isSynchronized() {
        return this.fSynchronizationStamp == this.getModificationStamp();
    }

    public long getModificationStamp() {
        return this.fFileStore != null ? this.fFileStore.fetchInfo().getLastModified() : -1L;
    }

    public void requestSynchronizationContext() {
        ++this.fSynchronizationContextCount;
    }

    public void releaseSynchronizationContext() {
        --this.fSynchronizationContextCount;
    }

    public boolean isSynchronizationContextRequested() {
        return this.fSynchronizationContextCount > 0;
    }

    public boolean isCommitable() {
        IFileInfo info = this.fFileStore.fetchInfo();
        return info.exists() && !info.getAttribute(2);
    }

    public void validationStateChanged(boolean validationState, IStatus status) {
    }
}

