/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.models.sql.schema;

import org.eclipse.emf.ecore.sdo.EDataObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Comment</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.schema.Comment#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.schema.Comment#getSQLObject <em>SQL Object</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage#getComment()
 * @model 
 * @extends EDataObject
 * @generated
 */
public interface Comment extends EDataObject{
	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage#getComment_Description()
	 * @model 
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.schema.Comment#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>SQL Object</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject#getComments <em>Comments</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>SQL Object</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>SQL Object</em>' reference.
	 * @see #setSQLObject(SQLObject)
	 * @see org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage#getComment_SQLObject()
	 * @see org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject#getComments
	 * @model opposite="comments" required="true"
	 * @generated
	 */
	SQLObject getSQLObject();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.schema.Comment#getSQLObject <em>SQL Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>SQL Object</em>' reference.
	 * @see #getSQLObject()
	 * @generated
	 */
	void setSQLObject(SQLObject value);

} // Comment
