/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.connection;

import java.sql.Connection;

public interface ConnectionManagerListener {
	public void connectionInfoCreated(ConnectionInfo info);
	public void connectionInfoRemoved(String name);
	public void connectionInfoRenamed(String previousName, ConnectionInfo info);
	public void connected(ConnectionInfo info, Connection connection);
	public void disconnected(ConnectionInfo info, Connection connection);
}
