/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.encoding;

import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.wst.sse.core.internal.encoding.NonContentBasedEncodingRules;

public class EncodingMemento
implements Cloneable {
    public static final String CLONED = "cloned";
    public static final String DEFAULTS_ASSUMED_FOR_EMPTY_INPUT = "DefaultsAssumedForEmptyInput";
    public static final String DEFAULTS_USED_DUE_TO_SMALL_STREAM = "defaultsUsedDueToSmallStream";
    public static final String DETECTED_STANDARD_UNICODE_BYTES = "detectedStandardUnicodeBytes";
    public static final String FOUND_ENCODING_IN_CONTENT = "foundEncodingInContent";
    public static final String FOUND_ENCODING_IN_STREAM = "foundEncodingInStream";
    public static final String FOUND_ENCODING_IN_STRUCTURED_DOCUMENT = "foundEncodingInStructuredDocument";
    public static final String GUESSED_ENCODING_FROM_STREAM = "GuessEncodingFromStream";
    public static final String JAVA_NAME_FOUND_AS_IANA_NAME = "noMappingFoundButJavaNameFoundToBeIANAName";
    public static final String JAVA_NAME_FOUND_IN_ALIAS_NAME = "noMappingFoundButJavaNameFoundInAliasTable";
    public static final String NO_IANA_NAME_FOUND = "noMappingFoundFromJavaNameToIANAName";
    public static final String USED_CONTENT_TYPE_DEFAULT = "UsedContentTypeDefault";
    public static final String USED_JAVA_DEFAULT = "UsedJavaDefault";
    public static final String USED_MEMENTO_FROM_LOAD = "usedMementoFromLoad";
    public static final String USED_PROPERTY_SETTINGS = "USED_PROPERTY_SETTINGS";
    public static final String USED_USER_SPECIFIED_PREFERENCE = "UsedUserSpecifiedPreference";
    public static final String USED_WORKSPACE_DEFAULT = "UsedWorkspaceDefault";
    public static final String USER_IS_USING_JAVA_ENCODING = "UserIsUsingJavaEncoding";
    private String fAppropriateDefault;
    private String fDetectedCharsetName;
    private String fInvalidEncoding;
    private String fJavaCharsetName;
    private boolean fUnicodeStream;
    private boolean fUTF83ByteBOMUsed;

    public Object clone() {
        EncodingMemento object = null;
        try {
            object = (EncodingMemento)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return object;
    }

    public String getAppropriateDefault() {
        if (this.fAppropriateDefault == null) {
            this.fAppropriateDefault = NonContentBasedEncodingRules.useDefaultNameRules(null);
        }
        return this.fAppropriateDefault;
    }

    public String getDetectedCharsetName() {
        return this.fDetectedCharsetName;
    }

    public String getInvalidEncoding() {
        return this.fInvalidEncoding;
    }

    public String getJavaCharsetName() {
        return this.fJavaCharsetName;
    }

    public byte[] getUnicodeBOM() {
        byte[] bom = null;
        if (this.isUTF83ByteBOMUsed()) {
            bom = IContentDescription.BOM_UTF_8;
        } else if (this.isUnicodeStream()) {
            if (this.getJavaCharsetName().equals("UTF-16") || this.getJavaCharsetName().equals("UTF-16LE")) {
                bom = IContentDescription.BOM_UTF_16LE;
            } else if (this.getJavaCharsetName().equals("UTF-16BE")) {
                bom = IContentDescription.BOM_UTF_16BE;
            }
        }
        return bom;
    }

    public boolean isUnicodeStream() {
        return this.fUnicodeStream;
    }

    public boolean isUTF83ByteBOMUsed() {
        return this.fUTF83ByteBOMUsed;
    }

    public boolean isValid() {
        return this.getInvalidEncoding() == null;
    }

    public void setAppropriateDefault(String appropriateDefault) {
        this.fAppropriateDefault = appropriateDefault;
    }

    public void setDetectedCharsetName(String detectedCharsetName) {
        this.fDetectedCharsetName = detectedCharsetName;
    }

    public void setInvalidEncoding(String invalidEncoding) {
        this.fInvalidEncoding = invalidEncoding;
    }

    public void setJavaCharsetName(String javaCharsetName) {
        this.fJavaCharsetName = javaCharsetName;
    }

    public void setUnicodeStream(boolean unicodeStream) {
        this.fUnicodeStream = unicodeStream;
    }

    public void setUTF83ByteBOMUsed(boolean uTF83ByteBOMUsed) {
        this.fUTF83ByteBOMUsed = uTF83ByteBOMUsed;
    }
}

