/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import gnu.regexp.REMatch;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.epic.debug.DebugTarget;
import org.epic.debug.PerlBreakpoint;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.PerlDebugThread;
import org.epic.debug.PerlLineBreakpoint;
import org.epic.debug.db.BreakpointMap;
import org.epic.debug.db.DebuggerInterface;
import org.epic.debug.db.IPPosition;
import org.epic.debug.db.RE;
import org.epic.debug.db.StackFrame;
import org.epic.debug.ui.action.ShowLocalVariableActionDelegate;
import org.epic.debug.util.DebuggerProxy2;
import org.epic.perleditor.PerlEditorPlugin;

public class PerlDB
implements IDebugElement {
    private static boolean canDisplayLocalVars = true;
    private final RE re = new RE();
    private final PerlDebugThread thread;
    private final DebuggerInterface db;
    private final BreakpointMap activeBreakpoints;
    private final BreakpointMap pendingBreakpoints;
    private IPPosition startIP;
    private boolean terminated;
    private DebugTarget target;
    private DebuggerInterface.Command currentCommand;
    private final DebuggerInterface.IListener commandListener = new DebuggerInterface.IListener(){

        public void commandFinished(DebuggerInterface.Command cmd) {
            PerlDB.this.commandFinished(cmd);
        }

        public void sessionTerminated() {
            PerlDB.this.sessionTerminated();
        }
    };

    public PerlDB(DebugTarget target) throws CoreException {
        this.target = target;
        this.pendingBreakpoints = new BreakpointMap();
        this.activeBreakpoints = new BreakpointMap();
        this.thread = new PerlDebugThread("Main Thread", target.getLaunch(), target, this);
        BufferedReader in = target.getDebugReadStream();
        PrintWriter out = target.getDebugWriteStream();
        if (PerlEditorPlugin.getDefault().getDebugConsolePreference()) {
            DebuggerProxy2 p = new DebuggerProxy2(in, out, this.getLaunch());
            this.getLaunch().addProcess((IProcess)p);
            in = p.getDebugIn();
            out = p.getDebugOut();
        }
        this.db = this.createDebuggerInterface(in, out);
    }

    public void init(String ioHost, int ioPort, int errorPort) throws DebugException {
        if (this.db == null) {
            return;
        }
        if (ioHost != null) {
            this.redirectIO(ioHost, ioPort);
            this.redirectError(ioHost, errorPort);
        }
        if (this.target.getPathMapper().requiresEffectiveIncPath()) {
            this.target.getPathMapper().setEffectiveIncPath(this.getEffectiveIncPath());
        }
        PerlDebugPlugin.getPerlBreakPointManager().addDebugger(this);
        this.target.perlDBstarted(this);
        this.updateStackFrames();
        if (this.isBreakPointReached()) {
            this.fireDebugEvent(2, 16);
        } else {
            this.fireDebugEvent(2, 8);
            if (!PerlEditorPlugin.getDefault().getSuspendAtFirstPreference()) {
                this.resume((IDebugElement)this.thread);
            }
        }
    }

    public boolean addBreakpoint(PerlBreakpoint bp) throws CoreException {
        return this.addBreakpoint(bp, false);
    }

    public boolean addBreakpoint(PerlBreakpoint bp, boolean isPending) throws CoreException {
        try {
            boolean isValid = this.setBreakpoint(bp, isPending);
            if (!isValid) {
                bp.setInvalidBreakpointPosition(true);
            }
            return isValid;
        }
        catch (IOException e) {
            this.throwDebugException(e);
            return false;
        }
    }

    public boolean canResume(IDebugElement dest) {
        return this.isSuspended(dest);
    }

    public boolean canStepInto(IDebugElement dest) {
        return this.isSuspended(dest);
    }

    public boolean canStepOver(IDebugElement dest) {
        return this.isSuspended(dest);
    }

    public boolean canStepReturn(IDebugElement dest) {
        return this.isSuspended(dest);
    }

    public boolean canSuspend(IDebugElement dest) {
        return false;
    }

    public boolean canTerminate() {
        return this.canTerminate(null);
    }

    public boolean canTerminate(IDebugElement dest) {
        return !this.isTerminated();
    }

    public String evaluateStatement(String text) throws CoreException {
        return this.evaluateStatement(text, true);
    }

    public String evaluateStatement(String text, boolean updateVars) throws CoreException {
        try {
            String output = this.db.eval(text);
            if (updateVars) {
                this.updateStackFrames();
            }
            return output;
        }
        catch (IOException e) {
            this.throwDebugException(e);
            return null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == this.getClass()) {
            return this;
        }
        return null;
    }

    public IDebugTarget getDebugTarget() {
        return this.target;
    }

    public ILaunch getLaunch() {
        return this.target.getLaunch();
    }

    public String getModelIdentifier() {
        return this.target.getModelIdentifier();
    }

    public IThread[] getThreads() {
        return new IThread[]{this.thread};
    }

    public boolean isStepping(IDebugElement dest) {
        return !this.terminated && !this.db.isSuspended() && this.currentCommand != null && this.currentCommand.isStepCommand();
    }

    public boolean isSuspended(IDebugElement dest) {
        return !this.terminated && this.currentCommand == null;
    }

    public boolean isTerminated() {
        return this.isTerminated(null);
    }

    public boolean isTerminated(IDebugElement dest) {
        return this.terminated;
    }

    public void redirectError(String host, int port) throws DebugException {
        try {
            this.db.redirectError(host, port);
        }
        catch (IOException e) {
            this.throwDebugException(e);
        }
    }

    public void redirectIO(String host, int port) throws DebugException {
        try {
            this.db.redirectIO(host, port);
        }
        catch (IOException e) {
            this.throwDebugException(e);
        }
    }

    public void removeBreakpoint(PerlBreakpoint bp) throws CoreException {
        if (this.pendingBreakpoints.remove(bp)) {
            return;
        }
        if (!(bp instanceof PerlLineBreakpoint)) {
            return;
        }
        try {
            IPath dbPath = this.getDebuggerPath(bp.getResourcePath());
            if (dbPath != null) {
                this.db.switchToFile(dbPath);
                this.db.removeLineBreakpoint(((PerlLineBreakpoint)bp).getLineNumber());
            } else {
                PerlDebugPlugin.errorDialog("Could not remove breakpoint. Reason: unknown remote mapping of local path " + bp.getResourcePath());
            }
        }
        catch (IOException e) {
            this.throwDebugException(e);
        }
    }

    public void resume(IDebugElement dest) throws DebugException {
        try {
            this.fireDebugEvent(1, 32);
            this.startIP = this.db.getCurrentIP();
            this.currentCommand = this.db.asyncResume();
        }
        catch (IOException e) {
            this.throwDebugException(e);
        }
    }

    public void shutdown() {
        this.abortSession();
    }

    public void stepInto(IDebugElement dest) throws DebugException {
        try {
            this.fireDebugEvent(1, 1);
            this.startIP = this.db.getCurrentIP();
            this.currentCommand = this.db.asyncStepInto();
        }
        catch (IOException e) {
            this.throwDebugException(e);
        }
    }

    public void stepOver(IDebugElement dest) throws DebugException {
        try {
            this.fireDebugEvent(1, 2);
            this.startIP = this.db.getCurrentIP();
            this.currentCommand = this.db.asyncStepOver();
        }
        catch (IOException e) {
            this.throwDebugException(e);
        }
    }

    public void stepReturn(IDebugElement dest) throws DebugException {
        try {
            this.fireDebugEvent(1, 4);
            this.startIP = this.db.getCurrentIP();
            this.currentCommand = this.db.asyncStepReturn();
        }
        catch (IOException e) {
            this.throwDebugException(e);
        }
    }

    public void suspend(IDebugElement dest) {
    }

    public void terminate() {
        this.abortSession();
    }

    public static void updateVariablesView() {
        if (ShowLocalVariableActionDelegate.getPreferenceValue() && !canDisplayLocalVars) {
            PerlDebugPlugin.errorDialog("Error displaying Local Variables\nInstall PadWalker on your Perl system or disable displaying of local variables");
        }
        Set debuggers = PerlDebugPlugin.getPerlBreakPointManager().getDebuggers();
        Iterator iterator = debuggers.iterator();
        while (iterator.hasNext()) {
            PerlDB db = (PerlDB)iterator.next();
            try {
                ((StackFrame)db.thread.getStackFrames()[0]).computeDisplayedVars();
            }
            catch (DebugException e) {
                PerlDebugPlugin.log(e);
            }
            db.fireDebugEvent(64, 0);
        }
    }

    private void abortSession() {
        if (!this.terminated) {
            this.terminated = true;
            if (this.db != null) {
                this.db.dispose();
            }
            PerlDebugPlugin.getPerlBreakPointManager().removeDebugger(this);
            this.target.debugSessionTerminated();
        }
    }

    private void commandFinished(DebuggerInterface.Command cmd) {
        try {
            this.currentCommand = null;
            if (this.isTerminated()) {
                return;
            }
            IPPosition endIP = this.maybeSkipStringEval(cmd);
            this.updateStackFrames();
            switch (cmd.getType()) {
                case 1: 
                case 2: 
                case 4: {
                    this.fireDebugEvent(2, this.isBreakPointReached() ? 16 : 8);
                    break;
                }
                case 8: {
                    if (this.isBreakPointReached()) {
                        this.fireDebugEvent(2, 16);
                        break;
                    }
                    if (this.startIP != null && !endIP.getPath().equals((Object)this.startIP.getPath())) {
                        this.insertPendingBreakpoints();
                    }
                    this.resume((IDebugElement)this.thread);
                }
            }
        }
        catch (IOException e) {
            try {
                this.throwDebugException(e);
            }
            catch (CoreException _e) {
                PerlDebugPlugin.log(_e);
            }
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
        }
    }

    private DebuggerInterface createDebuggerInterface(BufferedReader in, PrintWriter out) throws DebugException {
        try {
            return new DebuggerInterface(in, out, this.commandListener);
        }
        catch (IOException iOException) {
            this.fireDebugEvent(8, 0);
            this.terminated = true;
            return null;
        }
    }

    private void fireDebugEvent(int kind, int detail) {
        DebugEvent event = new DebugEvent((Object)this.thread, kind, detail);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    private IPath getDebuggerPath(IPath epicPath) {
        return this.target.getPathMapper().getDebuggerPath(epicPath, this.db);
    }

    private List getEffectiveIncPath() throws DebugException {
        try {
            ArrayList<Path> ret = new ArrayList<Path>();
            String output = this.db.eval(";{foreach $t(@INC) {print $DB::OUT $t.\"\\n\";}}");
            StringTokenizer s = new StringTokenizer(output, "\r\n");
            while (s.hasMoreTokens()) {
                ret.add(new Path(s.nextToken()));
            }
            return ret;
        }
        catch (IOException e) {
            this.throwDebugException(e);
            return null;
        }
    }

    private IPath getEpicPath(IPath dbPath) {
        return this.target.getPathMapper().getEpicPath(dbPath);
    }

    private boolean insertPendingBreakpoints() throws CoreException {
        try {
            IPPosition pos = this.db.getCurrentIP();
            IPath epicPath = this.getEpicPath(pos.getPath());
            if (epicPath == null) {
                this.unresolvedDebuggerPath(pos.getPath());
                return false;
            }
            Set bps = this.pendingBreakpoints.getBreakpoints(epicPath);
            if (bps.isEmpty()) {
                return false;
            }
            Iterator i = bps.iterator();
            while (i.hasNext()) {
                PerlBreakpoint bp = (PerlBreakpoint)((Object)i.next());
                if (this.addBreakpoint(bp, true)) continue;
                bp.setInvalidBreakpointPosition(true);
            }
            bps.clear();
            return true;
        }
        catch (IOException e) {
            this.throwDebugException(e);
            return false;
        }
    }

    private boolean isBreakPointReached() throws DebugException {
        try {
            IPPosition pos = this.db.getCurrentIP();
            if (pos == null) {
                return false;
            }
            IPath epicPath = this.getEpicPath(pos.getPath());
            if (epicPath == null) {
                this.unresolvedDebuggerPath(pos.getPath());
                return false;
            }
            PerlLineBreakpoint bp = (PerlLineBreakpoint)this.activeBreakpoints.getBreakpoint(epicPath, pos.getLine());
            return bp != null;
        }
        catch (IOException e) {
            this.throwDebugException(e);
            return false;
        }
    }

    private IPPosition maybeSkipStringEval(DebuggerInterface.Command cmd) throws IOException {
        IPPosition endIP = this.db.getCurrentIP();
        if (cmd.isStepCommand()) {
            while (!this.isTerminated() && endIP.equals(this.startIP)) {
                this.db.stepOver();
                endIP = this.db.getCurrentIP();
            }
        }
        return endIP;
    }

    private void sessionTerminated() {
        this.terminate();
    }

    private boolean setBreakpoint(PerlBreakpoint bp, boolean isPending) throws IOException {
        boolean success;
        IPath dbPath = this.getDebuggerPath(bp.getResourcePath());
        if (dbPath == null) {
            this.unresolvedEpicPath(bp.getResourcePath());
            return false;
        }
        if (!isPending && !(success = this.db.switchToFile(dbPath))) {
            this.pendingBreakpoints.add(bp);
            this.db.setLoadBreakpoint(dbPath);
            return true;
        }
        if (!(bp instanceof PerlLineBreakpoint)) {
            return false;
        }
        try {
            String condition;
            PerlLineBreakpoint lbp = (PerlLineBreakpoint)bp;
            String string = condition = lbp.isConditionEnabled() ? lbp.getCondition() : null;
            if (condition != null) {
                condition = condition.replaceAll("\\n\\r", " ");
                condition = condition.replaceAll("\\r", " ");
                condition = condition.replaceAll("\\n", " ");
            }
            if (this.db.setLineBreakpoint(lbp.getLineNumber(), condition)) {
                this.activeBreakpoints.add(bp);
                bp.addInstallation(this);
                return true;
            }
            return false;
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
            return false;
        }
    }

    private void throwDebugException(IOException e) throws DebugException {
        throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "An error occurred during communication with the debugger process", (Throwable)e));
    }

    private void updateStackFrames() throws DebugException {
        try {
            IPPosition currentIP = this.db.getCurrentIP();
            if (currentIP == null) {
                return;
            }
            String stackTrace = this.db.getStackTrace();
            REMatch[] matches = this.re.STACK_TRACE.getAllMatches((Object)stackTrace);
            IStackFrame[] previousFrames = this.thread.getStackFrames();
            StackFrame previousTopFrame = previousFrames != null ? (StackFrame)previousFrames[0] : null;
            IStackFrame[] frames = new StackFrame[matches.length + 1];
            frames[0] = new StackFrame(this.thread, currentIP.getPath(), currentIP.getLine(), this.getEpicPath(currentIP.getPath()), this.db, previousTopFrame);
            int pos = 0;
            while (pos < matches.length) {
                Path dbPath = new Path(matches[pos].toString(3));
                frames[pos + 1] = new StackFrame(this.thread, (IPath)dbPath, Integer.parseInt(matches[pos].toString(4)), this.getEpicPath((IPath)dbPath), matches[pos].toString(1), matches[pos].toString(2));
                ++pos;
            }
            this.thread.setStackFrames(frames);
        }
        catch (IOException e) {
            this.throwDebugException(e);
        }
    }

    private void unresolvedDebuggerPath(IPath dbPath) {
        PerlDebugPlugin.log((IStatus)new Status(2, PerlDebugPlugin.getUniqueIdentifier(), 0, "Could not map remote path " + dbPath + " to a local path. Some breakpoints may be ignored.", null));
    }

    private void unresolvedEpicPath(IPath epicPath) {
        PerlDebugPlugin.log((IStatus)new Status(2, PerlDebugPlugin.getUniqueIdentifier(), 0, "Could not map local path " + epicPath + " to a remote path. Some breakpoints may be ignored.", null));
    }
}

