/*

Copyright (C) 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __libnd_demux_h
#define __libnd_demux_h

#include <libnd.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>

/* We need the connection tracker and traceset plugins.
*/
#include <plugins/libnd_conntrack.h>
#include <plugins/libnd_traceset.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef struct lnd_demux LND_Demux;

/**
 * LND_TDProgressCallback - signature of callbacks that report progress.
 * @td: demuxer handle.
 * @done: how many of the registered traces have been scanned.
 */
typedef void (*LND_TDProgressCB)(LND_Demux *td, int done, void *user_data);

/* The demux granularity -- either host-pair, dest port, or dest host +
 * dest port.
 */
typedef enum {
  LND_DEMUX_MODE_HOST_PAIRS = 0,
  LND_DEMUX_MODE_DEST_PORTS = 1,
  LND_DEMUX_MODE_DEST_HOSTPORTS = 2,
} LND_DemuxMode;

/* Main demuxer structure */
struct lnd_demux
{
  LND_DemuxMode      mode;
  int                max_flows;
  gboolean           need_content;
  gboolean           do_report;
  gboolean           do_mark;

  LND_TraceSet      *traces;

  /* A hashtable recording for each dump file how many flows
   * have been written to it.
   */
  GHashTable        *dumper_usage; 

  int                iter;
  int                iter_lim;

  pcap_t            *pcap;

  /* Callback to report progress */
  LND_TDProgressCB   cb;
  void              *cb_data;
  
  LND_ConnTable     *conns;
  char              *output_dir;
  char              *others_file;
  pcap_dumper_t     *others_dumper;
  
  LND_Packet        *current;
};


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
