require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_M88K_PARAM_H_)) {
    eval 'sub _M88K_PARAM_H_ () {1;}' unless defined(&_M88K_PARAM_H_);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    require 'machine/cpu.ph';
	}
    }
    eval 'sub _MACHINE_ARCH () { &m88k;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"m88k";}' unless defined(&MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_M88K;}' unless defined(&MID_MACHINE);
    eval 'sub ALIGNBYTES () {15;}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        my($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) & ~ &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        my($p,$t) = @_;
	    eval q((((($p)) & ($sizeof{$t}-1)) == 0));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub NBPG () {(1<<  &PGSHIFT);}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () {12;}' unless defined(&PGSHIFT);
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub NPTEPG () {( &PAGE_SIZE / ($sizeof{ &pt_entry_t}));}' unless defined(&NPTEPG);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    eval 'sub UPAGES () {2;}' unless defined(&UPAGES);
    eval 'sub USPACE () {( &UPAGES *  &NBPG);}' unless defined(&USPACE);
    eval 'sub USPACE_ALIGN () {(0);}' unless defined(&USPACE_ALIGN);
    eval 'sub NMBCLUSTERS () {2048;}' unless defined(&NMBCLUSTERS);
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    eval 'sub NKMEMPAGES_MAX_DEFAULT () {((64* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    eval 'sub MSGBUFSIZE () { &PAGE_SIZE;}' unless defined(&MSGBUFSIZE);
    eval 'sub ctod {
        my($x) = @_;
	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        my($x) = @_;
	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub btodb {
        my($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        my($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    require 'machine/intr.ph';
    if(defined(&_KERNEL)) {
	eval 'sub DELAY {
	    my($x) = @_;
    	    eval q( &delay($x));
	}' unless defined(&DELAY);
	if(!defined( &_LOCORE)) {
	}
	eval 'sub CPU_88100 () {0x;}' unless defined(&CPU_88100);
	eval 'sub CPU_88110 () {0x1;}' unless defined(&CPU_88110);
	if(defined(&M88100)) {
	    if(defined(&M88110)) {
		eval 'sub CPU_IS88100 () {( &cputyp ==  &CPU_88100);}' unless defined(&CPU_IS88100);
		eval 'sub CPU_IS88110 () {( &cputyp !=  &CPU_88100);}' unless defined(&CPU_IS88110);
	    } else {
		eval 'sub CPU_IS88100 () {1;}' unless defined(&CPU_IS88100);
		eval 'sub CPU_IS88110 () {0;}' unless defined(&CPU_IS88110);
	    }
	} else {
	    eval 'sub CPU_IS88100 () {0;}' unless defined(&CPU_IS88100);
	    eval 'sub CPU_IS88110 () {1;}' unless defined(&CPU_IS88110);
	}
    }
}
1;
