require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SH_CPU_H_)) {
    eval 'sub _SH_CPU_H_ () {1;}' unless defined(&_SH_CPU_H_);
    require 'sh/psl.ph';
    require 'sh/frame.ph';
    if(defined(&_KERNEL)) {
	require 'sys/sched.ph';
	eval 'sub curcpu () {
	    eval q(( &cpu_info_store));
	}' unless defined(&curcpu);
	eval 'sub cpu_number () {
	    eval q(0);
	}' unless defined(&cpu_number);
	eval 'sub CPU_IS_PRIMARY {
	    my($ci) = @_;
    	    eval q(1);
	}' unless defined(&CPU_IS_PRIMARY);
	eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
	eval 'sub CPU_INFO_FOREACH {
	    my($cii, $ci) = @_;
    	    eval q( &for ($cii = 0, $ci =  &curcpu(); $ci !=  &NULL; $ci =  &NULL));
	}' unless defined(&CPU_INFO_FOREACH);
	eval 'sub CLKF_USERMODE {
	    my($cf) = @_;
    	    eval q((! &KERNELMODE(($cf)-> &ssr)));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_PC {
	    my($cf) = @_;
    	    eval q((($cf)-> &spc));
	}' unless defined(&CLKF_PC);
	eval 'sub CLKF_INTR {
	    my($cf) = @_;
    	    eval q(0);
	}' unless defined(&CLKF_INTR);
	eval 'sub PROC_PC {
	    my($p) = @_;
    	    eval q(((($p)-> ($p_md->{md_regs}))-> &tf_spc));
	}' unless defined(&PROC_PC);
	eval 'sub need_resched {
	    my($ci) = @_;
    	    eval q( &do {  &want_resched = 1;  &if ( &curproc !=  &NULL)  &aston( &curproc); }  &while ( 0));
	}' unless defined(&need_resched);
	eval 'sub clear_resched {
	    my($ci) = @_;
    	    eval q( &want_resched = 0);
	}' unless defined(&clear_resched);
	eval 'sub need_proftick {
	    my($p) = @_;
    	    eval q( &aston($p));
	}' unless defined(&need_proftick);
	eval 'sub signotify {
	    my($p) = @_;
    	    eval q( &aston($p));
	}' unless defined(&signotify);
	eval 'sub aston {
	    my($p) = @_;
    	    eval q((($p)-> ($p_md->{md_astpending}) = 1));
	}' unless defined(&aston);
	eval 'sub cpu_wait {
	    my($p) = @_;
    	    eval q((( &void)($p)));
	}' unless defined(&cpu_wait);
	eval 'sub DELAY {
	    my($x) = @_;
    	    eval q( &delay($x));
	}' unless defined(&DELAY);
	eval 'sub cpu_idle_enter () {
	    eval q( &do { }  &while (0));
	}' unless defined(&cpu_idle_enter);
	eval 'sub cpu_idle_cycle () {
	    eval q( &__asm  &volatile(\\"sleep\\"));
	}' unless defined(&cpu_idle_cycle);
	eval 'sub cpu_idle_leave () {
	    eval q( &do { }  &while (0));
	}' unless defined(&cpu_idle_leave);
    }
    eval 'sub SH3_PHYS_MASK () {0x1fffffff;}' unless defined(&SH3_PHYS_MASK);
    eval 'sub SH3_P0SEG_BASE () {0x;}' unless defined(&SH3_P0SEG_BASE);
    eval 'sub SH3_P0SEG_END () {0x7fffffff;}' unless defined(&SH3_P0SEG_END);
    eval 'sub SH3_P1SEG_BASE () {0x80000000;}' unless defined(&SH3_P1SEG_BASE);
    eval 'sub SH3_P1SEG_END () {0x9fffffff;}' unless defined(&SH3_P1SEG_END);
    eval 'sub SH3_P2SEG_BASE () {0xa0000000;}' unless defined(&SH3_P2SEG_BASE);
    eval 'sub SH3_P2SEG_END () {0xbfffffff;}' unless defined(&SH3_P2SEG_END);
    eval 'sub SH3_P3SEG_BASE () {0xc0000000;}' unless defined(&SH3_P3SEG_BASE);
    eval 'sub SH3_P3SEG_END () {0xdfffffff;}' unless defined(&SH3_P3SEG_END);
    eval 'sub SH3_P4SEG_BASE () {0xe0000000;}' unless defined(&SH3_P4SEG_BASE);
    eval 'sub SH3_P4SEG_END () {0xffffffff;}' unless defined(&SH3_P4SEG_END);
    eval 'sub SH3_P1SEG_TO_PHYS {
        my($x) = @_;
	    eval q((( &uint32_t)($x) &  &SH3_PHYS_MASK));
    }' unless defined(&SH3_P1SEG_TO_PHYS);
    eval 'sub SH3_P2SEG_TO_PHYS {
        my($x) = @_;
	    eval q((( &uint32_t)($x) &  &SH3_PHYS_MASK));
    }' unless defined(&SH3_P2SEG_TO_PHYS);
    eval 'sub SH3_PHYS_TO_P1SEG {
        my($x) = @_;
	    eval q((( &uint32_t)($x) |  &SH3_P1SEG_BASE));
    }' unless defined(&SH3_PHYS_TO_P1SEG);
    eval 'sub SH3_PHYS_TO_P2SEG {
        my($x) = @_;
	    eval q((( &uint32_t)($x) |  &SH3_P2SEG_BASE));
    }' unless defined(&SH3_PHYS_TO_P2SEG);
    eval 'sub SH3_P1SEG_TO_P2SEG {
        my($x) = @_;
	    eval q((( &uint32_t)($x) | 0x20000000));
    }' unless defined(&SH3_P1SEG_TO_P2SEG);
    eval 'sub SH3_P2SEG_TO_P1SEG {
        my($x) = @_;
	    eval q((( &uint32_t)($x) & ~0x20000000));
    }' unless defined(&SH3_P2SEG_TO_P1SEG);
    if(defined(&_KERNEL)) {
	unless(defined(&__lint__)) {
	    eval 'sub RUN_P2 () { &do {  &register  &uint32_t  &r0  &asm("r0");  &uint32_t  &pc;  &__asm  &volatile( "	mov.l	1f, %1	;" "	mova	2f, %0	;" "	or	%0, %1	;" "	jmp	@%1	;" "	 nop		;" "	.align 2	;" "1:	.long	0x20000000;" "2:;" : "=r"( &r0), "=r"( &pc)); }  &while (0);}' unless defined(&RUN_P2);
	    eval 'sub RUN_P1 () { &do {  &register  &uint32_t  &r0  &asm("r0");  &uint32_t  &pc;  &__asm  &volatile( "	mov.l	1f, %1	;" "	mova	2f, %0	;" "	nop		;" "	and	%0, %1	;" "	nop		;" "	nop		;" "	nop		;" "	nop		;" "	jmp	@%1	;" "	 nop		;" "	.align 2	;" "1:	.long	~0x20000000;" "2:;" : "=r"( &r0), "=r"( &pc)); }  &while (0);}' unless defined(&RUN_P1);
	    eval 'sub PAD_P1_SWITCH () { &__asm  &volatile ("nop;nop;nop;nop;nop;nop;nop;nop;");}' unless defined(&PAD_P1_SWITCH);
	} else {
	    eval 'sub RUN_P2 () { &do {}  &while ( 0);}' unless defined(&RUN_P2);
	    eval 'sub RUN_P1 () { &do {}  &while ( 0);}' unless defined(&RUN_P1);
	    eval 'sub PAD_P1_SWITCH () { &do {}  &while ( 0);}' unless defined(&PAD_P1_SWITCH);
	}
    }
    if(defined( &SH4)) {
	eval 'sub SH4_PVR_ADDR () {0xff000030;}' unless defined(&SH4_PVR_ADDR);
	eval 'sub SH4_PVR () {(*( &volatile  &uint32_t *)  &SH4_PVR_ADDR);}' unless defined(&SH4_PVR);
	eval 'sub SH4_PRR_ADDR () {0xff000044;}' unless defined(&SH4_PRR_ADDR);
	eval 'sub SH4_PRR () {(*( &volatile  &uint32_t *)  &SH4_PRR_ADDR);}' unless defined(&SH4_PRR);
	eval 'sub SH4_PVR_MASK () {0xffffff00;}' unless defined(&SH4_PVR_MASK);
	eval 'sub SH4_PVR_SH7750 () {0x4020500;}' unless defined(&SH4_PVR_SH7750);
	eval 'sub SH4_PVR_SH7750S () {0x4020600;}' unless defined(&SH4_PVR_SH7750S);
	eval 'sub SH4_PVR_SH775xR () {0x4050000;}' unless defined(&SH4_PVR_SH775xR);
	eval 'sub SH4_PVR_SH7751 () {0x4110000;}' unless defined(&SH4_PVR_SH7751);
	eval 'sub SH4_PRR_MASK () {0xfffffff0;}' unless defined(&SH4_PRR_MASK);
	eval 'sub SH4_PRR_7750R () {0x100;}' unless defined(&SH4_PRR_7750R);
	eval 'sub SH4_PRR_7751R () {0x110;}' unless defined(&SH4_PRR_7751R);
    }
    require 'machine/cputypes.ph';
    if(defined(&_KERNEL)) {
    }
}
1;
