require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_IXGB_OPENBSD_OS_H_)) {
    eval 'sub _IXGB_OPENBSD_OS_H_ () {1;}' unless defined(&_IXGB_OPENBSD_OS_H_);
    eval 'sub ASSERT {
        my($x) = @_;
	    eval q( &if(!($x))  &panic(\\"IXGB: x\\"));
    }' unless defined(&ASSERT);
    eval 'sub usec_delay {
        my($x) = @_;
	    eval q( &DELAY($x));
    }' unless defined(&usec_delay);
    eval 'sub msec_delay {
        my($x) = @_;
	    eval q( &DELAY(1000*($x)));
    }' unless defined(&msec_delay);
    eval 'sub DBG () {0;}' unless defined(&DBG);
    eval 'sub MSGOUT {
        my($S, $A, $B) = @_;
	    eval q( &printf($S \\"\\\\n\\", $A, $B));
    }' unless defined(&MSGOUT);
    eval 'sub DEBUGFUNC {
        my($F) = @_;
	    eval q( &DEBUGOUT($F););
    }' unless defined(&DEBUGFUNC);
    if((defined(&DBG) ? &DBG : 0)) {
	eval 'sub DEBUGOUT {
	    my($S) = @_;
    	    eval q( &printf($S \\"\\\\n\\"));
	}' unless defined(&DEBUGOUT);
	eval 'sub DEBUGOUT1 {
	    my($S,$A) = @_;
    	    eval q( &printf($S \\"\\\\n\\",$A));
	}' unless defined(&DEBUGOUT1);
	eval 'sub DEBUGOUT2 {
	    my($S,$A,$B) = @_;
    	    eval q( &printf($S \\"\\\\n\\",$A,$B));
	}' unless defined(&DEBUGOUT2);
	eval 'sub DEBUGOUT3 {
	    my($S,$A,$B,$C) = @_;
    	    eval q( &printf($S \\"\\\\n\\",$A,$B,$C));
	}' unless defined(&DEBUGOUT3);
	eval 'sub DEBUGOUT7 {
	    my($S,$A,$B,$C,$D,$E,$F,$G) = @_;
    	    eval q( &printf($S \\"\\\\n\\",$A,$B,$C,$D,$E,$F,$G));
	}' unless defined(&DEBUGOUT7);
    } else {
	eval 'sub DEBUGOUT {
	    my($S) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT);
	eval 'sub DEBUGOUT1 {
	    my($S,$A) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT1);
	eval 'sub DEBUGOUT2 {
	    my($S,$A,$B) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT2);
	eval 'sub DEBUGOUT3 {
	    my($S,$A,$B,$C) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT3);
	eval 'sub DEBUGOUT7 {
	    my($S,$A,$B,$C,$D,$E,$F,$G) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT7);
    }
    eval 'sub CMD_MEM_WRT_INVALIDATE () {0x10;}' unless defined(&CMD_MEM_WRT_INVALIDATE);
    eval 'sub le16_to_cpu () {1;}' unless defined(&le16_to_cpu);
    eval 'sub IXGB_WRITE_FLUSH {
        my($a) = @_;
	    eval q( &IXGB_READ_REG($a,  &STATUS));
    }' unless defined(&IXGB_WRITE_FLUSH);
    eval 'sub IXGB_READ_REG {
        my($a, $reg) = @_;
	    eval q( &bus_space_read_4( (($a)-> &back)-> &mem_bus_space_tag, (($a)-> &back)-> &mem_bus_space_handle,  &IXGB_$reg));
    }' unless defined(&IXGB_READ_REG);
    eval 'sub IXGB_WRITE_REG {
        my($a, $reg, $value) = @_;
	    eval q( &bus_space_write_4( (($a)-> &back)-> &mem_bus_space_tag, (($a)-> &back)-> &mem_bus_space_handle,  &IXGB_$reg, $value));
    }' unless defined(&IXGB_WRITE_REG);
    eval 'sub IXGB_READ_REG_ARRAY {
        my($a, $reg, $offset) = @_;
	    eval q( &bus_space_read_4( (($a)-> &back)-> &mem_bus_space_tag, (($a)-> &back)-> &mem_bus_space_handle, ( &IXGB_$reg + (($offset) << 2))));
    }' unless defined(&IXGB_READ_REG_ARRAY);
    eval 'sub IXGB_WRITE_REG_ARRAY {
        my($a, $reg, $offset, $value) = @_;
	    eval q( &bus_space_write_4( (($a)-> &back)-> &mem_bus_space_tag, (($a)-> &back)-> &mem_bus_space_handle, ( &IXGB_$reg + (($offset) << 2)), $value));
    }' unless defined(&IXGB_WRITE_REG_ARRAY);
    if(defined(&DEBUG)) {
	eval 'sub IXGB_KASSERT {
	    my($exp,$msg) = @_;
    	    eval q( &do {  &if (!($exp))  &panic $msg; }  &while (0));
	}' unless defined(&IXGB_KASSERT);
    } else {
	eval 'sub IXGB_KASSERT {
	    my($exp,$msg) = @_;
    	    eval q();
	}' unless defined(&IXGB_KASSERT);
    }
}
1;
