require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&SILI_PCI_BAR_GLOBAL)) {
    sub SILI_PCI_BAR_GLOBAL () {	0x10;}
}
unless(defined(&SILI_PCI_BAR_PORT)) {
    sub SILI_PCI_BAR_PORT () {	0x18;}
}
unless(defined(&SILI_PCI_BAR_INDIRECT)) {
    sub SILI_PCI_BAR_INDIRECT () {	0x20;}
}
unless(defined(&SILI_REG_PORT0_STATUS)) {
    sub SILI_REG_PORT0_STATUS () {	0x;}
}
unless(defined(&SILI_REG_PORT1_STATUS)) {
    sub SILI_REG_PORT1_STATUS () {	0x4;}
}
unless(defined(&SILI_REG_PORT2_STATUS)) {
    sub SILI_REG_PORT2_STATUS () {	0x8;}
}
unless(defined(&SILI_REG_PORT3_STATUS)) {
    sub SILI_REG_PORT3_STATUS () {	0xc;}
}
unless(defined(&SILI_REG_GC)) {
    sub SILI_REG_GC () {	0x40;}
}
unless(defined(&SILI_REG_GC_GR)) {
    sub SILI_REG_GC_GR () {	(1<<31);}
}
unless(defined(&SILI_REG_GC_MSIACK)) {
    sub SILI_REG_GC_MSIACK () {	(1<<30);}
}
unless(defined(&SILI_REG_GC_I2CINT)) {
    sub SILI_REG_GC_I2CINT () {	(1<<29);}
}
unless(defined(&SILI_REG_GC_PERRDIS)) {
    sub SILI_REG_GC_PERRDIS () {	(1<<28);}
}
unless(defined(&SILI_REG_GC_REQ64)) {
    sub SILI_REG_GC_REQ64 () {	(1<<20);}
}
unless(defined(&SILI_REG_GC_DEVSEL)) {
    sub SILI_REG_GC_DEVSEL () {	(1<<19);}
}
unless(defined(&SILI_REG_GC_STOP)) {
    sub SILI_REG_GC_STOP () {	(1<<18);}
}
unless(defined(&SILI_REG_GC_TRDY)) {
    sub SILI_REG_GC_TRDY () {	(1<<17);}
}
unless(defined(&SILI_REG_GC_M66EN)) {
    sub SILI_REG_GC_M66EN () {	(1<<16);}
}
unless(defined(&SILI_REG_GC_PIE_MASK)) {
    sub SILI_REG_GC_PIE_MASK () {	0xf;}
}
unless(defined(&SILI_FMT_GC)) {
    sub SILI_FMT_GC () {	"\020" "\040GR" "\037MSIACK" "\036I2CINT" "\035PERRDIS" "\025REQ64" "\024DEVSEL" "\023STOP" "\022TRDY" "\021M66EN" "\004P3IE" "\003P2IE" "\002P1IE" "\001P0IE";}
}
unless(defined(&SILI_REG_GIS)) {
    sub SILI_REG_GIS () {	0x44;}
}
unless(defined(&SILI_REG_GIS_I2C)) {
    sub SILI_REG_GIS_I2C () {	(1<< 29);}
}
unless(defined(&SILI_REG_GIS_PIS_MASK)) {
    sub SILI_REG_GIS_PIS_MASK () {	0xf;}
}
unless(defined(&SILI_REG_PHYCONF)) {
    sub SILI_REG_PHYCONF () {	0x48;}
}
unless(defined(&SILI_REG_BISTCTL)) {
    sub SILI_REG_BISTCTL () {	0x50;}
}
unless(defined(&SILI_REG_BISTPATTERN)) {
    sub SILI_REG_BISTPATTERN () {	0x54;}
}
unless(defined(&SILI_REG_BISTSTAT)) {
    sub SILI_REG_BISTSTAT () {	0x58;}
}
unless(defined(&SILI_REG_FLASHADDR)) {
    sub SILI_REG_FLASHADDR () {	0x70;}
}
unless(defined(&SILI_REG_FLASHDATA)) {
    sub SILI_REG_FLASHDATA () {	0x74;}
}
unless(defined(&SILI_REG_GPIOCTL)) {
    sub SILI_REG_GPIOCTL () {	 &SILI_REG_FLASHDATA;}
}
unless(defined(&SILI_REG_IICADDR)) {
    sub SILI_REG_IICADDR () {	0x78;}
}
unless(defined(&SILI_REG_IIC)) {
    sub SILI_REG_IIC () {	0x7c;}
}
unless(defined(&SILI_PORT_SIZE)) {
    sub SILI_PORT_SIZE () {	0x2000;}
}
unless(defined(&SILI_PORT_OFFSET)) {
    sub SILI_PORT_OFFSET {
	my($_p) = @_;
	eval q((($_p) *  &SILI_PORT_SIZE));
    }
}
unless(defined(&SILI_PREG_LRAM)) {
    sub SILI_PREG_LRAM () {	0x;}
}
unless(defined(&SILI_PREG_SLOT_WIDTH)) {
    sub SILI_PREG_SLOT_WIDTH () {	0x80;}
}
unless(defined(&SILI_PREG_SLOT)) {
    sub SILI_PREG_SLOT {
	my($_s) = @_;
	eval q(( &SILI_PREG_LRAM + ($_s) *  &SILI_PREG_SLOT_WIDTH));
    }
}
unless(defined(&SILI_PREG_RX_COUNT)) {
    sub SILI_PREG_RX_COUNT {
	my($_s) = @_;
	eval q(( &SILI_PREG_SLOT($_s) + 0x4));
    }
}
unless(defined(&SILI_PREG_SIG_HI)) {
    sub SILI_PREG_SIG_HI {
	my($_s) = @_;
	eval q(( &SILI_PREG_SLOT($_s) + 0xc));
    }
}
unless(defined(&SILI_PREG_SIG_HI_SHIFT)) {
    sub SILI_PREG_SIG_HI_SHIFT () {	8;}
}
unless(defined(&SILI_PREG_SIG_LO)) {
    sub SILI_PREG_SIG_LO {
	my($_s) = @_;
	eval q(( &SILI_PREG_SLOT($_s) + 0x14));
    }
}
unless(defined(&SILI_PREG_SIG_LO_MASK)) {
    sub SILI_PREG_SIG_LO_MASK () {	0xff;}
}
unless(defined(&SILI_PREG_PCS)) {
    sub SILI_PREG_PCS () {	0x1000;}
}
unless(defined(&SILI_PREG_PCS_PORTRDY)) {
    sub SILI_PREG_PCS_PORTRDY () {	(1<<31);}
}
unless(defined(&SILI_PREG_PCS_OOBB)) {
    sub SILI_PREG_PCS_OOBB () {	(1<<25);}
}
unless(defined(&SILI_PREG_PCS_ACTIVE)) {
    sub SILI_PREG_PCS_ACTIVE {
	my($_x) = @_;
	eval q(((($_x)>>16) & 0x1f));
    }
}
unless(defined(&SILI_PREG_PCS_LED_ON)) {
    sub SILI_PREG_PCS_LED_ON () {	(1<<15);}
}
unless(defined(&SILI_PREG_PCS_AIA)) {
    sub SILI_PREG_PCS_AIA () {	(1<<14);}
}
unless(defined(&SILI_PREG_PCS_PMEN)) {
    sub SILI_PREG_PCS_PMEN () {	(1<<13);}
}
unless(defined(&SILI_PREG_PCS_IA)) {
    sub SILI_PREG_PCS_IA () {	(1<<12);}
}
unless(defined(&SILI_PREG_PCS_IR)) {
    sub SILI_PREG_PCS_IR () {	(1<<11);}
}
unless(defined(&SILI_PREG_PCS_A32B)) {
    sub SILI_PREG_PCS_A32B () {	(1<<10);}
}
unless(defined(&SILI_PREG_PCS_SD)) {
    sub SILI_PREG_PCS_SD () {	(1<<9);}
}
unless(defined(&SILI_PREG_PCS_CD)) {
    sub SILI_PREG_PCS_CD () {	(1<<8);}
}
unless(defined(&SILI_PREG_PCS_TB)) {
    sub SILI_PREG_PCS_TB () {	(1<<7);}
}
unless(defined(&SILI_PREG_PCS_RESUME)) {
    sub SILI_PREG_PCS_RESUME () {	(1<<6);}
}
unless(defined(&SILI_PREG_PCS_PLEN)) {
    sub SILI_PREG_PCS_PLEN () {	(1<<5);}
}
unless(defined(&SILI_PREG_PCS_LEDDISABLE)) {
    sub SILI_PREG_PCS_LEDDISABLE () {	(1<<4);}
}
unless(defined(&SILI_PREG_PCS_NOINTCLR)) {
    sub SILI_PREG_PCS_NOINTCLR () {	(1<<3);}
}
unless(defined(&SILI_PREG_PCS_PORTINIT)) {
    sub SILI_PREG_PCS_PORTINIT () {	(1<<2);}
}
unless(defined(&SILI_PREG_PCS_DEVRESET)) {
    sub SILI_PREG_PCS_DEVRESET () {	(1<<1);}
}
unless(defined(&SILI_PREG_PCS_PORTRESET)) {
    sub SILI_PREG_PCS_PORTRESET () {	(1<<0);}
}
unless(defined(&SILI_PFMT_PCS)) {
    sub SILI_PFMT_PCS () {	"\020" "\032OOBB" "\020LED_ON" "\017AIA" "\016PMEN" "\015IA" "\014IR" "\013A32B" "\012SD" "\011CD" "\010TB" "\007RESUME" "\006PLEN" "\005LEDDISABLE" "\004NOINTCLR" "\003PORTINIT" "\002PORTINIT" "\001PORTRESET";}
}
unless(defined(&SILI_PREG_PCC)) {
    sub SILI_PREG_PCC () {	0x1004;}
}
unless(defined(&SILI_PREG_PCC_OOBB)) {
    sub SILI_PREG_PCC_OOBB () {	(1<<25);}
}
unless(defined(&SILI_PREG_PCC_LED_ON)) {
    sub SILI_PREG_PCC_LED_ON () {	(1<<15);}
}
unless(defined(&SILI_PREG_PCC_AIA)) {
    sub SILI_PREG_PCC_AIA () {	(1<<14);}
}
unless(defined(&SILI_PREG_PCC_PMEN)) {
    sub SILI_PREG_PCC_PMEN () {	(1<<13);}
}
unless(defined(&SILI_PREG_PCC_IA)) {
    sub SILI_PREG_PCC_IA () {	(1<<12);}
}
unless(defined(&SILI_PREG_PCC_IR)) {
    sub SILI_PREG_PCC_IR () {	(1<<11);}
}
unless(defined(&SILI_PREG_PCC_A32B)) {
    sub SILI_PREG_PCC_A32B () {	(1<<10);}
}
unless(defined(&SILI_PREG_PCC_SD)) {
    sub SILI_PREG_PCC_SD () {	(1<<9);}
}
unless(defined(&SILI_PREG_PCC_CD)) {
    sub SILI_PREG_PCC_CD () {	(1<<8);}
}
unless(defined(&SILI_PREG_PCC_TB)) {
    sub SILI_PREG_PCC_TB () {	(1<<7);}
}
unless(defined(&SILI_PREG_PCC_RESUME)) {
    sub SILI_PREG_PCC_RESUME () {	(1<<6);}
}
unless(defined(&SILI_PREG_PCC_PLEN)) {
    sub SILI_PREG_PCC_PLEN () {	(1<<5);}
}
unless(defined(&SILI_PREG_PCC_LEDDISABLE)) {
    sub SILI_PREG_PCC_LEDDISABLE () {	(1<<4);}
}
unless(defined(&SILI_PREG_PCC_NOINTCLR)) {
    sub SILI_PREG_PCC_NOINTCLR () {	(1<<3);}
}
unless(defined(&SILI_PREG_PCC_PORTINIT)) {
    sub SILI_PREG_PCC_PORTINIT () {	(1<<2);}
}
unless(defined(&SILI_PREG_PCC_DEVRESET)) {
    sub SILI_PREG_PCC_DEVRESET () {	(1<<1);}
}
unless(defined(&SILI_PREG_PCC_PORTRESET)) {
    sub SILI_PREG_PCC_PORTRESET () {	(1<<0);}
}
unless(defined(&SILI_PREG_IS)) {
    sub SILI_PREG_IS () {	0x1008;}
}
unless(defined(&SILI_PREG_IS_SDB)) {
    sub SILI_PREG_IS_SDB () {	(1<<11);}
}
unless(defined(&SILI_PREG_IS_HANDSHAKE)) {
    sub SILI_PREG_IS_HANDSHAKE () {	(1<<10);}
}
unless(defined(&SILI_PREG_IS_CRC)) {
    sub SILI_PREG_IS_CRC () {	(1<<9);}
}
unless(defined(&SILI_PREG_IS_DEC)) {
    sub SILI_PREG_IS_DEC () {	(1<<8);}
}
unless(defined(&SILI_PREG_IS_DEVXCHG)) {
    sub SILI_PREG_IS_DEVXCHG () {	(1<<7);}
}
unless(defined(&SILI_PREG_IS_UNRECFIS)) {
    sub SILI_PREG_IS_UNRECFIS () {	(1<<6);}
}
unless(defined(&SILI_PREG_IS_COMWAKE)) {
    sub SILI_PREG_IS_COMWAKE () {	(1<<5);}
}
unless(defined(&SILI_PREG_IS_PHYRDYCHG)) {
    sub SILI_PREG_IS_PHYRDYCHG () {	(1<<4);}
}
unless(defined(&SILI_PREG_IS_PMCHG)) {
    sub SILI_PREG_IS_PMCHG () {	(1<<3);}
}
unless(defined(&SILI_PREG_IS_PORTRDY)) {
    sub SILI_PREG_IS_PORTRDY () {	(1<<2);}
}
unless(defined(&SILI_PREG_IS_CMDERR)) {
    sub SILI_PREG_IS_CMDERR () {	(1<<1);}
}
unless(defined(&SILI_PREG_IS_CMDCOMP)) {
    sub SILI_PREG_IS_CMDCOMP () {	(1<<0);}
}
unless(defined(&SILI_PFMT_IS)) {
    sub SILI_PFMT_IS () {	"\020" "\014SDB" "\013HANDSHAKE" "\012CRC" "\011DECODE" "\010DEVXCHG" "\007UNRECFIS" "\006COMWAKE" "\005PHYRDYCHG" "\004PMCHG" "\003PORTRDY" "\002CMDERR" "\001CMDCOMP";}
}
unless(defined(&SILI_PREG_IES)) {
    sub SILI_PREG_IES () {	0x1010;}
}
unless(defined(&SILI_PREG_IEC)) {
    sub SILI_PREG_IEC () {	0x1014;}
}
unless(defined(&SILI_PREG_IE_SDB)) {
    sub SILI_PREG_IE_SDB () {	(1<<11);}
}
unless(defined(&SILI_PREG_IE_DEVXCHG)) {
    sub SILI_PREG_IE_DEVXCHG () {	(1<<7);}
}
unless(defined(&SILI_PREG_IE_UNRECFIS)) {
    sub SILI_PREG_IE_UNRECFIS () {	(1<<6);}
}
unless(defined(&SILI_PREG_IE_COMWAKE)) {
    sub SILI_PREG_IE_COMWAKE () {	(1<<5);}
}
unless(defined(&SILI_PREG_IE_PHYRDYCHG)) {
    sub SILI_PREG_IE_PHYRDYCHG () {	(1<<4);}
}
unless(defined(&SILI_PREG_IE_PMCHG)) {
    sub SILI_PREG_IE_PMCHG () {	(1<<3);}
}
unless(defined(&SILI_PREG_IE_PORTRDY)) {
    sub SILI_PREG_IE_PORTRDY () {	(1<<2);}
}
unless(defined(&SILI_PREG_IE_CMDERR)) {
    sub SILI_PREG_IE_CMDERR () {	(1<<1);}
}
unless(defined(&SILI_PREG_IE_CMDCOMP)) {
    sub SILI_PREG_IE_CMDCOMP () {	(1<<0);}
}
unless(defined(&SILI_PREG_IE_ALL)) {
    sub SILI_PREG_IE_ALL () {	0x8ff;}
}
unless(defined(&SILI_PREG_AUA)) {
    sub SILI_PREG_AUA () {	0x101c;}
}
unless(defined(&SILI_PREG_FIFO)) {
    sub SILI_PREG_FIFO () {	0x1020;}
}
unless(defined(&SILI_PREG_CE)) {
    sub SILI_PREG_CE () {	0x1024;}
}
unless(defined(&SILI_PREG_CE_DEVICEERROR)) {
    sub SILI_PREG_CE_DEVICEERROR () {	1;}
}
unless(defined(&SILI_PREG_CE_SDBERROR)) {
    sub SILI_PREG_CE_SDBERROR () {	2;}
}
unless(defined(&SILI_PREG_CE_DATAFISERROR)) {
    sub SILI_PREG_CE_DATAFISERROR () {	3;}
}
unless(defined(&SILI_PREG_FC)) {
    sub SILI_PREG_FC () {	0x1028;}
}
unless(defined(&SILI_PREG_RFT)) {
    sub SILI_PREG_RFT () {	0x102c;}
}
unless(defined(&SILI_PREG_DEC)) {
    sub SILI_PREG_DEC () {	0x1040;}
}
unless(defined(&SILI_PREG_CEC)) {
    sub SILI_PREG_CEC () {	0x1044;}
}
unless(defined(&SILI_PREG_HEC)) {
    sub SILI_PREG_HEC () {	0x1048;}
}
unless(defined(&SILI_PREG_PHYCONF)) {
    sub SILI_PREG_PHYCONF () {	0x1050;}
}
unless(defined(&SILI_PREG_PSS)) {
    sub SILI_PREG_PSS () {	0x1800;}
}
unless(defined(&SILI_PREG_PSS_ATTENTION)) {
    sub SILI_PREG_PSS_ATTENTION () {	(1<< 31);}
}
unless(defined(&SILI_PREG_PSS_ALL_SLOTS)) {
    sub SILI_PREG_PSS_ALL_SLOTS () {	0x7fffffff;}
}
unless(defined(&SILI_PREG_CAR_LO)) {
    sub SILI_PREG_CAR_LO {
	my($_s) = @_;
	eval q((0x1c00 + (($_s) * 0x8)));
    }
}
unless(defined(&SILI_PREG_CAR_HI)) {
    sub SILI_PREG_CAR_HI {
	my($_s) = @_;
	eval q((0x1c00 + (($_s) * 0x8) + 0x4));
    }
}
unless(defined(&SILI_PREG_CONTEXT)) {
    sub SILI_PREG_CONTEXT () {	0x1e0f;}
}
unless(defined(&SILI_PREG_SCTL)) {
    sub SILI_PREG_SCTL () {	0x1f00;}
}
unless(defined(&SILI_PREG_SSTS)) {
    sub SILI_PREG_SSTS () {	0x1f04;}
}
unless(defined(&SILI_PREG_SERR)) {
    sub SILI_PREG_SERR () {	0x1f08;}
}
unless(defined(&SILI_PREG_SACT)) {
    sub SILI_PREG_SACT () {	0x1f0c;}
}
unless(defined(&SILI_SGE_TRM)) {
    sub SILI_SGE_TRM () {	(1<<31);}
}
unless(defined(&SILI_SGE_LNK)) {
    sub SILI_SGE_LNK () {	(1<<30);}
}
unless(defined(&SILI_SGE_DRD)) {
    sub SILI_SGE_DRD () {	(1<<29);}
}
unless(defined(&SILI_SGE_XCF)) {
    sub SILI_SGE_XCF () {	(1<<28);}
}
unless(defined(&SILI_SGT_SGLLEN)) {
    sub SILI_SGT_SGLLEN () {	4;}
}
unless(defined(&SILI_PRB_PROTOCOL_OVERRIDE)) {
    sub SILI_PRB_PROTOCOL_OVERRIDE () {	(1<<0);}
}
unless(defined(&SILI_PRB_RETRANSMIT)) {
    sub SILI_PRB_RETRANSMIT () {	(1<<1);}
}
unless(defined(&SILI_PRB_EXTERNAL_COMMAND)) {
    sub SILI_PRB_EXTERNAL_COMMAND () {	(1<<2);}
}
unless(defined(&SILI_PRB_RECEIVE)) {
    sub SILI_PRB_RECEIVE () {	(1<<3);}
}
unless(defined(&SILI_PRB_PACKET_READ)) {
    sub SILI_PRB_PACKET_READ () {	(1<<4);}
}
unless(defined(&SILI_PRB_PACKET_WRITE)) {
    sub SILI_PRB_PACKET_WRITE () {	(1<<5);}
}
unless(defined(&SILI_PRB_INTERRUPT_MASK)) {
    sub SILI_PRB_INTERRUPT_MASK () {	(1<<6);}
}
unless(defined(&SILI_PRB_SOFT_RESET)) {
    sub SILI_PRB_SOFT_RESET () {	(1<<7);}
}
unless(defined(&SILI_MAX_CMDS)) {
    sub SILI_MAX_CMDS () {	31;}
}
unless(defined(&SILI_PRB_LENGTH)) {
    sub SILI_PRB_LENGTH () {	64;}
}
unless(defined(&SILI_PRB_ALIGN)) {
    sub SILI_PRB_ALIGN () {	8;}
}
unless(defined(&SILI_SGT_LENGTH)) {
    sub SILI_SGT_LENGTH () {	64;}
}
1;
