require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_DRM_H_)) {
    eval 'sub _DRM_H_ () {1;}' unless defined(&_DRM_H_);
    unless(defined(&__user)) {
	eval 'sub __user () {1;}' unless defined(&__user);
    }
    unless(defined(&__iomem)) {
	eval 'sub __iomem () {1;}' unless defined(&__iomem);
    }
    if(defined(&__GNUC__)) {
	eval 'sub DEPRECATED () { &__attribute__ (( &deprecated));}' unless defined(&DEPRECATED);
    } else {
	eval 'sub DEPRECATED () {1;}' unless defined(&DEPRECATED);
    }
    if(defined( &__linux__)) {
	require 'asm/ioctl.ph';
	eval 'sub DRM_IOCTL_NR {
	    my($n) = @_;
    	    eval q( &_IOC_NR($n));
	}' unless defined(&DRM_IOCTL_NR);
	eval 'sub DRM_IOC_VOID () { &_IOC_NONE;}' unless defined(&DRM_IOC_VOID);
	eval 'sub DRM_IOC_READ () { &_IOC_READ;}' unless defined(&DRM_IOC_READ);
	eval 'sub DRM_IOC_WRITE () { &_IOC_WRITE;}' unless defined(&DRM_IOC_WRITE);
	eval 'sub DRM_IOC_READWRITE () { &_IOC_READ| &_IOC_WRITE;}' unless defined(&DRM_IOC_READWRITE);
	eval 'sub DRM_IOC {
	    my($dir, $group, $nr, $size) = @_;
    	    eval q( &_IOC($dir, $group, $nr, $size));
	}' unless defined(&DRM_IOC);
    }
 elsif(defined( &__FreeBSD__) || defined( &__FreeBSD_kernel__) || defined( &__NetBSD__) || defined( &__OpenBSD__) || defined( &__DragonFly__)) {
	require 'sys/ioccom.ph';
	eval 'sub DRM_IOCTL_NR {
	    my($n) = @_;
    	    eval q((($n) & 0xff));
	}' unless defined(&DRM_IOCTL_NR);
	eval 'sub DRM_IOC_VOID () { &IOC_VOID;}' unless defined(&DRM_IOC_VOID);
	eval 'sub DRM_IOC_READ () { &IOC_OUT;}' unless defined(&DRM_IOC_READ);
	eval 'sub DRM_IOC_WRITE () { &IOC_IN;}' unless defined(&DRM_IOC_WRITE);
	eval 'sub DRM_IOC_READWRITE () { &IOC_INOUT;}' unless defined(&DRM_IOC_READWRITE);
	eval 'sub DRM_IOC {
	    my($dir, $group, $nr, $size) = @_;
    	    eval q( &_IOC($dir, $group, $nr, $size));
	}' unless defined(&DRM_IOC);
    }
    if(defined(&__OpenBSD__)) {
	eval 'sub DRM_MAJOR () {88;}' unless defined(&DRM_MAJOR);
    }
    if(defined( &__linux__) || defined( &__NetBSD__)) {
	eval 'sub DRM_MAJOR () {226;}' unless defined(&DRM_MAJOR);
    }
    eval 'sub DRM_MAX_MINOR () {15;}' unless defined(&DRM_MAX_MINOR);
    eval 'sub DRM_NAME () {"drm";}' unless defined(&DRM_NAME);
    eval 'sub DRM_MIN_ORDER () {5;}' unless defined(&DRM_MIN_ORDER);
    eval 'sub DRM_MAX_ORDER () {22;}' unless defined(&DRM_MAX_ORDER);
    eval 'sub DRM_RAM_PERCENT () {10;}' unless defined(&DRM_RAM_PERCENT);
    eval 'sub _DRM_LOCK_HELD () {0x80000000;}' unless defined(&_DRM_LOCK_HELD);
    eval 'sub _DRM_LOCK_CONT () {0x40000000;}' unless defined(&_DRM_LOCK_CONT);
    eval 'sub _DRM_LOCK_IS_HELD {
        my($lock) = @_;
	    eval q((($lock) &  &_DRM_LOCK_HELD));
    }' unless defined(&_DRM_LOCK_IS_HELD);
    eval 'sub _DRM_LOCK_IS_CONT {
        my($lock) = @_;
	    eval q((($lock) &  &_DRM_LOCK_CONT));
    }' unless defined(&_DRM_LOCK_IS_CONT);
    eval 'sub _DRM_LOCKING_CONTEXT {
        my($lock) = @_;
	    eval q((($lock) & ~( &_DRM_LOCK_HELD| &_DRM_LOCK_CONT)));
    }' unless defined(&_DRM_LOCKING_CONTEXT);
    if(defined( &__linux__)) {
    } else {
	require 'sys/types.ph';
    }
    if(defined(&__SIZE_TYPE__)) {
	eval 'sub DRM_SIZE_T () { &__SIZE_TYPE__;}' unless defined(&DRM_SIZE_T);
    } else {
	warn("\"__SIZE_TYPE__\ not\ defined\.\ \ Assuming\ sizeof\(size_t\)\ \=\=\ sizeof\(unsigned\ long\)\!\"");
	eval 'sub DRM_SIZE_T () {\'unsigned long\';}' unless defined(&DRM_SIZE_T);
    }
    undef(&DRM_SIZE_T) if defined(&DRM_SIZE_T);
    eval("sub DRM_ADD_COMMAND () { 0; }") unless defined(&DRM_ADD_COMMAND);
    eval("sub DRM_RM_COMMAND () { 1; }") unless defined(&DRM_RM_COMMAND);
    eval("sub DRM_INST_HANDLER () { 2; }") unless defined(&DRM_INST_HANDLER);
    eval("sub DRM_UNINST_HANDLER () { 3; }") unless defined(&DRM_UNINST_HANDLER);
    eval("sub _DRM_FRAME_BUFFER () { 0; }") unless defined(&_DRM_FRAME_BUFFER);
    eval("sub _DRM_REGISTERS () { 1; }") unless defined(&_DRM_REGISTERS);
    eval("sub _DRM_SHM () { 2; }") unless defined(&_DRM_SHM);
    eval("sub _DRM_AGP () { 3; }") unless defined(&_DRM_AGP);
    eval("sub _DRM_SCATTER_GATHER () { 4; }") unless defined(&_DRM_SCATTER_GATHER);
    eval("sub _DRM_CONSISTENT () { 5; }") unless defined(&_DRM_CONSISTENT);
    eval("sub _DRM_TTM () { 6; }") unless defined(&_DRM_TTM);
    eval("sub _DRM_RESTRICTED () { 0x01; }") unless defined(&_DRM_RESTRICTED);
    eval("sub _DRM_READ_ONLY () { 0x02; }") unless defined(&_DRM_READ_ONLY);
    eval("sub _DRM_LOCKED () { 0x04; }") unless defined(&_DRM_LOCKED);
    eval("sub _DRM_KERNEL () { 0x08; }") unless defined(&_DRM_KERNEL);
    eval("sub _DRM_WRITE_COMBINING () { 0x10; }") unless defined(&_DRM_WRITE_COMBINING);
    eval("sub _DRM_CONTAINS_LOCK () { 0x20; }") unless defined(&_DRM_CONTAINS_LOCK);
    eval("sub _DRM_REMOVABLE () { 0x40; }") unless defined(&_DRM_REMOVABLE);
    eval("sub _DRM_DRIVER () { 0x80; }") unless defined(&_DRM_DRIVER);
    eval("sub _DRM_STAT_LOCK () { 0; }") unless defined(&_DRM_STAT_LOCK);
    eval("sub _DRM_STAT_OPENS () { 1; }") unless defined(&_DRM_STAT_OPENS);
    eval("sub _DRM_STAT_CLOSES () { 2; }") unless defined(&_DRM_STAT_CLOSES);
    eval("sub _DRM_STAT_IOCTLS () { 3; }") unless defined(&_DRM_STAT_IOCTLS);
    eval("sub _DRM_STAT_LOCKS () { 4; }") unless defined(&_DRM_STAT_LOCKS);
    eval("sub _DRM_STAT_UNLOCKS () { 5; }") unless defined(&_DRM_STAT_UNLOCKS);
    eval("sub _DRM_STAT_VALUE () { 6; }") unless defined(&_DRM_STAT_VALUE);
    eval("sub _DRM_STAT_BYTE () { 7; }") unless defined(&_DRM_STAT_BYTE);
    eval("sub _DRM_STAT_COUNT () { 8; }") unless defined(&_DRM_STAT_COUNT);
    eval("sub _DRM_STAT_IRQ () { 9; }") unless defined(&_DRM_STAT_IRQ);
    eval("sub _DRM_STAT_PRIMARY () { 10; }") unless defined(&_DRM_STAT_PRIMARY);
    eval("sub _DRM_STAT_SECONDARY () { 11; }") unless defined(&_DRM_STAT_SECONDARY);
    eval("sub _DRM_STAT_DMA () { 12; }") unless defined(&_DRM_STAT_DMA);
    eval("sub _DRM_STAT_SPECIAL () { 13; }") unless defined(&_DRM_STAT_SPECIAL);
    eval("sub _DRM_STAT_MISSED () { 14; }") unless defined(&_DRM_STAT_MISSED);
    eval("sub _DRM_LOCK_READY () { 0x01; }") unless defined(&_DRM_LOCK_READY);
    eval("sub _DRM_LOCK_QUIESCENT () { 0x02; }") unless defined(&_DRM_LOCK_QUIESCENT);
    eval("sub _DRM_LOCK_FLUSH () { 0x04; }") unless defined(&_DRM_LOCK_FLUSH);
    eval("sub _DRM_LOCK_FLUSH_ALL () { 0x08; }") unless defined(&_DRM_LOCK_FLUSH_ALL);
    eval("sub _DRM_HALT_ALL_QUEUES () { 0x10; }") unless defined(&_DRM_HALT_ALL_QUEUES);
    eval("sub _DRM_HALT_CUR_QUEUES () { 0x20; }") unless defined(&_DRM_HALT_CUR_QUEUES);
    eval("sub _DRM_DMA_BLOCK () { 0x01; }") unless defined(&_DRM_DMA_BLOCK);
    eval("sub _DRM_DMA_WHILE_LOCKED () { 0x02; }") unless defined(&_DRM_DMA_WHILE_LOCKED);
    eval("sub _DRM_DMA_PRIORITY () { 0x04; }") unless defined(&_DRM_DMA_PRIORITY);
    eval("sub _DRM_DMA_WAIT () { 0x10; }") unless defined(&_DRM_DMA_WAIT);
    eval("sub _DRM_DMA_SMALLER_OK () { 0x20; }") unless defined(&_DRM_DMA_SMALLER_OK);
    eval("sub _DRM_DMA_LARGER_OK () { 0x40; }") unless defined(&_DRM_DMA_LARGER_OK);
    eval("sub _DRM_PAGE_ALIGN () { 0x01; }") unless defined(&_DRM_PAGE_ALIGN);
    eval("sub _DRM_AGP_BUFFER () { 0x02; }") unless defined(&_DRM_AGP_BUFFER);
    eval("sub _DRM_SG_BUFFER () { 0x04; }") unless defined(&_DRM_SG_BUFFER);
    eval("sub _DRM_FB_BUFFER () { 0x08; }") unless defined(&_DRM_FB_BUFFER);
    eval("sub _DRM_PCI_BUFFER_RO () { 0x10; }") unless defined(&_DRM_PCI_BUFFER_RO);
    if(defined( &__cplusplus)) {
    } else {
    }
    eval("sub _DRM_CONTEXT_PRESERVED () { 0x01; }") unless defined(&_DRM_CONTEXT_PRESERVED);
    eval("sub _DRM_CONTEXT_2DONLY () { 0x02; }") unless defined(&_DRM_CONTEXT_2DONLY);
    eval("sub DRM_DRAWABLE_CLIPRECTS () { 0; }") unless defined(&DRM_DRAWABLE_CLIPRECTS);
    eval("sub _DRM_VBLANK_ABSOLUTE () { 0x0; }") unless defined(&_DRM_VBLANK_ABSOLUTE);
    eval("sub _DRM_VBLANK_RELATIVE () { 0x1; }") unless defined(&_DRM_VBLANK_RELATIVE);
    eval("sub _DRM_VBLANK_FLIP () { 0x8000000; }") unless defined(&_DRM_VBLANK_FLIP);
    eval("sub _DRM_VBLANK_NEXTONMISS () { 0x10000000; }") unless defined(&_DRM_VBLANK_NEXTONMISS);
    eval("sub _DRM_VBLANK_SECONDARY () { 0x20000000; }") unless defined(&_DRM_VBLANK_SECONDARY);
    eval("sub _DRM_VBLANK_SIGNAL () { 0x40000000; }") unless defined(&_DRM_VBLANK_SIGNAL);
    eval 'sub _DRM_VBLANK_TYPES_MASK () {( &_DRM_VBLANK_ABSOLUTE |  &_DRM_VBLANK_RELATIVE);}' unless defined(&_DRM_VBLANK_TYPES_MASK);
    eval 'sub _DRM_VBLANK_FLAGS_MASK () {( &_DRM_VBLANK_SIGNAL |  &_DRM_VBLANK_SECONDARY |  &_DRM_VBLANK_NEXTONMISS);}' unless defined(&_DRM_VBLANK_FLAGS_MASK);
    eval 'sub _DRM_PRE_MODESET () {1;}' unless defined(&_DRM_PRE_MODESET);
    eval 'sub _DRM_POST_MODESET () {2;}' unless defined(&_DRM_POST_MODESET);
    eval 'sub DRM_FENCE_FLAG_EMIT () {0x1;}' unless defined(&DRM_FENCE_FLAG_EMIT);
    eval 'sub DRM_FENCE_FLAG_SHAREABLE () {0x2;}' unless defined(&DRM_FENCE_FLAG_SHAREABLE);
    eval 'sub DRM_FENCE_FLAG_WAIT_LAZY () {0x4;}' unless defined(&DRM_FENCE_FLAG_WAIT_LAZY);
    eval 'sub DRM_FENCE_FLAG_NO_USER () {0x10;}' unless defined(&DRM_FENCE_FLAG_NO_USER);
    eval 'sub DRM_FENCE_MASK_DRIVER () {0xff000000;}' unless defined(&DRM_FENCE_MASK_DRIVER);
    eval 'sub DRM_FENCE_TYPE_EXE () {0x1;}' unless defined(&DRM_FENCE_TYPE_EXE);
    eval 'sub DRM_BO_FLAG_READ () {(1 << 0);}' unless defined(&DRM_BO_FLAG_READ);
    eval 'sub DRM_BO_FLAG_WRITE () {(1 << 1);}' unless defined(&DRM_BO_FLAG_WRITE);
    eval 'sub DRM_BO_FLAG_EXE () {(1 << 2);}' unless defined(&DRM_BO_FLAG_EXE);
    eval 'sub DRM_BO_MASK_ACCESS () {( &DRM_BO_FLAG_READ |  &DRM_BO_FLAG_WRITE |  &DRM_BO_FLAG_EXE);}' unless defined(&DRM_BO_MASK_ACCESS);
    eval 'sub DRM_BO_FLAG_NO_EVICT () {(1 << 4);}' unless defined(&DRM_BO_FLAG_NO_EVICT);
    eval 'sub DRM_BO_FLAG_MAPPABLE () {(1 << 5);}' unless defined(&DRM_BO_FLAG_MAPPABLE);
    eval 'sub DRM_BO_FLAG_SHAREABLE () {(1 << 6);}' unless defined(&DRM_BO_FLAG_SHAREABLE);
    eval 'sub DRM_BO_FLAG_CACHED () {(1 << 7);}' unless defined(&DRM_BO_FLAG_CACHED);
    eval 'sub DRM_BO_FLAG_NO_MOVE () {(1 << 8);}' unless defined(&DRM_BO_FLAG_NO_MOVE);
    eval 'sub DRM_BO_FLAG_CACHED_MAPPED () {(1 << 19);}' unless defined(&DRM_BO_FLAG_CACHED_MAPPED);
    eval 'sub DRM_BO_FLAG_FORCE_CACHING () {(1 << 13);}' unless defined(&DRM_BO_FLAG_FORCE_CACHING);
    eval 'sub DRM_BO_FLAG_FORCE_MAPPABLE () {(1 << 14);}' unless defined(&DRM_BO_FLAG_FORCE_MAPPABLE);
    eval 'sub DRM_BO_FLAG_TILE () {(1 << 15);}' unless defined(&DRM_BO_FLAG_TILE);
    eval 'sub DRM_BO_FLAG_MEM_LOCAL () {(1 << 24);}' unless defined(&DRM_BO_FLAG_MEM_LOCAL);
    eval 'sub DRM_BO_FLAG_MEM_TT () {(1 << 25);}' unless defined(&DRM_BO_FLAG_MEM_TT);
    eval 'sub DRM_BO_FLAG_MEM_VRAM () {(1 << 26);}' unless defined(&DRM_BO_FLAG_MEM_VRAM);
    eval 'sub DRM_BO_FLAG_MEM_PRIV0 () {(1 << 27);}' unless defined(&DRM_BO_FLAG_MEM_PRIV0);
    eval 'sub DRM_BO_FLAG_MEM_PRIV1 () {(1 << 28);}' unless defined(&DRM_BO_FLAG_MEM_PRIV1);
    eval 'sub DRM_BO_FLAG_MEM_PRIV2 () {(1 << 29);}' unless defined(&DRM_BO_FLAG_MEM_PRIV2);
    eval 'sub DRM_BO_FLAG_MEM_PRIV3 () {(1 << 30);}' unless defined(&DRM_BO_FLAG_MEM_PRIV3);
    eval 'sub DRM_BO_FLAG_MEM_PRIV4 () {(1 << 31);}' unless defined(&DRM_BO_FLAG_MEM_PRIV4);
    eval 'sub DRM_BO_MASK_MEM () {0xff000000;}' unless defined(&DRM_BO_MASK_MEM);
    eval 'sub DRM_BO_MASK_MEMTYPE () {( &DRM_BO_MASK_MEM |  &DRM_BO_FLAG_CACHED_MAPPED |  &DRM_BO_FLAG_CACHED |  &DRM_BO_FLAG_MAPPABLE);}' unless defined(&DRM_BO_MASK_MEMTYPE);
    eval 'sub DRM_BO_MASK_DRIVER () {1.84464625987328e+19;}' unless defined(&DRM_BO_MASK_DRIVER);
    eval 'sub DRM_BO_HINT_DONT_BLOCK () {0x2;}' unless defined(&DRM_BO_HINT_DONT_BLOCK);
    eval 'sub DRM_BO_HINT_DONT_FENCE () {0x4;}' unless defined(&DRM_BO_HINT_DONT_FENCE);
    eval 'sub DRM_BO_HINT_WAIT_LAZY () {0x8;}' unless defined(&DRM_BO_HINT_WAIT_LAZY);
    eval 'sub DRM_BO_HINT_PRESUMED_OFFSET () {0x10;}' unless defined(&DRM_BO_HINT_PRESUMED_OFFSET);
    eval 'sub DRM_BO_INIT_MAGIC () {0xfe769812;}' unless defined(&DRM_BO_INIT_MAGIC);
    eval 'sub DRM_BO_INIT_MAJOR () {1;}' unless defined(&DRM_BO_INIT_MAJOR);
    eval 'sub DRM_BO_INIT_MINOR () {0;}' unless defined(&DRM_BO_INIT_MINOR);
    eval 'sub DRM_BO_INIT_PATCH () {0;}' unless defined(&DRM_BO_INIT_PATCH);
    eval 'sub DRM_BO_REP_BUSY () {0x1;}' unless defined(&DRM_BO_REP_BUSY);
    eval("sub drm_bo_validate () { 0; }") unless defined(&drm_bo_validate);
    eval("sub drm_bo_fence () { 1; }") unless defined(&drm_bo_fence);
    eval("sub drm_bo_ref_fence () { 2; }") unless defined(&drm_bo_ref_fence);
    eval 'sub DRM_BO_MEM_LOCAL () {0;}' unless defined(&DRM_BO_MEM_LOCAL);
    eval 'sub DRM_BO_MEM_TT () {1;}' unless defined(&DRM_BO_MEM_TT);
    eval 'sub DRM_BO_MEM_VRAM () {2;}' unless defined(&DRM_BO_MEM_VRAM);
    eval 'sub DRM_BO_MEM_PRIV0 () {3;}' unless defined(&DRM_BO_MEM_PRIV0);
    eval 'sub DRM_BO_MEM_PRIV1 () {4;}' unless defined(&DRM_BO_MEM_PRIV1);
    eval 'sub DRM_BO_MEM_PRIV2 () {5;}' unless defined(&DRM_BO_MEM_PRIV2);
    eval 'sub DRM_BO_MEM_PRIV3 () {6;}' unless defined(&DRM_BO_MEM_PRIV3);
    eval 'sub DRM_BO_MEM_PRIV4 () {7;}' unless defined(&DRM_BO_MEM_PRIV4);
    eval 'sub DRM_BO_MEM_TYPES () {8;}' unless defined(&DRM_BO_MEM_TYPES);
    eval 'sub DRM_BO_LOCK_UNLOCK_BM () {(1<< 0);}' unless defined(&DRM_BO_LOCK_UNLOCK_BM);
    eval 'sub DRM_BO_LOCK_IGNORE_NO_EVICT () {(1<< 1);}' unless defined(&DRM_BO_LOCK_IGNORE_NO_EVICT);
    eval 'sub DRM_IOCTL_BASE () {ord(\'d\');}' unless defined(&DRM_IOCTL_BASE);
    eval 'sub DRM_IO {
        my($nr) = @_;
	    eval q( &_IO( &DRM_IOCTL_BASE,$nr));
    }' unless defined(&DRM_IO);
    eval 'sub DRM_IOR {
        my($nr,$type) = @_;
	    eval q( &_IOR( &DRM_IOCTL_BASE,$nr,$type));
    }' unless defined(&DRM_IOR);
    eval 'sub DRM_IOW {
        my($nr,$type) = @_;
	    eval q( &_IOW( &DRM_IOCTL_BASE,$nr,$type));
    }' unless defined(&DRM_IOW);
    eval 'sub DRM_IOWR {
        my($nr,$type) = @_;
	    eval q( &_IOWR( &DRM_IOCTL_BASE,$nr,$type));
    }' unless defined(&DRM_IOWR);
    eval 'sub DRM_IOCTL_VERSION () { &DRM_IOWR(0x, \'struct drm_version\');}' unless defined(&DRM_IOCTL_VERSION);
    eval 'sub DRM_IOCTL_GET_UNIQUE () { &DRM_IOWR(0x1, \'struct drm_unique\');}' unless defined(&DRM_IOCTL_GET_UNIQUE);
    eval 'sub DRM_IOCTL_GET_MAGIC () { &DRM_IOR( 0x2, \'struct drm_auth\');}' unless defined(&DRM_IOCTL_GET_MAGIC);
    eval 'sub DRM_IOCTL_IRQ_BUSID () { &DRM_IOWR(0x3, \'struct drm_irq_busid\');}' unless defined(&DRM_IOCTL_IRQ_BUSID);
    eval 'sub DRM_IOCTL_GET_MAP () { &DRM_IOWR(0x4, \'struct drm_map\');}' unless defined(&DRM_IOCTL_GET_MAP);
    eval 'sub DRM_IOCTL_GET_CLIENT () { &DRM_IOWR(0x5, \'struct drm_client\');}' unless defined(&DRM_IOCTL_GET_CLIENT);
    eval 'sub DRM_IOCTL_GET_STATS () { &DRM_IOR( 0x6, \'struct drm_stats\');}' unless defined(&DRM_IOCTL_GET_STATS);
    eval 'sub DRM_IOCTL_SET_VERSION () { &DRM_IOWR(0x7, \'struct drm_set_version\');}' unless defined(&DRM_IOCTL_SET_VERSION);
    eval 'sub DRM_IOCTL_MODESET_CTL () { &DRM_IOW(0x8, \'struct drm_modeset_ctl\');}' unless defined(&DRM_IOCTL_MODESET_CTL);
    eval 'sub DRM_IOCTL_SET_UNIQUE () { &DRM_IOW( 0x10, \'struct drm_unique\');}' unless defined(&DRM_IOCTL_SET_UNIQUE);
    eval 'sub DRM_IOCTL_AUTH_MAGIC () { &DRM_IOW( 0x11, \'struct drm_auth\');}' unless defined(&DRM_IOCTL_AUTH_MAGIC);
    eval 'sub DRM_IOCTL_BLOCK () { &DRM_IOWR(0x12, \'struct drm_block\');}' unless defined(&DRM_IOCTL_BLOCK);
    eval 'sub DRM_IOCTL_UNBLOCK () { &DRM_IOWR(0x13, \'struct drm_block\');}' unless defined(&DRM_IOCTL_UNBLOCK);
    eval 'sub DRM_IOCTL_CONTROL () { &DRM_IOW( 0x14, \'struct drm_control\');}' unless defined(&DRM_IOCTL_CONTROL);
    eval 'sub DRM_IOCTL_ADD_MAP () { &DRM_IOWR(0x15, \'struct drm_map\');}' unless defined(&DRM_IOCTL_ADD_MAP);
    eval 'sub DRM_IOCTL_ADD_BUFS () { &DRM_IOWR(0x16, \'struct drm_buf_desc\');}' unless defined(&DRM_IOCTL_ADD_BUFS);
    eval 'sub DRM_IOCTL_MARK_BUFS () { &DRM_IOW( 0x17, \'struct drm_buf_desc\');}' unless defined(&DRM_IOCTL_MARK_BUFS);
    eval 'sub DRM_IOCTL_INFO_BUFS () { &DRM_IOWR(0x18, \'struct drm_buf_info\');}' unless defined(&DRM_IOCTL_INFO_BUFS);
    eval 'sub DRM_IOCTL_MAP_BUFS () { &DRM_IOWR(0x19, \'struct drm_buf_map\');}' unless defined(&DRM_IOCTL_MAP_BUFS);
    eval 'sub DRM_IOCTL_FREE_BUFS () { &DRM_IOW( 0x1a, \'struct drm_buf_free\');}' unless defined(&DRM_IOCTL_FREE_BUFS);
    eval 'sub DRM_IOCTL_RM_MAP () { &DRM_IOW( 0x1b, \'struct drm_map\');}' unless defined(&DRM_IOCTL_RM_MAP);
    eval 'sub DRM_IOCTL_SET_SAREA_CTX () { &DRM_IOW( 0x1c, \'struct drm_ctx_priv_map\');}' unless defined(&DRM_IOCTL_SET_SAREA_CTX);
    eval 'sub DRM_IOCTL_GET_SAREA_CTX () { &DRM_IOWR(0x1d, \'struct drm_ctx_priv_map\');}' unless defined(&DRM_IOCTL_GET_SAREA_CTX);
    eval 'sub DRM_IOCTL_ADD_CTX () { &DRM_IOWR(0x20, \'struct drm_ctx\');}' unless defined(&DRM_IOCTL_ADD_CTX);
    eval 'sub DRM_IOCTL_RM_CTX () { &DRM_IOWR(0x21, \'struct drm_ctx\');}' unless defined(&DRM_IOCTL_RM_CTX);
    eval 'sub DRM_IOCTL_MOD_CTX () { &DRM_IOW( 0x22, \'struct drm_ctx\');}' unless defined(&DRM_IOCTL_MOD_CTX);
    eval 'sub DRM_IOCTL_GET_CTX () { &DRM_IOWR(0x23, \'struct drm_ctx\');}' unless defined(&DRM_IOCTL_GET_CTX);
    eval 'sub DRM_IOCTL_SWITCH_CTX () { &DRM_IOW( 0x24, \'struct drm_ctx\');}' unless defined(&DRM_IOCTL_SWITCH_CTX);
    eval 'sub DRM_IOCTL_NEW_CTX () { &DRM_IOW( 0x25, \'struct drm_ctx\');}' unless defined(&DRM_IOCTL_NEW_CTX);
    eval 'sub DRM_IOCTL_RES_CTX () { &DRM_IOWR(0x26, \'struct drm_ctx_res\');}' unless defined(&DRM_IOCTL_RES_CTX);
    eval 'sub DRM_IOCTL_ADD_DRAW () { &DRM_IOWR(0x27, \'struct drm_draw\');}' unless defined(&DRM_IOCTL_ADD_DRAW);
    eval 'sub DRM_IOCTL_RM_DRAW () { &DRM_IOWR(0x28, \'struct drm_draw\');}' unless defined(&DRM_IOCTL_RM_DRAW);
    eval 'sub DRM_IOCTL_DMA () { &DRM_IOWR(0x29, \'struct drm_dma\');}' unless defined(&DRM_IOCTL_DMA);
    eval 'sub DRM_IOCTL_LOCK () { &DRM_IOW( 0x2a, \'struct drm_lock\');}' unless defined(&DRM_IOCTL_LOCK);
    eval 'sub DRM_IOCTL_UNLOCK () { &DRM_IOW( 0x2b, \'struct drm_lock\');}' unless defined(&DRM_IOCTL_UNLOCK);
    eval 'sub DRM_IOCTL_FINISH () { &DRM_IOW( 0x2c, \'struct drm_lock\');}' unless defined(&DRM_IOCTL_FINISH);
    eval 'sub DRM_IOCTL_AGP_ACQUIRE () { &DRM_IO( 0x30);}' unless defined(&DRM_IOCTL_AGP_ACQUIRE);
    eval 'sub DRM_IOCTL_AGP_RELEASE () { &DRM_IO( 0x31);}' unless defined(&DRM_IOCTL_AGP_RELEASE);
    eval 'sub DRM_IOCTL_AGP_ENABLE () { &DRM_IOW( 0x32, \'struct drm_agp_mode\');}' unless defined(&DRM_IOCTL_AGP_ENABLE);
    eval 'sub DRM_IOCTL_AGP_INFO () { &DRM_IOR( 0x33, \'struct drm_agp_info\');}' unless defined(&DRM_IOCTL_AGP_INFO);
    eval 'sub DRM_IOCTL_AGP_ALLOC () { &DRM_IOWR(0x34, \'struct drm_agp_buffer\');}' unless defined(&DRM_IOCTL_AGP_ALLOC);
    eval 'sub DRM_IOCTL_AGP_FREE () { &DRM_IOW( 0x35, \'struct drm_agp_buffer\');}' unless defined(&DRM_IOCTL_AGP_FREE);
    eval 'sub DRM_IOCTL_AGP_BIND () { &DRM_IOW( 0x36, \'struct drm_agp_binding\');}' unless defined(&DRM_IOCTL_AGP_BIND);
    eval 'sub DRM_IOCTL_AGP_UNBIND () { &DRM_IOW( 0x37, \'struct drm_agp_binding\');}' unless defined(&DRM_IOCTL_AGP_UNBIND);
    eval 'sub DRM_IOCTL_SG_ALLOC () { &DRM_IOWR( 0x38, \'struct drm_scatter_gather\');}' unless defined(&DRM_IOCTL_SG_ALLOC);
    eval 'sub DRM_IOCTL_SG_FREE () { &DRM_IOW( 0x39, \'struct drm_scatter_gather\');}' unless defined(&DRM_IOCTL_SG_FREE);
    eval 'sub DRM_IOCTL_WAIT_VBLANK () { &DRM_IOWR(0x3a, \'union drm_wait_vblank\');}' unless defined(&DRM_IOCTL_WAIT_VBLANK);
    eval 'sub DRM_IOCTL_UPDATE_DRAW () { &DRM_IOW(0x3f, \'struct drm_update_draw\');}' unless defined(&DRM_IOCTL_UPDATE_DRAW);
    eval 'sub DRM_IOCTL_MM_INIT () { &DRM_IOWR(0xc0, \'struct drm_mm_init_arg\');}' unless defined(&DRM_IOCTL_MM_INIT);
    eval 'sub DRM_IOCTL_MM_TAKEDOWN () { &DRM_IOWR(0xc1, \'struct drm_mm_type_arg\');}' unless defined(&DRM_IOCTL_MM_TAKEDOWN);
    eval 'sub DRM_IOCTL_MM_LOCK () { &DRM_IOWR(0xc2, \'struct drm_mm_type_arg\');}' unless defined(&DRM_IOCTL_MM_LOCK);
    eval 'sub DRM_IOCTL_MM_UNLOCK () { &DRM_IOWR(0xc3, \'struct drm_mm_type_arg\');}' unless defined(&DRM_IOCTL_MM_UNLOCK);
    eval 'sub DRM_IOCTL_FENCE_CREATE () { &DRM_IOWR(0xc4, \'struct drm_fence_arg\');}' unless defined(&DRM_IOCTL_FENCE_CREATE);
    eval 'sub DRM_IOCTL_FENCE_REFERENCE () { &DRM_IOWR(0xc6, \'struct drm_fence_arg\');}' unless defined(&DRM_IOCTL_FENCE_REFERENCE);
    eval 'sub DRM_IOCTL_FENCE_UNREFERENCE () { &DRM_IOWR(0xc7, \'struct drm_fence_arg\');}' unless defined(&DRM_IOCTL_FENCE_UNREFERENCE);
    eval 'sub DRM_IOCTL_FENCE_SIGNALED () { &DRM_IOWR(0xc8, \'struct drm_fence_arg\');}' unless defined(&DRM_IOCTL_FENCE_SIGNALED);
    eval 'sub DRM_IOCTL_FENCE_FLUSH () { &DRM_IOWR(0xc9, \'struct drm_fence_arg\');}' unless defined(&DRM_IOCTL_FENCE_FLUSH);
    eval 'sub DRM_IOCTL_FENCE_WAIT () { &DRM_IOWR(0xca, \'struct drm_fence_arg\');}' unless defined(&DRM_IOCTL_FENCE_WAIT);
    eval 'sub DRM_IOCTL_FENCE_EMIT () { &DRM_IOWR(0xcb, \'struct drm_fence_arg\');}' unless defined(&DRM_IOCTL_FENCE_EMIT);
    eval 'sub DRM_IOCTL_FENCE_BUFFERS () { &DRM_IOWR(0xcc, \'struct drm_fence_arg\');}' unless defined(&DRM_IOCTL_FENCE_BUFFERS);
    eval 'sub DRM_IOCTL_BO_CREATE () { &DRM_IOWR(0xcd, \'struct drm_bo_create_arg\');}' unless defined(&DRM_IOCTL_BO_CREATE);
    eval 'sub DRM_IOCTL_BO_MAP () { &DRM_IOWR(0xcf, \'struct drm_bo_map_wait_idle_arg\');}' unless defined(&DRM_IOCTL_BO_MAP);
    eval 'sub DRM_IOCTL_BO_UNMAP () { &DRM_IOWR(0xd0, \'struct drm_bo_handle_arg\');}' unless defined(&DRM_IOCTL_BO_UNMAP);
    eval 'sub DRM_IOCTL_BO_REFERENCE () { &DRM_IOWR(0xd1, \'struct drm_bo_reference_info_arg\');}' unless defined(&DRM_IOCTL_BO_REFERENCE);
    eval 'sub DRM_IOCTL_BO_UNREFERENCE () { &DRM_IOWR(0xd2, \'struct drm_bo_handle_arg\');}' unless defined(&DRM_IOCTL_BO_UNREFERENCE);
    eval 'sub DRM_IOCTL_BO_SETSTATUS () { &DRM_IOWR(0xd3, \'struct drm_bo_map_wait_idle_arg\');}' unless defined(&DRM_IOCTL_BO_SETSTATUS);
    eval 'sub DRM_IOCTL_BO_INFO () { &DRM_IOWR(0xd4, \'struct drm_bo_reference_info_arg\');}' unless defined(&DRM_IOCTL_BO_INFO);
    eval 'sub DRM_IOCTL_BO_WAIT_IDLE () { &DRM_IOWR(0xd5, \'struct drm_bo_map_wait_idle_arg\');}' unless defined(&DRM_IOCTL_BO_WAIT_IDLE);
    eval 'sub DRM_IOCTL_BO_VERSION () { &DRM_IOR(0xd6, \'struct drm_bo_version_arg\');}' unless defined(&DRM_IOCTL_BO_VERSION);
    eval 'sub DRM_IOCTL_MM_INFO () { &DRM_IOWR(0xd7, \'struct drm_mm_info_arg\');}' unless defined(&DRM_IOCTL_MM_INFO);
    eval 'sub DRM_COMMAND_BASE () {0x40;}' unless defined(&DRM_COMMAND_BASE);
    eval 'sub DRM_COMMAND_END () {0xa0;}' unless defined(&DRM_COMMAND_END);
    if(!defined( &__KERNEL__) || defined( &__FreeBSD__) || defined( &__OpenBSD__) || defined( &__NetBSD__)) {
    }
}
1;
