/*
 * THIS FILE AUTOMATICALLY GENERATED.  DO NOT EDIT.
 *
 * generated from:
 *	OpenBSD: pcidevs,v 1.1396 2008/07/28 16:53:18 reyk Exp 
 */

/*	$NetBSD: pcidevs,v 1.30 1997/06/24 06:20:24 thorpej Exp $	*/

/*
 * Copyright (c) 1995, 1996 Christopher G. Demetriou
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Christopher G. Demetriou
 *	for the NetBSD Project.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* Descriptions of known vendors and devices. */
struct pci_known_vendor {
	pci_vendor_id_t vendor;
	const char *vendorname;
};

struct pci_known_product {
	pci_vendor_id_t vendor;
	pci_product_id_t product;
	const char *productname;
};

static const struct pci_known_product pci_known_products[] = {
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_FIREWIRE,
	    "Firewire",
	},
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_OZ6729,
	    "OZ6729 CardBus",
	},
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_OZ6730,
	    "OZ6730 CardBus",
	},
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_OZ6922,
	    "OZ6922 CardBus",
	},
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_OZ6832,
	    "OZ6832 CardBus",
	},
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_OZ6836,
	    "OZ6836/OZ6860 CardBus",
	},
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_OZ6872,
	    "OZ68[17]2 CardBus",
	},
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_OZ6933,
	    "OZ6933 CardBus",
	},
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_OZ6972,
	    "OZ69[17]2 CardBus",
	},
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_OZ7110,
	    "OZ711Mx Misc",
	},
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_OZ7113,
	    "OZ711EC1 SmartCardBus",
	},
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_OZ7114,
	    "OZ711M1 CardBus",
	},
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_OZ7120,
	    "OZ711MP1 SDHC",
	},
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_OZ7130,
	    "OZ711MP1 XDHC",
	},
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_OZ7134,
	    "OZ711MP1 CardBus",
	},
	{
	    PCI_VENDOR_O2MICRO, PCI_PRODUCT_O2MICRO_OZ7223,
	    "OZ711E0 CardBus",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C985,
	    "3c985",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C996,
	    "3c996",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CRDAG675,
	    "3CRDAG675 (Atheros AR5212)",
	},
	{
	    PCI_VENDOR_3COM2, PCI_PRODUCT_3COM2_3CRPAG175,
	    "3CRPAG175 (Atheros AR5212)",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C_MPCI_MODEM,
	    "V.90 Modem",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C940,
	    "3c940",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C339,
	    "3c339",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C359,
	    "3c359",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C450,
	    "3c450",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C555,
	    "3c555 100Base-TX",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C575,
	    "3c575",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CCFE575BT,
	    "3CCFE575BT",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CCFE575CT,
	    "3CCFE575CT",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C590,
	    "3c590 10Mbps",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C595TX,
	    "3c595 100Base-TX",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C595T4,
	    "3c595 100Base-T4",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C595MII,
	    "3c595 10Mbps-MII",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CRSHPW796,
	    "3CRSHPW796 802.11b",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CRWE154G72,
	    "3CRWE154G72 802.11g",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C556,
	    "3c556 100Base-TX",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C556B,
	    "3c556B 100Base-TX",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CCFEM656,
	    "3CCFEM656",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CCFEM656B,
	    "3CCFEM656B",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_MODEM56,
	    "56k Modem",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CCFEM656C,
	    "3CCFEM656C",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_GLOBALMODEM56,
	    "56k Global Modem",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CSOHO100TX,
	    "3cSOHO-TX",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CRWE777A,
	    "3crwe777a AirConnect",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C940B,
	    "3c940B",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C900TPO,
	    "3c900 10Base-T",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C900COMBO,
	    "3c900 10Mbps-Combo",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C900B,
	    "3c900B 10Mbps",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C900BCOMBO,
	    "3c900B 10Mbps-Combo",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C900BTPC,
	    "3c900B 10Mbps-TPC",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C900BFL,
	    "3c900B 10Mbps-FL",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C905TX,
	    "3c905 100Base-TX",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C905T4,
	    "3c905 100Base-T4",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C905BTX,
	    "3c905B 100Base-TX",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C905BT4,
	    "3c905B 100Base-T4",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C905BCOMBO,
	    "3c905B 10/100Mbps-Combo",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C905BFX,
	    "3c905B 100Base-FX",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C905CTX,
	    "3c905C 100Base-TX",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C9201,
	    "3c9201 100Base-TX",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C920BEMBW,
	    "3c920B-EMB-WNM",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CSHO100BTX,
	    "3cSOHO 100B-TX",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C980TX,
	    "3c980 100Base-TX",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C980CTX,
	    "3c980C 100Base-TX",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CR990,
	    "3cr990",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CR990TX,
	    "3cr990-TX",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CR990TX95,
	    "3cr990-TX-95",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CR990TX97,
	    "3cr990-TX-97",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C990BTXM,
	    "3c990b-TX-M",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CR990FX,
	    "3cr990-FX",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CR990SVR95,
	    "3cr990SVR95",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3CR990SVR97,
	    "3cr990SVR97",
	},
	{
	    PCI_VENDOR_3COM, PCI_PRODUCT_3COM_3C990BSVR,
	    "3c990BSVR",
	},
	{
	    PCI_VENDOR_3DFX, PCI_PRODUCT_3DFX_VOODOO,
	    "Voodoo",
	},
	{
	    PCI_VENDOR_3DFX, PCI_PRODUCT_3DFX_VOODOO2,
	    "Voodoo2",
	},
	{
	    PCI_VENDOR_3DFX, PCI_PRODUCT_3DFX_BANSHEE,
	    "Banshee",
	},
	{
	    PCI_VENDOR_3DFX, PCI_PRODUCT_3DFX_VOODOO3,
	    "Voodoo3",
	},
	{
	    PCI_VENDOR_3DFX, PCI_PRODUCT_3DFX_VOODOO5,
	    "Voodoo5",
	},
	{
	    PCI_VENDOR_3DLABS, PCI_PRODUCT_3DLABS_300SX,
	    "300SX",
	},
	{
	    PCI_VENDOR_3DLABS, PCI_PRODUCT_3DLABS_500TX,
	    "500TX",
	},
	{
	    PCI_VENDOR_3DLABS, PCI_PRODUCT_3DLABS_DELTA,
	    "Delta",
	},
	{
	    PCI_VENDOR_3DLABS, PCI_PRODUCT_3DLABS_PERMEDIA,
	    "Permedia",
	},
	{
	    PCI_VENDOR_3DLABS, PCI_PRODUCT_3DLABS_500MX,
	    "500MX",
	},
	{
	    PCI_VENDOR_3DLABS, PCI_PRODUCT_3DLABS_PERMEDIA2,
	    "Permedia 2",
	},
	{
	    PCI_VENDOR_3DLABS, PCI_PRODUCT_3DLABS_OXYGEN_GVX1_CPU,
	    "Oxygen GVX1",
	},
	{
	    PCI_VENDOR_3DLABS, PCI_PRODUCT_3DLABS_PERMEDIA3,
	    "Permedia 3",
	},
	{
	    PCI_VENDOR_3DLABS, PCI_PRODUCT_3DLABS_OXYGEN_GVX1,
	    "Oxygen GVX1",
	},
	{
	    PCI_VENDOR_3DLABS, PCI_PRODUCT_3DLABS_WILDCAT_6210,
	    "Wildcat III 6210",
	},
	{
	    PCI_VENDOR_3DLABS, PCI_PRODUCT_3DLABS_WILDCAT_5110,
	    "Wildcat 5110",
	},
	{
	    PCI_VENDOR_3DLABS, PCI_PRODUCT_3DLABS_WILDCAT_7210,
	    "Wildcat IV 7210",
	},
	{
	    PCI_VENDOR_3WARE, PCI_PRODUCT_3WARE_ESCALADE,
	    "5000/6000 series RAID",
	},
	{
	    PCI_VENDOR_3WARE, PCI_PRODUCT_3WARE_ESCALADE_ASIC,
	    "7000/8000 series RAID",
	},
	{
	    PCI_VENDOR_3WARE, PCI_PRODUCT_3WARE_9000,
	    "9000 series RAID",
	},
	{
	    PCI_VENDOR_3WARE, PCI_PRODUCT_3WARE_9500,
	    "9500 series RAID",
	},
	{
	    PCI_VENDOR_ABOCOM, PCI_PRODUCT_ABOCOM_FE2500,
	    "FE2500 10/100",
	},
	{
	    PCI_VENDOR_ABOCOM, PCI_PRODUCT_ABOCOM_PCM200,
	    "PCM200 10/100",
	},
	{
	    PCI_VENDOR_ABOCOM, PCI_PRODUCT_ABOCOM_FE2000VX,
	    "FE2000VX 10/100",
	},
	{
	    PCI_VENDOR_ABOCOM, PCI_PRODUCT_ABOCOM_FE2500MX,
	    "FE2500MX 10/100",
	},
	{
	    PCI_VENDOR_AIRONET, PCI_PRODUCT_AIRONET_PC4800_1,
	    "PC4800 Wireless",
	},
	{
	    PCI_VENDOR_AIRONET, PCI_PRODUCT_AIRONET_PCI352,
	    "PCI35x WLAN",
	},
	{
	    PCI_VENDOR_AIRONET, PCI_PRODUCT_AIRONET_PC4500,
	    "PC4500 Wireless",
	},
	{
	    PCI_VENDOR_AIRONET, PCI_PRODUCT_AIRONET_PC4800,
	    "PC4800 Wireless",
	},
	{
	    PCI_VENDOR_AIRONET, PCI_PRODUCT_AIRONET_MPI350,
	    "MPI-350 Wireless",
	},
	{
	    PCI_VENDOR_ACC, PCI_PRODUCT_ACC_2188,
	    "ACCM 2188 VL-PCI",
	},
	{
	    PCI_VENDOR_ACC, PCI_PRODUCT_ACC_2051_HB,
	    "2051 PCI",
	},
	{
	    PCI_VENDOR_ACC, PCI_PRODUCT_ACC_2051_ISA,
	    "2051 ISA",
	},
	{
	    PCI_VENDOR_ACARD, PCI_PRODUCT_ACARD_ATP850U,
	    "ATP850U/UF",
	},
	{
	    PCI_VENDOR_ACARD, PCI_PRODUCT_ACARD_ATP860,
	    "ATP860",
	},
	{
	    PCI_VENDOR_ACARD, PCI_PRODUCT_ACARD_ATP860A,
	    "ATP860-A",
	},
	{
	    PCI_VENDOR_ACARD, PCI_PRODUCT_ACARD_ATP865A,
	    "ATP865-A",
	},
	{
	    PCI_VENDOR_ACARD, PCI_PRODUCT_ACARD_ATP865R,
	    "ATP865-R",
	},
	{
	    PCI_VENDOR_ACARD, PCI_PRODUCT_ACARD_AEC6710,
	    "AEC6710",
	},
	{
	    PCI_VENDOR_ACARD, PCI_PRODUCT_ACARD_AEC6712UW,
	    "AEC6712UW",
	},
	{
	    PCI_VENDOR_ACARD, PCI_PRODUCT_ACARD_AEC6712U,
	    "AEC6712U",
	},
	{
	    PCI_VENDOR_ACARD, PCI_PRODUCT_ACARD_AEC6712S,
	    "AEC6712S",
	},
	{
	    PCI_VENDOR_ACARD, PCI_PRODUCT_ACARD_AEC6710D,
	    "AEC6710D",
	},
	{
	    PCI_VENDOR_ACARD, PCI_PRODUCT_ACARD_AEC6715UW,
	    "AEC6715UW",
	},
	{
	    PCI_VENDOR_ACCTON, PCI_PRODUCT_ACCTON_5030,
	    "MPX 5030/5038",
	},
	{
	    PCI_VENDOR_ACCTON, PCI_PRODUCT_ACCTON_EN2242,
	    "EN2242",
	},
	{
	    PCI_VENDOR_ACCTON, PCI_PRODUCT_ACCTON_EN1217,
	    "EN1217",
	},
	{
	    PCI_VENDOR_ADDTRON, PCI_PRODUCT_ADDTRON_RHINEII,
	    "RhineII",
	},
	{
	    PCI_VENDOR_ADDTRON, PCI_PRODUCT_ADDTRON_8139,
	    "rtl8139",
	},
	{
	    PCI_VENDOR_ADDTRON, PCI_PRODUCT_ADDTRON_AWA100,
	    "AWA-100",
	},
	{
	    PCI_VENDOR_ACER, PCI_PRODUCT_ACER_M1435,
	    "M1435 VL-PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1445,
	    "M1445 VL-PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1449,
	    "M1449 ISA",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1451,
	    "M1451 PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1461,
	    "M1461 PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1489,
	    "M1489 PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1511,
	    "M1511 PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1513,
	    "M1513 ISA",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1521,
	    "M1523 PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1523,
	    "M1523 ISA",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1531,
	    "M1531 PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1533,
	    "M1533 ISA",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1535,
	    "M1535 PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1541,
	    "M1541 PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1543,
	    "M1543 ISA",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1563,
	    "M1563 ISA",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1573,
	    "M1573 ISA",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1575,
	    "M1575 ISA",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1621,
	    "M1621 PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1631,
	    "M1631 PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1644,
	    "M1644 PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1647,
	    "M1647 PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1689,
	    "M1689 PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M1695,
	    "M1695 PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M3309,
	    "M3309 MPEG",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M4803,
	    "M4803",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5219,
	    "M5219 UDMA IDE",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5229,
	    "M5229 UDMA IDE",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5237,
	    "M5237 USB",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5239,
	    "M5239 USB2",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5243,
	    "M5243 AGP/PCI-PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5246,
	    "M5246 AGP",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5247,
	    "M5247 AGP/PCI-PC",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5249,
	    "M5249 PCI-PCI",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M524B,
	    "M524B PCIE",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M524C,
	    "M524C PCIE",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M524D,
	    "M524D PCIE",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5261,
	    "M5261 LAN",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5263,
	    "M5263 LAN",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5281,
	    "M5281 SATA",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5287,
	    "M5287 SATA",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5288,
	    "M5288 SATA",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5289,
	    "M5289 SATA",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5451,
	    "M5451 Audio",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5455,
	    "M5455 Audio",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5457,
	    "M5457 Modem",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M5461,
	    "M5461 HD Audio",
	},
	{
	    PCI_VENDOR_ALI, PCI_PRODUCT_ALI_M7101,
	    "M7101 Power",
	},
	{
	    PCI_VENDOR_ADMTEK, PCI_PRODUCT_ADMTEK_AL981,
	    "AL981",
	},
	{
	    PCI_VENDOR_ADMTEK, PCI_PRODUCT_ADMTEK_AN983,
	    "AN983",
	},
	{
	    PCI_VENDOR_ADMTEK, PCI_PRODUCT_ADMTEK_AN985,
	    "AN985",
	},
	{
	    PCI_VENDOR_ADMTEK, PCI_PRODUCT_ADMTEK_ADM8211,
	    "ADM8211 WLAN",
	},
	{
	    PCI_VENDOR_ADMTEK, PCI_PRODUCT_ADMTEK_ADM9511,
	    "ADM9511",
	},
	{
	    PCI_VENDOR_ADMTEK, PCI_PRODUCT_ADMTEK_ADM9513,
	    "ADM9513",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_AIC7810,
	    "AIC-7810",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_2940AU_CN,
	    "AHA-2940AU/CN",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_2930CU,
	    "AHA-2930CU",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_AIC7850,
	    "AIC-7850",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_AIC7855,
	    "AIC-7855",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_AIC5900,
	    "AIC-5900 ATM",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_AIC5905,
	    "AIC-5905 ATM",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_1480,
	    "APA-1480",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_AIC7860,
	    "AIC-7860",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_2940AU,
	    "AHA-2940AU",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_AIC7870,
	    "AIC-7870",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_2940,
	    "AHA-2940",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_3940,
	    "AHA-3940",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_3985,
	    "AHA-3985",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_2944,
	    "AHA-2944",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_AIC7815,
	    "AIC-7815",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_AIC7880,
	    "AIC-7880",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_2940U,
	    "AHA-2940U",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_3940U,
	    "AHA-3940U",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_398XU,
	    "AHA-398XU",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_2944U,
	    "AHA-2944U",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_2940UWPro,
	    "AHA-2940UWPro",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_AIC6915,
	    "AIC-6915",
	},
	{
	    PCI_VENDOR_ADP, PCI_PRODUCT_ADP_7895,
	    "AIC-7895",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_2940U2,
	    "AHA-2940U2 U2",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_2930U2,
	    "AHA-2930U2 U2",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AAA131U2,
	    "AAA-131U2 U2",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AIC7890,
	    "AIC-7890/1 U2",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AIC7892,
	    "AIC-7892 U160",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_29160,
	    "AHA-29160 U160",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_19160B,
	    "AHA-19160B U160",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_3950U2B,
	    "AHA-3950U2B U2",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_3950U2D,
	    "AHA-3950U2D U2",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AIC7896,
	    "AIC-7896/7 U2",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_3960D,
	    "AHA-3960D U160",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AIC7899B,
	    "AIC-7899B",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AIC7899D,
	    "AIC-7899D",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AIC7899F,
	    "AIC-7899F",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AIC7899,
	    "AIC-7899 U160",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_SERVERAID,
	    "ServeRAID",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AAC2622,
	    "AAC-2622",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_ASR2200S,
	    "ASR-2200S",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_ASR2120S,
	    "ASR-2120S",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AAC364,
	    "AAC-364",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AAC3642,
	    "AAC-3642",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_PERC_2QC,
	    "Dell PERC 2/QC",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AIC7901,
	    "AIC-7901 U320",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AHA29320A,
	    "AHA-29320A U320",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AHA29320LP,
	    "AHA-29320LP U320",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AIC7901A,
	    "AIC-7901A U320",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AHA29320,
	    "AHA-29320 U320",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AHA29320B,
	    "AHA-29320B U320",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AHA29320LP2,
	    "AHA-29320LP U320",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AIC7902,
	    "AIC-7902 U320",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AIC7902_B,
	    "AIC-7902B U320",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AHA39320,
	    "AHA-39320 U320",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AHA39320B,
	    "AHA-39320B U320",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AHA39320A,
	    "AHA-39320A U320",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AHA39320D,
	    "AHA-39320D U320",
	},
	{
	    PCI_VENDOR_ADP2, PCI_PRODUCT_ADP2_AHA39320DB,
	    "AHA-39320DB U320",
	},
	{
	    PCI_VENDOR_ADVSYS, PCI_PRODUCT_ADVSYS_1200A,
	    "1200A",
	},
	{
	    PCI_VENDOR_ADVSYS, PCI_PRODUCT_ADVSYS_1200B,
	    "1200B",
	},
	{
	    PCI_VENDOR_ADVSYS, PCI_PRODUCT_ADVSYS_ULTRA,
	    "ABP-930/40UA",
	},
	{
	    PCI_VENDOR_ADVSYS, PCI_PRODUCT_ADVSYS_WIDE,
	    "ABP-940UW",
	},
	{
	    PCI_VENDOR_ADVSYS, PCI_PRODUCT_ADVSYS_U2W,
	    "ASP-3940U2W",
	},
	{
	    PCI_VENDOR_ADVSYS, PCI_PRODUCT_ADVSYS_U3W,
	    "ASP-3940U3W",
	},
	{
	    PCI_VENDOR_ATML, PCI_PRODUCT_ATML_WAIKATO,
	    "Waikato Dag3.2",
	},
	{
	    PCI_VENDOR_ATML, PCI_PRODUCT_ATML_DAG35,
	    "Endace Dag3.5",
	},
	{
	    PCI_VENDOR_ATML, PCI_PRODUCT_ATML_DAG422GE,
	    "Endace Dag4.22GE",
	},
	{
	    PCI_VENDOR_ATML, PCI_PRODUCT_ATML_DAG423,
	    "Endace Dag4.23",
	},
	{
	    PCI_VENDOR_AGEIA, PCI_PRODUCT_AGEIA_PHYSX,
	    "PhysX",
	},
	{
	    PCI_VENDOR_ALLIANCE, PCI_PRODUCT_ALLIANCE_AT22,
	    "AT22",
	},
	{
	    PCI_VENDOR_ALLIANCE, PCI_PRODUCT_ALLIANCE_AT24,
	    "AT24",
	},
	{
	    PCI_VENDOR_ALTEON, PCI_PRODUCT_ALTEON_ACENIC,
	    "Acenic",
	},
	{
	    PCI_VENDOR_ALTEON, PCI_PRODUCT_ALTEON_ACENICT,
	    "Acenic Copper",
	},
	{
	    PCI_VENDOR_ALTEON, PCI_PRODUCT_ALTEON_BCM5700,
	    "BCM5700",
	},
	{
	    PCI_VENDOR_ALTEON, PCI_PRODUCT_ALTEON_BCM5701,
	    "BCM5701",
	},
	{
	    PCI_VENDOR_ALTERA, PCI_PRODUCT_ALTERA_EBUS,
	    "EBus",
	},
	{
	    PCI_VENDOR_ALTIMA, PCI_PRODUCT_ALTIMA_AC1000,
	    "AC1000",
	},
	{
	    PCI_VENDOR_ALTIMA, PCI_PRODUCT_ALTIMA_AC1001,
	    "AC1001",
	},
	{
	    PCI_VENDOR_ALTIMA, PCI_PRODUCT_ALTIMA_AC9100,
	    "AC9100",
	},
	{
	    PCI_VENDOR_ALTIMA, PCI_PRODUCT_ALTIMA_AC1003,
	    "AC1003",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_AMD64_0F_HT,
	    "AMD64 0Fh HyperTransport",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_AMD64_0F_ADDR,
	    "AMD64 0Fh Address Map",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_AMD64_0F_DRAM,
	    "AMD64 0Fh DRAM Cfg",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_AMD64_0F_MISC,
	    "AMD64 0Fh Misc Cfg",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_AMD64_10_HT,
	    "AMD64 10h HyperTransport",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_AMD64_10_ADDR,
	    "AMD64 10h Address Map",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_AMD64_10_DRAM,
	    "AMD64 10h DRAM Cfg",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_AMD64_10_MISC,
	    "AMD64 10h Misc Cfg",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_AMD64_10_LINK,
	    "AMD64 10h Link Cfg",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_AMD64_11_HT,
	    "AMD64 11h HyperTransport",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_AMD64_11_ADDR,
	    "AMD64 11h Address Map",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_AMD64_11_DRAM,
	    "AMD64 11h DRAM Cfg",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_AMD64_11_MISC,
	    "AMD64 11h Misc Cfg",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_AMD64_11_LINK,
	    "AMD64 11h Link Cfg",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PCNET_PCI,
	    "79c970 PCnet-PCI",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PCHOME_PCI,
	    "79c978 PChome-PCI",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PCSCSI_PCI,
	    "53c974 PCscsi-PCI",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PCNETS_PCI,
	    "79C974 PCnet-PCI",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_GEODE_LX_PCHB,
	    "Geode LX",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_GEODE_LX_VIDEO,
	    "Geode LX Video",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_GEODE_LX_CRYPTO,
	    "Geode LX Crypto",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_CS5536_PCIB,
	    "CS5536 ISA",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_CS5536_AUDIO,
	    "CS5536 Audio",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_CS5536_OHCI,
	    "CS5536 USB",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_CS5536_EHCI,
	    "CS5536 USB",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_CS5536_IDE,
	    "CS5536 IDE",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_ELANSC520,
	    "ElanSC520 PCI",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_SC751_SC,
	    "751 System",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_SC751_PPB,
	    "751 PCI-PCI",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_762_PCHB,
	    "762 PCI",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_762_PPB,
	    "762 PCI-PCI",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_761_PCHB,
	    "761 PCI",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_761_PPB,
	    "761 PCI-PCI",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_755_ISA,
	    "755 ISA",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_755_IDE,
	    "755 IDE",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_755_PMC,
	    "755 Power",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_755_USB,
	    "755 USB",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PBC756_ISA,
	    "756 ISA",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PBC756_IDE,
	    "756 IDE",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PBC756_PMC,
	    "756 Power",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PBC756_USB,
	    "756 USB Host",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_766_ISA,
	    "766 ISA",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_766_IDE,
	    "766 IDE",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_766_USB,
	    "766 USB",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_766_PMC,
	    "766 Power",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_766_USB_HCI,
	    "766 USB OpenHCI",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PBC768_ISA,
	    "768 ISA",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PBC768_IDE,
	    "768 IDE",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PBC768_PMC,
	    "768 Power",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PBC768_ACA,
	    "768 AC97",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PBC768_MD,
	    "768 Modem",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PBC768_PPB,
	    "768 PCI-PCI",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PBC768_USB,
	    "768 USB",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_8131_PCIX,
	    "8131 PCIX",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_8131_PCIX_IOAPIC,
	    "8131 PCIX IOAPIC",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_8151_SC,
	    "8151 Sys Control",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_8151_AGP,
	    "8151 AGP",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_8132_PCIX,
	    "8132 PCIX",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_8132_PCIX_IOAPIC,
	    "8132 PCIX IOAPIC",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_8111_PPB,
	    "8111 PCI-PCI",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_8111_ETHER,
	    "8111 Ether",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_8111_USB,
	    "8111 USB",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_PBC8111_LPC,
	    "8111 LPC",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_8111_IDE,
	    "8111 IDE",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_8111_SMB,
	    "8111 SMBus",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_8111_PMC,
	    "8111 Power",
	},
	{
	    PCI_VENDOR_AMD, PCI_PRODUCT_AMD_8111_ACA,
	    "8111 AC97",
	},
	{
	    PCI_VENDOR_AMI, PCI_PRODUCT_AMI_MEGARAID,
	    "MegaRAID",
	},
	{
	    PCI_VENDOR_AMI, PCI_PRODUCT_AMI_MEGARAID428,
	    "MegaRAID Series 428",
	},
	{
	    PCI_VENDOR_AMI, PCI_PRODUCT_AMI_MEGARAID434,
	    "MegaRAID Series 434",
	},
	{
	    PCI_VENDOR_AD, PCI_PRODUCT_AD_SP21535,
	    "ADSP 21535 DSP",
	},
	{
	    PCI_VENDOR_AD, PCI_PRODUCT_AD_1889,
	    "AD1889 Audio",
	},
	{
	    PCI_VENDOR_AD, PCI_PRODUCT_AD_SP2141,
	    "SafeNet ADSP 2141",
	},
	{
	    PCI_VENDOR_ANTARES, PCI_PRODUCT_ANTARES_TC9021,
	    "TC9021",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_BANDIT,
	    "Bandit",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_GC,
	    "GC",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_OHARE,
	    "OHare",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_HEATHROW,
	    "Heathrow",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_PADDINGTON,
	    "Paddington",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_UNINORTHETH,
	    "Uni-N Eth",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_UNINORTH,
	    "Uni-N",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_UNINORTHETH_FW,
	    "Uni-N Eth Firewire",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_USB,
	    "USB",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_UNINORTH_AGP,
	    "Uni-N AGP",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_UNINORTHGMAC,
	    "Uni-N GMAC",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_KEYLARGO,
	    "Keylargo",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_PANGEA_GMAC,
	    "Pangea GMAC",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_PANGEA_MACIO,
	    "Pangea Macio",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_PANGEA_OHCI,
	    "Pangea USB",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_PANGEA_AGP,
	    "Pangea AGP",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_PANGEA,
	    "Pangea",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_PANGEA_PCI,
	    "Pangea PCI",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_UNINORTH2_AGP,
	    "Uni-N2 AGP",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_UNINORTH2,
	    "Uni-N2 Host",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_UNINORTH2ETH,
	    "Uni-N2 Host",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_PANGEA_FW,
	    "Pangea FireWire",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_UNINORTH_FW,
	    "UniNorth Firewire",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_UNINORTH2GMAC,
	    "Uni-N2 GMAC",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_UNINORTH_ATA,
	    "Uni-N ATA",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_UNINORTH_AGP3,
	    "UniNorth AGP",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_UNINORTH5,
	    "UniNorth PCI",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_UNINORTH6,
	    "UniNorth PCI",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_INTREPID_ATA,
	    "Intrepid ATA",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_INTREPID,
	    "Intrepid",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_INTREPID_OHCI,
	    "Intrepid USB",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_K2_USB,
	    "K2 USB",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_K2_MACIO,
	    "K2 Macio",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_K2_FW,
	    "K2 Firewire",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_K2_ATA,
	    "K2 ATA",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_U3_PPB1,
	    "U3 PCI-PCI",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_U3_PPB2,
	    "U3 PCI-PCI",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_U3_PPB3,
	    "U3 PCI-PCI",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_U3_PPB4,
	    "U3 PCI-PCI",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_U3_PPB5,
	    "U3 PCI-PCI",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_U3_AGP,
	    "U3 AGP",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_K2_GMAC,
	    "K2 GMAC",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_SHASTA,
	    "Shasta",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_SHASTA_ATA,
	    "Shasta ATA",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_SHASTA_GMAC,
	    "Shasta GMAC",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_SHASTA_FW,
	    "Shasta Firewire",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_SHASTA_PCI1,
	    "Shasta PCI",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_SHASTA_PCI2,
	    "Shasta PCI",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_SHASTA_PCI3,
	    "Shasta PCI",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_SHASTA_HT,
	    "Shasta HyperTransport",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_K2,
	    "K2",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_U3L_AGP,
	    "U3L AGP",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_K2_AGP,
	    "K2 AGP",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_INTREPID2_AGP,
	    "Intrepid 2 AGP",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_INTREPID2_PCI1,
	    "Intrepid 2 PCI",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_INTREPID2_PCI2,
	    "Intrepid 2 PCI",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_INTREPID2_ATA,
	    "Intrepid 2 ATA",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_INTREPID2_FW,
	    "Intrepid 2 FireWire",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_INTREPID2_GMAC,
	    "Intrepid 2 GMAC",
	},
	{
	    PCI_VENDOR_APPLE, PCI_PRODUCT_APPLE_BCM5701,
	    "BCM5701",
	},
	{
	    PCI_VENDOR_ARALION, PCI_PRODUCT_ARALION_ARS106S,
	    "ARS106S",
	},
	{
	    PCI_VENDOR_ARALION, PCI_PRODUCT_ARALION_ARS0303D,
	    "ARS0303D",
	},
	{
	    PCI_VENDOR_ARC, PCI_PRODUCT_ARC_USB,
	    "USB",
	},
	{
	    PCI_VENDOR_ARC, PCI_PRODUCT_ARC_1000PV,
	    "1000PV",
	},
	{
	    PCI_VENDOR_ARC, PCI_PRODUCT_ARC_2000PV,
	    "2000PV",
	},
	{
	    PCI_VENDOR_ARC, PCI_PRODUCT_ARC_2000MT,
	    "2000MT",
	},
	{
	    PCI_VENDOR_ARC, PCI_PRODUCT_ARC_2000MI,
	    "2000MI",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1110,
	    "ARC-1110",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1120,
	    "ARC-1120",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1130,
	    "ARC-1130",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1160,
	    "ARC-1160",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1170,
	    "ARC-1170",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1200,
	    "ARC-1200",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1200_B,
	    "ARC-1200 rev B",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1202,
	    "ARC-1202",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1210,
	    "ARC-1210",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1220,
	    "ARC-1220",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1230,
	    "ARC-1230",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1260,
	    "ARC-1260",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1270,
	    "ARC-1270",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1280,
	    "ARC-1280",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1380,
	    "ARC-1380",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1381,
	    "ARC-1381",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1680,
	    "ARC-1680",
	},
	{
	    PCI_VENDOR_ARECA, PCI_PRODUCT_ARECA_ARC1681,
	    "ARC-1681",
	},
	{
	    PCI_VENDOR_ASIX, PCI_PRODUCT_ASIX_AX88140A,
	    "AX88140A/88141",
	},
	{
	    PCI_VENDOR_ASUSTEK, PCI_PRODUCT_ASUSTEK_HFCPCI,
	    "ISDN",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_M241P,
	    "Radeon Mobility X600",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_FIREGL_V3200,
	    "FireGL V3200",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X600_RV380,
	    "Radeon X600 (RV380)",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X600_RV380_S,
	    "Radeon X600 (RV380) Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_9500PRO,
	    "Radeon 9500 Pro",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_9600PRO,
	    "Radeon 9600 Pro",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_9600LE,
	    "Radeon 9600 LE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_9600XT,
	    "Radeon 9600 XT",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_9550,
	    "Radeon 9550",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH32,
	    "Mach32",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_9500PRO_S,
	    "Radeon 9500 Pro Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_9600PRO_S,
	    "Radeon 9600 Pro Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_9600LE_S,
	    "Radeon 9600 LE Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_9600XT_S,
	    "Radeon 9600 XT Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_9550_S,
	    "Radeon 9550 Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_R200_BB,
	    "Radeon 8500 BB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_IGP320M,
	    "Radeon IGP 320M",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MOBILITY_M6,
	    "Mobility M6",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_AUDIO_200,
	    "IXP200 AC97",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_PCI_200,
	    "IXP200 PCI",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_EHCI_200,
	    "IXP200 USB2",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_200_1,
	    "IXP200 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_200_2,
	    "IXP200 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_IDE_200,
	    "IXP200 IDE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_ISA_200,
	    "IXP200 ISA",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_MODEM_200,
	    "IXP200 Modem",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_SMB_200,
	    "IXP200 SMBus",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_CT,
	    "Mach64 CT",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_CX,
	    "Mach64 CX",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_AUDIO_300,
	    "IXP300 AC97",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_PCI_300,
	    "IXP300 PCI",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_SMB_300,
	    "IXP300 SMBus",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_EHCI_300,
	    "IXP300 USB2",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_300_1,
	    "IXP300 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_300_2,
	    "IXP300 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_IDE_300,
	    "IXP300 IDE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_ISA_300,
	    "IXP300 ISA",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_MODEM_300,
	    "IXP300 Modem",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_SATA_300,
	    "IXP300 SATA",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_AUDIO_400,
	    "IXP400 AC97",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_PCI_400,
	    "IXP400 PCI",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_SMB_400,
	    "IXP400 SMBus",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_EHCI_400,
	    "IXP400 USB2",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_400_1,
	    "IXP400 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_400_2,
	    "IXP400 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_IDE_400,
	    "IXP400 IDE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_ISA_400,
	    "IXP400 ISA",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_MODEM_400,
	    "IXP400 Modem",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_SATA_400_1,
	    "IXP400 SATA",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_SATA_400_2,
	    "IXP400 SATA",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_HDA_450,
	    "IXP450 HD Audio",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_SATA_600,
	    "IXP600 SATA",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_AUDIO_600,
	    "IXP600 AC97",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_HDA_X00,
	    "IXPx00 HD Audio",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_PCI_600,
	    "IXP600 PCI",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_SMB_X00,
	    "IXPx00 SMBus",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_EHCI_600,
	    "IXP600 USB2",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_600_1,
	    "IXP600 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_600_2,
	    "IXP600 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_600_3,
	    "IXP600 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_600_4,
	    "IXP600 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_600_5,
	    "IXP600 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_IDE_600,
	    "IXP600 IDE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_ISA_600,
	    "IXP600 ISA",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_MODEM_600,
	    "IXP600 Modem",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_SATA_X00_1,
	    "IXPx00 SATA",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_SATA_X00_2,
	    "IXPx00 SATA",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_SATA_X00_3,
	    "IXPx00 SATA",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_SATA_X00_4,
	    "IXPx00 SATA",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_SATA_X00_5,
	    "IXPx00 SATA",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_SATA_X00_6,
	    "IXPx00 SATA",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_EHCI_700,
	    "IXP700 USB2",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_700_1,
	    "IXP700 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_700_2,
	    "IXP700 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_700_3,
	    "IXP700 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_700_4,
	    "IXP700 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_OHCI_700_5,
	    "IXP700 USB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_IDE_700,
	    "IXP700 IDE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_IXP_ISA_700,
	    "IXP700 ISA",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_ET,
	    "Mach64 ET",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGEPRO,
	    "Rage Pro",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GD,
	    "Mach64 GD",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GI,
	    "Mach64 GI",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GL,
	    "Mach64 GL",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GM,
	    "Mach64 GM",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GN,
	    "Mach64 GN",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GO,
	    "Mach64 GO",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GP,
	    "Mach64 GP",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GQ,
	    "Mach64 GQ",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGEXL,
	    "Rage XL",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GS,
	    "Mach64 GS",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GT,
	    "Mach64 GT",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GU,
	    "Mach64 GU",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GV,
	    "Mach64 GV",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GW,
	    "Mach64 GW",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GX,
	    "Mach64 GX",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GY,
	    "Mach64 GY",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_GZ,
	    "Mach64 GZ",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RV250,
	    "Radeon 9000",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RV250_S,
	    "Radeon 9000 Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X800PRO,
	    "Radeon X800 Pro",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X800PRO_S,
	    "Radeon X800 Pro Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_LB,
	    "Mach64 LB",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_LD,
	    "Mach64 LD",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_LE,
	    "Rage128 LE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MOBILITY_M3,
	    "Mobility M3",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_LG,
	    "Mach64 LG",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_LI,
	    "Mach64 LI",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MOBILITY_1,
	    "Mobility 1",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_LN,
	    "Mach64 LN",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_LP,
	    "Mach64 LP",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_LQ,
	    "Mach64 LQ",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE_PM,
	    "Rage P/M",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64LS,
	    "Mach64 LS",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_M7LW,
	    "Radeon Mobility M7 LW",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_M6LY,
	    "Radeon Mobility M6 LY",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_M6LZ,
	    "Radeon Mobility M6 LZ",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_M9Lf,
	    "Radeon Mobility M9 Lf",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_MF,
	    "Rage 128 Mobility MF",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_ML,
	    "Rage 128 Mobility ML",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_R300,
	    "Radeon 9500/9700",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON9500_PRO,
	    "Radeon 9500 Pro",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_9800XT,
	    "Radeon 9800 XT",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_R350,
	    "Radeon 9800 Pro",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RV350,
	    "Radeon Mobility M10 NP",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RV350_WS,
	    "Radeon Mobility M10 NT",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_R300_S,
	    "Radeon 9500/9700 Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_R350_S,
	    "Radeon 9800 Pro Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_PD,
	    "Rage 128 Pro PD",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE_FURY,
	    "Rage Fury",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_PK,
	    "Rage 128 PK",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_AIW,
	    "AIW Radeon",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_QE,
	    "Radeon QE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_QF,
	    "Radeon QF",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_QG,
	    "Radeon QG",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_R200_QL,
	    "Radeon 8500 QL",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_R200_QM,
	    "Radeon 9100 QM",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_R200_QN,
	    "Radeon 8500 QN",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_R200_QO,
	    "Radeon 8500 QO",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RV200_QW,
	    "Radeon 7500 QW",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_QY,
	    "Radeon VE QY",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_QZ,
	    "Radeon VE QZ",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_ES1000,
	    "ES1000",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_R200_Ql,
	    "Radeon 8500 Ql",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_GL,
	    "Rage 128 GL",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE_MAGNUM,
	    "Rage Magnum",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_RG,
	    "Rage 128 RG",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_RK,
	    "Rage 128 RK",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_VR,
	    "Rage 128 VR",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_SH,
	    "Rage 128 SH",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_SK,
	    "Rage 128 SK",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_SL,
	    "Rage 128 SL",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_SM,
	    "Rage 128 SM",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128,
	    "Rage 128",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_TF,
	    "Rage 128 Pro TF",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_TL,
	    "Rage 128 Pro TL",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RAGE128_TR,
	    "Rage 128 Pro TR",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_M300_M22,
	    "Radeon Mobility M300 M22",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X800_RV430,
	    "Radeon X800 (RV430)",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X800_RV430_S,
	    "Radeon X800 (RV430) Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X700_M26_1,
	    "Radeon Mobility X700 M26",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X700_M26_2,
	    "Radeon Mobility X700 M26",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_VT,
	    "Mach64 VT",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_VU,
	    "Mach64 VU",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_MACH64_VV,
	    "Mach64 VV",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS300_100_HB,
	    "RS300_100 Host",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS300_133_HB,
	    "RS300_133 Host",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS300_166_HB,
	    "RS300_166 Host",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_IGP9100_HB,
	    "Radeon IGP 9100 Host",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_IGP9100,
	    "Radeon Mobility IGP 9100",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_IGP9100_AGP,
	    "Radeon IGP 9100 AGP",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RV280_PRO_S,
	    "Radeon 9200 PRO Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RV280_S,
	    "Radeon 9200 Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS480_HB,
	    "RS480 Host",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RX480_HB,
	    "RX480 Host",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RD580_HB,
	    "RD580 Host",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RS480,
	    "Radeon XPRESS 200",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RS480_B,
	    "Radeon XPRESS 200M",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RX780_HB,
	    "RX780 Host",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RD780_HT_GFX,
	    "RD780 HT-PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RV280_PRO,
	    "Radeon 9200 PRO",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RV280,
	    "Radeon 9200",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RV280_B,
	    "Radeon 9200",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RV280_SE_S,
	    "Radeon 9200 SE Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RS482,
	    "Radeon XPRESS 200",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RS482_B,
	    "Radeon XPRESS 200M",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RD790_PCIE_1,
	    "RD790 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RD790_PCIE_3,
	    "RD790 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RD790_PCIE_2,
	    "RD790 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RX200_HB,
	    "Radeon XPRESS 200",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RX480_PCIE,
	    "RX480 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS480_PCIE_2,
	    "RS480 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS480_PCIE_3,
	    "RS480 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RX480_PCIE_2,
	    "RX480 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RX480_PCIE_3,
	    "RX480 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS480_PCIE_1,
	    "RS480 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RS400,
	    "Radeon XPRESS 200",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RS400_B,
	    "Radeon XPRESS 200M",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RC410,
	    "Radeon XPRESS 200",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RC410_B,
	    "Radeon XPRESS 200M",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X300,
	    "Radeon X300",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X600_RV370,
	    "Radeon X600 (RV370)",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X550,
	    "Radeon X550",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_FIREGL_RV370,
	    "FireGL V3100",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X300_S,
	    "Radeon X300 Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X600_RV370_S,
	    "Radeon X600 (RV370) Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X550_S,
	    "Radeon X550 Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_FIREGL_RV370_S,
	    "FireGL V3100 Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RV280_M,
	    "Radeon Mobility 9200",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_M9PLUS,
	    "Radeon Mobility 9200 (M9+)",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RV280_SE,
	    "Radeon 9200 SE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X800_GTO,
	    "Radeon X800 GTO",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X800_GTO_S,
	    "Radeon X800 GTO Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X700_PCIE,
	    "Radeon X700 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X700_PCIE_S,
	    "Radeon X700 PCIE Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X700_SE,
	    "Radeon X700 SE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X700_SE_S,
	    "Radeon X700 SE Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS100_PCI,
	    "RS100 PCI",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS200_PCI,
	    "RS200 PCI",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X1800,
	    "Radeon X1800",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X1600,
	    "Radeon X1600",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X1400,
	    "Radeon Mobility X1400",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X1300_M52,
	    "Radeon Mobility X1300 M52-64",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X1600_S,
	    "Radeon X1600 Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X1300PRO,
	    "Radeon X1300 Pro",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X1300,
	    "Radeon X1300",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X1300PRO_S,
	    "Radeon X1300 Pro Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X1300_S,
	    "Radeon X1300 Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X1600_PRO,
	    "Radeon X1600 PRO",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X1600_M,
	    "Radeon Mobility X1600",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RV530_M56,
	    "Mobility FireGL V5250",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X1600_PRO2,
	    "Radeon X1600 PRO (Secondary)",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X1950_PRO,
	    "Radeon X1950 Pro",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RX1650_XT,
	    "Radeon RX1650 XT",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X1950_PRO_S,
	    "Radeon X1950 Pro Sec",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_RX1650_XT2,
	    "Radeon RX1650 XT (Secondary)",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS690_HB,
	    "RS690 Host",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS740_HB,
	    "RS740 Host",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS690_PCIE_1,
	    "RS690 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS690M_PCIE_1,
	    "RS690M PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS690_PCIE_2,
	    "RS690 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS690_PCIE_4,
	    "RS690 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS690_PCIE_5,
	    "RS690 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS690_HDA,
	    "RS690 HD Audio",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_X1250,
	    "Radeon X1250",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_2100,
	    "Radeon 2100",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_HD2400_XT,
	    "Radeon HD 2400 XT",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_HD2400_PRO,
	    "Radeon HD 2400 Pro",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_HD2400_M72,
	    "Mobility Radeon HD 2400",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_HD3870,
	    "Radeon HD 3870",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_HD2600,
	    "Radeon HD 2600",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_HD3450,
	    "Radeon HD 3450",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS780_HB,
	    "RS780 Host",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS780_PCIE_1,
	    "RS780 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS780_PCIE_2,
	    "RS780 PCIE",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS780_HDA,
	    "RS780 HD Audio",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_HD3200,
	    "Radeon HD 3200",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_HD2600_HDA,
	    "Radeon HD 2600 HD Audio",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS690M_HDA,
	    "RS690M HD Audio",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RADEON_HD34xx_HDA,
	    "Radeon HD 34xx HD Audio",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS100_AGP,
	    "RS100 AGP",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS200_AGP,
	    "RS200 AGP",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS250_AGP,
	    "RS250 AGP",
	},
	{
	    PCI_VENDOR_ATI, PCI_PRODUCT_ATI_RS200M_AGP,
	    "RS200M AGP",
	},
	{
	    PCI_VENDOR_AMCIRCUITS, PCI_PRODUCT_AMCIRCUITS_S5933,
	    "S5933 PCI Matchmaker",
	},
	{
	    PCI_VENDOR_AMCIRCUITS, PCI_PRODUCT_AMCIRCUITS_LANAI,
	    "Myrinet LANai",
	},
	{
	    PCI_VENDOR_ASPEED, PCI_PRODUCT_ASPEED_AST2000,
	    "AST2000",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5210,
	    "AR5210",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5311,
	    "AR5311",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5211,
	    "AR5211",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5212,
	    "AR5212",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5212_2,
	    "AR5212",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5212_3,
	    "AR5212",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5212_4,
	    "AR5212",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5212_5,
	    "AR5212",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5212_6,
	    "AR5212",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5212_7,
	    "AR5212",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR2413,
	    "AR2413",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5413,
	    "AR5413",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5424,
	    "AR5424",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5416,
	    "AR5416",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5418,
	    "AR5418",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR9160,
	    "AR9160",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR9280,
	    "AR9280",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR9281,
	    "AR9281",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5210_AP,
	    "AR5210 (Early)",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5212_IBM,
	    "AR5212 (IBM MiniPCI)",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5210_DEFAULT,
	    "AR5210 (no eeprom)",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5212_DEFAULT,
	    "AR5212 (no eeprom)",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5211_DEFAULT,
	    "AR5211 (no eeprom)",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5212_FPGA,
	    "AR5212 (emulation board)",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5211_FPGA11B,
	    "AR5211Ref",
	},
	{
	    PCI_VENDOR_ATHEROS, PCI_PRODUCT_ATHEROS_AR5211_LEGACY,
	    "AR5211Ref",
	},
	{
	    PCI_VENDOR_ATRONICS, PCI_PRODUCT_ATRONICS_IDE_2015PL,
	    "IDE-2015PL",
	},
	{
	    PCI_VENDOR_ATTANSIC, PCI_PRODUCT_ATTANSIC_L1E,
	    "L1E",
	},
	{
	    PCI_VENDOR_ATTANSIC, PCI_PRODUCT_ATTANSIC_L1,
	    "L1",
	},
	{
	    PCI_VENDOR_ATTANSIC, PCI_PRODUCT_ATTANSIC_L2,
	    "L2",
	},
	{
	    PCI_VENDOR_AUREAL, PCI_PRODUCT_AUREAL_AU8820,
	    "Vortex 1",
	},
	{
	    PCI_VENDOR_AUREAL, PCI_PRODUCT_AUREAL_AU8830,
	    "Vortex 2",
	},
	{
	    PCI_VENDOR_AUREAL, PCI_PRODUCT_AUREAL_AU8810,
	    "Vortex Advantage",
	},
	{
	    PCI_VENDOR_AVANCE, PCI_PRODUCT_AVANCE_AVL2301,
	    "AVL2301",
	},
	{
	    PCI_VENDOR_AVANCE, PCI_PRODUCT_AVANCE_AVG2302,
	    "AVG2302",
	},
	{
	    PCI_VENDOR_AVANCE2, PCI_PRODUCT_AVANCE2_ALG2301,
	    "ALG2301",
	},
	{
	    PCI_VENDOR_AVANCE2, PCI_PRODUCT_AVANCE2_ALG2302,
	    "ALG2302",
	},
	{
	    PCI_VENDOR_AVANCE2, PCI_PRODUCT_AVANCE2_ALS4000,
	    "ALS4000",
	},
	{
	    PCI_VENDOR_AVLAB, PCI_PRODUCT_AVLAB_PCI2S,
	    "Dual Serial",
	},
	{
	    PCI_VENDOR_AVLAB, PCI_PRODUCT_AVLAB_LPPCI4S,
	    "Quad Serial",
	},
	{
	    PCI_VENDOR_AVM, PCI_PRODUCT_AVM_B1,
	    "BRI ISDN",
	},
	{
	    PCI_VENDOR_AVM, PCI_PRODUCT_AVM_FRITZ_CARD,
	    "Fritz ISDN",
	},
	{
	    PCI_VENDOR_AVM, PCI_PRODUCT_AVM_FRITZ_PCI_V2_ISDN,
	    "Fritz v2.0 ISDN",
	},
	{
	    PCI_VENDOR_AVM, PCI_PRODUCT_AVM_T1,
	    "PRI T1 ISDN",
	},
	{
	    PCI_VENDOR_AWT, PCI_PRODUCT_AWT_RT2890,
	    "RT2890",
	},
	{
	    PCI_VENDOR_BELKIN2, PCI_PRODUCT_BELKIN2_F5D6001,
	    "F5D6001",
	},
	{
	    PCI_VENDOR_BELKIN2, PCI_PRODUCT_BELKIN2_F5D6020V3,
	    "F5D6020V3",
	},
	{
	    PCI_VENDOR_BELKIN2, PCI_PRODUCT_BELKIN2_F5D7010,
	    "F5D7010",
	},
	{
	    PCI_VENDOR_BELKIN, PCI_PRODUCT_BELKIN_F5D6000,
	    "F5D6000",
	},
	{
	    PCI_VENDOR_BIT3, PCI_PRODUCT_BIT3_PCIVME617,
	    "VME 617",
	},
	{
	    PCI_VENDOR_BIT3, PCI_PRODUCT_BIT3_PCIVME2706,
	    "VME 2706",
	},
	{
	    PCI_VENDOR_BLUESTEEL, PCI_PRODUCT_BLUESTEEL_5501,
	    "5501",
	},
	{
	    PCI_VENDOR_BLUESTEEL, PCI_PRODUCT_BLUESTEEL_5601,
	    "5601",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5752,
	    "BCM5752",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5752M,
	    "BCM5752M",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5709,
	    "BCM5709",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5709S,
	    "BCM5709S",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5700,
	    "BCM5700",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5701,
	    "BCM5701",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5702,
	    "BCM5702",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5703,
	    "BCM5703",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5704C,
	    "BCM5704C",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5704S_ALT,
	    "BCM5704S Alt",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5706,
	    "BCM5706",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5708,
	    "BCM5708",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5702FE,
	    "BCM5702FE",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM57710,
	    "BCM57710",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5705,
	    "BCM5705",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5705K,
	    "BCM5705K",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5720,
	    "BCM5720",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5721,
	    "BCM5721",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5705M,
	    "BCM5705M",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5722,
	    "BCM5722",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5723,
	    "BCM5723",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5705M_ALT,
	    "BCM5705M Alt",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5714,
	    "BCM5714",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5714S,
	    "BCM5714S",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5780,
	    "BCM5780",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5780S,
	    "BCM5780S",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5705F,
	    "BCM5705F",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5754M,
	    "BCM5754M",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5755M,
	    "BCM5755M",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5756,
	    "BCM5756",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5750,
	    "BCM5750",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5751,
	    "BCM5751",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5715,
	    "BCM5715",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5715S,
	    "BCM5715S",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5754,
	    "BCM5754",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5755,
	    "BCM5755",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5750M,
	    "BCM5750M",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5751M,
	    "BCM5751M",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5751F,
	    "BCM5751F",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5787F,
	    "BCM5787F",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5761E,
	    "BCM5761E",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5761,
	    "BCM5761",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5764,
	    "BCM5764",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5787M,
	    "BCM5787M",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5782,
	    "BCM5782",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5784,
	    "BCM5784",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5786,
	    "BCM5786",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5787,
	    "BCM5787",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5788,
	    "BCM5788",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5789,
	    "BCM5789",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5702X,
	    "BCM5702X",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5703X,
	    "BCM5703X",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5704S,
	    "BCM5704S",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5706S,
	    "BCM5706S",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5708S,
	    "BCM5708S",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5702_ALT,
	    "BCM5702 Alt",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5703_ALT,
	    "BCM5703 Alt",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5781,
	    "BCM5781",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5753,
	    "BCM5753",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5753M,
	    "BCM5753M",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5753F,
	    "BCM5753F",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5903M,
	    "BCM5903M",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM4401B1,
	    "BCM4401B1",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5901,
	    "BCM5901",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5901A2,
	    "BCM5901A2",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5906,
	    "BCM5906",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM5906M,
	    "BCM5906M",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM4303,
	    "BCM4303",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM4307,
	    "BCM4307",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM4311,
	    "BCM4311",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM4312,
	    "BCM4312",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM4318,
	    "BCM4318",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM4319,
	    "BCM4319",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM4306,
	    "BCM4306",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM4306_2,
	    "BCM4306",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM4322,
	    "BCM4322",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM4309,
	    "BCM4309",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM43XG,
	    "BCM43XG",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM4328,
	    "BCM4328",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_SERIAL,
	    "Serial",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_SERIAL_GC,
	    "Serial",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM4401,
	    "BCM4401",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_BCM4401B0,
	    "BCM4401B0",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_5801,
	    "5801",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_5802,
	    "5802",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_5805,
	    "5805",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_5820,
	    "5820",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_5821,
	    "5821",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_5822,
	    "5822",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_5823,
	    "5823",
	},
	{
	    PCI_VENDOR_BROADCOM, PCI_PRODUCT_BROADCOM_5825,
	    "5825",
	},
	{
	    PCI_VENDOR_BROOKTREE, PCI_PRODUCT_BROOKTREE_BT848,
	    "BT848",
	},
	{
	    PCI_VENDOR_BROOKTREE, PCI_PRODUCT_BROOKTREE_BT849,
	    "BT849",
	},
	{
	    PCI_VENDOR_BROOKTREE, PCI_PRODUCT_BROOKTREE_BT878,
	    "BT878",
	},
	{
	    PCI_VENDOR_BROOKTREE, PCI_PRODUCT_BROOKTREE_BT879,
	    "BT879",
	},
	{
	    PCI_VENDOR_BROOKTREE, PCI_PRODUCT_BROOKTREE_BT878_AU,
	    "BT878 Audio",
	},
	{
	    PCI_VENDOR_BROOKTREE, PCI_PRODUCT_BROOKTREE_BT879_AU,
	    "BT879 Audio",
	},
	{
	    PCI_VENDOR_BROOKTREE, PCI_PRODUCT_BROOKTREE_BT8474,
	    "Bt8474 HDLC",
	},
	{
	    PCI_VENDOR_BUSLOGIC, PCI_PRODUCT_BUSLOGIC_MULTIMASTER_NC,
	    "MultiMaster NC",
	},
	{
	    PCI_VENDOR_BUSLOGIC, PCI_PRODUCT_BUSLOGIC_MULTIMASTER,
	    "MultiMaster",
	},
	{
	    PCI_VENDOR_BUSLOGIC, PCI_PRODUCT_BUSLOGIC_FLASHPOINT,
	    "FlashPoint",
	},
	{
	    PCI_VENDOR_C4T, PCI_PRODUCT_C4T_GPPCI,
	    "GPPCI",
	},
	{
	    PCI_VENDOR_CAVIUM, PCI_PRODUCT_CAVIUM_NITROX,
	    "Nitrox XL",
	},
	{
	    PCI_VENDOR_CCUBE, PCI_PRODUCT_CCUBE_CINEMASTER,
	    "Cinemaster",
	},
	{
	    PCI_VENDOR_CHELSIO, PCI_PRODUCT_CHELSIO_Nx10,
	    "Nx10 10GbE",
	},
	{
	    PCI_VENDOR_CHELSIO, PCI_PRODUCT_CHELSIO_PE9000,
	    "PE9000 10GbE",
	},
	{
	    PCI_VENDOR_CHELSIO, PCI_PRODUCT_CHELSIO_T302E,
	    "T302E 10GbE",
	},
	{
	    PCI_VENDOR_CHELSIO, PCI_PRODUCT_CHELSIO_T310E,
	    "T310E 10GbE",
	},
	{
	    PCI_VENDOR_CHELSIO, PCI_PRODUCT_CHELSIO_T320X,
	    "T320X 10GbE",
	},
	{
	    PCI_VENDOR_CHELSIO, PCI_PRODUCT_CHELSIO_T302X,
	    "T302X 10GbE",
	},
	{
	    PCI_VENDOR_CHELSIO, PCI_PRODUCT_CHELSIO_T320E,
	    "T320E 10GbE",
	},
	{
	    PCI_VENDOR_CHELSIO, PCI_PRODUCT_CHELSIO_T310X,
	    "T310X 10GbE",
	},
	{
	    PCI_VENDOR_CHELSIO, PCI_PRODUCT_CHELSIO_T3B10,
	    "T3B10 10GbE",
	},
	{
	    PCI_VENDOR_CHELSIO, PCI_PRODUCT_CHELSIO_T3B20,
	    "T3B20 10GbE",
	},
	{
	    PCI_VENDOR_CHELSIO, PCI_PRODUCT_CHELSIO_T3B02,
	    "T3B02 10GbE",
	},
	{
	    PCI_VENDOR_CHIPS, PCI_PRODUCT_CHIPS_64310,
	    "64310",
	},
	{
	    PCI_VENDOR_CHIPS, PCI_PRODUCT_CHIPS_65545,
	    "65545",
	},
	{
	    PCI_VENDOR_CHIPS, PCI_PRODUCT_CHIPS_65548,
	    "65548",
	},
	{
	    PCI_VENDOR_CHIPS, PCI_PRODUCT_CHIPS_65550,
	    "65550",
	},
	{
	    PCI_VENDOR_CHIPS, PCI_PRODUCT_CHIPS_65554,
	    "65554",
	},
	{
	    PCI_VENDOR_CHIPS, PCI_PRODUCT_CHIPS_65555,
	    "65555",
	},
	{
	    PCI_VENDOR_CHIPS, PCI_PRODUCT_CHIPS_68554,
	    "68554",
	},
	{
	    PCI_VENDOR_CHIPS, PCI_PRODUCT_CHIPS_69000,
	    "69000",
	},
	{
	    PCI_VENDOR_CHIPS, PCI_PRODUCT_CHIPS_69030,
	    "69030",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_GD7548,
	    "CL-GD7548",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_GD5430,
	    "CL-GD5430",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_GD5434_4,
	    "CL-GD5434-4",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_GD5434_8,
	    "CL-GD5434-8",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_GD5436,
	    "CL-GD5436",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_GD5446,
	    "CL-GD5446",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_GD5480,
	    "CL-GD5480",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_GD5462,
	    "CL-GD5462",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_GD5464,
	    "CL-GD5464",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_GD5465,
	    "CL-GD5465",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_PD6729,
	    "CL-PD6729",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_PD6832,
	    "CL-PD6832 CardBus",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_PD6833,
	    "CL-PD6833 CardBus",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_GD7542,
	    "CL-GD7542",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_GD7543,
	    "CL-GD7543",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CL_GD7541,
	    "CL-GD7541",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CS4610,
	    "CS4610 SoundFusion",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CS4615,
	    "CS4615",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CS4280,
	    "CS4280/46xx CrystalClear",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CS4615,
	    "CS4615",
	},
	{
	    PCI_VENDOR_CIRRUS, PCI_PRODUCT_CIRRUS_CS4281,
	    "CS4281 CrystalClear",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_AAR_1210SA,
	    "AAR-1210SA",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_AAR_1220SA,
	    "AAR-1220SA",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_640,
	    "PCI0640",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_642,
	    "PCI0642",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_643,
	    "PCI0643",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_646,
	    "PCI0646",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_647,
	    "PCI0647",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_648,
	    "PCI0648",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_649,
	    "PCI0649",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_650A,
	    "PCI0650A",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_670,
	    "USB0670",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_673,
	    "USB0673",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_680,
	    "PCI0680",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_3112,
	    "SiI3112 SATA",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_3114,
	    "SiI3114 SATA",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_3124,
	    "SiI3124 SATA",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_3131,
	    "SiI3131 SATA",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_3132,
	    "SiI3132 SATA",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_3512,
	    "SiI3512 SATA",
	},
	{
	    PCI_VENDOR_CMDTECH, PCI_PRODUCT_CMDTECH_3531,
	    "SiI3531 SATA",
	},
	{
	    PCI_VENDOR_CNET, PCI_PRODUCT_CNET_GIGACARD,
	    "GigaCard",
	},
	{
	    PCI_VENDOR_COGENT, PCI_PRODUCT_COGENT_EM110TX,
	    "EX110TX",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_PCI_EISA_BRIDGE,
	    "EISA",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_PCI_ISA_BRIDGE,
	    "ISA",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_CSA64XX,
	    "Smart Array 64xx",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_TRIFLEX1,
	    "Triflex PCI",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_TRIFLEX2,
	    "Triflex PCI",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_QVISION_V0,
	    "QVision",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_QVISION_1280P,
	    "QVision 1280/p",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_QVISION_V2,
	    "QVision",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_TRIFLEX4,
	    "Triflex PCI",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_CSA5300,
	    "Smart Array 5300",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_CSA5i,
	    "Smart Array 5i",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_CSA532,
	    "Smart Array 532",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_CSA5312,
	    "Smart Array 5312",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_CSA6i,
	    "Smart Array 6i",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_CSA641,
	    "Smart Array 641",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_CSA642,
	    "Smart Array 642",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_CSA6400,
	    "Smart Array 6400",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_CSA6400EM,
	    "Smart Array 6400 EM",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_CSA6422,
	    "Smart Array 6422",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_HOTPLUG_PCI,
	    "Hotplug PCI",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_USB,
	    "USB",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_FXP,
	    "Netelligent ASMC",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_PCI_ISA_BRIDGE1,
	    "ISA",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_PCI_HOTPLUG,
	    "PCI Hotplug",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_OHCI,
	    "USB OpenHost",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_SMART2P,
	    "SMART2P RAID",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_PCI_ISA_BRIDGE3,
	    "ISA",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_PCI_ISAPNP,
	    "ISAPnP",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_N100TX,
	    "Netelligent 10/100TX",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_IDE,
	    "Netelligent IDE",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_N10T,
	    "Netelligent 10 T",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_IntNF3P,
	    "Integrated NetFlex 3/P",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_DPNet100TX,
	    "DP Netelligent 10/100TX",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_IntPL100TX,
	    "ProLiant Netelligent 10/100TX",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_PCI_ISA_BRIDGE2,
	    "ISA",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_HOST_PCI_BRIDGE1,
	    "PCI",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_HOST_PCI_BRIDGE2,
	    "PCI",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_DP4000,
	    "Embedded Netelligent 10/100TX",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_N10T2,
	    "Netelligent 10 T/2 PCI",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_N10_TX_UTP,
	    "Netelligent 10/100TX",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_CSA5300_2,
	    "Smart Array 5300 rev.2",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_CSA5i_2,
	    "Smart Array 5i/532 rev.2",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_ILO_1,
	    "iLO",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_ILO_2,
	    "iLO",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_NF3P,
	    "NetFlex 3/P",
	},
	{
	    PCI_VENDOR_COMPAQ, PCI_PRODUCT_COMPAQ_NF3P_BNC,
	    "NetFlex 3/PB",
	},
	{
	    PCI_VENDOR_COMPEX, PCI_PRODUCT_COMPEX_COMPEXE,
	    "Compexe",
	},
	{
	    PCI_VENDOR_COMPEX, PCI_PRODUCT_COMPEX_RL100ATX,
	    "RL100-ATX 10/100",
	},
	{
	    PCI_VENDOR_COMPEX, PCI_PRODUCT_COMPEX_98713,
	    "PMAC 98713",
	},
	{
	    PCI_VENDOR_CONEXANT, PCI_PRODUCT_CONEXANT_56K_WINMODEM,
	    "56k Winmodem",
	},
	{
	    PCI_VENDOR_CONEXANT, PCI_PRODUCT_CONEXANT_56K_WINMODEM2,
	    "56k Winmodem",
	},
	{
	    PCI_VENDOR_CONEXANT, PCI_PRODUCT_CONEXANT_RS7112,
	    "10/100",
	},
	{
	    PCI_VENDOR_CONEXANT, PCI_PRODUCT_CONEXANT_56K_WINMODEM3,
	    "10/100",
	},
	{
	    PCI_VENDOR_CONEXANT, PCI_PRODUCT_CONEXANT_SOFTK56_PCI,
	    "SoftK56 PCI",
	},
	{
	    PCI_VENDOR_CONEXANT, PCI_PRODUCT_CONEXANT_HSF_56K_HSFI,
	    "HSF 56k HSFi",
	},
	{
	    PCI_VENDOR_CONEXANT, PCI_PRODUCT_CONEXANT_MUSYCC8478,
	    "MUSYCC CN8478",
	},
	{
	    PCI_VENDOR_CONEXANT, PCI_PRODUCT_CONEXANT_MUSYCC8474,
	    "MUSYCC CN8474",
	},
	{
	    PCI_VENDOR_CONEXANT, PCI_PRODUCT_CONEXANT_MUSYCC8472,
	    "MUSYCC CN8472",
	},
	{
	    PCI_VENDOR_CONEXANT, PCI_PRODUCT_CONEXANT_MUSYCC8471,
	    "MUSYCC CN8471",
	},
	{
	    PCI_VENDOR_CONEXANT, PCI_PRODUCT_CONEXANT_CX2388x,
	    "CX2388x",
	},
	{
	    PCI_VENDOR_CONEXANT, PCI_PRODUCT_CONEXANT_CX2388x_AUDIO,
	    "CX2388x Audio",
	},
	{
	    PCI_VENDOR_CONEXANT, PCI_PRODUCT_CONEXANT_CX2388x_MPEG,
	    "CX2388x MPEG",
	},
	{
	    PCI_VENDOR_CONEXANT, PCI_PRODUCT_CONEXANT_CX2388x_IR,
	    "CX2388x IR",
	},
	{
	    PCI_VENDOR_CONEXANT, PCI_PRODUCT_CONEXANT_CX2388x_AUDIO2,
	    "CX2388x Audio",
	},
	{
	    PCI_VENDOR_CONTAQ, PCI_PRODUCT_CONTAQ_82C599,
	    "82C599 VLB",
	},
	{
	    PCI_VENDOR_CONTAQ, PCI_PRODUCT_CONTAQ_82C693,
	    "CY82C693U ISA",
	},
	{
	    PCI_VENDOR_COREGA, PCI_PRODUCT_COREGA_CB_TXD,
	    "FEther CB-TXD 10/100",
	},
	{
	    PCI_VENDOR_COREGA, PCI_PRODUCT_COREGA_2CB_TXD,
	    "FEther II CB-TXD 10/100",
	},
	{
	    PCI_VENDOR_COREGA, PCI_PRODUCT_COREGA_CGLAPCIGT,
	    "CG-LAPCIGT",
	},
	{
	    PCI_VENDOR_COROLLARY, PCI_PRODUCT_COROLLARY_CBUSII_PCIB,
	    "C-Bus II-PCI",
	},
	{
	    PCI_VENDOR_COROLLARY, PCI_PRODUCT_COROLLARY_CCF,
	    "Cache Coherency Filter",
	},
	{
	    PCI_VENDOR_CREATIVELABS, PCI_PRODUCT_CREATIVELABS_SBLIVE,
	    "SoundBlaster Live",
	},
	{
	    PCI_VENDOR_CREATIVELABS, PCI_PRODUCT_CREATIVELABS_AWE64D,
	    "SoundBlaster AWE64D",
	},
	{
	    PCI_VENDOR_CREATIVELABS, PCI_PRODUCT_CREATIVELABS_AUDIGY,
	    "SoundBlaster Audigy",
	},
	{
	    PCI_VENDOR_CREATIVELABS, PCI_PRODUCT_CREATIVELABS_XFI,
	    "SoundBlaster X-Fi",
	},
	{
	    PCI_VENDOR_CREATIVELABS, PCI_PRODUCT_CREATIVELABS_SBLIVE2,
	    "SoundBlaster Live (Dell)",
	},
	{
	    PCI_VENDOR_CREATIVELABS, PCI_PRODUCT_CREATIVELABS_AUDIGYLS,
	    "SoundBlaster Audigy LS",
	},
	{
	    PCI_VENDOR_CREATIVELABS, PCI_PRODUCT_CREATIVELABS_AUDIGY2,
	    "SoundBlaster Audigy 2",
	},
	{
	    PCI_VENDOR_CREATIVELABS, PCI_PRODUCT_CREATIVELABS_FIWIRE,
	    "Firewire",
	},
	{
	    PCI_VENDOR_CREATIVELABS, PCI_PRODUCT_CREATIVELABS_SBJOY,
	    "PCI Gameport Joystick",
	},
	{
	    PCI_VENDOR_CREATIVELABS, PCI_PRODUCT_CREATIVELABS_AUDIGIN,
	    "SoundBlaster Audigy Digital",
	},
	{
	    PCI_VENDOR_CREATIVELABS, PCI_PRODUCT_CREATIVELABS_SBJOY2,
	    "PCI Gameport Joystick",
	},
	{
	    PCI_VENDOR_CREATIVELABS, PCI_PRODUCT_CREATIVELABS_SBJOY3,
	    "PCI Gameport Joystick",
	},
	{
	    PCI_VENDOR_CREATIVELABS, PCI_PRODUCT_CREATIVELABS_EV1938,
	    "Ectiva 1938",
	},
	{
	    PCI_VENDOR_CYCLADES, PCI_PRODUCT_CYCLADES_CYCLOMY_1,
	    "Cyclom-Y below 1M",
	},
	{
	    PCI_VENDOR_CYCLADES, PCI_PRODUCT_CYCLADES_CYCLOMY_2,
	    "Cyclom-Y",
	},
	{
	    PCI_VENDOR_CYCLADES, PCI_PRODUCT_CYCLADES_CYCLOM4Y_1,
	    "Cyclom-4Y below 1M",
	},
	{
	    PCI_VENDOR_CYCLADES, PCI_PRODUCT_CYCLADES_CYCLOM4Y_2,
	    "Cyclom-4Y",
	},
	{
	    PCI_VENDOR_CYCLADES, PCI_PRODUCT_CYCLADES_CYCLOM8Y_1,
	    "Cyclom-8Y below 1M",
	},
	{
	    PCI_VENDOR_CYCLADES, PCI_PRODUCT_CYCLADES_CYCLOM8Y_2,
	    "Cyclom-8Y",
	},
	{
	    PCI_VENDOR_CYCLADES, PCI_PRODUCT_CYCLADES_CYCLOMZ_1,
	    "Cyclom-Z below 1M",
	},
	{
	    PCI_VENDOR_CYCLADES, PCI_PRODUCT_CYCLADES_CYCLOMZ_2,
	    "Cyclom-Z",
	},
	{
	    PCI_VENDOR_CYCLONE, PCI_PRODUCT_CYCLONE_PCI_700,
	    "IQ80310",
	},
	{
	    PCI_VENDOR_CYRIX, PCI_PRODUCT_CYRIX_CX5510,
	    "Cx5510",
	},
	{
	    PCI_VENDOR_CYRIX, PCI_PRODUCT_CYRIX_GXMPCI,
	    "GXm PCI",
	},
	{
	    PCI_VENDOR_CYRIX, PCI_PRODUCT_CYRIX_GXMISA,
	    "GXm ISA",
	},
	{
	    PCI_VENDOR_CYRIX, PCI_PRODUCT_CYRIX_CX5530_PCIB,
	    "Cx5530 South",
	},
	{
	    PCI_VENDOR_CYRIX, PCI_PRODUCT_CYRIX_CX5530_SMI,
	    "Cx5530 SMI",
	},
	{
	    PCI_VENDOR_CYRIX, PCI_PRODUCT_CYRIX_CX5530_IDE,
	    "Cx5530 IDE",
	},
	{
	    PCI_VENDOR_CYRIX, PCI_PRODUCT_CYRIX_CX5530_AUDIO,
	    "Cx5530 XpressAUDIO",
	},
	{
	    PCI_VENDOR_CYRIX, PCI_PRODUCT_CYRIX_CX5530_VIDEO,
	    "Cx5530 Video",
	},
	{
	    PCI_VENDOR_DAVICOM, PCI_PRODUCT_DAVICOM_DM9009,
	    "DM9009",
	},
	{
	    PCI_VENDOR_DAVICOM, PCI_PRODUCT_DAVICOM_DM9100,
	    "DM9100",
	},
	{
	    PCI_VENDOR_DAVICOM, PCI_PRODUCT_DAVICOM_DM9102,
	    "DM9102",
	},
	{
	    PCI_VENDOR_DAVICOM, PCI_PRODUCT_DAVICOM_DM9132,
	    "DM9132",
	},
	{
	    PCI_VENDOR_DCI, PCI_PRODUCT_DCI_APCI2,
	    "PCCOM 2-port",
	},
	{
	    PCI_VENDOR_DCI, PCI_PRODUCT_DCI_APCI4,
	    "PCCOM 4-port",
	},
	{
	    PCI_VENDOR_DCI, PCI_PRODUCT_DCI_APCI8,
	    "PCCOM 8-port",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_21050,
	    "21050 PCI-PCI",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_21040,
	    "21040",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_21030,
	    "21030",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_NVRAM,
	    "Zephyr NV-RAM",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_KZPSA,
	    "KZPSA",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_21140,
	    "21140",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_PBXGB,
	    "TGA2",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_DEFPA,
	    "DEFPA",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_21041,
	    "21041",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_DGLPB,
	    "DGLPB (OPPO)",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_ZLXPL2,
	    "ZLXP-L2 (Pixelvision)",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_21142,
	    "21142/3",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_PN9000SX,
	    "Farallon PN9000SX",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_21052,
	    "21052 PCI-PCI",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_21150,
	    "21150 PCI-PCI",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_21150_BC,
	    "21150-BC PCI-PCI",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_21152,
	    "21152 PCI-PCI",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_21153,
	    "21153 PCI-PCI",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_21154,
	    "21154 PCI-PCI",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_CPQ42XX,
	    "Compaq SMART RAID 42xx",
	},
	{
	    PCI_VENDOR_DEC, PCI_PRODUCT_DEC_SWXCR,
	    "SWXCR RAID",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC_2SI,
	    "PERC 2/Si",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC_3DI,
	    "PERC 3/Di",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC_3SI,
	    "PERC 3/Si",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC_3SI_2,
	    "PERC 3/Si",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_DRAC_3_ADDIN,
	    "DRAC 3 Add-in",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_DRAC_3_VUART,
	    "DRAC 3 Virtual UART",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_DRAC_3_EMBD,
	    "DRAC 3 Embedded/Optional",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC_3DI_3,
	    "PERC 3/Di",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_DRAC_4_EMBD,
	    "DRAC 4 Embedded/Optional",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_DRAC_3_OPT,
	    "DRAC 3 Optional",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC_4DI,
	    "PERC 4/Di i960",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC_4DI_2,
	    "PERC 4/Di Verde",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_DRAC_4,
	    "DRAC 4",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_DRAC_4_VUART,
	    "DRAC 4 Virtual UART",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC_4EDI,
	    "PERC 4e/Di",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_DRAC_4_SMIC,
	    "DRAC 4 SMIC",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC_3DI_2_SUB,
	    "PERC 3/Di",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC_3SI_2_SUB,
	    "PERC 3/Si",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC_3DI_SUB2,
	    "PERC 3/Di",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC_3DI_SUB3,
	    "PERC 3/Di",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC_3DI_3_SUB,
	    "PERC 3/Di",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC_3DI_3_SUB2,
	    "PERC 3/Di",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC_3DI_3_SUB3,
	    "PERC 3/Di",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC5,
	    "PERC 5",
	},
	{
	    PCI_VENDOR_DELL, PCI_PRODUCT_DELL_PERC6,
	    "PERC 6",
	},
	{
	    PCI_VENDOR_DELTA, PCI_PRODUCT_DELTA_RHINEII,
	    "RhineII",
	},
	{
	    PCI_VENDOR_DELTA, PCI_PRODUCT_DELTA_8139,
	    "8139",
	},
	{
	    PCI_VENDOR_DIAMOND, PCI_PRODUCT_DIAMOND_VIPER,
	    "Viper/PCI",
	},
	{
	    PCI_VENDOR_DLINK, PCI_PRODUCT_DLINK_550TX,
	    "550TX",
	},
	{
	    PCI_VENDOR_DLINK, PCI_PRODUCT_DLINK_530TXPLUS,
	    "530TX+",
	},
	{
	    PCI_VENDOR_DLINK, PCI_PRODUCT_DLINK_DFE690TXD,
	    "DFE-690TXD",
	},
	{
	    PCI_VENDOR_DLINK, PCI_PRODUCT_DLINK_DRP32TXD,
	    "DRP32TXD",
	},
	{
	    PCI_VENDOR_DLINK, PCI_PRODUCT_DLINK_DWL610,
	    "DWL-610",
	},
	{
	    PCI_VENDOR_DLINK, PCI_PRODUCT_DLINK_DGE550T,
	    "DGE-550T",
	},
	{
	    PCI_VENDOR_DLINK, PCI_PRODUCT_DLINK_DGE550SX,
	    "DGE-550SX",
	},
	{
	    PCI_VENDOR_DLINK, PCI_PRODUCT_DLINK_DGE528T,
	    "DGE-528T",
	},
	{
	    PCI_VENDOR_DLINK, PCI_PRODUCT_DLINK_DGE560T,
	    "DGE-560T",
	},
	{
	    PCI_VENDOR_DLINK, PCI_PRODUCT_DLINK_DGE530T_B1,
	    "DGE-530T B1",
	},
	{
	    PCI_VENDOR_DLINK, PCI_PRODUCT_DLINK_DGE560SX,
	    "DGE-560SX",
	},
	{
	    PCI_VENDOR_DLINK, PCI_PRODUCT_DLINK_DGE550T_B1,
	    "DGE-550T B1",
	},
	{
	    PCI_VENDOR_DLINK, PCI_PRODUCT_DLINK_DGE530T_A1,
	    "DGE-530T A1",
	},
	{
	    PCI_VENDOR_DPT, PCI_PRODUCT_DPT_MEMCTLR,
	    "Memory Control",
	},
	{
	    PCI_VENDOR_DPT, PCI_PRODUCT_DPT_SC_RAID,
	    "SmartCache/Raid",
	},
	{
	    PCI_VENDOR_DPT, PCI_PRODUCT_DPT_I960_PPB,
	    "PCI-PCI",
	},
	{
	    PCI_VENDOR_DPT, PCI_PRODUCT_DPT_RAID_I2O,
	    "SmartRAID (I2O)",
	},
	{
	    PCI_VENDOR_DPT, PCI_PRODUCT_DPT_2005S,
	    "SmartRAID 2005S",
	},
	{
	    PCI_VENDOR_DOLPHIN, PCI_PRODUCT_DOLPHIN_PCISCI,
	    "PCI-SCI",
	},
	{
	    PCI_VENDOR_DTCTECH, PCI_PRODUCT_DTCTECH_DMX3194U,
	    "DMX3194U",
	},
	{
	    PCI_VENDOR_DYNALINK, PCI_PRODUCT_DYNALINK_IS64PH,
	    "IS64PH ISDN",
	},
	{
	    PCI_VENDOR_EFFICIENTNETS, PCI_PRODUCT_EFFICIENTNETS_ENI155PF,
	    "155P-MF1 ATM (FPGA)",
	},
	{
	    PCI_VENDOR_EFFICIENTNETS, PCI_PRODUCT_EFFICIENTNETS_ENI155PA,
	    "155P-MF1 ATM (ASIC)",
	},
	{
	    PCI_VENDOR_EFFICIENTNETS, PCI_PRODUCT_EFFICIENTNETS_EFSS25,
	    "25SS-3010 ATM (ASIC)",
	},
	{
	    PCI_VENDOR_EFFICIENTNETS, PCI_PRODUCT_EFFICIENTNETS_SS1023,
	    "SpeedStream 1023",
	},
	{
	    PCI_VENDOR_ELSA, PCI_PRODUCT_ELSA_QS1PCI,
	    "QuickStep 1000 ISDN",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPFC,
	    "LPFC",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP6000,
	    "LP6000",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPE121,
	    "LPe121",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPE1250,
	    "LPe1250",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP952,
	    "LP952",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP982,
	    "LP982",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP101,
	    "LP101",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP1050,
	    "LP1050",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP111,
	    "LP111",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP1150,
	    "LP1150",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPE111,
	    "LPe111",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPE1150,
	    "LPe1150",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPE1000,
	    "LPe1000",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPE1000_SP,
	    "LPe1000-SP",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPE1002_SP,
	    "LPe1002-SP",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPE12000,
	    "LPe12000",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPE12000_SP,
	    "LPe12000-SP",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPE12002_SP,
	    "LPe12002-SP",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP7000,
	    "LP7000",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP8000,
	    "LP8000",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP9000,
	    "LP9000",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP9802,
	    "LP9802",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP10000,
	    "LP10000",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPX10000,
	    "LPX10000",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP10000_S,
	    "LP10000-S",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP11000_S,
	    "LP11000-S",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPE11000_S,
	    "LPe11000-S",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPE12000_S,
	    "LPe12000-S",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP11000,
	    "LP11000",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP11000_SP,
	    "LP11000-SP",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LP11002_SP,
	    "LP11002-SP",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPE11000,
	    "LPe11000",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPE11000_SP,
	    "LPe11000-SP",
	},
	{
	    PCI_VENDOR_EMULEX, PCI_PRODUCT_EMULEX_LPE11002_SP,
	    "LPe11002-SP",
	},
	{
	    PCI_VENDOR_ENDACE, PCI_PRODUCT_ENDACE_DAG35,
	    "Endace Dag3.5",
	},
	{
	    PCI_VENDOR_ENDACE, PCI_PRODUCT_ENDACE_DAG36D,
	    "Endace Dag3.6D",
	},
	{
	    PCI_VENDOR_ENDACE, PCI_PRODUCT_ENDACE_DAG422GE,
	    "Endace Dag4.22GE",
	},
	{
	    PCI_VENDOR_ENDACE, PCI_PRODUCT_ENDACE_DAG423,
	    "Endace Dag4.23",
	},
	{
	    PCI_VENDOR_ENDACE, PCI_PRODUCT_ENDACE_DAG423GE,
	    "Endace Dag4.23GE",
	},
	{
	    PCI_VENDOR_ENE, PCI_PRODUCT_ENE_MEMSTICK,
	    "Memory Stick",
	},
	{
	    PCI_VENDOR_ENE, PCI_PRODUCT_ENE_SDCARD,
	    "SD Controller",
	},
	{
	    PCI_VENDOR_ENE, PCI_PRODUCT_ENE_SDMMC,
	    "SD/MMC",
	},
	{
	    PCI_VENDOR_ENE, PCI_PRODUCT_ENE_CB1211,
	    "CB-1211 CardBus",
	},
	{
	    PCI_VENDOR_ENE, PCI_PRODUCT_ENE_CB1225,
	    "CB-1225 CardBus",
	},
	{
	    PCI_VENDOR_ENE, PCI_PRODUCT_ENE_CB1410,
	    "CB-1410 CardBus",
	},
	{
	    PCI_VENDOR_ENE, PCI_PRODUCT_ENE_CB710,
	    "CB-710 CardBus",
	},
	{
	    PCI_VENDOR_ENE, PCI_PRODUCT_ENE_CB712,
	    "CB-712 CardBus",
	},
	{
	    PCI_VENDOR_ENE, PCI_PRODUCT_ENE_CB1420,
	    "CB-1420 CardBus",
	},
	{
	    PCI_VENDOR_ENE, PCI_PRODUCT_ENE_CB720,
	    "CB-720 CardBus",
	},
	{
	    PCI_VENDOR_ENE, PCI_PRODUCT_ENE_CB722,
	    "CB-722 CardBus",
	},
	{
	    PCI_VENDOR_ENSONIQ, PCI_PRODUCT_ENSONIQ_AUDIOPCI97,
	    "AudioPCI97",
	},
	{
	    PCI_VENDOR_ENSONIQ, PCI_PRODUCT_ENSONIQ_AUDIOPCI,
	    "AudioPCI",
	},
	{
	    PCI_VENDOR_ENSONIQ, PCI_PRODUCT_ENSONIQ_CT5880,
	    "CT5880",
	},
	{
	    PCI_VENDOR_ESSTECH, PCI_PRODUCT_ESSTECH_ES336H,
	    "ES366H Modem",
	},
	{
	    PCI_VENDOR_ESSTECH, PCI_PRODUCT_ESSTECH_MAESTROII,
	    "Maestro II",
	},
	{
	    PCI_VENDOR_ESSTECH, PCI_PRODUCT_ESSTECH_SOLO1,
	    "SOLO-1 AudioDrive",
	},
	{
	    PCI_VENDOR_ESSTECH, PCI_PRODUCT_ESSTECH_MAESTRO2E,
	    "Maestro 2E",
	},
	{
	    PCI_VENDOR_ESSTECH, PCI_PRODUCT_ESSTECH_ES1989,
	    "ES1989",
	},
	{
	    PCI_VENDOR_ESSTECH, PCI_PRODUCT_ESSTECH_ES1989M,
	    "ES1989 Modem",
	},
	{
	    PCI_VENDOR_ESSTECH, PCI_PRODUCT_ESSTECH_MAESTRO3,
	    "Maestro 3",
	},
	{
	    PCI_VENDOR_ESSTECH, PCI_PRODUCT_ESSTECH_ES1983,
	    "ES1983 Modem",
	},
	{
	    PCI_VENDOR_ESSTECH, PCI_PRODUCT_ESSTECH_MAESTRO3_2,
	    "Maestro 3 Audio",
	},
	{
	    PCI_VENDOR_ESSTECH, PCI_PRODUCT_ESSTECH_ES336H_N,
	    "ES366H Fax/Modem",
	},
	{
	    PCI_VENDOR_ESSTECH, PCI_PRODUCT_ESSTECH_SUPERLINK,
	    "ES2838/2839 SuperLink Modem",
	},
	{
	    PCI_VENDOR_ESSTECH, PCI_PRODUCT_ESSTECH_2898,
	    "ES2898 Modem",
	},
	{
	    PCI_VENDOR_ESSENTIAL, PCI_PRODUCT_ESSENTIAL_RR_HIPPI,
	    "RoadRunner HIPPI",
	},
	{
	    PCI_VENDOR_ESSENTIAL, PCI_PRODUCT_ESSENTIAL_RR_GIGE,
	    "RoadRunner Gig-E",
	},
	{
	    PCI_VENDOR_ES, PCI_PRODUCT_ES_FREEDOM,
	    "Freedom GBus",
	},
	{
	    PCI_VENDOR_EUMITCOM, PCI_PRODUCT_EUMITCOM_WL11000P,
	    "WL11000P",
	},
	{
	    PCI_VENDOR_EQUINOX, PCI_PRODUCT_EQUINOX_SST64,
	    "SST-64P",
	},
	{
	    PCI_VENDOR_EQUINOX, PCI_PRODUCT_EQUINOX_SST128,
	    "SST-128P",
	},
	{
	    PCI_VENDOR_EQUINOX, PCI_PRODUCT_EQUINOX_SST16A,
	    "SST-16P",
	},
	{
	    PCI_VENDOR_EQUINOX, PCI_PRODUCT_EQUINOX_SST16B,
	    "SST-16P",
	},
	{
	    PCI_VENDOR_EQUINOX, PCI_PRODUCT_EQUINOX_SST16C,
	    "SST-16P",
	},
	{
	    PCI_VENDOR_EQUINOX, PCI_PRODUCT_EQUINOX_SST4,
	    "SST-4p",
	},
	{
	    PCI_VENDOR_EQUINOX, PCI_PRODUCT_EQUINOX_SST8,
	    "SST-8p",
	},
	{
	    PCI_VENDOR_EXAR, PCI_PRODUCT_EXAR_XR17C152,
	    "XR17C152",
	},
	{
	    PCI_VENDOR_EXAR, PCI_PRODUCT_EXAR_XR17C154,
	    "XR17C154",
	},
	{
	    PCI_VENDOR_EXAR, PCI_PRODUCT_EXAR_XR17C158,
	    "XR17C158",
	},
	{
	    PCI_VENDOR_FORE, PCI_PRODUCT_FORE_PCA200,
	    "ATM PCA-200",
	},
	{
	    PCI_VENDOR_FORE, PCI_PRODUCT_FORE_PCA200E,
	    "ATM PCA-200e",
	},
	{
	    PCI_VENDOR_FORTEMEDIA, PCI_PRODUCT_FORTEMEDIA_FM801,
	    "801 Sound",
	},
	{
	    PCI_VENDOR_FREESCALE, PCI_PRODUCT_FREESCALE_MPC8349E,
	    "MPC8349E",
	},
	{
	    PCI_VENDOR_FREESCALE, PCI_PRODUCT_FREESCALE_MPC8349,
	    "MPC8349",
	},
	{
	    PCI_VENDOR_FREESCALE, PCI_PRODUCT_FREESCALE_MPC8347E_TBGA,
	    "MPC8347E TBGA",
	},
	{
	    PCI_VENDOR_FREESCALE, PCI_PRODUCT_FREESCALE_MPC8347_TBGA,
	    "MPC8347 TBGA",
	},
	{
	    PCI_VENDOR_FREESCALE, PCI_PRODUCT_FREESCALE_MPC8347E_PBGA,
	    "MPC8347E PBGA",
	},
	{
	    PCI_VENDOR_FREESCALE, PCI_PRODUCT_FREESCALE_MPC8347_PBGA,
	    "MPC8347 PBGA",
	},
	{
	    PCI_VENDOR_FREESCALE, PCI_PRODUCT_FREESCALE_MPC8343E,
	    "MPC8343E",
	},
	{
	    PCI_VENDOR_FREESCALE, PCI_PRODUCT_FREESCALE_MPC8343,
	    "MPC8343",
	},
	{
	    PCI_VENDOR_FUJITSU, PCI_PRODUCT_FUJITSU_PW008GE5,
	    "PW008GE5",
	},
	{
	    PCI_VENDOR_FUJITSU, PCI_PRODUCT_FUJITSU_PW008GE4,
	    "PW008GE4",
	},
	{
	    PCI_VENDOR_FUJITSU, PCI_PRODUCT_FUJITSU_PP250_450_LAN,
	    "PRIMEPOWER250/450 LAN",
	},
	{
	    PCI_VENDOR_FUTUREDOMAIN, PCI_PRODUCT_FUTUREDOMAIN_TMC_18C30,
	    "TMC-18C30 (36C70)",
	},
	{
	    PCI_VENDOR_GLOBALSUN, PCI_PRODUCT_GLOBALSUN_GL24110P03,
	    "GL24110P03",
	},
	{
	    PCI_VENDOR_GLOBALSUN, PCI_PRODUCT_GLOBALSUN_GL24110P,
	    "GL24110P",
	},
	{
	    PCI_VENDOR_GLOBALSUN, PCI_PRODUCT_GLOBALSUN_GL24110P02,
	    "GL24110P02",
	},
	{
	    PCI_VENDOR_GLOBESPAN, PCI_PRODUCT_GLOBESPAN_G7370,
	    "Pulsar G7370 ADSL",
	},
	{
	    PCI_VENDOR_GEMTEK, PCI_PRODUCT_GEMTEK_PR103,
	    "PR103",
	},
	{
	    PCI_VENDOR_HAUPPAUGE, PCI_PRODUCT_HAUPPAUGE_WINTV,
	    "WinTV",
	},
	{
	    PCI_VENDOR_HAWKING, PCI_PRODUCT_HAWKING_PN672TX,
	    "PN672TX 10/100",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_VISUALIZE_EG,
	    "Visualize EG",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_VISUALIZE_FX6,
	    "Visualize FX6",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_VISUALIZE_FX4,
	    "Visualize FX4",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_VISUALIZE_FX2,
	    "Visualize FX2",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_TACH_TL,
	    "Tach TL FibreChannel",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_TACH_XL2,
	    "Tach XL2 FibreChannel",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_J2585A,
	    "J2585A",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_J2585B,
	    "J2585B",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_DIVA,
	    "Diva Serial Multiport",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_ELROY,
	    "Elroy Ropes-PCI",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_VISUALIZE_FXE,
	    "Visualize FXe",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_TOPTOOLS,
	    "TopTools Communications Port",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_NETRAID_4M,
	    "NetRaid-4M",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_SMARTIRQ,
	    "NetServer SmartIRQ",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_82557B,
	    "82557B 10/100 NIC",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_PLUTO,
	    "Pluto MIO",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_ZX1_IOC,
	    "zx1 IOC",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_MERCURY,
	    "Mercury Ropes-PCI",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_QUICKSILVER,
	    "QuickSilver Ropes-PCI",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAV100,
	    "Smart Array V100",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAE200I_1,
	    "Smart Array E200i",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAE200,
	    "Smart Array E200",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAE200I_2,
	    "Smart Array E200i",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAE200I_3,
	    "Smart Array E200i",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAE200I_4,
	    "Smart Array E200i",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSA_1,
	    "Smart Array",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSA_2,
	    "Smart Array",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAP800,
	    "Smart Array P800",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAP600,
	    "Smart Array P600",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSA_3,
	    "Smart Array",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSA_4,
	    "Smart Array",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSA_5,
	    "Smart Array",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAE500,
	    "Smart Array E500",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAP400,
	    "Smart Array P400",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAP400I,
	    "Smart Array P400i",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSA_6,
	    "Smart Array",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSA_7,
	    "Smart Array",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSA_8,
	    "Smart Array",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSA_9,
	    "Smart Array",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSA_10,
	    "Smart Array",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSA_11,
	    "Smart Array",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSA_12,
	    "Smart Array",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAP212,
	    "Smart Array P212",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAP410,
	    "Smart Array P410",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAP410I,
	    "Smart Array P410i",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAP411,
	    "Smart Array P411",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_HPSAP812,
	    "Smart Array P812",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_USB,
	    "USB",
	},
	{
	    PCI_VENDOR_HP, PCI_PRODUCT_HP_IPMI,
	    "IPMI",
	},
	{
	    PCI_VENDOR_HIFN, PCI_PRODUCT_HIFN_7751,
	    "7751",
	},
	{
	    PCI_VENDOR_HIFN, PCI_PRODUCT_HIFN_6500,
	    "6500",
	},
	{
	    PCI_VENDOR_HIFN, PCI_PRODUCT_HIFN_7811,
	    "7811",
	},
	{
	    PCI_VENDOR_HIFN, PCI_PRODUCT_HIFN_7951,
	    "7951",
	},
	{
	    PCI_VENDOR_HIFN, PCI_PRODUCT_HIFN_78XX,
	    "7814/7851/7854",
	},
	{
	    PCI_VENDOR_HIFN, PCI_PRODUCT_HIFN_8065,
	    "8065",
	},
	{
	    PCI_VENDOR_HIFN, PCI_PRODUCT_HIFN_8165,
	    "8165",
	},
	{
	    PCI_VENDOR_HIFN, PCI_PRODUCT_HIFN_8154,
	    "8154",
	},
	{
	    PCI_VENDOR_HIFN, PCI_PRODUCT_HIFN_7956,
	    "7956",
	},
	{
	    PCI_VENDOR_HIFN, PCI_PRODUCT_HIFN_7955,
	    "7955/7954",
	},
	{
	    PCI_VENDOR_HINT, PCI_PRODUCT_HINT_HB6_1,
	    "HB6 PCI-PCI",
	},
	{
	    PCI_VENDOR_HINT, PCI_PRODUCT_HINT_HB6_2,
	    "HB6 PCI-PCI",
	},
	{
	    PCI_VENDOR_HINT, PCI_PRODUCT_HINT_HB4,
	    "HB4 PCI-PCI",
	},
	{
	    PCI_VENDOR_HINT, PCI_PRODUCT_HINT_VXPRO_II_HOST,
	    "Host",
	},
	{
	    PCI_VENDOR_HINT, PCI_PRODUCT_HINT_VXPRO_II_ISA,
	    "ISA",
	},
	{
	    PCI_VENDOR_HINT, PCI_PRODUCT_HINT_VXPRO_II_EIDE,
	    "EIDE",
	},
	{
	    PCI_VENDOR_HITACHI, PCI_PRODUCT_HITACHI_SWC,
	    "MSVCC01 Video Capture",
	},
	{
	    PCI_VENDOR_HITACHI, PCI_PRODUCT_HITACHI_SH7751,
	    "SH7751 PCI",
	},
	{
	    PCI_VENDOR_HITACHI, PCI_PRODUCT_HITACHI_SH7751R,
	    "SH7751R PCI",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_0x0002,
	    "MCA",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_0x0005,
	    "CPU - Alta Lite",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_0x0007,
	    "CPU - Alta MP",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_0x000a,
	    "ISA w/PnP",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_0x0017,
	    "CPU",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_0x0018,
	    "Auto LANStreamer",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_GXT150P,
	    "GXT-150P",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_82G2675,
	    "82G2675",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_MCA,
	    "MCA",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_82351,
	    "82351 PCI-PCI",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_SERVERAID,
	    "ServeRAID",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_MIAMI,
	    "Miami/PCI",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_OLYMPIC,
	    "Olympic",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_I82557B,
	    "i82557B 10/100",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_FIREGL2,
	    "FireGL2",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_133PCIX,
	    "133 PCIX-PCIX",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_SERVERAID2,
	    "ServeRAID",
	},
	{
	    PCI_VENDOR_IBM, PCI_PRODUCT_IBM_CALGARY_IOMMU,
	    "Calgary IOMMU",
	},
	{
	    PCI_VENDOR_ICENSEMBLE, PCI_PRODUCT_ICENSEMBLE_ICE1712,
	    "Envy24 I/O Ctrlr",
	},
	{
	    PCI_VENDOR_ICENSEMBLE, PCI_PRODUCT_ICENSEMBLE_VT172x,
	    "Envy24PT/HT Audio",
	},
	{
	    PCI_VENDOR_IDT, PCI_PRODUCT_IDT_77201,
	    "77201/77211 ATM (NICStAR)",
	},
	{
	    PCI_VENDOR_INDCOMPSRC, PCI_PRODUCT_INDCOMPSRC_WDT50x,
	    "WDT 50x Watchdog Timer",
	},
	{
	    PCI_VENDOR_INITIO, PCI_PRODUCT_INITIO_INIC850,
	    "INIC-850 (A100UW)",
	},
	{
	    PCI_VENDOR_INITIO, PCI_PRODUCT_INITIO_INIC1060,
	    "INIC-1060 (A100U2W)",
	},
	{
	    PCI_VENDOR_INITIO, PCI_PRODUCT_INITIO_INIC940,
	    "INIC-940",
	},
	{
	    PCI_VENDOR_INITIO, PCI_PRODUCT_INITIO_INIC941,
	    "INIC-941",
	},
	{
	    PCI_VENDOR_INITIO, PCI_PRODUCT_INITIO_INIC950,
	    "INIC-950",
	},
	{
	    PCI_VENDOR_INNOTEK, PCI_PRODUCT_INNOTEK_VBGA,
	    "VirtualBox Graphics Adapter",
	},
	{
	    PCI_VENDOR_INNOTEK, PCI_PRODUCT_INNOTEK_VBGS,
	    "VirtualBox Guest Service",
	},
	{
	    PCI_VENDOR_INPROCOMM, PCI_PRODUCT_INPROCOMM_IPN2120,
	    "IPN2120",
	},
	{
	    PCI_VENDOR_INPROCOMM, PCI_PRODUCT_INPROCOMM_IPN2220,
	    "IPN2220",
	},
	{
	    PCI_VENDOR_IMS, PCI_PRODUCT_IMS_5026,
	    "5026",
	},
	{
	    PCI_VENDOR_IMS, PCI_PRODUCT_IMS_5027,
	    "5027",
	},
	{
	    PCI_VENDOR_IMS, PCI_PRODUCT_IMS_5028,
	    "5028",
	},
	{
	    PCI_VENDOR_IMS, PCI_PRODUCT_IMS_8849,
	    "8849",
	},
	{
	    PCI_VENDOR_IMS, PCI_PRODUCT_IMS_8853,
	    "8853",
	},
	{
	    PCI_VENDOR_IMS, PCI_PRODUCT_IMS_TT128,
	    "Twin Turbo 128",
	},
	{
	    PCI_VENDOR_IMS, PCI_PRODUCT_IMS_TT3D,
	    "Twin Turbo 3D",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_EESISA,
	    "EES ISA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_21145,
	    "21145",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_80303,
	    "80303 IOP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_80312,
	    "80312 I/O Companion",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_IOXAPIC_A,
	    "IOxAPIC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_IOXAPIC_B,
	    "IOxAPIC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6700PXH_A,
	    "PCIE-PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6700PXH_B,
	    "PCIE-PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6702PXH,
	    "PCIE-PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_IOP332_A,
	    "IOP332 PCIE-PCIX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_IOP332_B,
	    "IOP332 PCIE-PCIX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_IOP331,
	    "IOP331 PCIX-PCIX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_41210_A,
	    "41210 PCIE-PCIX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_41210_B,
	    "41210 PCIE-PCIX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_IOP333_A,
	    "IOP333 PCIE-PCIX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_IOP333_B,
	    "IOP333 PCIE-PCIX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PCEB,
	    "82375EB EISA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_CDC,
	    "82424ZX Cache/DRAM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_SIO,
	    "82378IB ISA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82426EX,
	    "82426EX ISA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PCMC,
	    "82434LX/NX PCI/Cache/DRAM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_GDT_RAID1,
	    "GDT RAID",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_GDT_RAID2,
	    "GDT RAID",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_80960RP,
	    "i960 RP PCI-PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_80960RM,
	    "i960 RM PCI-PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_80960RN,
	    "i960 RN PCI-PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82542,
	    "PRO/1000 (82542)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82543GC_FIBER,
	    "PRO/1000F (82543GC)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_MODEM56,
	    "56k Modem",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82543GC_COPPER,
	    "PRO/1000T (82543GC)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82544EI_COPPER,
	    "PRO/1000XT (82544EI)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82544EI_FIBER,
	    "PRO/1000XF (82544EI)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82544GC_COPPER,
	    "PRO/1000T (82544GC)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82544GC_LOM,
	    "PRO/1000XT (82544GC)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82540EM,
	    "PRO/1000MT (82540EM)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82545EM_COPPER,
	    "PRO/1000MT (82545EM)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82546EB_COPPER,
	    "PRO/1000MT (82546EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82545EM_FIBER,
	    "PRO/1000MF (82545EM)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82546EB_FIBER,
	    "PRO/1000MF (82546EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82541EI,
	    "PRO/1000MT (82541EI)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82541ER_LOM,
	    "PRO/1000MT (82541EI)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82540EM_LOM,
	    "PRO/1000MT (82540EM)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82540EP_LOM,
	    "PRO/1000MT (82540EP)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82540EP,
	    "PRO/1000MT (82540EP)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82541EI_MOBILE,
	    "PRO/1000MT Mobile (82541EI)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82547EI,
	    "PRO/1000CT (82547EI)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82547EI_MOBILE,
	    "PRO/1000CT Mobile (82547EI)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82546EB_QUAD_CPR,
	    "PRO/1000MT QP (82546EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82540EP_LP,
	    "PRO/1000MT (82540EP)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82545GM_COPPER,
	    "PRO/1000MT (82545GM)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82545GM_FIBER,
	    "PRO/1000MF (82545GM)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82545GM_SERDES,
	    "PRO/1000MF (82545GM)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100,
	    "PRO/100",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82559,
	    "82559",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VE_0,
	    "PRO/100 VE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VE_1,
	    "PRO/100 VE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_0,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_1,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82562EH_HPNA_0,
	    "82562EH HomePNA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82562EH_HPNA_1,
	    "82562EH HomePNA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82562EH_HPNA_2,
	    "82562EH HomePNA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_2,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VE_2,
	    "PRO/100 VE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801DB_LAN,
	    "82801DB LAN",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_3,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_4,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VE_3,
	    "PRO/100 VE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_5,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_536EP,
	    "V.92 Modem",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_WL_2100,
	    "PRO/Wireless 2100",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82597EX,
	    "PRO/10GbE LR (82597EX)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH8_IGP_M_AMT,
	    "ICH8 IGP M AMT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH8_IGP_AMT,
	    "ICH8 IGP AMT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH8_IGP_C,
	    "ICH8 IGP C",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH8_IFE,
	    "ICH8 IFE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH8_IGP_M,
	    "ICH8 IGP M",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VE_4,
	    "PRO/100 VE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VE_5,
	    "PRO/100 VE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_6,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_7,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_8,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_9,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_10,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_11,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_12,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_M,
	    "PRO/100 M",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82571EB_COPPER,
	    "PRO/1000 PT (82571EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82571EB_FIBER,
	    "PRO/1000 PF (82571EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82571EB_SERDES,
	    "PRO/1000 PB (82571EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_LAN_2,
	    "82801FB LAN",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VE_6,
	    "PRO/100 VE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_13,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_14,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FBM_LAN,
	    "82801FBM LAN",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_LAN_2,
	    "82801GB LAN",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VE_7,
	    "PRO/100 VE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VE_8,
	    "PRO/100 VE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82547GI,
	    "PRO/1000CT (82547GI)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82541GI,
	    "PRO/1000MT (82541GI)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82541GI_MOBILE,
	    "PRO/1000MT Mobile (82541GI)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82541ER,
	    "PRO/1000MT (82541ER)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82546GB_COPPER,
	    "PRO/1000MT (82546GB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82546GB_FIBER,
	    "PRO/1000MF (82546GB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82546GB_SERDES,
	    "PRO/1000MF (82546GB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82541GI_LF,
	    "PRO/1000GT (82541GI)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82572EI_COPPER,
	    "PRO/1000 PT (82572EI)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82572EI_FIBER,
	    "PRO/1000 PF (82572EI)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82572EI_SERDES,
	    "PRO/1000 PB (82572EI)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82546GB_PCIE,
	    "PRO/1000MT (82546GB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82573E,
	    "PRO/1000MT (82573E)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82573E_IAMT,
	    "PRO/1000MT (82573E)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82573E_IDE,
	    "82573E IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82573E_KCS,
	    "82573E KCS",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82573E_SERIAL,
	    "82573E Serial",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_15,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_16,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_17,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_18,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_VM_19,
	    "PRO/100 VM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_80003ES2LAN_CPR_DPT,
	    "PRO/1000 PT (80003ES2)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_80003ES2LAN_SDS_DPT,
	    "PRO/1000 PF (80003ES2)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82546GB_QUAD_CPR,
	    "PRO/1000MT QP (82546GB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82573L,
	    "PRO/1000MT (82573L)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82546GB_2,
	    "PRO/1000MT (82546GB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82597EX_CX4,
	    "PRO/10GbE CX4 (82597EX)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82571EB_AT,
	    "PRO/1000 AT (82571EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82571EB_AF,
	    "PRO/1000 AF (82571EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82571EB_QUAD_CPR,
	    "PRO/1000 QP (82571EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82571EB_QUAD_FBR,
	    "PRO/1000 QP (82571EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82575EB_COPPER,
	    "PRO/1000 PT (82575EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82575EB_SERDES,
	    "PRO/1000 PF (82575EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82573L_PL_1,
	    "PRO/1000 PL (82573L)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82573V_PM,
	    "PRO/1000 PM (82573V)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82573E_PM,
	    "PRO/1000 PM (82573E)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82573L_PL_2,
	    "PRO/1000 PL (82573L)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82546GB_QUAD_CPR_K,
	    "PRO/1000MT QP (82546GB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82572EI,
	    "PRO/1000 PT (82572EI)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_80003ES2LAN_CPR_SPT,
	    "PRO/1000 PT (80003ES2)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_80003ES2LAN_SDS_SPT,
	    "PRO/1000 PF (80003ES2)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82571EB_QUAD_CPR_LP,
	    "PRO/1000 QP (82571EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH9_IGP_AMT,
	    "ICH9 IGP AMT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH9_IGP_M,
	    "ICH9 IGP M",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH9_IFE,
	    "ICH9 IFE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH9_IFE_G,
	    "ICH9 IFE G",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH9_IFE_GT,
	    "ICH9 IFE GT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH8_IFE_GT,
	    "ICH8 IFE GT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH8_IFE_G,
	    "ICH8 IFE G",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82598AF_DUAL,
	    "10GbE SR Dual (82598AF)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82598AF,
	    "10GbE SR (82598AF)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82598AT,
	    "10GbE (82598AT)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH9_IGP_M_V,
	    "ICH9 IGP M V",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH10_R_BM_LM,
	    "ICH10 R BM LM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH10_R_BM_LF,
	    "ICH10 R BM LF",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH10_R_BM_V,
	    "ICH10 R BM V",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82574L,
	    "PRO/1000 MT (82574L)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82571PT_QUAD_CPR,
	    "PRO/1000 QP (82571PT)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82575GB_QUAD_CPR,
	    "PRO/1000 QP (82575GB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82598AT_DUAL,
	    "10GbE Dual (82598AT)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82571EB_SDS_DUAL,
	    "PRO/1000 PT (82571EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82571EB_SDS_QUAD,
	    "PRO/1000 QP (82571EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82598EB_CX4,
	    "10GbE CX4 (82598EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH10_D_BM_LM,
	    "ICH10 D BM LM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH10_D_BM_LF,
	    "ICH10 D BM LF",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82598_SR_DUAL_EM,
	    "10GbE SR Dual (82598)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH9_BM,
	    "ICH9 BM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82598EB_CX4_DUAL,
	    "10GbE CX4 Dual (82598EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82598_DA_DUAL,
	    "10GbE DA Dual (82598)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82598EB_XF_LR,
	    "10GbE LR (82598EB)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH9_IGP_M_AMT,
	    "ICH9 IGP M AMT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82815_HB,
	    "82815 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82815_AGP,
	    "82815 AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82815_IGD,
	    "82815 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82806AA_APIC,
	    "82806AA APIC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82559ER,
	    "82559ER",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82092AA,
	    "82092AA IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_SAA7116,
	    "SAA7116",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82452_HB,
	    "82452KX/GX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82596,
	    "EE Pro 10 PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_EEPRO100,
	    "EE Pro 100",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_EEPRO100S,
	    "EE Pro 100 Smart",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_8255x,
	    "8255x",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82437FX,
	    "82437FX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82371FB_ISA,
	    "82371FB ISA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82371FB_IDE,
	    "82371FB IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82371MX,
	    "82371 ISA and IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82437MX,
	    "82437 PCI/Cache/DRAM",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82441FX,
	    "82441FX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82380AB,
	    "82380AB Mobile ISA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82380FB,
	    "82380FB Mobile PCI-PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82439HX,
	    "82439HX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82806AA,
	    "82806AA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82870P2_PPB,
	    "82870P2 PCIX-PCIX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82870P2_IOxAPIC,
	    "82870P2 IOxAPIC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82870P2_HPLUG,
	    "82870P2 Hot Plug",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_80960RP_ATU,
	    "80960RP ATU",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82840_HB,
	    "82840 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82840_AGP,
	    "82840 AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82840_PCI,
	    "82840 PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82845_HB,
	    "82845 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82845_AGP,
	    "82845 AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_IOAT,
	    "I/OAT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82597EX_SR,
	    "PRO/10GbE SR (82597EX)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82597EX_LR,
	    "PRO/10GbE LR (82597EX)",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801AA_LPC,
	    "82801AA LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801AA_IDE,
	    "82801AA IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801AA_USB,
	    "82801AA USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801AA_SMB,
	    "82801AA SMBus",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801AA_ACA,
	    "82801AA AC97",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801AA_ACM,
	    "82801AA Modem",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801AA_HPB,
	    "82801AA Hub-to-PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801AB_LPC,
	    "82801AB LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801AB_IDE,
	    "82801AB IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801AB_USB,
	    "82801AB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801AB_SMB,
	    "82801AB SMBus",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801AB_ACA,
	    "82801AB AC97",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801AB_ACM,
	    "82801AB Modem",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801AB_HPB,
	    "82801AB Hub-to-PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801BA_LPC,
	    "82801BA LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801BA_USB,
	    "82801BA USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801BA_SMB,
	    "82801BA SMBus",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801BA_USB2,
	    "82801BA USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801BA_ACA,
	    "82801BA AC97",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801BA_ACM,
	    "82801BA Modem",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801BAM_HPB,
	    "82801BAM Hub-to-PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82562,
	    "82562",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801BAM_IDE,
	    "82801BAM IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801BA_IDE,
	    "82801BA IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801BAM_LPC,
	    "82801BAM LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801BA_HPB,
	    "82801BA Hub-to-PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801E_LPC,
	    "82801E LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801E_USB,
	    "82801E USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801E_SMB,
	    "82801E SMBus",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801E_LAN_1,
	    "82801E LAN",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801E_LAN_2,
	    "82801E LAN",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801CA_LPC,
	    "82801CA LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801CA_USB_1,
	    "82801CA/CAM USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801CA_SMB,
	    "82801CA/CAM SMBus",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801CA_USB_2,
	    "82801CA/CAM USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801CA_ACA,
	    "82801CA/CAM AC97",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801CA_ACM,
	    "82801CA/CAM Modem",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801CA_USB_3,
	    "82801CA/CAM USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801CAM_IDE,
	    "82801CAM IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801CA_IDE,
	    "82801CA IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801CAM_LPC,
	    "82801CAM LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801DB_LPC,
	    "82801DB LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801DBL_IDE,
	    "82801DBL IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801DB_USB_1,
	    "82801DB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801DB_SMB,
	    "82801DB SMBus",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801DB_USB_2,
	    "82801DB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801DB_ACA,
	    "82801DB AC97",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801DB_ACM,
	    "82801DB Modem",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801DB_USB_3,
	    "82801DB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801DBM_IDE,
	    "82801DBM IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801DB_IDE,
	    "82801DB IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801DBM_LPC,
	    "82801DBM LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801DB_USB_4,
	    "82801DB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801EB_LPC,
	    "82801EB/ER LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801EB_SATA,
	    "82801EB SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801EB_USB_1,
	    "82801EB/ER USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801EB_SMB,
	    "82801EB/ER SMBus",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801EB_USB_2,
	    "82801EB/ER USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801EB_ACA,
	    "82801EB/ER AC97",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801EB_MODEM,
	    "82801EB/ER Modem",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801EB_USB_3,
	    "82801EB/ER USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801EB_IDE,
	    "82801EB/ER IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801EB_USB_5,
	    "82801EB/ER USB2",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801EB_USB_4,
	    "82801EB/ER USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801ER_SATA,
	    "82801ER SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82820_HB,
	    "82820 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82820_AGP,
	    "82820 AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82850_HB,
	    "82850 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82860_HB,
	    "82860 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82850_AGP,
	    "82850/82860 AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82860_PCI1,
	    "82860 PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82860_PCI2,
	    "82860 PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82860_PCI3,
	    "82860 PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82860_PCI4,
	    "82860 PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7500_HB,
	    "E7500 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7500_ERR,
	    "E7500 Error Reporting",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7500_PCI_B1,
	    "E7500 PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7500_PCI_B2,
	    "E7500 PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7500_PCI_C1,
	    "E7500 PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7500_PCI_C2,
	    "E7500 PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7500_PCI_D1,
	    "E7500 PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7500_PCI_D2,
	    "E7500 PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7501_HB,
	    "E7501 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7505_HB,
	    "E7505 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7505_ERR,
	    "E7505 Error Reporting",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7505_AGP,
	    "E7505 AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7505_PCI_B1,
	    "E7505 PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7505_PCI_B2,
	    "E7505 PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82845G_HB,
	    "82845G Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82845G_AGP,
	    "82845G AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82845G_IGD,
	    "82845G Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82865G_HB,
	    "82865G Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82865G_AGP,
	    "82865G AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82865G_IGD,
	    "82865G Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82865G_CSA,
	    "82865G CSA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82865G_OVF,
	    "82865G Overflow",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82875P_HB,
	    "82875P Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82875P_AGP,
	    "82875P AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82875P_CSA,
	    "82875P CSA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82915G_HB,
	    "82915G Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82915G_PCIE,
	    "82915G PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82915G_IGD_1,
	    "82915G Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82925X_HB,
	    "82925X Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82925X_PCIE,
	    "82925X PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7221_HB,
	    "E7221 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7221_PCIE,
	    "E7221 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7221_IGD,
	    "E7221 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82915GM_HB,
	    "82915GM Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82915GM_PCIE,
	    "82915GM PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82915GM_IGD_1,
	    "82915GM Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6300ESB_LPC,
	    "6300ESB LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6300ESB_IDE,
	    "6300ESB IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6300ESB_SATA,
	    "6300ESB SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6300ESB_SMB,
	    "6300ESB SMBus",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6300ESB_ACA,
	    "6300ESB AC97",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6300ESB_ACM,
	    "6300ESB Modem",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6300ESB_USB_1,
	    "6300ESB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6300ESB_USB_2,
	    "6300ESB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6300ESB_WDT,
	    "6300ESB WDT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6300ESB_APIC,
	    "6300ESB APIC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6300ESB_USB2,
	    "6300ESB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6300ESB_PCIX,
	    "6300ESB PCIX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6300ESB_SATA2,
	    "6300ESB SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000X_HB,
	    "5000X Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000Z_HB,
	    "5000Z Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000V_HB,
	    "5000V Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000P_HB,
	    "5000P Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000_PCIE_1,
	    "5000 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000_PCIE_2,
	    "5000 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000_PCIE_3,
	    "5000 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000_PCIE_4,
	    "5000 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000_PCIE_5,
	    "5000 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000_PCIE_6,
	    "5000 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000_ERR,
	    "5000 Error Reporting",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000_RESERVED_1,
	    "5000 Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000_RESERVED_2,
	    "5000 Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000_FBD_1,
	    "5000 FBD",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000_FBD_2,
	    "5000 FBD",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000_PCIE_7,
	    "5000 PCIE x8",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000_PCIE_8,
	    "5000 PCIE x8",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000_PCIE_9,
	    "5000 PCIE x8",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5000_PCIE_10,
	    "5000 PCIE x16",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_HB,
	    "E8500 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_PCIE_1,
	    "E8500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_PCIE_2,
	    "E8500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_PCIE_3,
	    "E8500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_PCIE_4,
	    "E8500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_PCIE_5,
	    "E8500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_PCIE_6,
	    "E8500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_PCIE_7,
	    "E8500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_PCIE_8,
	    "E8500 PCIE x8",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_PCIE_9,
	    "E8500 PCIE x8",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_PCIE_10,
	    "E8500 PCIE x8",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_IMI,
	    "E8500 IMI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_FSBINT,
	    "E8500 FSB/Boot/Interrupt",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_AM,
	    "E8500 Address Mapping",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_RAS,
	    "E8500 RAS",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_MISC_1,
	    "E8500 Misc",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_MISC_2,
	    "E8500 Misc",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_MISC_3,
	    "E8500 Misc",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_RES_1,
	    "E8500 Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_RES_2,
	    "E8500 Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_RES_3,
	    "E8500 Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_RES_4,
	    "E8500 Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_RES_5,
	    "E8500 Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_RES_6,
	    "E8500 Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_RES_7,
	    "E8500 Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_RES_8,
	    "E8500 Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_XMB_ID,
	    "E8500 XMB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_XMB_MISC,
	    "E8500 XMB Misc",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_XMB_MAI,
	    "E8500 XMB MAI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_XMB_DDR,
	    "E8500 XMB DDR",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_XMB_RES_1,
	    "E8500 XMB Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_XMB_RES_2,
	    "E8500 XMB Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_XMB_RES_3,
	    "E8500 XMB Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E8500_XMB_RES_4,
	    "E8500 XMB Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_LPC,
	    "82801FB LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FBM_LPC,
	    "82801FBM LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_SATA,
	    "82801FB SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FR_SATA,
	    "82801FR SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FBM_SATA,
	    "82801FBM SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_USB_1,
	    "82801FB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_USB_2,
	    "82801FB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_USB_3,
	    "82801FB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_USB_4,
	    "82801FB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_USB,
	    "82801FB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_PCIE_1,
	    "82801FB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_PCIE_2,
	    "82801FB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_PCIE_3,
	    "82801FB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_PCIE_4,
	    "82801FB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_HDA,
	    "82801FB HD Audio",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_SMB,
	    "82801FB SMBus",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_LAN,
	    "82801FB LAN",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_ACM,
	    "82801FB Modem",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_ACA,
	    "82801FB AC97",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801FB_IDE,
	    "82801FB IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_LPC,
	    "6321ESB LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_SATA,
	    "6321ESB SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_AHCI,
	    "6321ESB AHCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_RAID_1,
	    "6321ESB RAID",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_RAID_2,
	    "6321ESB RAID",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_USB_1,
	    "6321ESB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_USB_2,
	    "6321ESB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_USB_3,
	    "6321ESB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_USB_4,
	    "6321ESB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_USB_5,
	    "6321ESB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_PCIE_1,
	    "6321ESB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_PCIE_2,
	    "6321ESB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_PCIE_3,
	    "6321ESB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_PCIE_4,
	    "6321ESB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_ACA,
	    "6321ESB AC97",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_ACM,
	    "6321ESB Modem",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_HDA,
	    "6321ESB HD Audio",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_SMB,
	    "6321ESB SMBus",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_IDE,
	    "6321ESB IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82945G_HB,
	    "82945G Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82945G_PCIE,
	    "82945G PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82945G_IGD_1,
	    "82945G Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82955X_HB,
	    "82955X Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82955X_PCIE,
	    "82955X PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82945G_IGD_2,
	    "82945G Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7230_HB,
	    "E7230 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7230_PCIE,
	    "E7230 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82975X_PCIE_2,
	    "82975X PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82975X_HB,
	    "82975X Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82975X_PCIE,
	    "82975X PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82915G_IGD_2,
	    "82915G Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82915GM_IGD_2,
	    "82915GM Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82945GM_HB,
	    "82945GM Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82945GM_PCIE,
	    "82945GM PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82945GM_IGD_1,
	    "82945GM Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82945GM_IGD_2,
	    "82945GM Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82945GME_HB,
	    "82945GME Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82945GME_IGD_1,
	    "82945GME Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GH_LPC,
	    "82801GH LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_LPC,
	    "82801GB LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GBM_LPC,
	    "82801GBM LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GHM_LPC,
	    "82801GHM LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_SATA,
	    "82801GB SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GR_AHCI,
	    "82801GR AHCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GR_RAID,
	    "82801GR RAID",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GBM_SATA,
	    "82801GBM SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GBM_AHCI,
	    "82801GBM AHCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GHM_RAID,
	    "82801GHM RAID",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_USB_1,
	    "82801GB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_USB_2,
	    "82801GB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_USB_3,
	    "82801GB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_USB_4,
	    "82801GB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_USB_5,
	    "82801GB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_PCIE_1,
	    "82801GB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_PCIE_2,
	    "82801GB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_PCIE_3,
	    "82801GB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_PCIE_4,
	    "82801GB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_HDA,
	    "82801GB HD Audio",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_SMB,
	    "82801GB SMBus",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_LAN,
	    "82801GB LAN",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_ACM,
	    "82801GB Modem",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_ACA,
	    "82801GB AC97",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801GB_IDE,
	    "82801GB IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801G_PCIE_5,
	    "82801G PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801G_PCIE_6,
	    "82801G PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_LPC,
	    "82801H LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801HEM_LPC,
	    "82801HEM LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801HH_LPC,
	    "82801HH LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801HO_LPC,
	    "82801HO LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801HBM_LPC,
	    "82801HBM LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_SATA_1,
	    "82801H SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_AHCI_6P,
	    "82801H AHCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_RAID,
	    "82801H RAID",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_AHCI_4P,
	    "82801H AHCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_SATA_2,
	    "82801H SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801HBM_SATA,
	    "82801HBM SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801HBM_AHCI,
	    "82801HBM AHCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801HBM_RAID,
	    "82081HBM RAID",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_SMB,
	    "82801H SMBus",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_DMI,
	    "82801H DMI-PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_UHCI_1,
	    "82801H USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_UHCI_2,
	    "82801H USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_UHCI_3,
	    "82801H USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_UHCI_6,
	    "82801H USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_UHCI_4,
	    "82801H USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_UHCI_5,
	    "82801H USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_EHCI_1,
	    "82801H USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_EHCI_2,
	    "82801H USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_PCIE_1,
	    "82801H PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_PCIE_2,
	    "82801H PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_PCIE_3,
	    "82801H PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_PCIE_4,
	    "82801H PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_PCIE_5,
	    "82801H PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_PCIE_6,
	    "82801H PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_HDA,
	    "82801H HD Audio",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801H_TS,
	    "82801H Thermal",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801HBM_IDE,
	    "82801HBM IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801IH_LPC,
	    "82801IH LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801IO_LPC,
	    "82801IO LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801IR_LPC,
	    "82801IR LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801IB_LPC,
	    "82801IB LPC",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_SATA_1,
	    "82801I SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_SATA_2,
	    "82801I SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_AHCI_1,
	    "82801I AHCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_AHCI_2,
	    "82801I AHCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_SATA_3,
	    "82801I SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_SATA_4,
	    "82801I SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_SATA_5,
	    "82801I SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_SATA_6,
	    "82801I SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_SMB,
	    "82801I SMBus",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_TS,
	    "82801I Thermal",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_UHCI_1,
	    "82801I USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_UHCI_2,
	    "82801I USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_UHCI_3,
	    "82801I USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_UHCI_4,
	    "82801I USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_UHCI_5,
	    "82801I USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_UHCI_6,
	    "82801I USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_EHCI_1,
	    "82801I USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_EHCI_2,
	    "82801I USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_HDA,
	    "82801I HD Audio",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_PCIE_1,
	    "82801I PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_PCIE_2,
	    "82801I PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_PCIE_3,
	    "82801I PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_PCIE_4,
	    "82801I PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_PCIE_5,
	    "82801I PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82801I_PCIE_6,
	    "82801I PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_ICH9_IGP_C,
	    "ICH9 IGP C",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82946GZ_HB,
	    "82946GZ Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82946GZ_PCIE,
	    "82946GZ PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82946GZ_IGD_1,
	    "82946GZ Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82946GZ_IGD_2,
	    "82946GZ Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82946GZ_HECI_1,
	    "82946GZ HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82946GZ_HECI_2,
	    "82946GZ HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82946GZ_PT_IDER,
	    "82946GZ PT IDER",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82946GZ_KT,
	    "82946GZ KT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G35_HB,
	    "82G35 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G35_PCIE,
	    "82G35 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G35_IGD_1,
	    "82G35 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G35_IGD_2,
	    "82G35 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G35_HECI,
	    "82G35 HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q965_HB,
	    "82Q965 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q965_PCIE,
	    "82Q965 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q965_IGD_1,
	    "82Q965 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q965_IGD_2,
	    "82Q965 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q965_HECI_1,
	    "82Q965 HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q965_HECI_2,
	    "82Q965 HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q965_PT_IDER,
	    "82Q965 PT IDER",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q965_KT,
	    "82Q965 KT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G965_HB,
	    "82G965 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G965_PCIE,
	    "82G965 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G965_IGD_1,
	    "82G965 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G965_IGD_2,
	    "82G965 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G965_HECI_1,
	    "82G965 HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G965_HECI_2,
	    "82G965 HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G965_PT_IDER,
	    "82G965 PT IDER",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G965_KT,
	    "82G965 KT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q35_HB,
	    "82Q35 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q35_PCIE,
	    "82Q35 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q35_IGD_1,
	    "82Q35 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q35_IGD_2,
	    "82Q35 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q35_HECI_1,
	    "82Q35 HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q35_HECI_2,
	    "82Q35 HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q35_PT_IDER,
	    "82Q35 PT IDER",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q35_KT,
	    "82Q35 KT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G33_HB,
	    "82G33 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G33_PCIE,
	    "82G33 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G33_IGD_1,
	    "82G33 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G33_IGD_2,
	    "82G33 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G33_HECI_1,
	    "82G33 HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G33_HECI_2,
	    "82G33 HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G33_PT_IDER,
	    "82G33 PT IDER",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82G33_KT,
	    "82G33 KT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q33_HB,
	    "82Q33 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q33_PCIE,
	    "82Q33 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q33_IGD_1,
	    "82Q33 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q33_IGD_2,
	    "82Q33 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q33_HECI_1,
	    "82Q33 HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q33_HECI_2,
	    "82Q33 HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q33_PT_IDER,
	    "82Q33 PT IDER",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82Q33_KT,
	    "82Q33 KT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82X38_HB,
	    "82X38 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82X38_PCIE_1,
	    "82X38 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82X38_HECI_1,
	    "82X38 HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82X38_HECI_2,
	    "82X38 HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82X38_PT_IDER,
	    "82X38 PT IDER",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82X38_KT,
	    "82X38 KT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82X38_PCIE_2,
	    "82X38 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_3200_HB,
	    "3200/3210 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_3200_PCIE,
	    "3200/3210 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_3210_PCIE,
	    "3210 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82GM965_HB,
	    "GM965 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82GM965_PCIE,
	    "GM965 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82GM965_IGD_1,
	    "GM965 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82GM965_IGD_2,
	    "GM965 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82GME965_HB,
	    "GME965 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82GME965_PCIE,
	    "GME965 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82GME965_IGD_1,
	    "GME965 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82GME965_IGD_2,
	    "GME965 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82GME965_HECI_1,
	    "GME965 HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82GME965_HECI_2,
	    "GME965 HECI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82GME965_PT_IDER,
	    "GME965 PT IDER",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82GME965_KT,
	    "GME965 KT",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_RCU32,
	    "RCU32 I2O RAID",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_3124,
	    "3124 SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_31244,
	    "31244 SATA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82855PM_HB,
	    "82855PM Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82855PM_AGP,
	    "82855PM AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82855PM_PM,
	    "82855PM Power",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_PCIE_5,
	    "6321ESB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_PCIX,
	    "6321ESB PCIE-PCIX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_PCIE_6,
	    "6321ESB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_PCIE_7,
	    "6321ESB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_PCIE_8,
	    "6321ESB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_PCIE_9,
	    "6321ESB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_PCIE_10,
	    "6321ESB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_6321ESB_PCIE_11,
	    "6321ESB PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82830M_HB,
	    "82830M Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82830M_AGP,
	    "82830M AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82830M_IGD,
	    "82830M Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82855GM_HB,
	    "82855GM Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82855GME_AGP,
	    "82855GME AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82855GM_IGD,
	    "82855GM Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82855GM_MEM,
	    "82855GM Memory",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82855GM_CFG,
	    "82855GM Config",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82854_HB,
	    "82854 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82854_IGD,
	    "82854 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7520_HB,
	    "E7520 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7520_ERR,
	    "E7520 Error Reporting",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7320_HB,
	    "E7320 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7320_ERR,
	    "E7320 Error Reporting",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7520_DMA,
	    "E7520 DMA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7520_PCIE_A0,
	    "E7520 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7520_PCIE_A1,
	    "E7520 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7520_PCIE_B0,
	    "E7520 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7520_PCIE_B1,
	    "E7520 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7520_PCIE_C0,
	    "E7520 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7520_PCIE_C1,
	    "E7520 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7520_CFG,
	    "E7520 Config",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E7525_HB,
	    "E7525 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_IOAT_CNB,
	    "I/OAT CNB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E5400_HB,
	    "E4500 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E4500_PCIE_1,
	    "E4500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E4500_PCIE_2,
	    "E4500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E4500_PCIE_3,
	    "E4500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E4500_PCIE_4,
	    "E4500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E4500_PCIE_5,
	    "E4500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E4500_PCIE_6,
	    "E4500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E4500_PCIE_7,
	    "E4500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E4500_PCIE_8,
	    "E4500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_E4500_PCIE_9,
	    "E4500 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_IOAT_SNB,
	    "I/OAT SNB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_WL_2200BG,
	    "PRO/Wireless 2200BG",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_WL_2225BG,
	    "PRO/Wireless 2225BG",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_WL_3945ABG_1,
	    "PRO/Wireless 3945ABG",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_WL_2915ABG_1,
	    "PRO/Wireless 2915ABG",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_WL_2915ABG_2,
	    "PRO/Wireless 2915ABG",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_WL_3945ABG_2,
	    "PRO/Wireless 3945ABG",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_WL_4965AGN_1,
	    "Wireless WiFi Link 4965AGN",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_WL_4965AGN_2,
	    "Wireless WiFi Link 4965AGN",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_TURBO_MEMORY,
	    "Turbo Memory",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_80960RD,
	    "i960 RD PCI-PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PRO_100_SERVER,
	    "PRO 100 Server",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_HB,
	    "5100 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_PCIE_2,
	    "5100 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_PCIE_3,
	    "5100 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_PCIE_4,
	    "5100 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_PCIE_5,
	    "5100 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_PCIE_6,
	    "5100 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_PCIE_7,
	    "5100 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_FSB,
	    "5100 FSB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_RESERVED_1,
	    "5100 Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_RESERVED_2,
	    "5100 Reserved",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_DDR,
	    "5100 DDR",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_DDR2,
	    "5100 DDR",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_PCIE_23,
	    "5100 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_PCIE_45,
	    "5100 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_PCIE_67,
	    "5100 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_5100_PCIE_47,
	    "5100 PCIE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_IOAT_SCNB,
	    "I/OAT SCNB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82371SB_ISA,
	    "82371SB ISA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82371SB_IDE,
	    "82371SB IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82371USB,
	    "82371SB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82437VX,
	    "82437VX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82439TX,
	    "82439TX System",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82371AB_ISA,
	    "82371AB PIIX4 ISA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82371AB_IDE,
	    "82371AB IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82371AB_USB,
	    "82371AB USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82371AB_PM,
	    "82371AB Power",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82810_HB,
	    "82810 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82810_IGD,
	    "82810 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82810_DC100_HB,
	    "82810-DC100 Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82810_DC100_IGD,
	    "82810-DC100 Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82810E_HB,
	    "82810E Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82810E_IGD,
	    "82810E Video",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82443LX,
	    "82443LX AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82443LX_AGP,
	    "82443LX AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82443BX,
	    "82443BX AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82443BX_AGP,
	    "82443BX AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82443BX_NOAGP,
	    "82443BX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82440MX_HB,
	    "82440MX Host",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82440MX_ACA,
	    "82440MX AC97",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82440MX_ACM,
	    "82440MX Modem",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82440MX_ISA,
	    "82440MX ISA",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82440MX_IDE,
	    "82440MX IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82440MX_USB,
	    "82440MX USB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82440MX_PM,
	    "82440MX Power",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82440BX,
	    "82440BX AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82440BX_AGP,
	    "82440BX AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82443GX,
	    "82443GX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82372FB_IDE,
	    "82372FB IDE",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82740,
	    "82740 AGP",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PCI450_PB,
	    "82450KX/GX",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_PCI450_MC,
	    "82450KX/GX Memory",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82451NX,
	    "82451NX Mem & IO",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82454NX,
	    "82454NX PXB",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82802AC,
	    "82802AC Firmware Hub 8Mbit",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_82802AB,
	    "82802AB Firmware Hub 4Mbit",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_I2OPCIB,
	    "I2O RAID PCI-PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_RCU21,
	    "RCU21 I2O RAID",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_RCUxx,
	    "RCUxx I2O RAID",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_RCU31,
	    "RCU31 I2O RAID",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_RCU31L,
	    "RCU31L I2O RAID",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_21152,
	    "S21152BB PCI-PCI",
	},
	{
	    PCI_VENDOR_INTEL, PCI_PRODUCT_INTEL_21154,
	    "S21154AE/BE PCI-PCI",
	},
	{
	    PCI_VENDOR_INTERGRAPH, PCI_PRODUCT_INTERGRAPH_4D50T,
	    "Powerstorm 4D50T",
	},
	{
	    PCI_VENDOR_INTERGRAPH, PCI_PRODUCT_INTERGRAPH_INTENSE3D,
	    "Intense 3D",
	},
	{
	    PCI_VENDOR_INTERGRAPH, PCI_PRODUCT_INTERGRAPH_EXPERT3D,
	    "Expert3D",
	},
	{
	    PCI_VENDOR_INTERPHASE, PCI_PRODUCT_INTERPHASE_5526,
	    "5526 FibreChannel",
	},
	{
	    PCI_VENDOR_INTERSIL, PCI_PRODUCT_INTERSIL_ISL3872,
	    "PRISM3",
	},
	{
	    PCI_VENDOR_INTERSIL, PCI_PRODUCT_INTERSIL_MINI_PCI_WLAN,
	    "PRISM2.5",
	},
	{
	    PCI_VENDOR_INTERSIL, PCI_PRODUCT_INTERSIL_ISL3877,
	    "Prism Indigo",
	},
	{
	    PCI_VENDOR_INTERSIL, PCI_PRODUCT_INTERSIL_ISL3886,
	    "Prism Javelin/Xbow",
	},
	{
	    PCI_VENDOR_INTERSIL, PCI_PRODUCT_INTERSIL_ISL3890,
	    "Prism GT/Duette",
	},
	{
	    PCI_VENDOR_INVERTEX, PCI_PRODUCT_INVERTEX_AEON,
	    "AEON",
	},
	{
	    PCI_VENDOR_IODATA, PCI_PRODUCT_IODATA_GV_BCTV3,
	    "GV-BCTV3",
	},
	{
	    PCI_VENDOR_ITT, PCI_PRODUCT_ITT_AGX016,
	    "AGX016",
	},
	{
	    PCI_VENDOR_ITT, PCI_PRODUCT_ITT_ITT3204,
	    "ITT3204 MPEG Decoder",
	},
	{
	    PCI_VENDOR_ITEXPRESS, PCI_PRODUCT_ITEXPRESS_IT8211F,
	    "IT8211F",
	},
	{
	    PCI_VENDOR_ITEXPRESS, PCI_PRODUCT_ITEXPRESS_IT8212F,
	    "IT8212F",
	},
	{
	    PCI_VENDOR_ITEXPRESS, PCI_PRODUCT_ITEXPRESS_IT8213F,
	    "IT8213F",
	},
	{
	    PCI_VENDOR_ITEXPRESS, PCI_PRODUCT_ITEXPRESS_IT8330G,
	    "IT8330G",
	},
	{
	    PCI_VENDOR_ITEXPRESS, PCI_PRODUCT_ITEXPRESS_IT8888F_ISA,
	    "IT8888F ISA",
	},
	{
	    PCI_VENDOR_JMICRON, PCI_PRODUCT_JMICRON_JMC250,
	    "JMC250",
	},
	{
	    PCI_VENDOR_JMICRON, PCI_PRODUCT_JMICRON_JMC260,
	    "JMC260",
	},
	{
	    PCI_VENDOR_JMICRON, PCI_PRODUCT_JMICRON_JMB360,
	    "JMB360 SATA",
	},
	{
	    PCI_VENDOR_JMICRON, PCI_PRODUCT_JMICRON_JMB361,
	    "JMB361 IDE/SATA",
	},
	{
	    PCI_VENDOR_JMICRON, PCI_PRODUCT_JMICRON_JMB362,
	    "JMB362 SATA",
	},
	{
	    PCI_VENDOR_JMICRON, PCI_PRODUCT_JMICRON_JMB363,
	    "JMB363 IDE/SATA",
	},
	{
	    PCI_VENDOR_JMICRON, PCI_PRODUCT_JMICRON_JMB365,
	    "JMB365 IDE/SATA",
	},
	{
	    PCI_VENDOR_JMICRON, PCI_PRODUCT_JMICRON_JMB366,
	    "JMB366 IDE/SATA",
	},
	{
	    PCI_VENDOR_JMICRON, PCI_PRODUCT_JMICRON_JMB368,
	    "JMB368 IDE",
	},
	{
	    PCI_VENDOR_KTI, PCI_PRODUCT_KTI_KTIE,
	    "KTI",
	},
	{
	    PCI_VENDOR_LMC, PCI_PRODUCT_LMC_HSSI,
	    "HSSI",
	},
	{
	    PCI_VENDOR_LMC, PCI_PRODUCT_LMC_DS3,
	    "DS3",
	},
	{
	    PCI_VENDOR_LMC, PCI_PRODUCT_LMC_SSI,
	    "SSI",
	},
	{
	    PCI_VENDOR_LMC, PCI_PRODUCT_LMC_DS1,
	    "DS1",
	},
	{
	    PCI_VENDOR_LMC, PCI_PRODUCT_LMC_HSSIC,
	    "HSSIc",
	},
	{
	    PCI_VENDOR_LANERGY, PCI_PRODUCT_LANERGY_APPIAN_PCI_LITE,
	    "Appian Lite",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_TWOSP_2S,
	    "Dual Serial",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_QUATTRO_AB,
	    "Dual Serial",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_QUATTRO_CD,
	    "Dual Serial",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_IOFLEX_2S_0,
	    "Serial",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_IOFLEX_2S_1,
	    "Serial",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_QUATTRO_AB2,
	    "Dual Serial",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_QUATTRO_CD2,
	    "Dual Serial",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_OCTOPUS550_0,
	    "Quad Serial",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_OCTOPUS550_1,
	    "Quad Serial",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_LAVAPORT_2,
	    "Serial",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_LAVAPORT_0,
	    "Serial",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_LAVAPORT_1,
	    "Serial",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_650,
	    "Serial",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_TWOSP_1P,
	    "Parallel",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_PARALLEL2,
	    "Dual Parallel",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_PARALLEL2A,
	    "Dual Parallel",
	},
	{
	    PCI_VENDOR_LAVA, PCI_PRODUCT_LAVA_PARALLELB,
	    "Dual Parallel",
	},
	{
	    PCI_VENDOR_LEADTEK, PCI_PRODUCT_LEADTEK_S3_805,
	    "S3 805",
	},
	{
	    PCI_VENDOR_LEADTEK, PCI_PRODUCT_LEADTEK_WINFAST,
	    "Leadtek WinFast TV 2000",
	},
	{
	    PCI_VENDOR_LEADTEK, PCI_PRODUCT_LEADTEK_WINFAST_XP,
	    "Leadtek WinFast TV 2000 XP",
	},
	{
	    PCI_VENDOR_LEVEL1, PCI_PRODUCT_LEVEL1_LXT1001,
	    "LXT1001",
	},
	{
	    PCI_VENDOR_LINKSYS, PCI_PRODUCT_LINKSYS_EG1032,
	    "EG1032",
	},
	{
	    PCI_VENDOR_LINKSYS, PCI_PRODUCT_LINKSYS_EG1064,
	    "EG1064",
	},
	{
	    PCI_VENDOR_LINKSYS, PCI_PRODUCT_LINKSYS_PCMPC200,
	    "PCMPC200",
	},
	{
	    PCI_VENDOR_LINKSYS, PCI_PRODUCT_LINKSYS_PCM200,
	    "PCM200",
	},
	{
	    PCI_VENDOR_LITEON, PCI_PRODUCT_LITEON_PNIC,
	    "PNIC",
	},
	{
	    PCI_VENDOR_LITEON, PCI_PRODUCT_LITEON_PNICII,
	    "PNIC-II",
	},
	{
	    PCI_VENDOR_GLOBALSUN, PCI_PRODUCT_GLOBALSUN_8031,
	    "8031",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM,
	    "K56flex DSVD LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0441,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0442,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0443,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0444,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0445,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0446,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0447,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0448,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0449,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_044A,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_044B,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_044C,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_044D,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_044E,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0450,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0451,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0452,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0453,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0454,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0455,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0456,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0457,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0458,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_0459,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_045A,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_045C,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_LTMODEM_048c,
	    "LTMODEM",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_VENUSMODEM,
	    "Venus Modem",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_USBHC,
	    "USB",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_USBHC2,
	    "USB 2-port",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_USBQBUS,
	    "USB QuadraBus",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_FW322,
	    "FW322 1394",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_ET1310_GBE,
	    "ET1310",
	},
	{
	    PCI_VENDOR_LUCENT, PCI_PRODUCT_LUCENT_ET1310_FE,
	    "ET1310",
	},
	{
	    PCI_VENDOR_LUXSONOR, PCI_PRODUCT_LUXSONOR_LS242,
	    "LS242 DVD Decoder",
	},
	{
	    PCI_VENDOR_MACRONIX, PCI_PRODUCT_MACRONIX_MX98713,
	    "PMAC 98713",
	},
	{
	    PCI_VENDOR_MACRONIX, PCI_PRODUCT_MACRONIX_MX98715,
	    "PMAC 98715",
	},
	{
	    PCI_VENDOR_MACRONIX, PCI_PRODUCT_MACRONIX_MX98727,
	    "PMAC 98727",
	},
	{
	    PCI_VENDOR_MACRONIX, PCI_PRODUCT_MACRONIX_MX86250,
	    "MX86250",
	},
	{
	    PCI_VENDOR_MADGE, PCI_PRODUCT_MADGE_SMARTRN,
	    "Smart 16/4 PCI Ringnode",
	},
	{
	    PCI_VENDOR_MADGE, PCI_PRODUCT_MADGE_SMARTRN2,
	    "Smart 16/4 PCI Ringnode Mk2",
	},
	{
	    PCI_VENDOR_MADGE, PCI_PRODUCT_MADGE_SMARTRN3,
	    "Smart 16/4 PCI Ringnode Mk3",
	},
	{
	    PCI_VENDOR_MADGE, PCI_PRODUCT_MADGE_SMARTRN1,
	    "Smart 16/4 PCI Ringnode Mk1",
	},
	{
	    PCI_VENDOR_MADGE, PCI_PRODUCT_MADGE_164CB,
	    "16/4 Cardbus",
	},
	{
	    PCI_VENDOR_MADGE, PCI_PRODUCT_MADGE_PRESTO,
	    "Presto PCI",
	},
	{
	    PCI_VENDOR_MADGE, PCI_PRODUCT_MADGE_SMARTHSRN100,
	    "Smart 100/16/4 PCI-HS Ringnode",
	},
	{
	    PCI_VENDOR_MADGE, PCI_PRODUCT_MADGE_SMARTRN100,
	    "Smart 100/16/4 PCI Ringnode",
	},
	{
	    PCI_VENDOR_MADGE, PCI_PRODUCT_MADGE_164CB2,
	    "16/4 CardBus Mk2",
	},
	{
	    PCI_VENDOR_MADGE, PCI_PRODUCT_MADGE_COLLAGE25,
	    "Collage 25 ATM",
	},
	{
	    PCI_VENDOR_MADGE, PCI_PRODUCT_MADGE_COLLAGE155,
	    "Collage 155 ATM",
	},
	{
	    PCI_VENDOR_MARTINMARIETTA, PCI_PRODUCT_MARTINMARIETTA_I740,
	    "i740 PCI",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88W8300_1,
	    "Libertas 88W8300",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88W8310,
	    "Libertas 88W8310",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88W8335_1,
	    "Libertas 88W8335",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88W8335_2,
	    "Libertas 88W8335",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88W8300_2,
	    "Libertas 88W8300",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON,
	    "Yukon 88E8001/8003/8010",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8021CU,
	    "Yukon 88E8021CU",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8022CU,
	    "Yukon 88E8022CU",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8061CU,
	    "Yukon 88E8061CU",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8062CU,
	    "Yukon 88E8062CU",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8021X,
	    "Yukon 88E8021X",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8022X,
	    "Yukon 88E8022X",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8061X,
	    "Yukon 88E8061X",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8062X,
	    "Yukon 88E8062X",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8035,
	    "Yukon 88E8035",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8036,
	    "Yukon 88E8036",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8038,
	    "Yukon 88E8038",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8039,
	    "Yukon 88E8039",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8040,
	    "Yukon 88E8040",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8040T,
	    "Yukon 88E8040T",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_C033,
	    "Yukon 88EC033",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8042,
	    "Yukon 88E8042",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8048,
	    "Yukon 88E8048",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8052,
	    "Yukon 88E8052",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8050,
	    "Yukon 88E8050",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8053,
	    "Yukon 88E8053",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8055,
	    "Yukon 88E8055",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8056,
	    "Yukon 88E8056",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8070,
	    "Yukon 88E8070",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_C036,
	    "Yukon 88EC036",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_C032,
	    "Yukon 88EC032",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_C034,
	    "Yukon 88EC034",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_C042,
	    "Yukon 88EC042",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8058,
	    "Yukon 88E8058",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8071,
	    "Yukon 88E8071",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8072,
	    "Yukon 88E8072",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8055_2,
	    "Yukon 88E8055",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_8075,
	    "Yukon 88E8075",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_YUKON_BELKIN,
	    "Yukon (Belkin F5D5005)",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SX5040,
	    "88SX5040 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SX5041,
	    "88SX5041 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SX5080,
	    "88SX5080 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SX5081,
	    "88SX5081 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SX6040,
	    "88SX6040 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SX6041,
	    "88SX6041 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SX6042,
	    "88SX6042 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SX6080,
	    "88SX6080 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SX6081,
	    "88SX6081 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SE6101,
	    "88SE6101 IDE",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SE6111,
	    "88SE6111 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SE6120,
	    "88SE6120 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SE6121,
	    "88SE6121 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SE6122,
	    "88SE6122 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SE6140,
	    "88SE6140 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SE6141,
	    "88SE6141 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SE6145,
	    "88SE6145 SATA",
	},
	{
	    PCI_VENDOR_MARVELL, PCI_PRODUCT_MARVELL_88SX7042,
	    "88SX7042 SATA",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_ATLAS,
	    "MGA PX2085 (Atlas)",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_MILLENIUM,
	    "MGA Millenium 2064W (Storm)",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_MYSTIQUE_220,
	    "MGA 1064SG 220MHz",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_MILLENNIUM_II,
	    "MGA Millennium II 2164W",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_MILLENNIUM_IIAGP,
	    "MGA Millennium II 2164WA-B AGP",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_MILL_II_G200_PCI,
	    "MGA G200 PCI",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_MILL_II_G200_AGP,
	    "MGA G200 AGP",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_G200E_SE,
	    "MGA G200e (ServerEngines)",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_MILL_II_G400_AGP,
	    "MGA G400/G450 AGP",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_IMPRESSION,
	    "MGA Impression",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_PRODUCTIVA_PCI,
	    "MGA G100 PCI",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_PRODUCTIVA_AGP,
	    "MGA G100 AGP",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_MYSTIQUE,
	    "MGA 1064SG",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_G400_TH,
	    "MGA G400 Twin Head",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_MILL_II_G550_AGP,
	    "MGA G550 AGP",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_MILL_P650_PCIE,
	    "MGA P650 PCIe",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_MILL_G200_SD,
	    "MGA Millennium G200 SD",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_PROD_G100_SD,
	    "MGA Produktiva G100 SD",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_MYST_G200_SD,
	    "MGA Mystique G200 SD",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_MILL_G200_SG,
	    "MGA Millennium G200 SG",
	},
	{
	    PCI_VENDOR_MATROX, PCI_PRODUCT_MATROX_MARV_G200_SD,
	    "MGA Marvel G200 SD",
	},
	{
	    PCI_VENDOR_MEINBERG, PCI_PRODUCT_MEINBERG_PCI32,
	    "PCI32",
	},
	{
	    PCI_VENDOR_MEINBERG, PCI_PRODUCT_MEINBERG_PCI509,
	    "PCI509",
	},
	{
	    PCI_VENDOR_MEINBERG, PCI_PRODUCT_MEINBERG_PCI511,
	    "PCI511",
	},
	{
	    PCI_VENDOR_MEINBERG, PCI_PRODUCT_MEINBERG_PEX511,
	    "PEX511",
	},
	{
	    PCI_VENDOR_MEINBERG, PCI_PRODUCT_MEINBERG_GPS170PCI,
	    "GPS170PCI",
	},
	{
	    PCI_VENDOR_MELLANOX, PCI_PRODUCT_MELLANOX_CONNECTX_EN,
	    "ConnectX EN",
	},
	{
	    PCI_VENDOR_MENTOR, PCI_PRODUCT_MENTOR_PCI0660,
	    "PCI",
	},
	{
	    PCI_VENDOR_MENTOR, PCI_PRODUCT_MENTOR_PCI0661,
	    "PCI-PCI",
	},
	{
	    PCI_VENDOR_MICREL, PCI_PRODUCT_MICREL_KSZ8841,
	    "KSZ8841 10/100",
	},
	{
	    PCI_VENDOR_MICREL, PCI_PRODUCT_MICREL_KSZ8842,
	    "KSZ8842 dual-port 10/100 switch",
	},
	{
	    PCI_VENDOR_MICROSOFT, PCI_PRODUCT_MICROSOFT_MN120,
	    "MN-120 10/100",
	},
	{
	    PCI_VENDOR_MICROSOFT, PCI_PRODUCT_MICROSOFT_MN130,
	    "MN-130 10/100",
	},
	{
	    PCI_VENDOR_MIRO, PCI_PRODUCT_MIRO_2IVDC,
	    "2IVDC-PCX1",
	},
	{
	    PCI_VENDOR_MIRO, PCI_PRODUCT_MIRO_DC20,
	    "MiroVIDEO DC20",
	},
	{
	    PCI_VENDOR_MIRO, PCI_PRODUCT_MIRO_MEDIA3D,
	    "Media 3D",
	},
	{
	    PCI_VENDOR_MIRO, PCI_PRODUCT_MIRO_DC10,
	    "MiroVIDEO DC10/DC20",
	},
	{
	    PCI_VENDOR_MITSUBISHIELEC, PCI_PRODUCT_MITSUBISHIELEC_4D30T,
	    "Powerstorm 4D30T",
	},
	{
	    PCI_VENDOR_MITSUBISHIELEC, PCI_PRODUCT_MITSUBISHIELEC_GUI,
	    "GUI Accel",
	},
	{
	    PCI_VENDOR_MOT, PCI_PRODUCT_MOT_MPC105,
	    "MPC105 PCI",
	},
	{
	    PCI_VENDOR_MOT, PCI_PRODUCT_MOT_MPC106,
	    "MPC106 PCI",
	},
	{
	    PCI_VENDOR_MOT, PCI_PRODUCT_MOT_SM56,
	    "SM56",
	},
	{
	    PCI_VENDOR_MOT, PCI_PRODUCT_MOT_RAVEN,
	    "Raven PCI",
	},
	{
	    PCI_VENDOR_MOXA, PCI_PRODUCT_MOXA_CP114,
	    "CP-114",
	},
	{
	    PCI_VENDOR_MOXA, PCI_PRODUCT_MOXA_C104H,
	    "C104H",
	},
	{
	    PCI_VENDOR_MOXA, PCI_PRODUCT_MOXA_CP104,
	    "CP-104UL",
	},
	{
	    PCI_VENDOR_MOXA, PCI_PRODUCT_MOXA_C168H,
	    "C168H",
	},
	{
	    PCI_VENDOR_MRTMAGMA, PCI_PRODUCT_MRTMAGMA_DMA4,
	    "DMA4 serial",
	},
	{
	    PCI_VENDOR_MYLEX, PCI_PRODUCT_MYLEX_960P_V2,
	    "DAC960P V2 RAID",
	},
	{
	    PCI_VENDOR_MYLEX, PCI_PRODUCT_MYLEX_960P_V3,
	    "DAC960P V3 RAID",
	},
	{
	    PCI_VENDOR_MYLEX, PCI_PRODUCT_MYLEX_960P_V4,
	    "DAC960P V4 RAID",
	},
	{
	    PCI_VENDOR_MYLEX, PCI_PRODUCT_MYLEX_960P_V5,
	    "DAC960P V5 RAID",
	},
	{
	    PCI_VENDOR_MYLEX, PCI_PRODUCT_MYLEX_ACCELERAID,
	    "AcceleRAID",
	},
	{
	    PCI_VENDOR_MYLEX, PCI_PRODUCT_MYLEX_EXTREMERAID,
	    "eXtremeRAID",
	},
	{
	    PCI_VENDOR_MYRICOM, PCI_PRODUCT_MYRICOM_Z8E,
	    "Z8E",
	},
	{
	    PCI_VENDOR_MYRICOM, PCI_PRODUCT_MYRICOM_LANAI_92,
	    "Myrinet LANai 9.2",
	},
	{
	    PCI_VENDOR_MYSON, PCI_PRODUCT_MYSON_MTD800,
	    "MTD800 10/100",
	},
	{
	    PCI_VENDOR_MYSON, PCI_PRODUCT_MYSON_MTD803,
	    "MTD803 10/100",
	},
	{
	    PCI_VENDOR_MYSON, PCI_PRODUCT_MYSON_MTD891,
	    "MTD891 10/100/1000",
	},
	{
	    PCI_VENDOR_MUTECH, PCI_PRODUCT_MUTECH_MV1000,
	    "MV1000",
	},
	{
	    PCI_VENDOR_NDC, PCI_PRODUCT_NDC_NCP130,
	    "NCP130",
	},
	{
	    PCI_VENDOR_NDC, PCI_PRODUCT_NDC_NCP130A2,
	    "NCP130 Rev A2",
	},
	{
	    PCI_VENDOR_NATINST, PCI_PRODUCT_NATINST_PCIGPIB,
	    "PCI-GPIB",
	},
	{
	    PCI_VENDOR_NETCHIP, PCI_PRODUCT_NETCHIP_NET2282,
	    "NET2282 USB",
	},
	{
	    PCI_VENDOR_NETXEN, PCI_PRODUCT_NETXEN_NXB_10GXxR,
	    "NXB-10GXxR (NX2031)",
	},
	{
	    PCI_VENDOR_NETXEN, PCI_PRODUCT_NETXEN_NXB_10GCX4,
	    "NXB-10GCX4 (NX2031)",
	},
	{
	    PCI_VENDOR_NETXEN, PCI_PRODUCT_NETXEN_NXB_4GCU,
	    "NXB-4GCU (NX2035)",
	},
	{
	    PCI_VENDOR_NETXEN, PCI_PRODUCT_NETXEN_NXB_IMEZ,
	    "IMEZ 10GbE",
	},
	{
	    PCI_VENDOR_NETXEN, PCI_PRODUCT_NETXEN_NXB_HMEZ,
	    "HMEZ 10GbE",
	},
	{
	    PCI_VENDOR_NETXEN, PCI_PRODUCT_NETXEN_NXB_IMEZ_2,
	    "IMEZ 10GbE Mgmt",
	},
	{
	    PCI_VENDOR_NETXEN, PCI_PRODUCT_NETXEN_NXB_HMEZ_2,
	    "HMEZ 10GbE Mgmt",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_DP83810,
	    "DP83810 10/100",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_PC87415,
	    "PC87415 IDE",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_PC87560,
	    "87560 Legacy I/O",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_USB,
	    "USB",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_DP83815,
	    "DP83815 10/100",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_DP83820,
	    "DP83820 10/100/1000",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_CS5535_HB,
	    "CS5535 Host",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_CS5535_ISA,
	    "CS5535 ISA",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_CS5535_IDE,
	    "CS5535 IDE",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_CS5535_AUDIO,
	    "CS5535 AUDIO",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_CS5535_USB,
	    "CS5535 USB",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_CS5535_VIDEO,
	    "CS5535 VIDEO",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_SATURN,
	    "Saturn",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_SCx200_ISA,
	    "SCx200 ISA",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_SCx200_SMI,
	    "SCx200 SMI",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_SCx200_IDE,
	    "SCx200 IDE",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_SCx200_AUDIO,
	    "SCx200 AUDIO",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_SCx200_VIDEO,
	    "SCx200 VIDEO",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_SCx200_XBUS,
	    "SCx200 X-BUS",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_SC1100_ISA,
	    "SC1100 ISA",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_SC1100_SMI,
	    "SC1100 SMI",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_SC1100_XBUS,
	    "SC1100 X-Bus",
	},
	{
	    PCI_VENDOR_NS, PCI_PRODUCT_NS_NS87410,
	    "NS87410",
	},
	{
	    PCI_VENDOR_NEC, PCI_PRODUCT_NEC_USB,
	    "USB",
	},
	{
	    PCI_VENDOR_NEC, PCI_PRODUCT_NEC_POWERVR2,
	    "PowerVR PCX2",
	},
	{
	    PCI_VENDOR_NEC, PCI_PRODUCT_NEC_MARTH,
	    "I/O",
	},
	{
	    PCI_VENDOR_NEC, PCI_PRODUCT_NEC_PKUG,
	    "I/O",
	},
	{
	    PCI_VENDOR_NEC, PCI_PRODUCT_NEC_uPD72874,
	    "Firewire",
	},
	{
	    PCI_VENDOR_NEC, PCI_PRODUCT_NEC_USB2,
	    "USB",
	},
	{
	    PCI_VENDOR_NEC, PCI_PRODUCT_NEC_uPD720400,
	    "PCIE-PCIX",
	},
	{
	    PCI_VENDOR_NEC, PCI_PRODUCT_NEC_VERSAMAESTRO,
	    "Versa Maestro",
	},
	{
	    PCI_VENDOR_NEC, PCI_PRODUCT_NEC_VERSAPRONXVA26D,
	    "Versa Va26D Maestro",
	},
	{
	    PCI_VENDOR_NEOMAGIC, PCI_PRODUCT_NEOMAGIC_NM2070,
	    "Magicgraph NM2070",
	},
	{
	    PCI_VENDOR_NEOMAGIC, PCI_PRODUCT_NEOMAGIC_128V,
	    "Magicgraph 128V",
	},
	{
	    PCI_VENDOR_NEOMAGIC, PCI_PRODUCT_NEOMAGIC_128ZV,
	    "Magicgraph 128ZV",
	},
	{
	    PCI_VENDOR_NEOMAGIC, PCI_PRODUCT_NEOMAGIC_NM2160,
	    "Magicgraph NM2160",
	},
	{
	    PCI_VENDOR_NEOMAGIC, PCI_PRODUCT_NEOMAGIC_NM2200,
	    "Magicgraph NM2200",
	},
	{
	    PCI_VENDOR_NEOMAGIC, PCI_PRODUCT_NEOMAGIC_NM2360,
	    "Magicgraph NM2360",
	},
	{
	    PCI_VENDOR_NEOMAGIC, PCI_PRODUCT_NEOMAGIC_NM2230,
	    "MagicMedia 256AV+",
	},
	{
	    PCI_VENDOR_NEOMAGIC, PCI_PRODUCT_NEOMAGIC_NM256XLP,
	    "MagicMedia 256XL+",
	},
	{
	    PCI_VENDOR_NEOMAGIC, PCI_PRODUCT_NEOMAGIC_NM256AV,
	    "MagicMedia 256AV",
	},
	{
	    PCI_VENDOR_NEOMAGIC, PCI_PRODUCT_NEOMAGIC_NM256ZX,
	    "MagicMedia 256ZX",
	},
	{
	    PCI_VENDOR_NETERION, PCI_PRODUCT_NETERION_XFRAME,
	    "Xframe",
	},
	{
	    PCI_VENDOR_NETERION, PCI_PRODUCT_NETERION_XFRAME_2,
	    "Xframe II",
	},
	{
	    PCI_VENDOR_NETGEAR, PCI_PRODUCT_NETGEAR_MA301,
	    "MA301",
	},
	{
	    PCI_VENDOR_NETGEAR, PCI_PRODUCT_NETGEAR_GA620,
	    "GA620",
	},
	{
	    PCI_VENDOR_NETGEAR, PCI_PRODUCT_NETGEAR_GA620T,
	    "GA620T",
	},
	{
	    PCI_VENDOR_NETMOS, PCI_PRODUCT_NETMOS_NM9805,
	    "Nm9805",
	},
	{
	    PCI_VENDOR_NETMOS, PCI_PRODUCT_NETMOS_NM9835,
	    "Nm9835",
	},
	{
	    PCI_VENDOR_NETMOS, PCI_PRODUCT_NETMOS_NM9845,
	    "Nm9845",
	},
	{
	    PCI_VENDOR_NETSEC, PCI_PRODUCT_NETSEC_7751,
	    "7751",
	},
	{
	    PCI_VENDOR_CMI, PCI_PRODUCT_CMI_CMI8338A,
	    "CMI8338A Audio",
	},
	{
	    PCI_VENDOR_CMI, PCI_PRODUCT_CMI_CMI8338B,
	    "CMI8338B Audio",
	},
	{
	    PCI_VENDOR_CMI, PCI_PRODUCT_CMI_CMI8738,
	    "CMI8738/C3DX Audio",
	},
	{
	    PCI_VENDOR_CMI, PCI_PRODUCT_CMI_CMI8738B,
	    "CMI8738B Audio",
	},
	{
	    PCI_VENDOR_CMI, PCI_PRODUCT_CMI_HSP56,
	    "HSP56 AMR",
	},
	{
	    PCI_VENDOR_NETOCTAVE, PCI_PRODUCT_NETOCTAVE_NSP2K,
	    "NSP2K",
	},
	{
	    PCI_VENDOR_NETVIN, PCI_PRODUCT_NETVIN_NV5000,
	    "NetVin 5000",
	},
	{
	    PCI_VENDOR_NEWBRIDGE, PCI_PRODUCT_NEWBRIDGE_CA91CX42,
	    "Universe VME",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1000,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1001,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1002,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1010,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1011,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1012,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1020,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1021,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1030,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1031,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1032,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1034,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1035,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1036,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1050,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1051,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_1052,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2000,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2001,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2002,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2010,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2011,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2012,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2020,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2021,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2030,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2031,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2032,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2040,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2041,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2042,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2050,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2051,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2052,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2060,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2061,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2062,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2081,
	    "I/O",
	},
	{
	    PCI_VENDOR_SIIG, PCI_PRODUCT_SIIG_2082,
	    "I/O",
	},
	{
	    PCI_VENDOR_SOLARFLARE, PCI_PRODUCT_SOLARFLARE_FALCON_P,
	    "Falcon P",
	},
	{
	    PCI_VENDOR_SOLARFLARE, PCI_PRODUCT_SOLARFLARE_FALCON_S,
	    "Falcon S",
	},
	{
	    PCI_VENDOR_SOLARFLARE, PCI_PRODUCT_SOLARFLARE_EF1002,
	    "EF1002",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_810,
	    "53c810",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_820,
	    "53c820",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_825,
	    "53c825",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_815,
	    "53c815",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_810AP,
	    "53c810AP",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_860,
	    "53c860",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_1510D,
	    "53c1510D",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_896,
	    "53c896",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_895,
	    "53c895",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_885,
	    "53c885",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_875,
	    "53c875",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_1510,
	    "53c1510",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_895A,
	    "53c895A",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_1010,
	    "53c1010-33",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_1010_2,
	    "53c1010-66",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_1030,
	    "53c1030",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_1030ZC,
	    "53c1030ZC",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_1030_1035,
	    "53c1035",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_1030ZC_1035,
	    "53c1035",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_1035,
	    "53c1035",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_1035ZC,
	    "53c1035ZC",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_SAS1064,
	    "SAS1064",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_SAS1068,
	    "SAS1068",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_SAS1068_2,
	    "SAS1068",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_SAS1064E,
	    "SAS1064E",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_SAS1064E_2,
	    "SAS1064E",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_SAS1068E,
	    "SAS1068E",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_SAS1068E_2,
	    "SAS1068E",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_SAS1066E,
	    "SAS1066E",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_SAS1064A,
	    "SAS1064A",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_SAS1066,
	    "SAS1066",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_SAS1078,
	    "SAS1078",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_SAS1078_PCIE,
	    "SAS1078",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_875J,
	    "53c875J",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_MEGARAID_320,
	    "MegaRAID 320",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_MEGARAID_3202E,
	    "MegaRAID 320-2E",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_MEGARAID_SATA,
	    "MegaRAID SATA 4x/8x",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_MEGARAID_SAS,
	    "MegaRAID SAS 1064R",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_MEGARAID_VERDE_ZCR,
	    "MegaRAID Verde ZCR",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_FC909,
	    "FC909",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_FC909A,
	    "FC909A",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_FC929,
	    "FC929",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_FC929_1,
	    "FC929",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_FC919,
	    "FC919",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_FC919_1,
	    "FC919",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_FC929X,
	    "FC929X",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_FC919X,
	    "FC919X",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_FC949X,
	    "FC949X",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_FC939X,
	    "FC939X",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_FC949E,
	    "FC949E",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_YELLOWFIN_1,
	    "Yellowfin",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_YELLOWFIN_2,
	    "Yellowfin",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_61C102,
	    "61C102",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_63C815,
	    "63C815",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_1030R,
	    "53c1030R",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_MEGARAID,
	    "MegaRAID",
	},
	{
	    PCI_VENDOR_SYMBIOS, PCI_PRODUCT_SYMBIOS_PE_GNIC,
	    "Packet Engines G-NIC",
	},
	{
	    PCI_VENDOR_PERICOM, PCI_PRODUCT_PERICOM_PI7C21P100,
	    "PI7C21P100 PCIX-PCIX",
	},
	{
	    PCI_VENDOR_PERICOM, PCI_PRODUCT_PERICOM_PPB_1,
	    "PCI-PCI",
	},
	{
	    PCI_VENDOR_PERICOM, PCI_PRODUCT_PERICOM_PPB_2,
	    "PCI-PCI",
	},
	{
	    PCI_VENDOR_PLANEX, PCI_PRODUCT_PLANEX_FNW_3603_TX,
	    "FNW-3603-TX 10/100",
	},
	{
	    PCI_VENDOR_PLANEX, PCI_PRODUCT_PLANEX_FNW_3800_TX,
	    "FNW-3800-TX 10/100",
	},
	{
	    PCI_VENDOR_NEXGEN, PCI_PRODUCT_NEXGEN_NX82C501,
	    "NX82C501 PCI",
	},
	{
	    PCI_VENDOR_NKK, PCI_PRODUCT_NKK_NDR4600,
	    "NDR4600 PCI",
	},
	{
	    PCI_VENDOR_NORTEL, PCI_PRODUCT_NORTEL_BS21,
	    "BS21 10/100",
	},
	{
	    PCI_VENDOR_NORTEL, PCI_PRODUCT_NORTEL_211818A,
	    "E-mobility Wireless",
	},
	{
	    PCI_VENDOR_NUMBER9, PCI_PRODUCT_NUMBER9_I128,
	    "Imagine-128",
	},
	{
	    PCI_VENDOR_NUMBER9, PCI_PRODUCT_NUMBER9_I128_2,
	    "Imagine-128 II",
	},
	{
	    PCI_VENDOR_NUMBER9, PCI_PRODUCT_NUMBER9_I128_T2R,
	    "Imagine-128 T2R",
	},
	{
	    PCI_VENDOR_NUMBER9, PCI_PRODUCT_NUMBER9_I128_T2R4,
	    "Imagine-128 T2R4",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NV1,
	    "NV1",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_DAC64,
	    "DAC64",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_RIVA_TNT,
	    "Riva TNT",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_RIVA_TNT2,
	    "Riva TNT2",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_RIVA_TNT2_ULTRA,
	    "Riva TNT2 Ultra",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_VANTA1,
	    "Vanta",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_VANTA2,
	    "Vanta",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP04_ISA,
	    "MCP04 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP04_SMB,
	    "MCP04 SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP04_IDE,
	    "MCP04 IDE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP04_SATA,
	    "MCP04 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP04_LAN1,
	    "MCP04 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP04_LAN2,
	    "MCP04 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP04_AC97,
	    "MCP04 AC97",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP04_OHCI,
	    "MCP04 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP04_ECHI,
	    "MCP04 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP04_PPB,
	    "MCP04 PCI-PCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP04_SATA2,
	    "MCP04 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE4_ISA,
	    "nForce4 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE4_ISA2,
	    "nForce4 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE4_SMB,
	    "nForce4 SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE4_ATA133,
	    "nForce4 IDE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE4_SATA1,
	    "nForce4 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE4_SATA2,
	    "nForce4 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_CK804_LAN1,
	    "CK804 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_CK804_LAN2,
	    "CK804 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE4_AC,
	    "nForce4 AC97",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE4_USB,
	    "nForce4 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE4_USB2,
	    "nForce4 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE4_PPB,
	    "nForce4 PCI-PCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE4_PPB2,
	    "nForce4 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE4_MEM,
	    "nForce4 DDR",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_ISA,
	    "nForce2 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_SMB,
	    "nForce2 SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_IDE,
	    "nForce2 IDE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_LAN,
	    "nForce2 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_USB,
	    "nForce2 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_USB2,
	    "nForce2 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_ACA,
	    "nForce2 AC97",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_APU,
	    "nForce2 Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_PPB,
	    "nForce2 PCI-PCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_PPB2,
	    "nForce2 PCI-PCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_FW,
	    "nForce2 FireWire",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP04_PPB2,
	    "MCP04 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_400_ISA,
	    "nForce2 400 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_400_SMB,
	    "nForce2 400 SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_400_IDE,
	    "nForce2 400 IDE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_LAN2,
	    "nForce3 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_400_USB,
	    "nForce2 400 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_400_USB2,
	    "nForce2 400 USB2",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_400_ACA,
	    "nForce2 400 AC97",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_400_PPB,
	    "nForce2 400 PCI-PCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_LAN3,
	    "nForce3 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_400_SATA,
	    "nForce2 400 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_ITNT2,
	    "Aladdin TNT2",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6800GO,
	    "GeForce Go 6800",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6800GO_U,
	    "GeForce Go 6800 Ultra",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADROFXGO1400,
	    "Quadro FX Go1400",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADROFX1400,
	    "Quadro FX 1400",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_ISA,
	    "nForce3 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_PCHB,
	    "nForce3 PCI Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_PPB2,
	    "nForce3 PCI-PCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_CK804_MEM,
	    "CK804",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_SMB,
	    "nForce3 SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_IDE,
	    "nForce3 IDE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_LAN1,
	    "nForce3 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_USB,
	    "nForce3 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_USB2,
	    "nForce3 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_MODEM,
	    "nForce3 Modem",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_ACA,
	    "nForce3 AC97",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_PPB,
	    "nForce3 PCI-PCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_LAN4,
	    "nForce3 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_250_ISA,
	    "nForce3 250 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_250_PCHB,
	    "nForce3 250 PCI Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_250_AGP,
	    "nForce3 250 AGP",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_250_SATA,
	    "nForce3 250 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_250_SMB,
	    "nForce3 250 SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_250_IDE,
	    "nForce3 250 IDE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_LAN5,
	    "nForce3 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_250_USB,
	    "nForce3 250 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_250_USB2,
	    "nForce3 250 USB2",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_250_ACA,
	    "nForce3 250 AC97",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_250_PPB,
	    "nForce3 250 PCI-PCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE3_250_SATA2,
	    "nForce3 250 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6600GTAGP,
	    "GeForce 6600 GT AGP",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6600_3,
	    "GeForce 6600",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE7800GS,
	    "GeForce 7800 GS",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6800GT,
	    "GeForce 6800 GT",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADROFX330,
	    "Quadro FX 330",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE256,
	    "GeForce256",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE256_DDR,
	    "GeForce256 DDR",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADOR,
	    "Quadro",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE2MX,
	    "GeForce2 MX",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE2MX_100,
	    "GeForce2 MX 100",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE2GO,
	    "GeForce2 Go",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADRO2_MXR,
	    "Quadro2 MXR",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6600GT,
	    "GeForce 6600 GT",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6600,
	    "GeForce 6600",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6600_2,
	    "GeForce 6600",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6600GO,
	    "GeForce 6600 Go",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6600GO_2,
	    "GeForce 6600 Go",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE2GTS,
	    "GeForce2 GTS",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE2TI,
	    "GeForce2 Ti",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE2ULTRA,
	    "GeForce2 Ultra",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADRO2PRO,
	    "Quadro2 Pro",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6200,
	    "GeForce 6200",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADRONVS285,
	    "Quadro NVS 285",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEGO6200,
	    "GeForce Go 6200",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4MX460,
	    "GeForce4 MX 460",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4MX440,
	    "GeForce4 MX 440",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4MX420,
	    "GeForce4 MX 420",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4440GO,
	    "GeForce4 440 Go",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4420GO,
	    "GeForce4 420 Go",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4420GOM32,
	    "GeForce4 420 Go 32M",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADRO4500XGL,
	    "Quadro4 500XGL",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4440GOM64,
	    "GeForce4 440 Go 64M",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADRO4200,
	    "Quadro4 200/400NVS",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADRO4550XGL,
	    "Quadro4 550XGL",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADRO4500GOGL,
	    "Quadro4 GoGL",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4MX440AGP8,
	    "GeForce4 MX 440 AGP",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4MX440SEAGP8,
	    "GeForce4 MX 440SE AGP",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4MX420AGP8,
	    "GeForce 4 MX 420 AGP",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4MX4000,
	    "GeForce4 MX 4000",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADRO4_580XGL,
	    "Quadro4 580 XGL",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADRO4NVS,
	    "Quadro4 NVS",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADRO4_380XGL,
	    "Quadro4 380 XGL",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE8800GTX,
	    "GeForce 8800 GTX",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE8800GTS,
	    "GeForce 8800 GTS",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE2_11,
	    "GeForce2 Crush11",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE_PCHB,
	    "nForce PCI Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE_DDR2,
	    "nForce 220 DDR",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE_DDR,
	    "nForce 420 DDR",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE_MEM,
	    "nForce 220/420",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE_MEM1,
	    "nForce 220/420",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE_APU,
	    "nForce APU",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE_ACA,
	    "nForce AC97",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE_ISA,
	    "nForce ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE_SMB,
	    "nForce SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE_AGP,
	    "nForce AGP",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE_PPB,
	    "nForce PCI-PCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE_IDE,
	    "nForce IDE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE_USB,
	    "nForce USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE_LAN,
	    "nForce LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE7300LE,
	    "GeForce 7300 LE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE7200GS,
	    "GeForce 7200 GS",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE7300GO,
	    "GeForce 7300 Go",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE7400GO,
	    "GeForce 7400 Go",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE7300GS,
	    "GeForce 7300 GS",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_PCHB,
	    "nForce2 PCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_AGP,
	    "nForce2 AGP",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_MEM0,
	    "nForce2",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_MEM1,
	    "nForce2",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_MEM2,
	    "nForce2",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_MEM3,
	    "nForce2",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_MEM4,
	    "nForce2",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_NFORCE2_MEM5,
	    "nForce2",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4MXNFORCE,
	    "GeForce4 MX nForce GPU",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE3,
	    "GeForce3",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE3TI200,
	    "GeForce3 Ti 200",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE3TI500,
	    "GeForce3 Ti 500",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADRO_DCC,
	    "Quadro DCC",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6200_2,
	    "GeForce 6200",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6150,
	    "GeForce 6150",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6150LE,
	    "GeForce 6150 LE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6100,
	    "GeForce 6100",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEGO6100,
	    "GeForce Go 6100",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4TI4600,
	    "GeForce4 Ti 4600",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4TI4400,
	    "GeForce4 Ti 4400",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4TI4200,
	    "GeForce4 Ti 4200",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADRO4900XGL,
	    "Quadro4 900 XGL",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADRO4750XGL,
	    "Quadro4 750 XGL",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADRO4700XGL,
	    "Quadro4 700 XGL",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_ISA1,
	    "MCP51 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_ISA2,
	    "MCP51 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_ISA3,
	    "MCP51 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_ISA4,
	    "MCP51 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_SMB,
	    "MCP51 SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_IDE,
	    "MCP51 IDE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_SATA,
	    "MCP51 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_SATA2,
	    "MCP51 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_LAN1,
	    "MCP51 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_LAN2,
	    "MCP51 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_ACA,
	    "MCP51 AC97",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_HDA,
	    "MCP51 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_OHCI,
	    "MCP51 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_EHCI,
	    "MCP51 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_PPB,
	    "MCP51 PCI-PCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_HB,
	    "MCP51 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_PMU,
	    "MCP51 PMU",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP51_MEM,
	    "MCP51 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_MEM_2,
	    "C51 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_MEM_3,
	    "C51 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4TI4800,
	    "GeForce4 Ti 4800",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4TI4200_2,
	    "GeForce4 Ti 4200",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE4TI4200GO,
	    "GeForce4 Ti 4200 Go",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE7900GT,
	    "GeForce 7900 GT/GTO",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADROFX3500,
	    "Quadro FX 3500",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE7600GT_2,
	    "GeForce 7600 GT",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE7600GS_2,
	    "GeForce 7600 GS",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_HB_1,
	    "C51 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_HB_2,
	    "C51 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_HB_3,
	    "C51 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_HB_4,
	    "C51 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_HB_5,
	    "C51 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_HB_6,
	    "C51 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_HB_7,
	    "C51 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_HB_8,
	    "C51 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_MEM_5,
	    "C51 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_MEM_4,
	    "C51 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_MEM_0,
	    "C51 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_PCIE_0,
	    "C51 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_PCIE_1,
	    "C51 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_PCIE_2,
	    "C51 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_MEM_1,
	    "C51 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C51_MEM_6,
	    "C51 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFX5800_U,
	    "GeForce FX 5800 Ultra",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFX5800,
	    "GeForce FX 5800",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFX5600_U,
	    "GeForce FX 5600 Ultra",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFX5600,
	    "GeForce FX 5600",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFXGO5600,
	    "GeForce FX Go 5600",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFXGO5650,
	    "GeForce FX Go 5650",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFX5200_U,
	    "GeForce FX 5200 Ultra",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFX5200,
	    "GeForce FX 5200",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFXGO5200,
	    "GeForce FX Go 5200",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFX5500,
	    "GeForce FX 5500",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFX5100,
	    "GeForce FX 5100",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFXGO5200_3,
	    "GeForce FX Go 5200",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFXGO5200_2,
	    "GeForce FX Go 5200",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADROFX500,
	    "Quadro FX 500/600",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFXGO5300,
	    "GeForce FX Go 5300",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFXGO5100,
	    "GeForce FX Go 5100",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFX5900_U,
	    "GeForce FX 5900 Ultra",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFX5900,
	    "GeForce FX 5900",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFX5950_U,
	    "GeForce FX 5950 Ultra",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFX5700LE,
	    "GeForce FX 5700LE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFXGO5700_2,
	    "GeForce FX Go 5700",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCEFXGO5700,
	    "GeForce FX Go 5700",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_ISA1,
	    "MCP55 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_ISA2,
	    "MCP55 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_ISA3,
	    "MCP55 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_ISA4,
	    "MCP55 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_ISA5,
	    "MCP55 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_ISA6,
	    "MCP55 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_ISA7,
	    "MCP55 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_ISA8,
	    "MCP55 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_SMB,
	    "MCP55 SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_USB_1,
	    "MCP55 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_USB_2,
	    "MCP55 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_IDE,
	    "MCP55 IDE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_MEM2,
	    "MCP55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_MEM3,
	    "MCP55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_OHCI,
	    "MCP55 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_EHCI,
	    "MCP55 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_PPB_6,
	    "MCP55 PCI-PCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_HDA,
	    "MCP55 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_LAN1,
	    "MCP55 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_LAN2,
	    "MCP55 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_PPB_1,
	    "MCP55 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_PPB_2,
	    "MCP55 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_PPB_3,
	    "MCP55 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_PPB_4,
	    "MCP55 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_PPB_5,
	    "MCP55 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_MEM,
	    "MCP55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_SATA,
	    "MCP55 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP55_SATA2,
	    "MCP55 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE7600GT,
	    "GeForce 7600 GT",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE7600GS,
	    "GeForce 7600 GS",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE7300GT,
	    "GeForce 7300 GT",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_HB_1,
	    "C55 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_HB_2,
	    "C55 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_HB_3,
	    "C55 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_HB_4,
	    "C55 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_HB_5,
	    "C55 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_HB_6,
	    "C55 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_HB_7,
	    "C55 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_HB_8,
	    "C55 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_1,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_2,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_3,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_4,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_5,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_6,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_7,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_8,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_9,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_10,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_11,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_12,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_13,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_14,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_15,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_PCIE_0,
	    "C55 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_PCIE_1,
	    "C55 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_PCIE_2,
	    "C55 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_16,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_PCIE_3,
	    "C55 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_C55_MEM_17,
	    "C55 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6100_430,
	    "GeForce 6100 nForce 430",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE6100_405,
	    "GeForce 6100 nForce 405",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_ISA,
	    "MCP61 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_HDA_1,
	    "MCP61 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_LAN1,
	    "MCP61 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_LAN2,
	    "MCP61 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_SATA,
	    "MCP61 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_PPB_1,
	    "MCP61 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_PPB_2,
	    "MCP61 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_MEM,
	    "MCP61 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_SMB,
	    "MCP61 SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_IDE,
	    "MCP61 IDE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_LAN3,
	    "MCP61 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_LAN4,
	    "MCP61 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_HDA_2,
	    "MCP61 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_OHCI,
	    "MCP61 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_EHCI,
	    "MPC61 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_PPB_3,
	    "MCP61",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_SMU,
	    "MCP61 SMU",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_MEM2,
	    "MCP61 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_SATA2,
	    "MCP61 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP61_SATA3,
	    "MCP61 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE8600_GT,
	    "GeForce 8600 GT",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE8600M_GT,
	    "GeForce 8600M GT",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_QUADROFX570M,
	    "Quadro FX 570M",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE8400_GS,
	    "GeForce 8400 GS",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE8400M_G,
	    "GeForce 8400M G",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_ISA,
	    "MCP65 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_ISA2,
	    "MCP65 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_MEM,
	    "MCP65 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_MEM2,
	    "MCP65 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_SMB,
	    "MCP65 SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_IDE,
	    "MCP65 IDE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_PCI,
	    "MCP65 PCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_HDA_1,
	    "MCP65 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_HDA_2,
	    "MCP65 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_AHCI_1,
	    "MCP65 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_AHCI_2,
	    "MCP65 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_AHCI_3,
	    "MCP65 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_AHCI_4,
	    "MCP65 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_LAN1,
	    "MCP65 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_LAN2,
	    "MCP65 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_LAN3,
	    "MCP65 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_LAN4,
	    "MCP65 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_USB_1,
	    "MCP65 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_USB_2,
	    "MCP65 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_USB_3,
	    "MCP65 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_USB_4,
	    "MCP65 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_PPB_1,
	    "MCP65 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_PPB_2,
	    "MCP65 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_PPB_3,
	    "MCP65 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_SATA,
	    "MCP65 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_SATA2,
	    "MCP65 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_SATA3,
	    "MCP65 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP65_SATA4,
	    "MCP65 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE7000M,
	    "GeForce 7000M",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_MEM2,
	    "MCP67 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_SMB,
	    "MCP67 SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_MEM_1,
	    "MCP67 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_HB_1,
	    "MCP67 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_LAN1,
	    "MCP67 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_LAN2,
	    "MCP67 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_LAN3,
	    "MCP67 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_LAN4,
	    "MCP67 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_SATA,
	    "MCP67 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_SATA2,
	    "MCP67 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_SATA3,
	    "MCP67 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_SATA4,
	    "MCP67 SATA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_AHCI_1,
	    "MCP67 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_AHCI_2,
	    "MCP67 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_AHCI_3,
	    "MCP67 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_AHCI_4,
	    "MCP67 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_AHCI_5,
	    "MCP67 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_AHCI_6,
	    "MCP67 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_AHCI_7,
	    "MCP67 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_AHCI_8,
	    "MCP67 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_HDA_1,
	    "MCP67 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_HDA_2,
	    "MCP67 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_OHCI,
	    "MCP67 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_EHCI,
	    "MCP67 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_IDE,
	    "MCP67 IDE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_PPB_1,
	    "MCP67 PCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP67_PPB_2,
	    "MCP67 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_EHCI,
	    "MCP73 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_IDE,
	    "MCP73 IDE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_PPB_1,
	    "MCP73 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_PPB_2,
	    "MCP73 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_PPB_3,
	    "MCP73 PCIE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_IDE,
	    "MCP77 IDE",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_SMB,
	    "MCP77 SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_LAN1,
	    "MCP77 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_LAN2,
	    "MCP77 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_LAN3,
	    "MCP77 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_LAN4,
	    "MCP77 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_HDA_1,
	    "MCP77 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_HDA_2,
	    "MCP77 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_HDA_3,
	    "MCP77 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_HDA_4,
	    "MCP77 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_HB_1,
	    "MCP73 Host",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_MEM11,
	    "MCP73 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_MEM,
	    "MCP73 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_MEM2,
	    "MCP73 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_MEM3,
	    "MCP73 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_MEM4,
	    "MCP73 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_MEM5,
	    "MCP73 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_MEM6,
	    "MCP73 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_MEM7,
	    "MCP73 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_MEM8,
	    "MCP73 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_MEM9,
	    "MCP73 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_ISA,
	    "MCP73 ISA",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_SMB,
	    "MCP73 SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_MEM10,
	    "MCP73 Memory",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_LAN1,
	    "MCP73 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_LAN2,
	    "MCP73 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_LAN3,
	    "MCP73 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_LAN4,
	    "MCP73 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_GEFORCE7050,
	    "GeForce 7050",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_AHCI_1,
	    "MCP73 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_AHCI_2,
	    "MCP73 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_AHCI_3,
	    "MCP73 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_AHCI_4,
	    "MCP73 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_AHCI_5,
	    "MCP73 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_AHCI_6,
	    "MCP73 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_AHCI_7,
	    "MCP73 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_AHCI_8,
	    "MCP73 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_AHCI_9,
	    "MCP73 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_AHCI_10,
	    "MCP73 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_AHCI_11,
	    "MCP73 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_AHCI_12,
	    "MCP73 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_HDA_1,
	    "MCP73 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_HDA_2,
	    "MCP73 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP73_OHCI,
	    "MCP73 USB",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_SMB,
	    "MCP79 SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_LAN1,
	    "MCP79 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_LAN2,
	    "MCP79 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_LAN3,
	    "MCP79 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_LAN4,
	    "MCP79 LAN",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_AHCI_1,
	    "MCP79 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_AHCI_2,
	    "MCP79 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_AHCI_3,
	    "MCP79 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_AHCI_4,
	    "MCP79 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_AHCI_5,
	    "MCP79 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_AHCI_6,
	    "MCP79 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_AHCI_7,
	    "MCP79 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_AHCI_8,
	    "MCP79 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_AHCI_9,
	    "MCP79 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_AHCI_10,
	    "MCP79 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_AHCI_11,
	    "MCP79 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_AHCI_12,
	    "MCP79 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_HDA_1,
	    "MCP79 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_HDA_2,
	    "MCP79 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_HDA_3,
	    "MCP79 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP79_HDA_4,
	    "MCP79 HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_AHCI_1,
	    "MCP77 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_AHCI_2,
	    "MCP77 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_AHCI_3,
	    "MCP77 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_AHCI_4,
	    "MCP77 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_AHCI_5,
	    "MCP77 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_AHCI_6,
	    "MCP77 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_AHCI_7,
	    "MCP77 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_AHCI_8,
	    "MCP77 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_AHCI_9,
	    "MCP77 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_AHCI_10,
	    "MCP77 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_AHCI_11,
	    "MCP77 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP77_AHCI_12,
	    "MCP77 AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_SMB,
	    "MCP7B SMBus",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_AHCI_1,
	    "MCP7B AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_AHCI_2,
	    "MCP7B AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_AHCI_3,
	    "MCP7B AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_AHCI_4,
	    "MCP7B AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_AHCI_5,
	    "MCP7B AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_AHCI_6,
	    "MCP7B AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_AHCI_7,
	    "MCP7B AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_AHCI_8,
	    "MCP7B AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_AHCI_9,
	    "MCP7B AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_AHCI_10,
	    "MCP7B AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_AHCI_11,
	    "MCP7B AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_AHCI_12,
	    "MCP7B AHCI",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_HDA_1,
	    "MCP7B HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_HDA_2,
	    "MCP7B HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_HDA_3,
	    "MCP7B HD Audio",
	},
	{
	    PCI_VENDOR_NVIDIA, PCI_PRODUCT_NVIDIA_MCP7B_HDA_4,
	    "MCP7B HD Audio",
	},
	{
	    PCI_VENDOR_OAKTECH, PCI_PRODUCT_OAKTECH_OTI1007,
	    "OTI107",
	},
	{
	    PCI_VENDOR_OLICOM, PCI_PRODUCT_OLICOM_OC2325,
	    "OC2325",
	},
	{
	    PCI_VENDOR_OLICOM, PCI_PRODUCT_OLICOM_OC2183,
	    "OC2183",
	},
	{
	    PCI_VENDOR_OLICOM, PCI_PRODUCT_OLICOM_OC2326,
	    "OC2326",
	},
	{
	    PCI_VENDOR_OMEGA, PCI_PRODUCT_OMEGA_82C092G,
	    "82C092G",
	},
	{
	    PCI_VENDOR_OPTI, PCI_PRODUCT_OPTI_82C557,
	    "82C557 Host",
	},
	{
	    PCI_VENDOR_OPTI, PCI_PRODUCT_OPTI_82C558,
	    "82C558 ISA",
	},
	{
	    PCI_VENDOR_OPTI, PCI_PRODUCT_OPTI_82C568,
	    "82C568 IDE",
	},
	{
	    PCI_VENDOR_OPTI, PCI_PRODUCT_OPTI_82D568,
	    "82D568 IDE",
	},
	{
	    PCI_VENDOR_OPTI, PCI_PRODUCT_OPTI_82C621,
	    "82C621 IDE",
	},
	{
	    PCI_VENDOR_OPTI, PCI_PRODUCT_OPTI_82C700,
	    "82C700",
	},
	{
	    PCI_VENDOR_OPTI, PCI_PRODUCT_OPTI_82C701,
	    "82C701",
	},
	{
	    PCI_VENDOR_OPTI, PCI_PRODUCT_OPTI_82C822,
	    "82C822",
	},
	{
	    PCI_VENDOR_OPTI, PCI_PRODUCT_OPTI_82C861,
	    "82C861",
	},
	{
	    PCI_VENDOR_OPTION, PCI_PRODUCT_OPTION_F32,
	    "3G+ UMTS HSDPA (F32)",
	},
	{
	    PCI_VENDOR_OXFORD, PCI_PRODUCT_OXFORD_VSCOM_PCI010L,
	    "010L",
	},
	{
	    PCI_VENDOR_OXFORD, PCI_PRODUCT_OXFORD_VSCOM_PCI100L,
	    "100L",
	},
	{
	    PCI_VENDOR_OXFORD, PCI_PRODUCT_OXFORD_VSCOM_PCI110L,
	    "110L",
	},
	{
	    PCI_VENDOR_OXFORD, PCI_PRODUCT_OXFORD_VSCOM_PCI200L,
	    "200L",
	},
	{
	    PCI_VENDOR_OXFORD, PCI_PRODUCT_OXFORD_VSCOM_PCI210L,
	    "210L",
	},
	{
	    PCI_VENDOR_MOLEX, PCI_PRODUCT_MOLEX_VSCOM_PCI400L,
	    "400L",
	},
	{
	    PCI_VENDOR_OXFORD, PCI_PRODUCT_OXFORD_VSCOM_PCI800L,
	    "800L",
	},
	{
	    PCI_VENDOR_OXFORD, PCI_PRODUCT_OXFORD_VSCOM_PCIx10H,
	    "x10H",
	},
	{
	    PCI_VENDOR_OXFORD, PCI_PRODUCT_OXFORD_VSCOM_PCI100H,
	    "100H",
	},
	{
	    PCI_VENDOR_OXFORD, PCI_PRODUCT_OXFORD_VSCOM_PCI200H,
	    "200H",
	},
	{
	    PCI_VENDOR_OXFORD, PCI_PRODUCT_OXFORD_VSCOM_PCI800H_0,
	    "400H/800H",
	},
	{
	    PCI_VENDOR_OXFORD, PCI_PRODUCT_OXFORD_VSCOM_PCI800H_1,
	    "800H",
	},
	{
	    PCI_VENDOR_OXFORD, PCI_PRODUCT_OXFORD_VSCOM_PCI200HV2,
	    "200HV2",
	},
	{
	    PCI_VENDOR_OXFORD2, PCI_PRODUCT_OXFORD2_VSCOM_PCI011H,
	    "011H",
	},
	{
	    PCI_VENDOR_OXFORD2, PCI_PRODUCT_OXFORD2_OX16PCI954,
	    "OX16PCI954",
	},
	{
	    PCI_VENDOR_OXFORD2, PCI_PRODUCT_OXFORD2_OX16PCI954K,
	    "OX16PCI954K",
	},
	{
	    PCI_VENDOR_OXFORD2, PCI_PRODUCT_OXFORD2_EXSYS_EX41092,
	    "Exsys EX-41092",
	},
	{
	    PCI_VENDOR_OXFORD2, PCI_PRODUCT_OXFORD2_OXCB950,
	    "OXCB950",
	},
	{
	    PCI_VENDOR_OXFORD2, PCI_PRODUCT_OXFORD2_OXMPCI954,
	    "OXmPCI954",
	},
	{
	    PCI_VENDOR_OXFORD2, PCI_PRODUCT_OXFORD2_OXMPCI954D,
	    "OXmPCI954 Disabled",
	},
	{
	    PCI_VENDOR_OXFORD2, PCI_PRODUCT_OXFORD2_EXSYS_EX41098,
	    "Exsys EX-41098",
	},
	{
	    PCI_VENDOR_OXFORD2, PCI_PRODUCT_OXFORD2_OX16PCI954P,
	    "OX16PCI954 Parallel",
	},
	{
	    PCI_VENDOR_OXFORD2, PCI_PRODUCT_OXFORD2_OX16PCI952,
	    "OX16PCI952",
	},
	{
	    PCI_VENDOR_OXFORD2, PCI_PRODUCT_OXFORD2_OX16PCI952P,
	    "OX16PCI952 Parallel",
	},
	{
	    PCI_VENDOR_PDC, PCI_PRODUCT_PDC_QSTOR_SATA,
	    "QStor SATA",
	},
	{
	    PCI_VENDOR_PE, PCI_PRODUCT_PE_GNIC2,
	    "PMC/GNIC2",
	},
	{
	    PCI_VENDOR_PARALLELS, PCI_PRODUCT_PARALLELS_TOOLS,
	    "Tools",
	},
	{
	    PCI_VENDOR_PARALLELS, PCI_PRODUCT_PARALLELS_VIDEO,
	    "Video",
	},
	{
	    PCI_VENDOR_PCTECH, PCI_PRODUCT_PCTECH_RZ1000,
	    "RZ1000",
	},
	{
	    PCI_VENDOR_PCTEL, PCI_PRODUCT_PCTEL_MICROMODEM56,
	    "HSP MicroModem 56",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CMIC_LE,
	    "CMIC-LE",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CNB20_LE,
	    "CNB20-LE Host",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CNB20HE_1,
	    "CNB20HE Host",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CNB20_LE_2,
	    "CNB20-LE Host",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CNB20HE_2,
	    "CNB20HE Host",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CNB20LE,
	    "CNB20LE Host",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CIOB30,
	    "CIOB30",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CMIC_HE,
	    "CMIC-HE",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CMIC_WS_GC_LE,
	    "CMIC-WS Host (GC-LE)",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CNB20_HE,
	    "CNB20-HE Host",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CMIC_LE_GC_LE,
	    "CNB20-HE Host (GC-LE)",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CMIC_GC_1,
	    "CMIC-GC Host",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CMIC_GC_2,
	    "CMIC-GC Host",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_GCNB_LE,
	    "GCNB-LE Host",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_HT_1000_PCI,
	    "HT-1000 PCI",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CIOB_X2,
	    "CIOB-X2 PCIX",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_PCIE_PCIX,
	    "PCIE-PCIX",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_HT_1000_PCIX,
	    "HT-1000 PCIX",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CIOB_E,
	    "CIOB-E",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_HT_2000_PCIX,
	    "HT-2000 PCIX",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_HT_2000_PCIE,
	    "HT-2000 PCIE",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_HT_2100_PCIE_1,
	    "HT-2100 PCIE",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_HT_2100_PCIE_2,
	    "HT-2100 PCIE",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_HT_2100_PCIE_3,
	    "HT-2100 PCIE",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_HT_2100_PCIE_5,
	    "HT-2100 PCIE",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_OSB4,
	    "OSB4",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CSB5,
	    "CSB5",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CSB6,
	    "CSB6",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_HT_1000,
	    "HT-1000",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_IDE,
	    "IDE",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_OSB4_IDE,
	    "OSB4 IDE",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CSB5_IDE,
	    "CSB5 IDE",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CSB6_RAID_IDE,
	    "CSB6 RAID/IDE",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_HT_1000_IDE,
	    "HT-1000 IDE",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CSB6_IDE,
	    "CSB6 IDE",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_USB,
	    "OSB4/CSB5 USB",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CSB6_USB,
	    "CSB6 USB",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_HT_1000_USB,
	    "HT-1000 USB",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CSB5_LPC_1,
	    "CSB5 LPC",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_GCLE_2,
	    "GCLE-2 Host",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_CSB5_LPC_2,
	    "CSB5 LPC",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_HT_1000_LPC,
	    "HT-1000 LPC",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_K2_SATA,
	    "K2 SATA",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_FRODO4_SATA,
	    "Frodo4 SATA",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_FRODO8_SATA,
	    "Frodo8 SATA",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_HT_1000_SATA_1,
	    "HT-1000 SATA",
	},
	{
	    PCI_VENDOR_RCC, PCI_PRODUCT_RCC_HT_1000_SATA_2,
	    "HT-1000 SATA",
	},
	{
	    PCI_VENDOR_RENDITION, PCI_PRODUCT_RENDITION_V1000,
	    "Verite 1000",
	},
	{
	    PCI_VENDOR_RENDITION, PCI_PRODUCT_RENDITION_V2x00,
	    "Verite V2x00",
	},
	{
	    PCI_VENDOR_PHILIPS, PCI_PRODUCT_PHILIPS_OHCI,
	    "ISP156x USB",
	},
	{
	    PCI_VENDOR_PHILIPS, PCI_PRODUCT_PHILIPS_EHCI,
	    "ISP156x USB",
	},
	{
	    PCI_VENDOR_PHILIPS, PCI_PRODUCT_PHILIPS_SAA7130,
	    "SAA7130 TV",
	},
	{
	    PCI_VENDOR_PHILIPS, PCI_PRODUCT_PHILIPS_SAA7133,
	    "SAA7133 TV",
	},
	{
	    PCI_VENDOR_PHILIPS, PCI_PRODUCT_PHILIPS_SAA7134,
	    "SAA7134 TV",
	},
	{
	    PCI_VENDOR_PHILIPS, PCI_PRODUCT_PHILIPS_SAA7135,
	    "SAA7135 TV",
	},
	{
	    PCI_VENDOR_PICOPOWER, PCI_PRODUCT_PICOPOWER_PT80C826,
	    "PT80C826",
	},
	{
	    PCI_VENDOR_PICOPOWER, PCI_PRODUCT_PICOPOWER_PT86C521,
	    "PT86C521",
	},
	{
	    PCI_VENDOR_PICOPOWER, PCI_PRODUCT_PICOPOWER_PT86C523,
	    "PT86C523",
	},
	{
	    PCI_VENDOR_PICOPOWER, PCI_PRODUCT_PICOPOWER_PC87550,
	    "PC87550",
	},
	{
	    PCI_VENDOR_PICOPOWER, PCI_PRODUCT_PICOPOWER_PT86C523_2,
	    "PT86C523_2",
	},
	{
	    PCI_VENDOR_PIJNENBURG, PCI_PRODUCT_PIJNENBURG_PCC_ISES,
	    "PCC-ISES",
	},
	{
	    PCI_VENDOR_PLATFORM, PCI_PRODUCT_PLATFORM_ES1849,
	    "ES1849",
	},
	{
	    PCI_VENDOR_PLX, PCI_PRODUCT_PLX_1076,
	    "I/O 1076",
	},
	{
	    PCI_VENDOR_PLX, PCI_PRODUCT_PLX_1077,
	    "I/O 1077",
	},
	{
	    PCI_VENDOR_PLX, PCI_PRODUCT_PLX_6520_PCIX,
	    "6520 PCIX-PCIX",
	},
	{
	    PCI_VENDOR_PLX, PCI_PRODUCT_PLX_PEX_8112,
	    "PEX 8112",
	},
	{
	    PCI_VENDOR_PLX, PCI_PRODUCT_PLX_PEX_8114,
	    "PEX 8114",
	},
	{
	    PCI_VENDOR_PLX, PCI_PRODUCT_PLX_PEX_8517,
	    "PEX 8517",
	},
	{
	    PCI_VENDOR_PLX, PCI_PRODUCT_PLX_PEX_8518,
	    "PEX 8518",
	},
	{
	    PCI_VENDOR_PLX, PCI_PRODUCT_PLX_PEX_8524,
	    "PEX 8524",
	},
	{
	    PCI_VENDOR_PLX, PCI_PRODUCT_PLX_PEX_8532,
	    "PEX 8532",
	},
	{
	    PCI_VENDOR_PLX, PCI_PRODUCT_PLX_PEX_8533,
	    "PEX 8533",
	},
	{
	    PCI_VENDOR_PLX, PCI_PRODUCT_PLX_9016,
	    "I/O 9016",
	},
	{
	    PCI_VENDOR_PLX, PCI_PRODUCT_PLX_9050,
	    "I/O 9050",
	},
	{
	    PCI_VENDOR_PLX, PCI_PRODUCT_PLX_9080,
	    "I/O 9080",
	},
	{
	    PCI_VENDOR_PLX, PCI_PRODUCT_PLX_CRONYX_OMEGA,
	    "Cronyx Omega",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20265,
	    "PDC20265",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20263,
	    "PDC20263",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20275,
	    "PDC20275",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20318,
	    "PDC20318",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20319,
	    "PDC20319",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20371,
	    "PDC20371",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20379,
	    "PDC20379",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20378,
	    "PDC20378",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20375,
	    "PDC20375",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20376,
	    "PDC20376",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20377,
	    "PDC20377",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC40719,
	    "PDC40719",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC40519,
	    "PDC40519",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20771,
	    "PDC20771",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20571,
	    "PDC20571",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20579,
	    "PDC20579",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC40779,
	    "PDC40779",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC40718,
	    "PDC40718",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC40518,
	    "PDC40518",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20775,
	    "PDC20775",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20575,
	    "PDC20575",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20267,
	    "PDC20267",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20246,
	    "PDC20246",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20262,
	    "PDC20262",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20268,
	    "PDC20268",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20269,
	    "PDC20269",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20276,
	    "PDC20276",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_DC5030,
	    "DC5030",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20268R,
	    "PDC20268R",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20271,
	    "PDC20271",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20617,
	    "PDC20617",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20620,
	    "PDC20620",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20621,
	    "PDC20621",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20618,
	    "PDC20618",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20619,
	    "PDC20619",
	},
	{
	    PCI_VENDOR_PROMISE, PCI_PRODUCT_PROMISE_PDC20277,
	    "PDC20277",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP10160,
	    "ISP10160",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP1020,
	    "ISP1020",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP1022,
	    "ISP1022",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP1080,
	    "ISP1080",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP12160,
	    "ISP12160",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP1240,
	    "ISP1240",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP1280,
	    "ISP1280",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP2100,
	    "ISP2100",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP2200,
	    "ISP2200",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP2300,
	    "ISP2300",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP2312,
	    "ISP2312",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP2322,
	    "ISP2322",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP2422,
	    "ISP2422",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP2432,
	    "ISP2432",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP2512,
	    "ISP2512",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP2522,
	    "ISP2522",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP2532,
	    "ISP2532",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP4010_TOE,
	    "ISP4010 iSCSI TOE",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP4022_TOE,
	    "ISP4022 iSCSI TOE",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP4032_TOE,
	    "ISP4032 iSCSI TOE",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP4010_HBA,
	    "ISP4010 iSCSI HBA",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP4022_HBA,
	    "ISP4022 iSCSI HBA",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP4032_HBA,
	    "ISP4032 iSCSI HBA",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP5422,
	    "ISP5422",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP5432,
	    "ISP5432",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP6312,
	    "ISP6312",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP6322,
	    "ISP6322",
	},
	{
	    PCI_VENDOR_QLOGIC, PCI_PRODUCT_QLOGIC_ISP8432,
	    "ISP8432",
	},
	{
	    PCI_VENDOR_QUANCOM, PCI_PRODUCT_QUANCOM_PWDOG1,
	    "PWDOG1",
	},
	{
	    PCI_VENDOR_QUANTUMDESIGNS, PCI_PRODUCT_QUANTUMDESIGNS_8500,
	    "8500",
	},
	{
	    PCI_VENDOR_QUANTUMDESIGNS, PCI_PRODUCT_QUANTUMDESIGNS_8580,
	    "8580",
	},
	{
	    PCI_VENDOR_RALINK, PCI_PRODUCT_RALINK_RT2460A,
	    "RT2460A",
	},
	{
	    PCI_VENDOR_RALINK, PCI_PRODUCT_RALINK_RT2560,
	    "RT2560",
	},
	{
	    PCI_VENDOR_RALINK, PCI_PRODUCT_RALINK_RT2561S,
	    "RT2561S",
	},
	{
	    PCI_VENDOR_RALINK, PCI_PRODUCT_RALINK_RT2561,
	    "RT2561",
	},
	{
	    PCI_VENDOR_RALINK, PCI_PRODUCT_RALINK_RT2661,
	    "RT2661",
	},
	{
	    PCI_VENDOR_RALINK, PCI_PRODUCT_RALINK_RT2860,
	    "RT2860",
	},
	{
	    PCI_VENDOR_RALINK, PCI_PRODUCT_RALINK_RT2890,
	    "RT2890",
	},
	{
	    PCI_VENDOR_RALINK, PCI_PRODUCT_RALINK_RT2760,
	    "RT2760",
	},
	{
	    PCI_VENDOR_RALINK, PCI_PRODUCT_RALINK_RT2790,
	    "RT2790",
	},
	{
	    PCI_VENDOR_REALTEK, PCI_PRODUCT_REALTEK_RT8029,
	    "8029",
	},
	{
	    PCI_VENDOR_REALTEK, PCI_PRODUCT_REALTEK_RT8129,
	    "8129",
	},
	{
	    PCI_VENDOR_REALTEK, PCI_PRODUCT_REALTEK_RT8101E,
	    "8101E",
	},
	{
	    PCI_VENDOR_REALTEK, PCI_PRODUCT_REALTEK_RT8138,
	    "8138",
	},
	{
	    PCI_VENDOR_REALTEK, PCI_PRODUCT_REALTEK_RT8139,
	    "8139",
	},
	{
	    PCI_VENDOR_REALTEK, PCI_PRODUCT_REALTEK_RT8169SC,
	    "8169SC",
	},
	{
	    PCI_VENDOR_REALTEK, PCI_PRODUCT_REALTEK_RT8168,
	    "8168",
	},
	{
	    PCI_VENDOR_REALTEK, PCI_PRODUCT_REALTEK_RT8169,
	    "8169",
	},
	{
	    PCI_VENDOR_REALTEK, PCI_PRODUCT_REALTEK_RT8180,
	    "8180",
	},
	{
	    PCI_VENDOR_REALTEK, PCI_PRODUCT_REALTEK_RT8185,
	    "8185",
	},
	{
	    PCI_VENDOR_RICOH, PCI_PRODUCT_RICOH_RF5C465,
	    "5C465 CardBus",
	},
	{
	    PCI_VENDOR_RICOH, PCI_PRODUCT_RICOH_RF5C466,
	    "5C466 CardBus",
	},
	{
	    PCI_VENDOR_RICOH, PCI_PRODUCT_RICOH_RF5C475,
	    "5C475 CardBus",
	},
	{
	    PCI_VENDOR_RICOH, PCI_PRODUCT_RICOH_RF5C476,
	    "5C476 CardBus",
	},
	{
	    PCI_VENDOR_RICOH, PCI_PRODUCT_RICOH_RF5C477,
	    "5C477 CardBus",
	},
	{
	    PCI_VENDOR_RICOH, PCI_PRODUCT_RICOH_RF5C478,
	    "5C478 CardBus",
	},
	{
	    PCI_VENDOR_RICOH, PCI_PRODUCT_RICOH_R5C521,
	    "5C521 Firewire",
	},
	{
	    PCI_VENDOR_RICOH, PCI_PRODUCT_RICOH_R5C551,
	    "5C551 Firewire",
	},
	{
	    PCI_VENDOR_RICOH, PCI_PRODUCT_RICOH_RL5C552,
	    "5C552 Firewire",
	},
	{
	    PCI_VENDOR_RICOH, PCI_PRODUCT_RICOH_R5C592,
	    "5C592 Memory Stick",
	},
	{
	    PCI_VENDOR_RICOH, PCI_PRODUCT_RICOH_R5C822,
	    "5C822 SD/MMC",
	},
	{
	    PCI_VENDOR_RICOH, PCI_PRODUCT_RICOH_R5C832,
	    "5C832 Firewire",
	},
	{
	    PCI_VENDOR_RICOH, PCI_PRODUCT_RICOH_R5C843,
	    "5C843 MMC",
	},
	{
	    PCI_VENDOR_RICOH, PCI_PRODUCT_RICOH_R5C852,
	    "5C852 xD",
	},
	{
	    PCI_VENDOR_ROCKWELL, PCI_PRODUCT_ROCKWELL_RS56SP_PCI11P1,
	    "RS56/SP-PCI11P1 Modem",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_VIRGE,
	    "ViRGE",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_TRIO32,
	    "Trio32",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_TRIO64,
	    "Trio32/64",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_AURORA64P,
	    "Aurora64V+",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_TRIO64UVP,
	    "Trio64UV+",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_868,
	    "868",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_VIRGE_VX,
	    "ViRGE VX",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_928,
	    "86C928",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_864_0,
	    "86C864-0",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_864_1,
	    "86C864-1",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_864_2,
	    "86C864-2",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_864_3,
	    "86C864-3",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_964_0,
	    "86C964-0",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_964_1,
	    "86C964-1",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_964_2,
	    "86C964-2",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_964_3,
	    "86C964-3",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_968_0,
	    "86C968-0",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_968_1,
	    "86C968-1",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_968_2,
	    "86C968-2",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_968_3,
	    "86C968-3",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_TRIO64V2_DX,
	    "Trio64V2/DX",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_PLATO,
	    "Plato",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_TRIO3D_AGP,
	    "Trio3D AGP",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_VIRGE_DX_GX,
	    "ViRGE DX/GX",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_VIRGE_GX2,
	    "ViRGE GX2",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_TRIO3_DX2,
	    "Trio3 DX2",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_SAVAGE3D,
	    "Savage 3D",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_SAVAGE3D_M,
	    "Savage 3DM",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_SAVAGE4,
	    "Savage 4",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_PROSAVAGE_PM133,
	    "ProSavage PM133",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_PROSAVAGE_KM133,
	    "ProSavage KM133",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_VIRGE_MX,
	    "ViRGE MX",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_VIRGE_MXP,
	    "ViRGE MXP",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_SAVAGE_MXMV,
	    "Savage/MX-MV",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_SAVAGE_MX,
	    "Savage/MX",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_SAVAGE_IXMV,
	    "Savage/IX-MV",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_SAVAGE_IX,
	    "Savage/IX",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_SUPERSAVAGE,
	    "SuperSavage",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_TWISTER,
	    "Twister",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_TWISTER_K,
	    "Twister-K",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_PROSAVAGE_DDR,
	    "ProSavage DDR",
	},
	{
	    PCI_VENDOR_S3, PCI_PRODUCT_S3_SONICVIBES,
	    "SonicVibes",
	},
	{
	    PCI_VENDOR_SAFENET, PCI_PRODUCT_SAFENET_SAFEXCEL,
	    "SafeXcel",
	},
	{
	    PCI_VENDOR_SAMSUNG, PCI_PRODUCT_SAMSUNG_SWL2210P,
	    "MagicLAN SWL-2210P",
	},
	{
	    PCI_VENDOR_SANGOMA, PCI_PRODUCT_SANGOMA_A10X,
	    "A10x",
	},
	{
	    PCI_VENDOR_DIGI, PCI_PRODUCT_DIGI_NEO4,
	    "Neo-4",
	},
	{
	    PCI_VENDOR_DIGI, PCI_PRODUCT_DIGI_NEO8,
	    "Neo-8",
	},
	{
	    PCI_VENDOR_SCHNEIDERKOCH, PCI_PRODUCT_SCHNEIDERKOCH_FDDI,
	    "FDDI",
	},
	{
	    PCI_VENDOR_SCHNEIDERKOCH, PCI_PRODUCT_SCHNEIDERKOCH_SK98XX,
	    "SK-98xx",
	},
	{
	    PCI_VENDOR_SCHNEIDERKOCH, PCI_PRODUCT_SCHNEIDERKOCH_SK98XX2,
	    "SK-98xx v2.0",
	},
	{
	    PCI_VENDOR_SCHNEIDERKOCH, PCI_PRODUCT_SCHNEIDERKOCH_SK9D21,
	    "SK-9D21",
	},
	{
	    PCI_VENDOR_SCHNEIDERKOCH, PCI_PRODUCT_SCHNEIDERKOCH_SK9Sxx,
	    "SK-9Sxx",
	},
	{
	    PCI_VENDOR_SCHNEIDERKOCH, PCI_PRODUCT_SCHNEIDERKOCH_SK9821,
	    "SK-9821",
	},
	{
	    PCI_VENDOR_SCHNEIDERKOCH, PCI_PRODUCT_SCHNEIDERKOCH_SK9843,
	    "SK-9843",
	},
	{
	    PCI_VENDOR_SCHNEIDERKOCH, PCI_PRODUCT_SCHNEIDERKOCH_SK9Exx,
	    "SK-9Exx",
	},
	{
	    PCI_VENDOR_SGI, PCI_PRODUCT_SGI_IOC3,
	    "IOC3",
	},
	{
	    PCI_VENDOR_SGI, PCI_PRODUCT_SGI_RAD1,
	    "Rad1",
	},
	{
	    PCI_VENDOR_SGI, PCI_PRODUCT_SGI_TIGON,
	    "Tigon",
	},
	{
	    PCI_VENDOR_SGI, PCI_PRODUCT_SGI_IOC4,
	    "IOC4",
	},
	{
	    PCI_VENDOR_SGSTHOMSON, PCI_PRODUCT_SGSTHOMSON_2000,
	    "STG 2000X",
	},
	{
	    PCI_VENDOR_SGSTHOMSON, PCI_PRODUCT_SGSTHOMSON_1764,
	    "STG 1764",
	},
	{
	    PCI_VENDOR_SGSTHOMSON, PCI_PRODUCT_SGSTHOMSON_KYROII,
	    "Kyro-II",
	},
	{
	    PCI_VENDOR_SGSTHOMSON, PCI_PRODUCT_SGSTHOMSON_1764X,
	    "STG 1764X",
	},
	{
	    PCI_VENDOR_SIGMA, PCI_PRODUCT_SIGMA_64GX,
	    "64GX",
	},
	{
	    PCI_VENDOR_SIGMA, PCI_PRODUCT_SIGMA_DVDMAGICPRO,
	    "DVDmagic-PRO",
	},
	{
	    PCI_VENDOR_SILAN, PCI_PRODUCT_SILAN_SC92301,
	    "SC92301",
	},
	{
	    PCI_VENDOR_SILAN, PCI_PRODUCT_SILAN_8139D,
	    "8139D",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_86C201,
	    "86C201 AGP",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_86C202,
	    "86C202 VGA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_648FX,
	    "648FX AGP",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_PPB_1,
	    "PCI-PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_86C205_1,
	    "86C205",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_85C503,
	    "85C503 System",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_5595,
	    "5595 System",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_PPB_2,
	    "PCI-PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_85C503_ISA,
	    "85C503 ISA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_180,
	    "180 SATA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_181,
	    "181 SATA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_182,
	    "182 SATA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_190,
	    "190",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_191,
	    "191",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_5597_VGA,
	    "5597/5598 VGA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_6215,
	    "6215",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_86C205_2,
	    "86C205",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_300,
	    "300/305/630 VGA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_315PRO_VGA,
	    "315 Pro VGA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_85C501,
	    "85C501",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_85C496,
	    "85C496",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_85C596,
	    "85C596",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_530,
	    "530 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_540,
	    "540 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_550,
	    "550 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_85C601,
	    "85C601 EIDE",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_620,
	    "620 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_630,
	    "630 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_633,
	    "633 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_635,
	    "635 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_640,
	    "640 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_645,
	    "645 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_646,
	    "646 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_648,
	    "648 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_649,
	    "649 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_650,
	    "650 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_651,
	    "651 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_652,
	    "652 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_655,
	    "655 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_656,
	    "656 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_658,
	    "658 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_661,
	    "661 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_662,
	    "662 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_730,
	    "730 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_733,
	    "733 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_735,
	    "735 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_740,
	    "740 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_741,
	    "741 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_745,
	    "745 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_746,
	    "746 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_748,
	    "748 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_750,
	    "750 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_751,
	    "751 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_752,
	    "752 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_755,
	    "755 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_756,
	    "756 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_760,
	    "760 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_761,
	    "761 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_900,
	    "900 10/100BaseTX",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_961,
	    "961 ISA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_962,
	    "962 ISA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_963,
	    "963 ISA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_964,
	    "964 ISA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_965,
	    "965 ISA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_966,
	    "966 ISA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_5315,
	    "530 VGA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_5511,
	    "5511",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_5512,
	    "5512",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_5513,
	    "5513 EIDE",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_5571,
	    "5571 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_5581,
	    "5581",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_5582,
	    "5582",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_5591,
	    "5591 PCI",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_5596,
	    "5596",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_5597_HB,
	    "5597/5598 Host",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_6204,
	    "6204",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_6205,
	    "6205",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_6300,
	    "6300",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_530_VGA,
	    "530 VGA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_650_VGA,
	    "650 VGA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_6326,
	    "6326 VGA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_6330,
	    "6330 VGA",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_5597_USB,
	    "5597/5598 USB",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_7002,
	    "7002 USB",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_7007,
	    "7007 FireWire",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_7012_ACA,
	    "7012 AC97",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_7013,
	    "7013 Modem",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_7016,
	    "7016 10/100BaseTX",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_7018,
	    "7018 Audio",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_7019,
	    "7019 Audio",
	},
	{
	    PCI_VENDOR_SIS, PCI_PRODUCT_SIS_966_HDA,
	    "966 HD Audio",
	},
	{
	    PCI_VENDOR_SMC, PCI_PRODUCT_SMC_83C170,
	    "83C170 (EPIC/100)",
	},
	{
	    PCI_VENDOR_SMC, PCI_PRODUCT_SMC_83C175,
	    "83C175 (EPIC/100)",
	},
	{
	    PCI_VENDOR_SMC, PCI_PRODUCT_SMC_37C665,
	    "FDC 37C665",
	},
	{
	    PCI_VENDOR_SMC, PCI_PRODUCT_SMC_37C922,
	    "FDC 37C922",
	},
	{
	    PCI_VENDOR_SMI, PCI_PRODUCT_SMI_SM710,
	    "LynxEM",
	},
	{
	    PCI_VENDOR_SMI, PCI_PRODUCT_SMI_SM712,
	    "LynxEM+",
	},
	{
	    PCI_VENDOR_SMI, PCI_PRODUCT_SMI_SM720,
	    "Lynx3DM",
	},
	{
	    PCI_VENDOR_SMI, PCI_PRODUCT_SMI_SM810,
	    "LynxE",
	},
	{
	    PCI_VENDOR_SMI, PCI_PRODUCT_SMI_SM811,
	    "LynxE+",
	},
	{
	    PCI_VENDOR_SMI, PCI_PRODUCT_SMI_SM820,
	    "Lynx3D",
	},
	{
	    PCI_VENDOR_SMI, PCI_PRODUCT_SMI_SM910,
	    "910",
	},
	{
	    PCI_VENDOR_SMSC, PCI_PRODUCT_SMSC_VICTORY66_IDE_1,
	    "Victory66 IDE",
	},
	{
	    PCI_VENDOR_SMSC, PCI_PRODUCT_SMSC_VICTORY66_ISA,
	    "Victory66 ISA",
	},
	{
	    PCI_VENDOR_SMSC, PCI_PRODUCT_SMSC_VICTORY66_IDE_2,
	    "Victory66 IDE",
	},
	{
	    PCI_VENDOR_SMSC, PCI_PRODUCT_SMSC_VICTORY66_USB,
	    "Victory66 USB",
	},
	{
	    PCI_VENDOR_SMSC, PCI_PRODUCT_SMSC_VICTORY66_PM,
	    "Victory66 Power",
	},
	{
	    PCI_VENDOR_SNI, PCI_PRODUCT_SNI_PIRAHNA,
	    "Pirahna 2-port",
	},
	{
	    PCI_VENDOR_SNI, PCI_PRODUCT_SNI_TCPMSE,
	    "Tulip, power, switch extender",
	},
	{
	    PCI_VENDOR_SNI, PCI_PRODUCT_SNI_FPGAIBUS,
	    "FPGA I-Bus Tracer for MBD",
	},
	{
	    PCI_VENDOR_SNI, PCI_PRODUCT_SNI_SZB6120,
	    "SZB6120",
	},
	{
	    PCI_VENDOR_SONY, PCI_PRODUCT_SONY_CXD1947A,
	    "CXD1947A FireWire",
	},
	{
	    PCI_VENDOR_SONY, PCI_PRODUCT_SONY_CXD3222,
	    "CXD3222 FireWire",
	},
	{
	    PCI_VENDOR_SONY, PCI_PRODUCT_SONY_MEMSTICK_SLOT,
	    "Memory Stick Slot",
	},
	{
	    PCI_VENDOR_STALLION, PCI_PRODUCT_STALLION_EASYIO,
	    "EasyIO",
	},
	{
	    PCI_VENDOR_STB2, PCI_PRODUCT_STB2_RIVA128,
	    "Velocity128",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_EBUS,
	    "PCIO EBus2",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_HME,
	    "HME",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_RIO_EBUS,
	    "RIO EBus",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_ERINETWORK,
	    "ERI Ether",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_FIREWIRE,
	    "FireWire",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_USB,
	    "USB",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_GEMNETWORK,
	    "GEM",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_SIMBA,
	    "Simba PCI-PCI",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_5821,
	    "Crypto 5821",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_SCA1K,
	    "Crypto 1K",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_SCA6K,
	    "Crypto 6K",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_PSYCHO,
	    "Psycho PCI",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_MS_IIep,
	    "microSPARC IIep PCI",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_US_IIi,
	    "UltraSPARC IIi PCI",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_US_IIe,
	    "UltraSPARC IIe PCI",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_CASSINI,
	    "Cassini",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_NEPTUNE,
	    "Neptune",
	},
	{
	    PCI_VENDOR_SUN, PCI_PRODUCT_SUN_SBBC,
	    "SBBC",
	},
	{
	    PCI_VENDOR_SUNDANCE, PCI_PRODUCT_SUNDANCE_ST201_1,
	    "ST201",
	},
	{
	    PCI_VENDOR_SUNDANCE, PCI_PRODUCT_SUNDANCE_ST201_2,
	    "ST201",
	},
	{
	    PCI_VENDOR_SUNDANCE, PCI_PRODUCT_SUNDANCE_TC9021,
	    "TC9021",
	},
	{
	    PCI_VENDOR_SUNDANCE, PCI_PRODUCT_SUNDANCE_ST1023,
	    "ST1023",
	},
	{
	    PCI_VENDOR_SUNDANCE, PCI_PRODUCT_SUNDANCE_ST2021,
	    "ST2021",
	},
	{
	    PCI_VENDOR_SUNDANCE, PCI_PRODUCT_SUNDANCE_TC9021_ALT,
	    "TC9021 (alt ID)",
	},
	{
	    PCI_VENDOR_SUNIX, PCI_PRODUCT_SUNIX_40XX,
	    "40XX",
	},
	{
	    PCI_VENDOR_SUNIX, PCI_PRODUCT_SUNIX_4018A,
	    "4018A",
	},
	{
	    PCI_VENDOR_SURECOM, PCI_PRODUCT_SURECOM_NE34,
	    "NE-34",
	},
	{
	    PCI_VENDOR_SYBA, PCI_PRODUCT_SYBA_4S2P,
	    "4S2P",
	},
	{
	    PCI_VENDOR_SYBA, PCI_PRODUCT_SYBA_4S,
	    "4S",
	},
	{
	    PCI_VENDOR_SYMBOL, PCI_PRODUCT_SYMBOL_LA41X3,
	    "Spectrum24 LA41X3",
	},
	{
	    PCI_VENDOR_SYMPHONY, PCI_PRODUCT_SYMPHONY_82C101,
	    "82C101",
	},
	{
	    PCI_VENDOR_SYMPHONY, PCI_PRODUCT_SYMPHONY_82C103,
	    "82C103",
	},
	{
	    PCI_VENDOR_SYMPHONY, PCI_PRODUCT_SYMPHONY_82C105,
	    "82C105",
	},
	{
	    PCI_VENDOR_SYMPHONY2, PCI_PRODUCT_SYMPHONY2_82C101,
	    "82C101",
	},
	{
	    PCI_VENDOR_SYMPHONY, PCI_PRODUCT_SYMPHONY_82C565,
	    "82C565 ISA",
	},
	{
	    PCI_VENDOR_TTTECH, PCI_PRODUCT_TTTECH_MC322,
	    "MC322",
	},
	{
	    PCI_VENDOR_TAMARACK, PCI_PRODUCT_TAMARACK_TC9021,
	    "TC9021 GigE",
	},
	{
	    PCI_VENDOR_TAMARACK, PCI_PRODUCT_TAMARACK_TC9021_ALT,
	    "TC9021 GigE (alt ID)",
	},
	{
	    PCI_VENDOR_TEHUTI, PCI_PRODUCT_TEHUTI_TN3009,
	    "TN3009",
	},
	{
	    PCI_VENDOR_TEHUTI, PCI_PRODUCT_TEHUTI_TN3010,
	    "TN3010",
	},
	{
	    PCI_VENDOR_TEHUTI, PCI_PRODUCT_TEHUTI_TN3014,
	    "TN3014",
	},
	{
	    PCI_VENDOR_TEKRAM, PCI_PRODUCT_TEKRAM_DC290,
	    "DC-290(M)",
	},
	{
	    PCI_VENDOR_TEKRAM2, PCI_PRODUCT_TEKRAM2_DC690C,
	    "DC-690C",
	},
	{
	    PCI_VENDOR_TEKRAM2, PCI_PRODUCT_TEKRAM2_DC3X5U,
	    "DC-3x5U",
	},
	{
	    PCI_VENDOR_TERRATEC, PCI_PRODUCT_TERRATEC_TVALUE_PLUS,
	    "Terratec TV+",
	},
	{
	    PCI_VENDOR_TERRATEC, PCI_PRODUCT_TERRATEC_TVALUE,
	    "Terratec TValue",
	},
	{
	    PCI_VENDOR_TERRATEC, PCI_PRODUCT_TERRATEC_TVALUER,
	    "Terratec TValue Radio",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_TLAN,
	    "TLAN",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PERMEDIA,
	    "3DLabs Permedia",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PERMEDIA2,
	    "3DLabs Permedia 2",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_TSB12LV21,
	    "TSB12LV21 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_TSB12LV22,
	    "TSB12LV22 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI4450_FW,
	    "PCI4450 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI4410_FW,
	    "PCI4410 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_TSB12LV23,
	    "TSB12LV23 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_TSB12LV26,
	    "TSB12LV26 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_TSB43AA22,
	    "TSB43AA22 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_TSB43AB22,
	    "TSB43AB22 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_TSB43AB23,
	    "TSB43AB23 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_TSB82AA2,
	    "TSB82AA2 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_TSB43AB21,
	    "TSB43AB21 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI4451_FW,
	    "PCI4451 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI4510_FW,
	    "PCI4510 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI4520_FW,
	    "PCI4520 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI7410_FW,
	    "PCI7(4-6)10 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI7420_FW,
	    "PCI7x20 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI7XX1,
	    "PCI7XX1 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI7XX1_FW,
	    "PCI7XX1 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI7XX1_FLASH,
	    "PCI7XX1 Flash",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI7XX1_SD,
	    "PCI7XX1 Secure Data",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI7XX1_SM,
	    "PCI7XX1 Smart Card",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI6515,
	    "PCI6515 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI6515SC,
	    "PCI6515 CardBus (Smart Card mode)",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCIXX12,
	    "PCIXX12 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCIXX12_FW,
	    "PCIXX12 FireWire",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCIXX12_MCR,
	    "PCIXX12 Multimedia Card Reader",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCIXX12_SD,
	    "PCIXX12 Secure Data",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCIXX12_SM,
	    "PCIXX12 Smart Card",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1620_MISC,
	    "PCI1620 Misc",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_XIO2000A,
	    "XIO2000A PCIE-PCI",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_ACX100A,
	    "ACX100A",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_ACX100B,
	    "ACX100B",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_ACX111,
	    "ACX111",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1130,
	    "PCI1130 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1031,
	    "PCI1031 PCMCIA",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1131,
	    "PCI1131 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1250,
	    "PCI1250 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1220,
	    "PCI1220 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1221,
	    "PCI1221 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1210,
	    "PCI1210 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1450,
	    "PCI1450 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1225,
	    "PCI1225 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1251,
	    "PCI1251 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1211,
	    "PCI1211 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1251B,
	    "PCI1251B CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI2030,
	    "PCI2030 PCI-PCI",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI2031,
	    "PCI2031 PCI-PCI",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI2032,
	    "PCI2032 PCI-PCI",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI2250,
	    "PCI2250 PCI-PCI",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI2050,
	    "PCI2050 PCI-PCI",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI4450_CB,
	    "PCI4450 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI4410_CB,
	    "PCI4410 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI4451_CB,
	    "PCI4451 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI4510_CB,
	    "PCI4510 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI4520_CB,
	    "PCI4520 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI7510_CB,
	    "PCI7510 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI7610_CB,
	    "PCI7610 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI7410_CB,
	    "PCI7410 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI7610SM,
	    "PCI7610 CardBus (Smart Card mode)",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI7410SD,
	    "PCI7[46]10 CardBus (SD/MMC mode)",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI7410MS,
	    "PCI7[46]10 CardBus (Memory stick mode)",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1410,
	    "PCI1410 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1420,
	    "PCI1420 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1451,
	    "PCI1451 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1421,
	    "PCI1421 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1620,
	    "PCI1620 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1520,
	    "PCI1520 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1510,
	    "PCI1510 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1530,
	    "PCI1530 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI1515,
	    "PCI1515 CardBus",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI2040,
	    "PCI2040 DSP",
	},
	{
	    PCI_VENDOR_TI, PCI_PRODUCT_TI_PCI7420,
	    "PCI7420 CardBus",
	},
	{
	    PCI_VENDOR_TIGERJET, PCI_PRODUCT_TIGERJET_TIGER320,
	    "PCI",
	},
	{
	    PCI_VENDOR_TOPIC, PCI_PRODUCT_TOPIC_5634PCV,
	    "5634PCV SurfRider",
	},
	{
	    PCI_VENDOR_TOSHIBA, PCI_PRODUCT_TOSHIBA_R4x00,
	    "R4x00",
	},
	{
	    PCI_VENDOR_TOSHIBA, PCI_PRODUCT_TOSHIBA_TC35856F,
	    "TC35856F ATM (Meteor)",
	},
	{
	    PCI_VENDOR_TOSHIBA, PCI_PRODUCT_TOSHIBA_R4X00,
	    "R4x00 PCI",
	},
	{
	    PCI_VENDOR_TOSHIBA2, PCI_PRODUCT_TOSHIBA2_THB,
	    "PCI",
	},
	{
	    PCI_VENDOR_TOSHIBA2, PCI_PRODUCT_TOSHIBA2_ISA,
	    "ISA",
	},
	{
	    PCI_VENDOR_TOSHIBA2, PCI_PRODUCT_TOSHIBA2_ToPIC95,
	    "ToPIC95 CardBus-PCI",
	},
	{
	    PCI_VENDOR_TOSHIBA2, PCI_PRODUCT_TOSHIBA2_ToPIC95B,
	    "ToPIC95B CardBus",
	},
	{
	    PCI_VENDOR_TOSHIBA2, PCI_PRODUCT_TOSHIBA2_ToPIC97,
	    "ToPIC97 CardBus",
	},
	{
	    PCI_VENDOR_TOSHIBA2, PCI_PRODUCT_TOSHIBA2_ToPIC100,
	    "ToPIC100 CardBus",
	},
	{
	    PCI_VENDOR_TOSHIBA2, PCI_PRODUCT_TOSHIBA2_TFIRO,
	    "Fast Infrared Type O",
	},
	{
	    PCI_VENDOR_TOSHIBA2, PCI_PRODUCT_TOSHIBA2_SDCARD,
	    "SD Controller",
	},
	{
	    PCI_VENDOR_TRANSMETA, PCI_PRODUCT_TRANSMETA_NB,
	    "Northbridge",
	},
	{
	    PCI_VENDOR_TRANSMETA, PCI_PRODUCT_TRANSMETA_LONGRUN_NB,
	    "LongRun Northbridge",
	},
	{
	    PCI_VENDOR_TRANSMETA, PCI_PRODUCT_TRANSMETA_MEM1,
	    "Mem1",
	},
	{
	    PCI_VENDOR_TRANSMETA, PCI_PRODUCT_TRANSMETA_MEM2,
	    "Mem2",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_4DWAVE_DX,
	    "4DWAVE DX",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_4DWAVE_NX,
	    "4DWAVE NX",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_CYBERBLADEI7,
	    "CyberBlade i7",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_CYBERBLADEI7AGP,
	    "CyberBlade i7 AGP",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_CYBERBLADEI1,
	    "CyberBlade i1",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_CYBERBLADEI1AGP,
	    "CyberBlade i1 AGP",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_CYBERBLADEAI1,
	    "CyberBlade Ai1",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_CYBERBLADEAI1AGP,
	    "CyberBlade Ai1 AGP",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_CYBERBLADEXPAI1,
	    "CyberBlade XP/Ai1",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_TGUI_9320,
	    "TGUI 9320",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_TGUI_9350,
	    "TGUI 9350",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_TGUI_9360,
	    "TGUI 9360",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_TGUI_9388,
	    "TGUI 9388",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_CYBER_9397,
	    "CYBER 9397",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_CYBER_9397DVD,
	    "CYBER 9397DVD",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_TGUI_9420,
	    "TGUI 9420",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_TGUI_9440,
	    "TGUI 9440",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_CYBER_9525,
	    "CYBER 9525",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_TGUI_9660,
	    "TGUI 9660",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_TGUI_9680,
	    "TGUI 9680",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_TGUI_9682,
	    "TGUI 9682",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_3DIMAGE_9750,
	    "3DImage 9750",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_3DIMAGE_9850,
	    "3DImage 9850",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_BLADE_3D,
	    "Blade 3D",
	},
	{
	    PCI_VENDOR_TRIDENT, PCI_PRODUCT_TRIDENT_BLADE_XP,
	    "CyberBlade XP",
	},
	{
	    PCI_VENDOR_TRIONES, PCI_PRODUCT_TRIONES_HPT343,
	    "HPT343/345 IDE",
	},
	{
	    PCI_VENDOR_TRIONES, PCI_PRODUCT_TRIONES_HPT366,
	    "HPT36x/37x IDE",
	},
	{
	    PCI_VENDOR_TRIONES, PCI_PRODUCT_TRIONES_HPT372A,
	    "HPT372A IDE",
	},
	{
	    PCI_VENDOR_TRIONES, PCI_PRODUCT_TRIONES_HPT302,
	    "HPT302 IDE",
	},
	{
	    PCI_VENDOR_TRIONES, PCI_PRODUCT_TRIONES_HPT371,
	    "HPT371 IDE",
	},
	{
	    PCI_VENDOR_TRIONES, PCI_PRODUCT_TRIONES_HPT374,
	    "HPT374 IDE",
	},
	{
	    PCI_VENDOR_TRITECH, PCI_PRODUCT_TRITECH_TR25202,
	    "Pyramid3D TR25202",
	},
	{
	    PCI_VENDOR_TSENG, PCI_PRODUCT_TSENG_ET4000_W32P_A,
	    "ET4000w32p rev A",
	},
	{
	    PCI_VENDOR_TSENG, PCI_PRODUCT_TSENG_ET4000_W32P_B,
	    "ET4000w32p rev B",
	},
	{
	    PCI_VENDOR_TSENG, PCI_PRODUCT_TSENG_ET4000_W32P_C,
	    "ET4000w32p rev C",
	},
	{
	    PCI_VENDOR_TSENG, PCI_PRODUCT_TSENG_ET4000_W32P_D,
	    "ET4000w32p rev D",
	},
	{
	    PCI_VENDOR_TSENG, PCI_PRODUCT_TSENG_ET6000,
	    "ET6000/ET6100",
	},
	{
	    PCI_VENDOR_TSENG, PCI_PRODUCT_TSENG_ET6300,
	    "ET6300",
	},
	{
	    PCI_VENDOR_TVIA, PCI_PRODUCT_TVIA_IGA1680,
	    "IGA-1680",
	},
	{
	    PCI_VENDOR_TVIA, PCI_PRODUCT_TVIA_IGA1682,
	    "IGA-1682",
	},
	{
	    PCI_VENDOR_TVIA, PCI_PRODUCT_TVIA_IGA1683,
	    "IGA-1683",
	},
	{
	    PCI_VENDOR_TVIA, PCI_PRODUCT_TVIA_CP2000,
	    "CyberPro 2000",
	},
	{
	    PCI_VENDOR_TVIA, PCI_PRODUCT_TVIA_CP2000A,
	    "CyberPro 2010",
	},
	{
	    PCI_VENDOR_TVIA, PCI_PRODUCT_TVIA_CP5000,
	    "CyberPro 5000",
	},
	{
	    PCI_VENDOR_TVIA, PCI_PRODUCT_TVIA_CP5050,
	    "CyberPro 5050",
	},
	{
	    PCI_VENDOR_TVIA, PCI_PRODUCT_TVIA_CP5202,
	    "CyberPro 5202",
	},
	{
	    PCI_VENDOR_TVIA, PCI_PRODUCT_TVIA_CP5252,
	    "CyberPro 5252",
	},
	{
	    PCI_VENDOR_TURTLEBEACH, PCI_PRODUCT_TURTLEBEACH_SANTA_CRUZ,
	    "Santa Cruz",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM82C881,
	    "UM82C881 486",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM82C886,
	    "UM82C886 ISA",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM8673F,
	    "UM8673F EIDE",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM8881,
	    "UM8881 HB4 486 PCI",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM82C891,
	    "UM82C891",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM886A,
	    "UM886A",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM8886BF,
	    "UM8886BF",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM8710,
	    "UM8710",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM8886,
	    "UM8886",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM8881F,
	    "UM8881F Host",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM8886F,
	    "UM8886F ISA",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM8886A,
	    "UM8886A",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM8891A,
	    "UM8891A",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM9017F,
	    "UM9017F",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM8886E_OR_WHAT,
	    "ISA",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM8886N,
	    "UM8886N",
	},
	{
	    PCI_VENDOR_UMC, PCI_PRODUCT_UMC_UM8891N,
	    "UM8891N",
	},
	{
	    PCI_VENDOR_ULSI, PCI_PRODUCT_ULSI_US201,
	    "US201",
	},
	{
	    PCI_VENDOR_USR2, PCI_PRODUCT_USR2_USR997902,
	    "USR997902",
	},
	{
	    PCI_VENDOR_USR, PCI_PRODUCT_USR_3CP5610,
	    "3CP5610",
	},
	{
	    PCI_VENDOR_USR2, PCI_PRODUCT_USR2_WL11000P,
	    "WL11000P",
	},
	{
	    PCI_VENDOR_V3, PCI_PRODUCT_V3_V961PBC,
	    "V961PBC i960 PCI",
	},
	{
	    PCI_VENDOR_V3, PCI_PRODUCT_V3_V292PBC,
	    "V292PBC AMD290x0 PCI",
	},
	{
	    PCI_VENDOR_V3, PCI_PRODUCT_V3_V960PBC,
	    "V960PBC i960 PCI",
	},
	{
	    PCI_VENDOR_V3, PCI_PRODUCT_V3_V96DPC,
	    "V96DPC i960 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8M800_0,
	    "K8M800 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8T890_0,
	    "K8T890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PT880_0,
	    "PT880 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PM800_AGP,
	    "PM800 AGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_KT880_AGP,
	    "KT880 AGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8HTB_0,
	    "K8HTB Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8363,
	    "VT8363 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PT894,
	    "PT894 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CN700,
	    "CN700 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CX700,
	    "CX700 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M890,
	    "P4M890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8M890_0,
	    "K8M890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT3351_HB,
	    "VT3351 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VX800_0,
	    "VX800 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M900,
	    "P4M900 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8371_HB,
	    "VT8371 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8501,
	    "VT8501",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C505,
	    "VT82C505",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C561,
	    "VT82C561",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C571,
	    "VT82C571 IDE",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C576,
	    "VT82C576 3V",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VX700_IDE,
	    "VX700 IDE",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C585,
	    "VT82C585 ISA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C586_ISA,
	    "VT82C586 ISA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8237A_SATA,
	    "VT8237A SATA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C595,
	    "VT82C595 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C596A,
	    "VT82C596A ISA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C597PCI,
	    "VT82C597 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C598PCI,
	    "VT82C598 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8601,
	    "VT8601 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8605,
	    "VT8605 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C686A_ISA,
	    "VT82C686 ISA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C691,
	    "VT82C691 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C693,
	    "VT82C693 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT86C926,
	    "VT86C926 Amazon",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C570M,
	    "VT82C570M PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C570MV,
	    "VT82C570M ISA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CHROME9HC3,
	    "Chrome9 HC3 IGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8M800_1,
	    "K8M800 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8T890_1,
	    "K8T890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PT880_1,
	    "PT880 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PM800_ERRS,
	    "PM800 Errors",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_KT880_1,
	    "KT880 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8HTB_1,
	    "K8HTB Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PT894_2,
	    "PT894 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CN700_2,
	    "CN700 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CX700_1,
	    "CX700 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M890_1,
	    "P4M890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8M890_1,
	    "K8M890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT3351_2,
	    "VT3351 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VX800_1,
	    "VX800 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M900_1,
	    "P4M900 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C416,
	    "VT82C416 IDE",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C1595,
	    "VT82C1595 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8M800_2,
	    "K8M800 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8T890_2,
	    "K8T890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PT880_2,
	    "PT880 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PM800,
	    "PM800 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_KT880_2,
	    "KT880 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8HTB_2,
	    "K8HTB Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PT894_3,
	    "PT894 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CN700_3,
	    "CN700 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CX700_2,
	    "CX700 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M890_2,
	    "P4M890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8M890_2,
	    "K8M890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT3351_3,
	    "VT3351 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VX800_2,
	    "VX800 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M900_2,
	    "P4M900 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8251_PCI,
	    "VT8251 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8251_PCIE_0,
	    "VT8251 PCIE",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8251_PCIE_1,
	    "VT8251 PCIE",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8251_PCIE_2,
	    "VT8251 PCIE",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8251_VLINK,
	    "VT8251 VLINK",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT83C572,
	    "VT83C572 USB",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C586_PWR,
	    "VT82C586 Power",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_RHINE,
	    "Rhine/RhineII",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT6306,
	    "VT6306 FireWire",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C596,
	    "VT82C596 Power",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C596B_PM,
	    "VT82C596B PM",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT6105M,
	    "VT6105M RhineIII",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C686A_SMB,
	    "VT82C686 SMBus",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C686A_AC97,
	    "VT82C686 AC97",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8233_AC97,
	    "VT8233 AC97",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_RHINEII_2,
	    "RhineII-2",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C686A_ACM,
	    "VT82C686 Modem",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8233_ISA,
	    "VT8233 ISA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8633,
	    "VT8633 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8366,
	    "VT8366 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8653_PCI,
	    "VT8653 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT6202,
	    "VT6202 USB",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT6105,
	    "VT6105 RhineIII",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_UNICHROME,
	    "S3 Unichrome PRO IGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8361_PCI,
	    "VT8361 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8101_PPB,
	    "VT8101 VPX-64 PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8375,
	    "VT8375 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PM800_UNICHROME,
	    "PM800 Unichrome S3",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT612x,
	    "VT612x",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CLE266,
	    "CLE266",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8623,
	    "VT8623 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8233A_ISA,
	    "VT8233A ISA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8751,
	    "VT8751 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT6420_SATA,
	    "VT6420 SATA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_UNICHROME2_1,
	    "S3 UniChrome Pro II IGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT6410,
	    "VT6410 IDE",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4X400,
	    "P4X400 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8235_ISA,
	    "VT8235 ISA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4N333,
	    "P4N333 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8HTB,
	    "K8HTB Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8377,
	    "VT8377 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8M800,
	    "K8M800 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8378,
	    "VT8378 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PT890,
	    "PT890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8T800M,
	    "K8T800M Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8237_ISA,
	    "VT8237 ISA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_DELTACHROME,
	    "DeltaChrome Video",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8T890_3,
	    "K8T890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT6421_SATA,
	    "VT6421 SATA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CX700_PPB_1,
	    "CX700 PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CX700_3,
	    "CX700 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VX700_1,
	    "VX700 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PT880_3,
	    "PT880 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PM800_DRAM,
	    "PM800 DRAM",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_KT880_3,
	    "KT880 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8HTB_3,
	    "K8HTB Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8251_ISA,
	    "VT8251 ISA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_HDA,
	    "HD Audio",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CX700_4,
	    "CX700 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M890_3,
	    "P4M890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8M890_3,
	    "K8M890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8237A_ISA,
	    "VT8237A ISA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_UNICHROME_3,
	    "S3 Unichrome PRO IGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_UNICHROME_2,
	    "S3 Unichrome PRO IGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8251_SATA,
	    "VT8251 SATA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT3351_4,
	    "VT3351 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VX800_DRAM,
	    "VX800 DRAM",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M900_3,
	    "P4M900 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CHROME9_HC,
	    "Chrome9 HC IGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8237S_ISA,
	    "VT8237S ISA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8237A_PPB_1,
	    "VT8237A PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8237A_PPB_2,
	    "VT8237A PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8M800_4,
	    "K8M800 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8T890_4,
	    "K8T890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PT880_4,
	    "PT880 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PM800_PMC,
	    "PM800 PMC",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_KT880_4,
	    "KT880 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8HTB_4,
	    "K8HTB Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PT894_4,
	    "PT894 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CN700_4,
	    "CN700 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CX700_5,
	    "CX700 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M890_4,
	    "P4M890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8M890_4,
	    "K8M890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT3351_5,
	    "VT3351 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VX800_4,
	    "VX800 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M900_4,
	    "P4M900 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8T890_IOAPIC,
	    "K8T890 IOAPIC",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PT894_IOAPIC,
	    "PT894 IOAPIC",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CX700_IDE,
	    "CX700 IDE",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M890_IOAPIC,
	    "P4M890 IOAPIC",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8M890_IOAPIC,
	    "K8M890 IOAPIC",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8237A_SATA_2,
	    "VT8237A SATA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT3351_IOAPIC,
	    "VT3351 IOAPIC",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VX800_IOAPIC,
	    "VX800 IOAPIC",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M900_IOAPIC,
	    "P4M900 IOAPIC",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8237S_SATA,
	    "VT8237S SATA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_RHINEII,
	    "RhineII",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT3351_6,
	    "VT3351 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8M890_6,
	    "K8M890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M890_6,
	    "P4M890 Security",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VX800_6,
	    "VX800 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M900_6,
	    "P4M900 Security",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8M800_7,
	    "K8M800 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8378_VGA,
	    "VT8378 VGA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PT894_5,
	    "PT894 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M890_7,
	    "P4M890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8M890_7,
	    "K8M890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VX800_7,
	    "VX800 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M900_7,
	    "P4M900 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8T890_7,
	    "K8T890 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PT880_7,
	    "PT880 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_PM800_PCI,
	    "PM800 PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_KT880_7,
	    "KT880 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8HTB_7,
	    "K8HTB Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CN700_7,
	    "CN700 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CX700_7,
	    "CX700 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT3351_7,
	    "VT3351 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8231_ISA,
	    "VT8231 ISA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8231_PWR,
	    "VT8231 PMG",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8363_AGP,
	    "VT8363 AGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_CX700_ISA,
	    "CX700 ISA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VX800_ISA,
	    "VX800 ISA",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8371_PPB,
	    "VT8371 PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8501_AGP,
	    "VT8501 AGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C597AGP,
	    "VT82C597 AGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C598AGP,
	    "VT82C598 AGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT82C601,
	    "VT82C601 AGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8605_AGP,
	    "VT8605 AGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VX800_SDMMC,
	    "VX800 SD/MMC",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VX800_SDIO,
	    "VX800 SDIO",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8T890_PPB_A,
	    "K8T890 PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M890_PPB_1,
	    "P4M890 PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VX800_A,
	    "VX800 Host",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M900_PPB_1,
	    "P4M900 PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8633_AGP,
	    "VT8633 AGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8366_AGP,
	    "VT8366 AGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8361_AGP,
	    "VT8361 AGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8101_IOAPIC,
	    "VT8101 VPX-64 IOAPIC",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8363_PCI,
	    "VT8363 PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8235_AGP,
	    "VT8235 AGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8HTB_AGP,
	    "K8HTB AGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VT8377_AGP,
	    "VT8377 AGP",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_VX800_PPB,
	    "VX800 PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8T890_PPB_B,
	    "K8T890 PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8T890_PPB_C,
	    "K8T890 PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M890_PPB_2,
	    "P4M890 PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_P4M900_PPB_2,
	    "P4M900 PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8T890_PPB_D,
	    "K8T890 PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8T890_PPB_E,
	    "K8T890 PCI-PCI",
	},
	{
	    PCI_VENDOR_VIATECH, PCI_PRODUCT_VIATECH_K8T890_PPB_F,
	    "K8T890 PCI-PCI",
	},
	{
	    PCI_VENDOR_VITESSE, PCI_PRODUCT_VITESSE_VSC_7174,
	    "VSC-7174 SATA",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_60x0,
	    "GDT6000/6020/6050",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6000B,
	    "GDT6000B/6010",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x10,
	    "GDT6110/6510",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x20,
	    "GDT6120/6520",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6530,
	    "GDT6530",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6550,
	    "GDT6550",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x17,
	    "GDT6x17",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x27,
	    "GDT6x27",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6537,
	    "GDT6537",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6557,
	    "GDT6557",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x15,
	    "GDT6x15",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x25,
	    "GDT6x25",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6535,
	    "GDT6535",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6555,
	    "GDT6555",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x17RP,
	    "GDT6x17RP",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x27RP,
	    "GDT6x27RP",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6537RP,
	    "GDT6537RP",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6557RP,
	    "GDT6557RP",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x11RP,
	    "GDT6x11RP",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x21RP,
	    "GDT6x21RP",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x17RD,
	    "GDT6x17RP1",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x27RD,
	    "GDT6x27RP1",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6537RD,
	    "GDT6537RP1",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6557RD,
	    "GDT6557RP1",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x11RD,
	    "GDT6x11RP1",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x21RD,
	    "GDT6x21RP1",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x18RD,
	    "GDT6x18RD",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x28RD,
	    "GDT6x28RD",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x38RD,
	    "GDT6x38RD",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x58RD,
	    "GDT6x58RD",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x17RP2,
	    "GDT6x17RP2",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x27RP2,
	    "GDT6x27RP2",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6537RP2,
	    "GDT6537RP2",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6557RP2,
	    "GDT6557RP2",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x11RP2,
	    "GDT6x11RP2",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x21RP2,
	    "GDT6x21RP2",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x13RS,
	    "GDT6513RS",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x23RS,
	    "GDT6523RS",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6518RS,
	    "GDT6518RS",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x28RS,
	    "GDT6x28RS",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x38RS,
	    "GDT6x38RS",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x58RS,
	    "GDT6x58RS",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x33RS,
	    "GDT6x33RS",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x43RS,
	    "GDT6x43RS",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x53RS,
	    "GDT6x53RS",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x63RS,
	    "GDT6x63RS",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_7x13RN,
	    "GDT7x13RN",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_7x23RN,
	    "GDT7x23RN",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_7x18RN,
	    "GDT7x18RN",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_7x28RN,
	    "GDT7x28RN",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_7x38RN,
	    "GDT7x38RN",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_7x58RN,
	    "GDT7x58RN",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_7x43RN,
	    "GDT7x43RN",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_7x53RN,
	    "GDT7x53RN",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_7x63RN,
	    "GDT7x63RN",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_4x13RZ,
	    "GDT4x13RZ",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_4x23RZ,
	    "GDT4x23RZ",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_8x13RZ,
	    "GDT8x13RZ",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_8x23RZ,
	    "GDT8x23RZ",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_8x33RZ,
	    "GDT8x33RZ",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_8x43RZ,
	    "GDT8x43RZ",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_8x53RZ,
	    "GDT8x53RZ",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_8x63RZ,
	    "GDT8x63RZ",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x19RD,
	    "GDT6x19RD",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_6x29RD,
	    "GDT6x29RD",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_7x19RN,
	    "GDT7x19RN",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_7x29RN,
	    "GDT7x29RN",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_8x22RZ,
	    "GDT8x22RZ",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_ICP,
	    "ICP",
	},
	{
	    PCI_VENDOR_VORTEX, PCI_PRODUCT_VORTEX_GDT_ICP2,
	    "ICP",
	},
	{
	    PCI_VENDOR_VLSI, PCI_PRODUCT_VLSI_82C592,
	    "82C592 CPU",
	},
	{
	    PCI_VENDOR_VLSI, PCI_PRODUCT_VLSI_82C593,
	    "82C593 ISA",
	},
	{
	    PCI_VENDOR_VLSI, PCI_PRODUCT_VLSI_82C594,
	    "82C594 Wildcat",
	},
	{
	    PCI_VENDOR_VLSI, PCI_PRODUCT_VLSI_82C596597,
	    "82C596/597 Wildcat ISA",
	},
	{
	    PCI_VENDOR_VLSI, PCI_PRODUCT_VLSI_82C541,
	    "82C541",
	},
	{
	    PCI_VENDOR_VLSI, PCI_PRODUCT_VLSI_82C543,
	    "82C543",
	},
	{
	    PCI_VENDOR_VLSI, PCI_PRODUCT_VLSI_82C532,
	    "82C532",
	},
	{
	    PCI_VENDOR_VLSI, PCI_PRODUCT_VLSI_82C534,
	    "82C534",
	},
	{
	    PCI_VENDOR_VLSI, PCI_PRODUCT_VLSI_82C535,
	    "82C535",
	},
	{
	    PCI_VENDOR_VLSI, PCI_PRODUCT_VLSI_82C147,
	    "82C147",
	},
	{
	    PCI_VENDOR_VLSI, PCI_PRODUCT_VLSI_82C975,
	    "82C975",
	},
	{
	    PCI_VENDOR_VLSI, PCI_PRODUCT_VLSI_82C925,
	    "82C925",
	},
	{
	    PCI_VENDOR_VMWARE, PCI_PRODUCT_VMWARE_VIRTUAL2,
	    "Virtual SVGA II",
	},
	{
	    PCI_VENDOR_VMWARE, PCI_PRODUCT_VMWARE_VIRTUAL,
	    "Virtual SVGA",
	},
	{
	    PCI_VENDOR_VMWARE, PCI_PRODUCT_VMWARE_NET,
	    "Virtual NIC",
	},
	{
	    PCI_VENDOR_VMWARE, PCI_PRODUCT_VMWARE_EHCI,
	    "Virtual EHCI",
	},
	{
	    PCI_VENDOR_VMWARE, PCI_PRODUCT_VMWARE_PPB,
	    "Virtual PCI-PCI",
	},
	{
	    PCI_VENDOR_WEITEK, PCI_PRODUCT_WEITEK_P9000,
	    "P9000",
	},
	{
	    PCI_VENDOR_WEITEK, PCI_PRODUCT_WEITEK_P9100,
	    "P9100",
	},
	{
	    PCI_VENDOR_WD, PCI_PRODUCT_WD_WD33C193A,
	    "WD33C193A",
	},
	{
	    PCI_VENDOR_WD, PCI_PRODUCT_WD_WD33C196A,
	    "WD33C196A",
	},
	{
	    PCI_VENDOR_WD, PCI_PRODUCT_WD_WD33C197A,
	    "WD33C197A",
	},
	{
	    PCI_VENDOR_WD, PCI_PRODUCT_WD_WD7193,
	    "WD7193",
	},
	{
	    PCI_VENDOR_WD, PCI_PRODUCT_WD_WD7197,
	    "WD7197",
	},
	{
	    PCI_VENDOR_WD, PCI_PRODUCT_WD_WD33C296A,
	    "WD33C296A",
	},
	{
	    PCI_VENDOR_WD, PCI_PRODUCT_WD_WD34C296,
	    "WD34C296",
	},
	{
	    PCI_VENDOR_WD, PCI_PRODUCT_WD_WD9710,
	    "WD9610",
	},
	{
	    PCI_VENDOR_WD, PCI_PRODUCT_WD_90C,
	    "90C",
	},
	{
	    PCI_VENDOR_WINBOND, PCI_PRODUCT_WINBOND_W83769F,
	    "W83769F",
	},
	{
	    PCI_VENDOR_WINBOND, PCI_PRODUCT_WINBOND_W89C840F,
	    "W89C840F 10/100",
	},
	{
	    PCI_VENDOR_WINBOND, PCI_PRODUCT_WINBOND_W89C940F,
	    "Linksys EtherPCI II",
	},
	{
	    PCI_VENDOR_WINBOND, PCI_PRODUCT_WINBOND_W83C553F_0,
	    "W83C553F ISA",
	},
	{
	    PCI_VENDOR_WINBOND, PCI_PRODUCT_WINBOND_W83C553F_1,
	    "W83C553F",
	},
	{
	    PCI_VENDOR_WINBOND, PCI_PRODUCT_WINBOND_W89C940F_1,
	    "W89C940F",
	},
	{
	    PCI_VENDOR_WINBOND, PCI_PRODUCT_WINBOND_W6692,
	    "W6692 ISDN",
	},
	{
	    PCI_VENDOR_WINBOND2, PCI_PRODUCT_WINBOND2_W89C940,
	    "Linksys EtherPCI",
	},
	{
	    PCI_VENDOR_XGI, PCI_PRODUCT_XGI_VOLARI_Z7,
	    "Volari Z7",
	},
	{
	    PCI_VENDOR_XIRCOM, PCI_PRODUCT_XIRCOM_X3201_3,
	    "X3201-3",
	},
	{
	    PCI_VENDOR_XIRCOM, PCI_PRODUCT_XIRCOM_X3201_3_21143,
	    "X3201-3 (21143)",
	},
	{
	    PCI_VENDOR_XIRCOM, PCI_PRODUCT_XIRCOM_CARDBUS_ETH_1,
	    "CardBus Ethernet",
	},
	{
	    PCI_VENDOR_XIRCOM, PCI_PRODUCT_XIRCOM_CARDBUS_ETH_2,
	    "CardBus Ethernet",
	},
	{
	    PCI_VENDOR_XIRCOM, PCI_PRODUCT_XIRCOM_CARDBUS_ETH_3,
	    "CardBus Ethernet",
	},
	{
	    PCI_VENDOR_XIRCOM, PCI_PRODUCT_XIRCOM_MPCI_MODEM_V90,
	    "Mini-PCI V.90 56k Modem",
	},
	{
	    PCI_VENDOR_XIRCOM, PCI_PRODUCT_XIRCOM_CARDBUS_ETH_4,
	    "CardBus Ethernet",
	},
	{
	    PCI_VENDOR_XIRCOM, PCI_PRODUCT_XIRCOM_MPCI_MODEM_K56,
	    "Mini-PCI K56Flex Modem",
	},
	{
	    PCI_VENDOR_XIRCOM, PCI_PRODUCT_XIRCOM_MODEM_56K,
	    "CardBus 56k Modem",
	},
	{
	    PCI_VENDOR_XIRCOM, PCI_PRODUCT_XIRCOM_MODEM56,
	    "56k Modem",
	},
	{
	    PCI_VENDOR_XIRCOM, PCI_PRODUCT_XIRCOM_CBEM56G,
	    "CBEM56G Modem",
	},
	{
	    PCI_VENDOR_YAMAHA, PCI_PRODUCT_YAMAHA_YMF724,
	    "724",
	},
	{
	    PCI_VENDOR_YAMAHA, PCI_PRODUCT_YAMAHA_YMF734,
	    "734",
	},
	{
	    PCI_VENDOR_YAMAHA, PCI_PRODUCT_YAMAHA_YMF738_TEG,
	    "738",
	},
	{
	    PCI_VENDOR_YAMAHA, PCI_PRODUCT_YAMAHA_YMF737,
	    "737",
	},
	{
	    PCI_VENDOR_YAMAHA, PCI_PRODUCT_YAMAHA_YMF740,
	    "740",
	},
	{
	    PCI_VENDOR_YAMAHA, PCI_PRODUCT_YAMAHA_YMF740C,
	    "740C",
	},
	{
	    PCI_VENDOR_YAMAHA, PCI_PRODUCT_YAMAHA_YMF724F,
	    "724F",
	},
	{
	    PCI_VENDOR_YAMAHA, PCI_PRODUCT_YAMAHA_YMF744,
	    "744",
	},
	{
	    PCI_VENDOR_YAMAHA, PCI_PRODUCT_YAMAHA_YMF754,
	    "754",
	},
	{
	    PCI_VENDOR_YAMAHA, PCI_PRODUCT_YAMAHA_YMF738,
	    "738",
	},
	{
	    PCI_VENDOR_ZEINET, PCI_PRODUCT_ZEINET_1221,
	    "1221",
	},
	{
	    PCI_VENDOR_ZIATECH, PCI_PRODUCT_ZIATECH_ZT8905,
	    "PCI-ST32",
	},
	{
	    PCI_VENDOR_ZOLTRIX, PCI_PRODUCT_ZOLTRIX_GENIE_TV_FM,
	    "Genie TV/FM",
	},
	{
	    PCI_VENDOR_ZORAN, PCI_PRODUCT_ZORAN_ZR36057,
	    "TV",
	},
	{
	    PCI_VENDOR_ZORAN, PCI_PRODUCT_ZORAN_ZR36120,
	    "DVD",
	},
	{
	    PCI_VENDOR_ZYDAS, PCI_PRODUCT_ZYDAS_ZD1201,
	    "ZD1201",
	},
	{
	    PCI_VENDOR_ZYDAS, PCI_PRODUCT_ZYDAS_ZD1202,
	    "ZD1202",
	},
	{
	    PCI_VENDOR_ZYDAS, PCI_PRODUCT_ZYDAS_ZD1205,
	    "ZD1205",
	},
	{ 0, 0, NULL, }
};

static const struct pci_known_vendor pci_known_vendors[] = {
	{
	    PCI_VENDOR_MARTINMARIETTA,
	    "Martin-Marietta",
	},
	{
	    PCI_VENDOR_HAUPPAUGE,
	    "Hauppauge",
	},
	{
	    PCI_VENDOR_TTTECH,
	    "TTTech",
	},
	{
	    PCI_VENDOR_DYNALINK,
	    "Dynalink",
	},
	{
	    PCI_VENDOR_COMPAQ,
	    "Compaq",
	},
	{
	    PCI_VENDOR_SYMBIOS,
	    "Symbios Logic",
	},
	{
	    PCI_VENDOR_ATI,
	    "ATI",
	},
	{
	    PCI_VENDOR_ULSI,
	    "ULSI Systems",
	},
	{
	    PCI_VENDOR_VLSI,
	    "VLSI",
	},
	{
	    PCI_VENDOR_AVANCE,
	    "Avance Logic",
	},
	{
	    PCI_VENDOR_NS,
	    "NS",
	},
	{
	    PCI_VENDOR_TSENG,
	    "Tseng Labs",
	},
	{
	    PCI_VENDOR_WEITEK,
	    "Weitek",
	},
	{
	    PCI_VENDOR_DEC,
	    "DEC",
	},
	{
	    PCI_VENDOR_CIRRUS,
	    "Cirrus Logic",
	},
	{
	    PCI_VENDOR_IBM,
	    "IBM",
	},
	{
	    PCI_VENDOR_WD,
	    "Western Digital",
	},
	{
	    PCI_VENDOR_AMI,
	    "AMI",
	},
	{
	    PCI_VENDOR_AMD,
	    "AMD",
	},
	{
	    PCI_VENDOR_TRIDENT,
	    "Trident",
	},
	{
	    PCI_VENDOR_ACER,
	    "Acer",
	},
	{
	    PCI_VENDOR_DELL,
	    "Dell",
	},
	{
	    PCI_VENDOR_SNI,
	    "Siemens Nixdorf AG",
	},
	{
	    PCI_VENDOR_MATROX,
	    "Matrox",
	},
	{
	    PCI_VENDOR_CHIPS,
	    "Chips and Technologies",
	},
	{
	    PCI_VENDOR_TOSHIBA,
	    "Toshiba",
	},
	{
	    PCI_VENDOR_MIRO,
	    "Miro Computer Products AG",
	},
	{
	    PCI_VENDOR_NEC,
	    "NEC",
	},
	{
	    PCI_VENDOR_FUTUREDOMAIN,
	    "Future Domain",
	},
	{
	    PCI_VENDOR_SIS,
	    "SiS",
	},
	{
	    PCI_VENDOR_HP,
	    "Hewlett-Packard",
	},
	{
	    PCI_VENDOR_PCTECH,
	    "PC Technology",
	},
	{
	    PCI_VENDOR_ASUSTEK,
	    "Asustek",
	},
	{
	    PCI_VENDOR_DPT,
	    "DPT",
	},
	{
	    PCI_VENDOR_OPTI,
	    "Opti",
	},
	{
	    PCI_VENDOR_ELSA,
	    "Elsa",
	},
	{
	    PCI_VENDOR_SGSTHOMSON,
	    "SGS Thomson",
	},
	{
	    PCI_VENDOR_BUSLOGIC,
	    "BusLogic",
	},
	{
	    PCI_VENDOR_TI,
	    "TI",
	},
	{
	    PCI_VENDOR_SONY,
	    "Sony",
	},
	{
	    PCI_VENDOR_OAKTECH,
	    "Oak Technology",
	},
	{
	    PCI_VENDOR_WINBOND,
	    "Winbond",
	},
	{
	    PCI_VENDOR_HITACHI,
	    "Hitachi",
	},
	{
	    PCI_VENDOR_SMSC,
	    "SMSC",
	},
	{
	    PCI_VENDOR_MOT,
	    "Motorola",
	},
	{
	    PCI_VENDOR_PROMISE,
	    "Promise",
	},
	{
	    PCI_VENDOR_NUMBER9,
	    "Number 9",
	},
	{
	    PCI_VENDOR_UMC,
	    "UMC",
	},
	{
	    PCI_VENDOR_ITT,
	    "I. T. T.",
	},
	{
	    PCI_VENDOR_PICOPOWER,
	    "Picopower",
	},
	{
	    PCI_VENDOR_MYLEX,
	    "Mylex",
	},
	{
	    PCI_VENDOR_APPLE,
	    "Apple",
	},
	{
	    PCI_VENDOR_MITAC,
	    "Mitac",
	},
	{
	    PCI_VENDOR_YAMAHA,
	    "Yamaha",
	},
	{
	    PCI_VENDOR_NEXGEN,
	    "NexGen Microsystems",
	},
	{
	    PCI_VENDOR_QLOGIC,
	    "QLogic",
	},
	{
	    PCI_VENDOR_CYRIX,
	    "Cyrix",
	},
	{
	    PCI_VENDOR_LEADTEK,
	    "LeadTek Research",
	},
	{
	    PCI_VENDOR_INTERPHASE,
	    "Interphase",
	},
	{
	    PCI_VENDOR_CONTAQ,
	    "Contaq Microsystems",
	},
	{
	    PCI_VENDOR_BIT3,
	    "Bit3",
	},
	{
	    PCI_VENDOR_OLICOM,
	    "Olicom",
	},
	{
	    PCI_VENDOR_SUN,
	    "Sun",
	},
	{
	    PCI_VENDOR_INTERGRAPH,
	    "Intergraph",
	},
	{
	    PCI_VENDOR_DIAMOND,
	    "Diamond Multimedia",
	},
	{
	    PCI_VENDOR_NATINST,
	    "National Instruments",
	},
	{
	    PCI_VENDOR_CMDTECH,
	    "CMD Technology",
	},
	{
	    PCI_VENDOR_QUANTUMDESIGNS,
	    "Quantum Designs",
	},
	{
	    PCI_VENDOR_BROOKTREE,
	    "Brooktree",
	},
	{
	    PCI_VENDOR_SGI,
	    "SGI",
	},
	{
	    PCI_VENDOR_ACC,
	    "ACC Microelectronics",
	},
	{
	    PCI_VENDOR_SYMPHONY,
	    "Symphony Labs",
	},
	{
	    PCI_VENDOR_STB,
	    "STB Systems",
	},
	{
	    PCI_VENDOR_PLX,
	    "PLX",
	},
	{
	    PCI_VENDOR_MADGE,
	    "Madge Networks",
	},
	{
	    PCI_VENDOR_3COM,
	    "3Com",
	},
	{
	    PCI_VENDOR_SMC,
	    "SMC",
	},
	{
	    PCI_VENDOR_ALI,
	    "Acer Labs",
	},
	{
	    PCI_VENDOR_MITSUBISHIELEC,
	    "Mitsubishi Electronics",
	},
	{
	    PCI_VENDOR_SURECOM,
	    "Surecom",
	},
	{
	    PCI_VENDOR_NEOMAGIC,
	    "Neomagic",
	},
	{
	    PCI_VENDOR_MENTOR,
	    "Mentor ARC",
	},
	{
	    PCI_VENDOR_ADVSYS,
	    "Advansys",
	},
	{
	    PCI_VENDOR_FUJITSU,
	    "Fujitsu",
	},
	{
	    PCI_VENDOR_MOLEX,
	    "Molex",
	},
	{
	    PCI_VENDOR_MACRONIX,
	    "Macronix",
	},
	{
	    PCI_VENDOR_ES,
	    "Evans & Sutherland",
	},
	{
	    PCI_VENDOR_NVIDIA,
	    "NVIDIA",
	},
	{
	    PCI_VENDOR_EMULEX,
	    "Emulex",
	},
	{
	    PCI_VENDOR_IMS,
	    "Integrated Micro Solutions",
	},
	{
	    PCI_VENDOR_TEKRAM,
	    "Tekram (1st ID)",
	},
	{
	    PCI_VENDOR_NEWBRIDGE,
	    "Newbridge",
	},
	{
	    PCI_VENDOR_AMCIRCUITS,
	    "Applied Micro Circuits",
	},
	{
	    PCI_VENDOR_TVIA,
	    "Tvia",
	},
	{
	    PCI_VENDOR_REALTEK,
	    "Realtek",
	},
	{
	    PCI_VENDOR_NKK,
	    "NKK",
	},
	{
	    PCI_VENDOR_IODATA,
	    "IO Data Device",
	},
	{
	    PCI_VENDOR_INITIO,
	    "Initio",
	},
	{
	    PCI_VENDOR_CREATIVELABS,
	    "Creative Labs",
	},
	{
	    PCI_VENDOR_TRIONES,
	    "HighPoint",
	},
	{
	    PCI_VENDOR_SIGMA,
	    "Sigma Designs",
	},
	{
	    PCI_VENDOR_VIATECH,
	    "VIA",
	},
	{
	    PCI_VENDOR_COGENT,
	    "Cogent Data",
	},
	{
	    PCI_VENDOR_SIEMENS,
	    "Siemens",
	},
	{
	    PCI_VENDOR_ZNYX,
	    "Znyx Networks",
	},
	{
	    PCI_VENDOR_ACCTON,
	    "Accton",
	},
	{
	    PCI_VENDOR_VORTEX,
	    "Vortex",
	},
	{
	    PCI_VENDOR_EFFICIENTNETS,
	    "Efficent Networks",
	},
	{
	    PCI_VENDOR_IDT,
	    "IDT",
	},
	{
	    PCI_VENDOR_FORE,
	    "FORE Systems",
	},
	{
	    PCI_VENDOR_PHILIPS,
	    "Philips",
	},
	{
	    PCI_VENDOR_ZIATECH,
	    "Ziatech",
	},
	{
	    PCI_VENDOR_CYCLONE,
	    "Cyclone",
	},
	{
	    PCI_VENDOR_EQUINOX,
	    "Equinox",
	},
	{
	    PCI_VENDOR_ALLIANCE,
	    "Alliance Semiconductor",
	},
	{
	    PCI_VENDOR_SCHNEIDERKOCH,
	    "Schneider & Koch",
	},
	{
	    PCI_VENDOR_DIGI,
	    "Digi",
	},
	{
	    PCI_VENDOR_MUTECH,
	    "Mutech",
	},
	{
	    PCI_VENDOR_XIRCOM,
	    "Xircom",
	},
	{
	    PCI_VENDOR_RENDITION,
	    "Rendition",
	},
	{
	    PCI_VENDOR_RCC,
	    "ServerWorks",
	},
	{
	    PCI_VENDOR_ALTERA,
	    "Altera",
	},
	{
	    PCI_VENDOR_TOSHIBA2,
	    "Toshiba",
	},
	{
	    PCI_VENDOR_RICOH,
	    "Ricoh",
	},
	{
	    PCI_VENDOR_DLINK,
	    "D-Link Systems",
	},
	{
	    PCI_VENDOR_COROLLARY,
	    "Corollary",
	},
	{
	    PCI_VENDOR_ACARD,
	    "Acard",
	},
	{
	    PCI_VENDOR_ZEINET,
	    "Zeinet",
	},
	{
	    PCI_VENDOR_OMEGA,
	    "Omega Micro",
	},
	{
	    PCI_VENDOR_MARVELL,
	    "Marvell",
	},
	{
	    PCI_VENDOR_LITEON,
	    "Lite-On",
	},
	{
	    PCI_VENDOR_V3,
	    "V3 Semiconductor",
	},
	{
	    PCI_VENDOR_PINNACLE,
	    "Pinnacle Systems",
	},
	{
	    PCI_VENDOR_LUCENT,
	    "AT&T/Lucent",
	},
	{
	    PCI_VENDOR_DOLPHIN,
	    "Dolphin",
	},
	{
	    PCI_VENDOR_MRTMAGMA,
	    "Mesa Ridge (MAGMA)",
	},
	{
	    PCI_VENDOR_AD,
	    "Analog Devices",
	},
	{
	    PCI_VENDOR_ZORAN,
	    "Zoran",
	},
	{
	    PCI_VENDOR_PIJNENBURG,
	    "Pijnenburg",
	},
	{
	    PCI_VENDOR_COMPEX,
	    "Compex",
	},
	{
	    PCI_VENDOR_CYCLADES,
	    "Cyclades",
	},
	{
	    PCI_VENDOR_ESSENTIAL,
	    "Essential Communications",
	},
	{
	    PCI_VENDOR_O2MICRO,
	    "O2 Micro",
	},
	{
	    PCI_VENDOR_3DFX,
	    "3DFX Interactive",
	},
	{
	    PCI_VENDOR_ATML,
	    "ATML",
	},
	{
	    PCI_VENDOR_CCUBE,
	    "C-Cube",
	},
	{
	    PCI_VENDOR_AVM,
	    "AVM",
	},
	{
	    PCI_VENDOR_STALLION,
	    "Stallion Technologies",
	},
	{
	    PCI_VENDOR_COREGA,
	    "Corega",
	},
	{
	    PCI_VENDOR_ASIX,
	    "ASIX",
	},
	{
	    PCI_VENDOR_ESSTECH,
	    "ESS",
	},
	{
	    PCI_VENDOR_INTERSIL,
	    "Intersil",
	},
	{
	    PCI_VENDOR_NORTEL,
	    "Nortel Networks",
	},
	{
	    PCI_VENDOR_SMI,
	    "Silicon Motion",
	},
	{
	    PCI_VENDOR_ENSONIQ,
	    "Ensoniq",
	},
	{
	    PCI_VENDOR_TRANSMETA,
	    "Transmeta",
	},
	{
	    PCI_VENDOR_ROCKWELL,
	    "Rockwell",
	},
	{
	    PCI_VENDOR_DAVICOM,
	    "Davicom",
	},
	{
	    PCI_VENDOR_ITEXPRESS,
	    "ITExpress",
	},
	{
	    PCI_VENDOR_PLATFORM,
	    "Platform",
	},
	{
	    PCI_VENDOR_LUXSONOR,
	    "LuxSonor",
	},
	{
	    PCI_VENDOR_TRITECH,
	    "TriTech Microelectronics",
	},
	{
	    PCI_VENDOR_ALTEON,
	    "Alteon",
	},
	{
	    PCI_VENDOR_USR,
	    "US Robotics",
	},
	{
	    PCI_VENDOR_STB2,
	    "NVIDIA/SGS-Thomson",
	},
	{
	    PCI_VENDOR_PERICOM,
	    "Pericom",
	},
	{
	    PCI_VENDOR_AUREAL,
	    "Aureal",
	},
	{
	    PCI_VENDOR_ADMTEK,
	    "ADMtek",
	},
	{
	    PCI_VENDOR_PE,
	    "Packet Engines",
	},
	{
	    PCI_VENDOR_FORTEMEDIA,
	    "Forte Media",
	},
	{
	    PCI_VENDOR_SIIG,
	    "SIIG",
	},
	{
	    PCI_VENDOR_DTCTECH,
	    "DTC Tech",
	},
	{
	    PCI_VENDOR_PCTEL,
	    "PCTEL",
	},
	{
	    PCI_VENDOR_MEINBERG,
	    "Meinberg Funkuhren",
	},
	{
	    PCI_VENDOR_CNET,
	    "CNet",
	},
	{
	    PCI_VENDOR_SILICOM,
	    "Silicom",
	},
	{
	    PCI_VENDOR_LMC,
	    "LAN Media",
	},
	{
	    PCI_VENDOR_NETGEAR,
	    "Netgear",
	},
	{
	    PCI_VENDOR_MOXA,
	    "Moxa",
	},
	{
	    PCI_VENDOR_LEVEL1,
	    "Level 1",
	},
	{
	    PCI_VENDOR_HIFN,
	    "Hifn",
	},
	{
	    PCI_VENDOR_EXAR,
	    "Exar",
	},
	{
	    PCI_VENDOR_3WARE,
	    "3ware",
	},
	{
	    PCI_VENDOR_ABOCOM,
	    "Abocom",
	},
	{
	    PCI_VENDOR_SUNDANCE,
	    "Sundance",
	},
	{
	    PCI_VENDOR_CMI,
	    "C-Media Electronics",
	},
	{
	    PCI_VENDOR_LAVA,
	    "Lava",
	},
	{
	    PCI_VENDOR_SUNIX,
	    "Sunix",
	},
	{
	    PCI_VENDOR_ICENSEMBLE,
	    "IC Ensemble",
	},
	{
	    PCI_VENDOR_MICROSOFT,
	    "Microsoft",
	},
	{
	    PCI_VENDOR_OXFORD2,
	    "Oxford",
	},
	{
	    PCI_VENDOR_CHELSIO,
	    "Chelsio",
	},
	{
	    PCI_VENDOR_TAMARACK,
	    "Tamarack",
	},
	{
	    PCI_VENDOR_ASKEY,
	    "Askey",
	},
	{
	    PCI_VENDOR_AVERMEDIA,
	    "Avermedia",
	},
	{
	    PCI_VENDOR_AIRONET,
	    "Aironet",
	},
	{
	    PCI_VENDOR_GLOBESPAN,
	    "Globespan",
	},
	{
	    PCI_VENDOR_MYRICOM,
	    "Myricom",
	},
	{
	    PCI_VENDOR_OXFORD,
	    "VScom",
	},
	{
	    PCI_VENDOR_AVLAB,
	    "Avlab",
	},
	{
	    PCI_VENDOR_INVERTEX,
	    "Invertex",
	},
	{
	    PCI_VENDOR_BROADCOM,
	    "Broadcom",
	},
	{
	    PCI_VENDOR_PLANEX,
	    "Planex",
	},
	{
	    PCI_VENDOR_CONEXANT,
	    "Conexant",
	},
	{
	    PCI_VENDOR_DELTA,
	    "Delta",
	},
	{
	    PCI_VENDOR_MYSON,
	    "Myson Century",
	},
	{
	    PCI_VENDOR_TOPIC,
	    "Topic/SmartLink",
	},
	{
	    PCI_VENDOR_ENE,
	    "ENE",
	},
	{
	    PCI_VENDOR_ARALION,
	    "Aralion",
	},
	{
	    PCI_VENDOR_TERRATEC,
	    "TerraTec",
	},
	{
	    PCI_VENDOR_SYMBOL,
	    "Symbol",
	},
	{
	    PCI_VENDOR_SYBA,
	    "Syba",
	},
	{
	    PCI_VENDOR_BLUESTEEL,
	    "Bluesteel",
	},
	{
	    PCI_VENDOR_VMWARE,
	    "VMware",
	},
	{
	    PCI_VENDOR_ZOLTRIX,
	    "Zoltrix",
	},
	{
	    PCI_VENDOR_MELLANOX,
	    "Mellanox",
	},
	{
	    PCI_VENDOR_AGILENT,
	    "Agilent",
	},
	{
	    PCI_VENDOR_QUICKNET,
	    "Quicknet Technologies",
	},
	{
	    PCI_VENDOR_NDC,
	    "National Datacomm",
	},
	{
	    PCI_VENDOR_PDC,
	    "Pacific Data",
	},
	{
	    PCI_VENDOR_EUMITCOM,
	    "Eumitcom",
	},
	{
	    PCI_VENDOR_NETSEC,
	    "NetSec",
	},
	{
	    PCI_VENDOR_ZYDAS,
	    "ZyDAS Technology",
	},
	{
	    PCI_VENDOR_SAMSUNG,
	    "Samsung",
	},
	{
	    PCI_VENDOR_ATHEROS,
	    "Atheros",
	},
	{
	    PCI_VENDOR_GLOBALSUN,
	    "Global Sun",
	},
	{
	    PCI_VENDOR_SAFENET,
	    "SafeNet",
	},
	{
	    PCI_VENDOR_MICREL,
	    "Micrel",
	},
	{
	    PCI_VENDOR_USR2,
	    "US Robotics",
	},
	{
	    PCI_VENDOR_VITESSE,
	    "Vitesse",
	},
	{
	    PCI_VENDOR_LINKSYS,
	    "Linksys",
	},
	{
	    PCI_VENDOR_NETOCTAVE,
	    "Netoctave",
	},
	{
	    PCI_VENDOR_ALTIMA,
	    "Altima",
	},
	{
	    PCI_VENDOR_ANTARES,
	    "Antares Microsystems",
	},
	{
	    PCI_VENDOR_CAVIUM,
	    "Cavium",
	},
	{
	    PCI_VENDOR_BELKIN2,
	    "Belkin",
	},
	{
	    PCI_VENDOR_HAWKING,
	    "Hawking Technology",
	},
	{
	    PCI_VENDOR_NETCHIP,
	    "NetChip Technology",
	},
	{
	    PCI_VENDOR_I4,
	    "I4",
	},
	{
	    PCI_VENDOR_ARECA,
	    "Areca",
	},
	{
	    PCI_VENDOR_NETERION,
	    "Neterion",
	},
	{
	    PCI_VENDOR_INPROCOMM,
	    "INPROCOMM",
	},
	{
	    PCI_VENDOR_LANERGY,
	    "Lanergy",
	},
	{
	    PCI_VENDOR_RALINK,
	    "Ralink",
	},
	{
	    PCI_VENDOR_XGI,
	    "XGI Technology",
	},
	{
	    PCI_VENDOR_SILAN,
	    "Silan",
	},
	{
	    PCI_VENDOR_SANGOMA,
	    "Sangoma",
	},
	{
	    PCI_VENDOR_SOLARFLARE,
	    "Solarflare",
	},
	{
	    PCI_VENDOR_OPTION,
	    "Option",
	},
	{
	    PCI_VENDOR_FREESCALE,
	    "Freescale",
	},
	{
	    PCI_VENDOR_ATTANSIC,
	    "Attansic Technology",
	},
	{
	    PCI_VENDOR_AGEIA,
	    "Ageia",
	},
	{
	    PCI_VENDOR_JMICRON,
	    "JMicron",
	},
	{
	    PCI_VENDOR_ASPEED,
	    "ASPEED Technology",
	},
	{
	    PCI_VENDOR_AWT,
	    "AWT",
	},
	{
	    PCI_VENDOR_SYMPHONY2,
	    "Symphony Labs",
	},
	{
	    PCI_VENDOR_TEKRAM2,
	    "Tekram",
	},
	{
	    PCI_VENDOR_TEHUTI,
	    "Tehuti Networks",
	},
	{
	    PCI_VENDOR_HINT,
	    "Hint",
	},
	{
	    PCI_VENDOR_3DLABS,
	    "3D Labs",
	},
	{
	    PCI_VENDOR_AVANCE2,
	    "Avance Logic",
	},
	{
	    PCI_VENDOR_ADDTRON,
	    "Addtron",
	},
	{
	    PCI_VENDOR_NETXEN,
	    "NetXen",
	},
	{
	    PCI_VENDOR_INDCOMPSRC,
	    "Industrial Computer Source",
	},
	{
	    PCI_VENDOR_NETVIN,
	    "NetVin",
	},
	{
	    PCI_VENDOR_GEMTEK,
	    "Gemtek",
	},
	{
	    PCI_VENDOR_TURTLEBEACH,
	    "Turtle Beach",
	},
	{
	    PCI_VENDOR_S3,
	    "S3",
	},
	{
	    PCI_VENDOR_C4T,
	    "c't Magazin",
	},
	{
	    PCI_VENDOR_DCI,
	    "Decision Computer",
	},
	{
	    PCI_VENDOR_QUANCOM,
	    "Quancom Informationssysteme",
	},
	{
	    PCI_VENDOR_INTEL,
	    "Intel",
	},
	{
	    PCI_VENDOR_INNOTEK,
	    "InnoTek",
	},
	{
	    PCI_VENDOR_SIGMATEL,
	    "Sigmatel",
	},
	{
	    PCI_VENDOR_WINBOND2,
	    "Winbond",
	},
	{
	    PCI_VENDOR_KTI,
	    "KTI",
	},
	{
	    PCI_VENDOR_ADP,
	    "Adaptec",
	},
	{
	    PCI_VENDOR_ADP2,
	    "Adaptec",
	},
	{
	    PCI_VENDOR_ATRONICS,
	    "Atronics",
	},
	{
	    PCI_VENDOR_NETMOS,
	    "NetMos",
	},
	{
	    PCI_VENDOR_PARALLELS,
	    "Parallels",
	},
	{
	    PCI_VENDOR_3COM2,
	    "3Com",
	},
	{
	    PCI_VENDOR_TIGERJET,
	    "TigerJet Network",
	},
	{
	    PCI_VENDOR_ENDACE,
	    "Endace",
	},
	{
	    PCI_VENDOR_BELKIN,
	    "Belkin Components",
	},
	{
	    PCI_VENDOR_ARC,
	    "ARC Logic",
	},
	{
	    PCI_VENDOR_INVALID,
	    "INVALID VENDOR ID",
	},
	{ 0, NULL, }
};
