require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&ISES_DMA_READ_COUNT)) {
    sub ISES_DMA_READ_COUNT () {	0x100;}
}
unless(defined(&ISES_DMA_RCOUNT)) {
    sub ISES_DMA_RCOUNT {
	my($x) = @_;
	eval q((($x) << 16));
    }
}
unless(defined(&ISES_DMA_WRITE_COUNT)) {
    sub ISES_DMA_WRITE_COUNT () {	0x100;}
}
unless(defined(&ISES_DMA_WCOUNT)) {
    sub ISES_DMA_WCOUNT {
	my($x) = @_;
	eval q((($x) & 0xff));
    }
}
unless(defined(&ISES_DMA_WRITE_START)) {
    sub ISES_DMA_WRITE_START () {	0x104;}
}
unless(defined(&ISES_DMA_READ_START)) {
    sub ISES_DMA_READ_START () {	0x108;}
}
unless(defined(&ISES_DMA_CTRL)) {
    sub ISES_DMA_CTRL () {	0x10c;}
}
unless(defined(&ISES_DMA_STATUS)) {
    sub ISES_DMA_STATUS () {	 &ISES_DMA_CTRL;}
}
unless(defined(&ISES_DMA_RESET)) {
    sub ISES_DMA_RESET () {	0x110;}
}
unless(defined(&ISES_DMA_CTRL_ILT)) {
    sub ISES_DMA_CTRL_ILT () {	0x40000000;}
}
unless(defined(&ISES_DMA_CTRL_RMULT)) {
    sub ISES_DMA_CTRL_RMULT () {	0xd000000;}
}
unless(defined(&ISES_DMA_CTRL_RLINE)) {
    sub ISES_DMA_CTRL_RLINE () {	0x9000000;}
}
unless(defined(&ISES_DMA_CTRL_READ)) {
    sub ISES_DMA_CTRL_READ () {	0x1000000;}
}
unless(defined(&ISES_DMA_CTRL_WRITE)) {
    sub ISES_DMA_CTRL_WRITE () {	0x100;}
}
unless(defined(&ISES_DMA_STATUS_R_RUN)) {
    sub ISES_DMA_STATUS_R_RUN () {	0x1000000;}
}
unless(defined(&ISES_DMA_STATUS_R_ERR)) {
    sub ISES_DMA_STATUS_R_ERR () {	0x2000000;}
}
unless(defined(&ISES_DMA_STATUS_W_RUN)) {
    sub ISES_DMA_STATUS_W_RUN () {	0x100;}
}
unless(defined(&ISES_DMA_STATUS_W_ERR)) {
    sub ISES_DMA_STATUS_W_ERR () {	0x200;}
}
unless(defined(&ISES_A_OFFSET)) {
    sub ISES_A_OFFSET () {	0x200;}
}
unless(defined(&ISES_A)) {
    sub ISES_A {
	my($x) = @_;
	eval q(( &ISES_A_OFFSET + ($x)));
    }
}
unless(defined(&ISES_A_STAT)) {
    sub ISES_A_STAT () {	 &ISES_A(0x);}
}
unless(defined(&ISES_A_INTS)) {
    sub ISES_A_INTS () {	 &ISES_A(0x4);}
}
unless(defined(&ISES_A_INTE)) {
    sub ISES_A_INTE () {	 &ISES_A(0x8);}
}
unless(defined(&ISES_A_SREQ)) {
    sub ISES_A_SREQ () {	 &ISES_A(0xc);}
}
unless(defined(&ISES_A_CTRL)) {
    sub ISES_A_CTRL () {	 &ISES_A_SREQ;}
}
unless(defined(&ISES_A_OQD)) {
    sub ISES_A_OQD () {	 &ISES_A(0x10);}
}
unless(defined(&ISES_A_IQD)) {
    sub ISES_A_IQD () {	 &ISES_A_OQD;}
}
unless(defined(&ISES_A_OQS)) {
    sub ISES_A_OQS () {	 &ISES_A(0x14);}
}
unless(defined(&ISES_A_IQS)) {
    sub ISES_A_IQS () {	 &ISES_A(0x18);}
}
unless(defined(&ISES_A_OQF)) {
    sub ISES_A_OQF () {	 &ISES_A(0x1c);}
}
unless(defined(&ISES_A_IQF)) {
    sub ISES_A_IQF () {	 &ISES_A(0x20);}
}
unless(defined(&ISES_B_OFFSET)) {
    sub ISES_B_OFFSET () {	0x300;}
}
unless(defined(&ISES_B)) {
    sub ISES_B {
	my($x) = @_;
	eval q(( &ISES_B_OFFSET + ($x)));
    }
}
unless(defined(&ISES_B_BDATAIN)) {
    sub ISES_B_BDATAIN () {	 &ISES_B(0x);}
}
unless(defined(&ISES_B_BDATAOUT)) {
    sub ISES_B_BDATAOUT () {	 &ISES_B(0x4);}
}
unless(defined(&ISES_B_STAT)) {
    sub ISES_B_STAT () {	 &ISES_B(0x8);}
}
unless(defined(&ISES_I_OFFSET)) {
    sub ISES_I_OFFSET () {	0x400;}
}
unless(defined(&ISES_BO_OFFSET)) {
    sub ISES_BO_OFFSET () {	0x500;}
}
unless(defined(&ISES_BO)) {
    sub ISES_BO {
	my($x) = @_;
	eval q(( &ISES_BO_OFFSET + ($x)));
    }
}
unless(defined(&ISES_BO_STAT)) {
    sub ISES_BO_STAT () {	 &ISES_BO(0x);}
}
unless(defined(&ISES_BO_LOOPCOUNTER)) {
    sub ISES_BO_LOOPCOUNTER () {	 &ISES_BO(0x4);}
}
unless(defined(&ISES_BO_TESTREG)) {
    sub ISES_BO_TESTREG () {	 &ISES_BO(0x8);}
}
unless(defined(&ISES_BO_STAT_LOOP)) {
    sub ISES_BO_STAT_LOOP () {	0x1;}
}
unless(defined(&ISES_BO_STAT_TAMPER)) {
    sub ISES_BO_STAT_TAMPER () {	0x2;}
}
unless(defined(&ISES_BO_STAT_POWERDOWN)) {
    sub ISES_BO_STAT_POWERDOWN () {	0x4;}
}
unless(defined(&ISES_BO_STAT_ACONF)) {
    sub ISES_BO_STAT_ACONF () {	0x8;}
}
unless(defined(&ISES_BO_STAT_HWRESET)) {
    sub ISES_BO_STAT_HWRESET () {	0x10;}
}
unless(defined(&ISES_BO_STAT_AIRQ)) {
    sub ISES_BO_STAT_AIRQ () {	0x20;}
}
unless(defined(&ISES_STAT_LNAU_MASKED)) {
    sub ISES_STAT_LNAU_MASKED () {	0x1;}
}
unless(defined(&ISES_STAT_LNAU_BUSY_1)) {
    sub ISES_STAT_LNAU_BUSY_1 () {	0x2;}
}
unless(defined(&ISES_STAT_LNAU_ERR_1)) {
    sub ISES_STAT_LNAU_ERR_1 () {	0x4;}
}
unless(defined(&ISES_STAT_LNAU_BUSY_2)) {
    sub ISES_STAT_LNAU_BUSY_2 () {	0x8;}
}
unless(defined(&ISES_STAT_LNAU_ERR_2)) {
    sub ISES_STAT_LNAU_ERR_2 () {	0x10;}
}
unless(defined(&ISES_STAT_BCHU_MASKED)) {
    sub ISES_STAT_BCHU_MASKED () {	0x20;}
}
unless(defined(&ISES_STAT_BCHU_BUSY)) {
    sub ISES_STAT_BCHU_BUSY () {	0x40;}
}
unless(defined(&ISES_STAT_BCHU_ERR)) {
    sub ISES_STAT_BCHU_ERR () {	0x80;}
}
unless(defined(&ISES_STAT_BCHU_SCIF)) {
    sub ISES_STAT_BCHU_SCIF () {	0x100;}
}
unless(defined(&ISES_STAT_BCHU_HIF)) {
    sub ISES_STAT_BCHU_HIF () {	0x200;}
}
unless(defined(&ISES_STAT_BCHU_DDB)) {
    sub ISES_STAT_BCHU_DDB () {	0x400;}
}
unless(defined(&ISES_STAT_BCHU_IRF)) {
    sub ISES_STAT_BCHU_IRF () {	0x800;}
}
unless(defined(&ISES_STAT_BCHU_OAF)) {
    sub ISES_STAT_BCHU_OAF () {	0x1000;}
}
unless(defined(&ISES_STAT_BCHU_DIE)) {
    sub ISES_STAT_BCHU_DIE () {	0x2000;}
}
unless(defined(&ISES_STAT_BCHU_UE)) {
    sub ISES_STAT_BCHU_UE () {	0x4000;}
}
unless(defined(&ISES_STAT_BCHU_IFE)) {
    sub ISES_STAT_BCHU_IFE () {	0x8000;}
}
unless(defined(&ISES_STAT_BCHU_IFHE)) {
    sub ISES_STAT_BCHU_IFHE () {	0x10000;}
}
unless(defined(&ISES_STAT_BCHU_IFF)) {
    sub ISES_STAT_BCHU_IFF () {	0x20000;}
}
unless(defined(&ISES_STAT_BCHU_OFE)) {
    sub ISES_STAT_BCHU_OFE () {	0x40000;}
}
unless(defined(&ISES_STAT_BCHU_OFHF)) {
    sub ISES_STAT_BCHU_OFHF () {	0x80000;}
}
unless(defined(&ISES_STAT_BCHU_OFF)) {
    sub ISES_STAT_BCHU_OFF () {	0x100000;}
}
unless(defined(&ISES_STAT_HW_DA)) {
    sub ISES_STAT_HW_DA () {	0x200000;}
}
unless(defined(&ISES_STAT_HW_ACONF)) {
    sub ISES_STAT_HW_ACONF () {	0x400000;}
}
unless(defined(&ISES_STAT_SW_WFOQ)) {
    sub ISES_STAT_SW_WFOQ () {	0x800000;}
}
unless(defined(&ISES_STAT_SW_OQSINC)) {
    sub ISES_STAT_SW_OQSINC () {	0x8000000;}
}
unless(defined(&ISES_STAT_IDP_MASK)) {
    sub ISES_STAT_IDP_MASK () {	0xf000000;}
}
unless(defined(&ISES_STAT_IDP_STATE)) {
    sub ISES_STAT_IDP_STATE {
	my($x) = @_;
	eval q(((($x) &  &ISES_STAT_IDP_MASK) >> 24));
    }
}
unless(defined(&ISES_IDP_WFPL)) {
    sub ISES_IDP_WFPL () {	0x4;}
}
unless(defined(&ISES_STAT_SW_MASK)) {
    sub ISES_STAT_SW_MASK () {	0x3000000;}
}
unless(defined(&ISES_STAT_SW_MODE)) {
    sub ISES_STAT_SW_MODE {
	my($x) = @_;
	eval q(((($x) &  &ISES_STAT_SW_MASK) >> 24));
    }
}
unless(defined(&ISES_A_CTRL_RESET)) {
    sub ISES_A_CTRL_RESET () {	0x;}
}
unless(defined(&ISES_A_CTRL_CONTINUE)) {
    sub ISES_A_CTRL_CONTINUE () {	0x1;}
}
if(defined(&ISESDEBUG)) {
}
unless(defined(&ISES_BERR_DPAR)) {
    sub ISES_BERR_DPAR () {	0x1;}
}
unless(defined(&ISES_BERR_IDESBCP)) {
    sub ISES_BERR_IDESBCP () {	0x2;}
}
unless(defined(&ISES_BERR_ISFRBCP)) {
    sub ISES_BERR_ISFRBCP () {	0x4;}
}
unless(defined(&ISES_BERR_INCMBCP)) {
    sub ISES_BERR_INCMBCP () {	0x8;}
}
unless(defined(&ISES_BERR_IBCF)) {
    sub ISES_BERR_IBCF () {	0x10;}
}
unless(defined(&ISES_BERR_reserved)) {
    sub ISES_BERR_reserved () {	0x20;}
}
unless(defined(&ISES_BERR_SRB)) {
    sub ISES_BERR_SRB () {	0x40;}
}
unless(defined(&ISES_BERR_HRB)) {
    sub ISES_BERR_HRB () {	0x80;}
}
unless(defined(&ISES_BERR_IHFR)) {
    sub ISES_BERR_IHFR () {	0x100;}
}
unless(defined(&ISES_BERR_PADERR)) {
    sub ISES_BERR_PADERR () {	0x200;}
}
unless(defined(&ISES_BERR_BIDM)) {
    sub ISES_BERR_BIDM () {	0x400;}
}
unless(defined(&ISES_BCHCR_BCHU_DIE)) {
    sub ISES_BCHCR_BCHU_DIE () {	0x1;}
}
unless(defined(&ISES_BCHCR_BCHU_UE)) {
    sub ISES_BCHCR_BCHU_UE () {	0x2;}
}
unless(defined(&ISES_BCHCR_BCHU_RST)) {
    sub ISES_BCHCR_BCHU_RST () {	0x4;}
}
unless(defined(&ISES_SELR_BCHU_EH)) {
    sub ISES_SELR_BCHU_EH () {	0x80000000;}
}
unless(defined(&ISES_SELR_BCHU_HISOF)) {
    sub ISES_SELR_BCHU_HISOF () {	0x1000000;}
}
unless(defined(&ISES_SELR_BCHU_DIS)) {
    sub ISES_SELR_BCHU_DIS () {	0x2000000;}
}
unless(defined(&ISES_HOMR_HMTR)) {
    sub ISES_HOMR_HMTR () {	0x800000;}
}
unless(defined(&ISES_HOMR_ER)) {
    sub ISES_HOMR_ER () {	0x300000;}
}
unless(defined(&ISES_HOMR_HFR)) {
    sub ISES_HOMR_HFR () {	0x70000;}
}
unless(defined(&ISES_HOMR_HFR_NOP)) {
    sub ISES_HOMR_HFR_NOP () {	0x;}
}
unless(defined(&ISES_HOMR_HFR_MD5)) {
    sub ISES_HOMR_HFR_MD5 () {	0x10000;}
}
unless(defined(&ISES_HOMR_HFR_RMD160)) {
    sub ISES_HOMR_HFR_RMD160 () {	0x20000;}
}
unless(defined(&ISES_HOMR_HFR_RMD128)) {
    sub ISES_HOMR_HFR_RMD128 () {	0x30000;}
}
unless(defined(&ISES_HOMR_HFR_SHA1)) {
    sub ISES_HOMR_HFR_SHA1 () {	0x40000;}
}
unless(defined(&ISES_SOMR_BCFR)) {
    sub ISES_SOMR_BCFR () {	0xf000;}
}
unless(defined(&ISES_SOMR_BCPR)) {
    sub ISES_SOMR_BCPR () {	0xff0;}
}
unless(defined(&ISES_SOMR_BOMR)) {
    sub ISES_SOMR_BOMR () {	( &ISES_SOMR_BCFR |  &ISES_SOMR_BCPR);}
}
unless(defined(&ISES_SOMR_BOMR_NOP)) {
    sub ISES_SOMR_BOMR_NOP () {	0x;}
}
unless(defined(&ISES_SOMR_BOMR_TRANSPARENT)) {
    sub ISES_SOMR_BOMR_TRANSPARENT () {	0x10;}
}
unless(defined(&ISES_SOMR_BOMR_DES)) {
    sub ISES_SOMR_BOMR_DES () {	0x1000;}
}
unless(defined(&ISES_SOMR_BOMR_3DES2)) {
    sub ISES_SOMR_BOMR_3DES2 () {	0x1010;}
}
unless(defined(&ISES_SOMR_BOMR_3DES)) {
    sub ISES_SOMR_BOMR_3DES () {	0x1020;}
}
unless(defined(&ISES_SOMR_BOMR_SAFER)) {
    sub ISES_SOMR_BOMR_SAFER () {	0x2000;}
}
unless(defined(&ISES_SOMR_EDR)) {
    sub ISES_SOMR_EDR () {	0x8;}
}
unless(defined(&ISES_SOMR_FMR)) {
    sub ISES_SOMR_FMR () {	0x3;}
}
unless(defined(&ISES_SOMR_FMR_ECB)) {
    sub ISES_SOMR_FMR_ECB () {	0x;}
}
unless(defined(&ISES_SOMR_FMR_CBC)) {
    sub ISES_SOMR_FMR_CBC () {	0x1;}
}
unless(defined(&ISES_SOMR_FMR_CFB64)) {
    sub ISES_SOMR_FMR_CFB64 () {	0x2;}
}
unless(defined(&ISES_SOMR_FMR_OFB64)) {
    sub ISES_SOMR_FMR_OFB64 () {	0x3;}
}
unless(defined(&ISES_OFFSET_HRNG_CTRL)) {
    sub ISES_OFFSET_HRNG_CTRL () {	0x;}
}
unless(defined(&ISES_OFFSET_HRNG_LFSR)) {
    sub ISES_OFFSET_HRNG_LFSR () {	0x4;}
}
unless(defined(&ISES_HRNG_CTRL_HE)) {
    sub ISES_HRNG_CTRL_HE () {	0x1;}
}
unless(defined(&ISES_MKCMD)) {
    sub ISES_MKCMD {
	my($cmd,$len) = @_;
	eval q(($cmd | $cmd << 16| $len << 8| $len << 24));
    }
}
unless(defined(&ISES_CMD_NONE)) {
    sub ISES_CMD_NONE () {	-1;}
}
unless(defined(&ISES_CMD_CHIP_ID)) {
    sub ISES_CMD_CHIP_ID () {	0x;}
}
unless(defined(&ISES_CMD_LRESET_1)) {
    sub ISES_CMD_LRESET_1 () {	0x1;}
}
unless(defined(&ISES_CMD_LRSFLG_1)) {
    sub ISES_CMD_LRSFLG_1 () {	0x2;}
}
unless(defined(&ISES_CMD_LUPLOAD_1)) {
    sub ISES_CMD_LUPLOAD_1 () {	0x3;}
}
unless(defined(&ISES_CMD_LW_A_1)) {
    sub ISES_CMD_LW_A_1 () {	0x4;}
}
unless(defined(&ISES_CMD_LW_B_1)) {
    sub ISES_CMD_LW_B_1 () {	0x5;}
}
unless(defined(&ISES_CMD_LW_N_1)) {
    sub ISES_CMD_LW_N_1 () {	0x6;}
}
unless(defined(&ISES_CMD_LW_Bq_1)) {
    sub ISES_CMD_LW_Bq_1 () {	0x7;}
}
unless(defined(&ISES_CMD_LW_Nq_1)) {
    sub ISES_CMD_LW_Nq_1 () {	0x8;}
}
unless(defined(&ISES_CMD_LW_Bp_1)) {
    sub ISES_CMD_LW_Bp_1 () {	0x9;}
}
unless(defined(&ISES_CMD_LW_Np_1)) {
    sub ISES_CMD_LW_Np_1 () {	0xa;}
}
unless(defined(&ISES_CMD_LW_U_1)) {
    sub ISES_CMD_LW_U_1 () {	0xb;}
}
unless(defined(&ISES_CMD_LMOD_1)) {
    sub ISES_CMD_LMOD_1 () {	0xc;}
}
unless(defined(&ISES_CMD_LMULMOD_1)) {
    sub ISES_CMD_LMULMOD_1 () {	0xd;}
}
unless(defined(&ISES_CMD_LEXPMOD_1)) {
    sub ISES_CMD_LEXPMOD_1 () {	0xe;}
}
unless(defined(&ISES_CMD_LEXPCRTMOD_1)) {
    sub ISES_CMD_LEXPCRTMOD_1 () {	0xf;}
}
unless(defined(&ISES_CMD_LRESET_2)) {
    sub ISES_CMD_LRESET_2 () {	0x10;}
}
unless(defined(&ISES_CMD_LRSFLG_2)) {
    sub ISES_CMD_LRSFLG_2 () {	0x11;}
}
unless(defined(&ISES_CMD_LUPLOAD_2)) {
    sub ISES_CMD_LUPLOAD_2 () {	0x12;}
}
unless(defined(&ISES_CMD_LW_A_2)) {
    sub ISES_CMD_LW_A_2 () {	0x13;}
}
unless(defined(&ISES_CMD_LW_B_2)) {
    sub ISES_CMD_LW_B_2 () {	0x14;}
}
unless(defined(&ISES_CMD_LW_N_2)) {
    sub ISES_CMD_LW_N_2 () {	0x15;}
}
unless(defined(&ISES_CMD_LW_Bq_2)) {
    sub ISES_CMD_LW_Bq_2 () {	0x16;}
}
unless(defined(&ISES_CMD_LW_Nq_2)) {
    sub ISES_CMD_LW_Nq_2 () {	0x17;}
}
unless(defined(&ISES_CMD_LW_Bp_2)) {
    sub ISES_CMD_LW_Bp_2 () {	0x18;}
}
unless(defined(&ISES_CMD_LW_Np_2)) {
    sub ISES_CMD_LW_Np_2 () {	0x19;}
}
unless(defined(&ISES_CMD_LW_U_2)) {
    sub ISES_CMD_LW_U_2 () {	0x1a;}
}
unless(defined(&ISES_CMD_LMOD_2)) {
    sub ISES_CMD_LMOD_2 () {	0x1b;}
}
unless(defined(&ISES_CMD_LMULMOD_2)) {
    sub ISES_CMD_LMULMOD_2 () {	0x1c;}
}
unless(defined(&ISES_CMD_LEXPMOD_2)) {
    sub ISES_CMD_LEXPMOD_2 () {	0x1d;}
}
unless(defined(&ISES_CMD_LEXPCRTMOD_2)) {
    sub ISES_CMD_LEXPCRTMOD_2 () {	0x1e;}
}
unless(defined(&ISES_CMD_RST_BERR)) {
    sub ISES_CMD_RST_BERR () {	0x1f;}
}
unless(defined(&ISES_CMD_BR_BERR)) {
    sub ISES_CMD_BR_BERR () {	0x20;}
}
unless(defined(&ISES_CMD_BW_DATA)) {
    sub ISES_CMD_BW_DATA () {	0x21;}
}
unless(defined(&ISES_CMD_BR_DATA)) {
    sub ISES_CMD_BR_DATA () {	0x22;}
}
unless(defined(&ISES_CMD_BW_BCHCR)) {
    sub ISES_CMD_BW_BCHCR () {	0x23;}
}
unless(defined(&ISES_CMD_BR_BCHCR)) {
    sub ISES_CMD_BR_BCHCR () {	0x24;}
}
unless(defined(&ISES_CMD_BW_OMR)) {
    sub ISES_CMD_BW_OMR () {	0x25;}
}
unless(defined(&ISES_CMD_BR_OMR)) {
    sub ISES_CMD_BR_OMR () {	0x26;}
}
unless(defined(&ISES_CMD_BW_KR0)) {
    sub ISES_CMD_BW_KR0 () {	0x27;}
}
unless(defined(&ISES_CMD_BR_KR0)) {
    sub ISES_CMD_BR_KR0 () {	0x28;}
}
unless(defined(&ISES_CMD_BW_KR1)) {
    sub ISES_CMD_BW_KR1 () {	0x29;}
}
unless(defined(&ISES_CMD_BR_KR1)) {
    sub ISES_CMD_BR_KR1 () {	0x2a;}
}
unless(defined(&ISES_CMD_BW_KR2)) {
    sub ISES_CMD_BW_KR2 () {	0x2b;}
}
unless(defined(&ISES_CMD_BR_KR2)) {
    sub ISES_CMD_BR_KR2 () {	0x2c;}
}
unless(defined(&ISES_CMD_BW_SCCR)) {
    sub ISES_CMD_BW_SCCR () {	0x2d;}
}
unless(defined(&ISES_CMD_BR_SCCR)) {
    sub ISES_CMD_BR_SCCR () {	0x2e;}
}
unless(defined(&ISES_CMD_BW_DBCR)) {
    sub ISES_CMD_BW_DBCR () {	0x2f;}
}
unless(defined(&ISES_CMD_BR_DBCR)) {
    sub ISES_CMD_BR_DBCR () {	0x30;}
}
unless(defined(&ISES_CMD_BW_HMLR)) {
    sub ISES_CMD_BW_HMLR () {	0x31;}
}
unless(defined(&ISES_CMD_BR_HMLR)) {
    sub ISES_CMD_BR_HMLR () {	0x32;}
}
unless(defined(&ISES_CMD_BW_CVR)) {
    sub ISES_CMD_BW_CVR () {	0x33;}
}
unless(defined(&ISES_CMD_BR_CVR)) {
    sub ISES_CMD_BR_CVR () {	0x34;}
}
unless(defined(&ISES_CMD_BPROC)) {
    sub ISES_CMD_BPROC () {	0x35;}
}
unless(defined(&ISES_CMD_BTERM)) {
    sub ISES_CMD_BTERM () {	0x36;}
}
unless(defined(&ISES_CMD_BSWITCH)) {
    sub ISES_CMD_BSWITCH () {	0x37;}
}
unless(defined(&ISES_CMD_HSTART)) {
    sub ISES_CMD_HSTART () {	0x38;}
}
unless(defined(&ISES_CMD_HSTOP)) {
    sub ISES_CMD_HSTOP () {	0x39;}
}
unless(defined(&ISES_CMD_HSEED)) {
    sub ISES_CMD_HSEED () {	0x3a;}
}
unless(defined(&ISES_CMD_HBITS)) {
    sub ISES_CMD_HBITS () {	0x3b;}
}
unless(defined(&ISES_RC_MASK)) {
    sub ISES_RC_MASK () {	0xffff;}
}
unless(defined(&ISES_RC_SUCCESS)) {
    sub ISES_RC_SUCCESS () {	0x;}
}
unless(defined(&ISES_RC_CMDERR)) {
    sub ISES_RC_CMDERR () {	0x1;}
}
unless(defined(&ISES_RC_QERR)) {
    sub ISES_RC_QERR () {	0x2;}
}
unless(defined(&ISES_RC_LNAU_ERR)) {
    sub ISES_RC_LNAU_ERR () {	0x3;}
}
unless(defined(&ISES_RC_BCHU_ERR)) {
    sub ISES_RC_BCHU_ERR () {	0x4;}
}
unless(defined(&ISES_RC_BCHU_BIFCSEL)) {
    sub ISES_RC_BCHU_BIFCSEL () {	0x5;}
}
unless(defined(&ISES_RC_BCHU_ODD)) {
    sub ISES_RC_BCHU_ODD () {	0x6;}
}
unless(defined(&ISES_RC_HRNG_ILLEN)) {
    sub ISES_RC_HRNG_ILLEN () {	0x7;}
}
unless(defined(&ISES_IRQ_TIMER_1)) {
    sub ISES_IRQ_TIMER_1 () {	0x1;}
}
unless(defined(&ISES_IRQ_TIMER_2)) {
    sub ISES_IRQ_TIMER_2 () {	0x2;}
}
unless(defined(&ISES_IRQ_I_IIN0)) {
    sub ISES_IRQ_I_IIN0 () {	0x4;}
}
unless(defined(&ISES_IRQ_I_IIN1)) {
    sub ISES_IRQ_I_IIN1 () {	0x8;}
}
unless(defined(&ISES_IRQ_I_IIN2)) {
    sub ISES_IRQ_I_IIN2 () {	0x10;}
}
unless(defined(&ISES_IRQ_I_IIN3)) {
    sub ISES_IRQ_I_IIN3 () {	0x20;}
}
unless(defined(&ISES_IRQ_LNAU_1_ERROR)) {
    sub ISES_IRQ_LNAU_1_ERROR () {	0x40;}
}
unless(defined(&ISES_IRQ_LNAU_1_DONE)) {
    sub ISES_IRQ_LNAU_1_DONE () {	0x80;}
}
unless(defined(&ISES_IRQ_LNAU_2_ERROR)) {
    sub ISES_IRQ_LNAU_2_ERROR () {	0x100;}
}
unless(defined(&ISES_IRQ_LNAU_2_DONE)) {
    sub ISES_IRQ_LNAU_2_DONE () {	0x200;}
}
unless(defined(&ISES_IRQ_BCHU_DONE)) {
    sub ISES_IRQ_BCHU_DONE () {	0x400;}
}
unless(defined(&ISES_IRQ_BCHU_ERROR)) {
    sub ISES_IRQ_BCHU_ERROR () {	0x800;}
}
unless(defined(&ISES_IRQ_BCHU_IRF)) {
    sub ISES_IRQ_BCHU_IRF () {	0x1000;}
}
unless(defined(&ISES_IRQ_BCHU_OAF)) {
    sub ISES_IRQ_BCHU_OAF () {	0x2000;}
}
unless(defined(&ISES_IRQ_BCHU_IEF)) {
    sub ISES_IRQ_BCHU_IEF () {	0x4000;}
}
unless(defined(&ISES_IRQ_A_WCTRL)) {
    sub ISES_IRQ_A_WCTRL () {	0x8000;}
}
unless(defined(&ISES_IRQ_A_RSREQ)) {
    sub ISES_IRQ_A_RSREQ () {	0x10000;}
}
unless(defined(&ISES_IRQ_A_DIQ)) {
    sub ISES_IRQ_A_DIQ () {	0x20000;}
}
unless(defined(&ISES_IRQ_A_CIQ)) {
    sub ISES_IRQ_A_CIQ () {	0x40000;}
}
unless(defined(&ISES_IRQ_A_OQF)) {
    sub ISES_IRQ_A_OQF () {	0x80000;}
}
unless(defined(&ISES_SESSION)) {
    sub ISES_SESSION {
	my($sid) = @_;
	eval q(( ($sid) & 0xfffffff));
    }
}
unless(defined(&ISES_CARD)) {
    sub ISES_CARD {
	my($sid) = @_;
	eval q(((($sid) & 0xf0000000) >> 28));
    }
}
unless(defined(&ISES_SID)) {
    sub ISES_SID {
	my($crd,$ses) = @_;
	eval q(((($crd) << 28) | (($ses) & 0xfffffff)));
    }
}
unless(defined(&ISES_B_DATASIZE)) {
    sub ISES_B_DATASIZE () {	4096;}
}
1;
