require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SPARC_BUS_H_)) {
    eval 'sub _SPARC_BUS_H_ () {1;}' unless defined(&_SPARC_BUS_H_);
    require 'machine/autoconf.ph';
    require 'uvm/uvm_extern.ph';
    require 'machine/pmap.ph';
    eval 'sub TAG_LITTLE_ENDIAN () {0x80000000;}' unless defined(&TAG_LITTLE_ENDIAN);
    eval 'sub SET_TAG_BIG_ENDIAN {
        my($t) = @_;
	    eval q((($t))-> &rr_iospace &= ~ &TAG_LITTLE_ENDIAN);
    }' unless defined(&SET_TAG_BIG_ENDIAN);
    eval 'sub SET_TAG_LITTLE_ENDIAN {
        my($t) = @_;
	    eval q((($t))-> &rr_iospace |=  &TAG_LITTLE_ENDIAN);
    }' unless defined(&SET_TAG_LITTLE_ENDIAN);
    eval 'sub IS_TAG_LITTLE_ENDIAN {
        my($t) = @_;
	    eval q((($t)-> &rr_iospace &  &TAG_LITTLE_ENDIAN));
    }' unless defined(&IS_TAG_LITTLE_ENDIAN);
    eval 'sub BUS_SPACE_BARRIER_READ () {0;}' unless defined(&BUS_SPACE_BARRIER_READ);
    eval 'sub BUS_SPACE_BARRIER_WRITE () {1;}' unless defined(&BUS_SPACE_BARRIER_WRITE);
    eval 'sub bus_space_read_1 {
        my($tag, $handle, $offset) = @_;
	    eval q((( &void)($tag), *( &volatile  &u_int8_t *)(($handle) + ($offset))));
    }' unless defined(&bus_space_read_1);
    eval 'sub __bus_space_read_2 {
        my($tag, $handle, $offset) = @_;
	    eval q(*( &volatile  &u_int16_t *)(($handle) + ($offset)));
    }' unless defined(&__bus_space_read_2);
    eval 'sub __bus_space_read_4 {
        my($tag, $handle, $offset) = @_;
	    eval q(*( &volatile  &u_int32_t *)(($handle) + ($offset)));
    }' unless defined(&__bus_space_read_4);
    eval 'sub bus_space_read_2 {
        my($tag, $handle, $offset) = @_;
	    eval q((( &IS_TAG_LITTLE_ENDIAN($tag)) ?  &letoh16( &__bus_space_read_2($tag, $handle, $offset)) :  &__bus_space_read_2($tag, $handle, $offset)));
    }' unless defined(&bus_space_read_2);
    eval 'sub bus_space_read_4 {
        my($tag, $handle, $offset) = @_;
	    eval q((( &IS_TAG_LITTLE_ENDIAN($tag)) ?  &letoh32( &__bus_space_read_4($tag, $handle, $offset)) :  &__bus_space_read_4($tag, $handle, $offset)));
    }' unless defined(&bus_space_read_4);
    eval 'sub bus_space_write_1 {
        my($tag, $handle, $offset, $value) = @_;
	    eval q((( &void)($tag), *( &volatile  &u_int8_t *)(($handle) + ($offset)) = ($value)));
    }' unless defined(&bus_space_write_1);
    eval 'sub __bus_space_write_2 {
        my($tag, $handle, $offset, $value) = @_;
	    eval q(*( &volatile  &u_int16_t *)(($handle) + ($offset)) = ($value));
    }' unless defined(&__bus_space_write_2);
    eval 'sub __bus_space_write_4 {
        my($tag, $handle, $offset, $value) = @_;
	    eval q(*( &volatile  &u_int32_t *)(($handle) + ($offset)) = ($value));
    }' unless defined(&__bus_space_write_4);
    eval 'sub bus_space_write_2 {
        my($tag, $handle, $offset, $value) = @_;
	    eval q( &__bus_space_write_2($tag, $handle, $offset, ( &IS_TAG_LITTLE_ENDIAN($tag)) ?  &htole16($value) : ($value)));
    }' unless defined(&bus_space_write_2);
    eval 'sub bus_space_write_4 {
        my($tag, $handle, $offset, $value) = @_;
	    eval q( &__bus_space_write_4($tag, $handle, $offset, ( &IS_TAG_LITTLE_ENDIAN($tag)) ?  &htole32($value) : ($value)));
    }' unless defined(&bus_space_write_4);
}
1;
