require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&RA_MAXVADDR)) {
    sub RA_MAXVADDR () {	8;}
}
unless(defined(&RA_MAXREG)) {
    sub RA_MAXREG () {	16;}
}
unless(defined(&RA_MAXINTR)) {
    sub RA_MAXINTR () {	8;}
}
unless(defined(&ra_vaddr)) {
    sub ra_vaddr () {	 $ra_vaddrs[0];}
}
unless(defined(&ra_iospace)) {
    sub ra_iospace () {	 ($ra_reg[0]->{rr_iospace});}
}
unless(defined(&ra_paddr)) {
    sub ra_paddr () {	 ($ra_reg[0]->{rr_paddr});}
}
unless(defined(&ra_len)) {
    sub ra_len () {	 ($ra_reg[0]->{rr_len});}
}
unless(defined(&BUS_MAIN)) {
    sub BUS_MAIN () {	0;}
}
unless(defined(&BUS_OBIO)) {
    sub BUS_OBIO () {	1;}
}
unless(defined(&BUS_VME16)) {
    sub BUS_VME16 () {	2;}
}
unless(defined(&BUS_VME32)) {
    sub BUS_VME32 () {	3;}
}
unless(defined(&BUS_SBUS)) {
    sub BUS_SBUS () {	4;}
}
unless(defined(&BUS_XBOX)) {
    sub BUS_XBOX () {	5;}
}
unless(defined(&BUS_FGA)) {
    sub BUS_FGA () {	6;}
}
unless(defined(&BUS_FGA_A16D8)) {
    sub BUS_FGA_A16D8 () {	7;}
}
unless(defined(&BUS_FGA_A16D16)) {
    sub BUS_FGA_A16D16 () {	8;}
}
unless(defined(&BUS_FGA_A16D32)) {
    sub BUS_FGA_A16D32 () {	9;}
}
unless(defined(&BUS_FGA_A24D8)) {
    sub BUS_FGA_A24D8 () {	10;}
}
unless(defined(&BUS_FGA_A24D16)) {
    sub BUS_FGA_A24D16 () {	11;}
}
unless(defined(&BUS_FGA_A24D32)) {
    sub BUS_FGA_A24D32 () {	12;}
}
unless(defined(&BUS_FGA_A32D8)) {
    sub BUS_FGA_A32D8 () {	13;}
}
unless(defined(&BUS_FGA_A32D16)) {
    sub BUS_FGA_A32D16 () {	14;}
}
unless(defined(&BUS_FGA_A32D32)) {
    sub BUS_FGA_A32D32 () {	15;}
}
unless(defined(&mapiodev)) {
    sub mapiodev {
	my($pa, $offset, $size) = @_;
	eval q( &mapdev($pa, 0, $offset, $size));
    }
}
unless(defined(&REG2PHYS)) {
    sub REG2PHYS {
	my($rr, $offset) = @_;
	eval q(((($rr)-> &rr_paddr + ($offset)) |  &PMAP_IOENC(($rr)-> &rr_iospace) ));
    }
}
unless(defined(&MEMARR_AVAILPHYS)) {
    sub MEMARR_AVAILPHYS () {	0;}
}
unless(defined(&MEMARR_TOTALPHYS)) {
    sub MEMARR_TOTALPHYS () {	1;}
}
1;
