# NOTE: Derived from blib/lib/Graphics/ColorNames.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Graphics::ColorNames;

#line 248 "blib/lib/Graphics/ColorNames.pm (autosplit into blib/lib/auto/Graphics/ColorNames/load_scheme.al)"
sub load_scheme {
  my $self   = shift;
  my $scheme = shift;

  if (ref($scheme) eq 'HASH') {
    foreach my $name (keys %$scheme) {
      $self->{NAMES}->{lc($name)} = $scheme->{$name},
	unless (defined $self->{NAMES}->{lc($name)});
    }
  }
  elsif (ref($scheme) eq 'CODE') {
    push @{ $self->{SCHEMES} }, $scheme;
  }
  else {
    undef $!;
    eval {
      if ((ref($scheme) eq 'GLOB') || $scheme->isa('IO::File')
                                   || $scheme->isa('FileHandle')) {
	$self->_load_scheme_from_file($scheme);
      }
    };
    if ($@) {
      croak "unsupported scheme type: ", ref($scheme);
    }
    elsif ($!) {
      croak $!;
    }
  }
}

# end of Graphics::ColorNames::load_scheme
1;
