/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.EntityBinding;
import com.sleepycat.bdb.collection.StoredCollection;
import com.sleepycat.bdb.collection.StoredContainer;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.Set;

public class StoredValueSet
extends StoredCollection
implements Set {
    private boolean isSingleKey;

    public StoredValueSet(DataStore dataStore, DataBinding dataBinding, boolean bl) {
        super(new DataView(dataStore, null, null, dataBinding, null, bl));
    }

    public StoredValueSet(DataStore dataStore, EntityBinding entityBinding, boolean bl) {
        super(new DataView(dataStore, null, null, null, entityBinding, bl));
    }

    public StoredValueSet(DataIndex dataIndex, DataBinding dataBinding, boolean bl) {
        super(new DataView(null, dataIndex, null, dataBinding, null, bl));
    }

    public StoredValueSet(DataIndex dataIndex, EntityBinding entityBinding, boolean bl) {
        super(new DataView(null, dataIndex, null, null, entityBinding, bl));
    }

    StoredValueSet(DataView dataView) {
        super(dataView);
    }

    StoredValueSet(DataView dataView, boolean bl) {
        super(dataView);
        this.isSingleKey = bl;
    }

    public boolean add(Object object) {
        if (this.view.getIndex() != null) {
            throw new UnsupportedOperationException("add() not allowed with index");
        }
        if (this.isSingleKey) {
            boolean bl = this.beginAutoCommit();
            try {
                int n = this.view.addValue(this.view.getSingleKeyThang(), object, Db.DB_NODUPDATA);
                this.commitAutoCommit(bl);
                return n == 0;
            }
            catch (Exception exception) {
                throw this.handleException(exception, bl);
            }
        }
        if (this.view.getValueEntityBinding() == null) {
            throw new UnsupportedOperationException("add() requires entity binding");
        }
        return this.add(null, object);
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public boolean remove(Object object) {
        return this.removeValue(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int size() {
        int n;
        DataCursor dataCursor;
        block7: {
            int n2;
            block6: {
                if (!this.isSingleKey) {
                    return super.size();
                }
                dataCursor = null;
                try {
                    try {
                        dataCursor = new DataCursor(this.view, false);
                        int n3 = dataCursor.get(null, null, Db.DB_FIRST, false);
                        if (n3 == 0) {
                            n2 = dataCursor.count();
                            Object var5_6 = null;
                            break block6;
                        }
                        n = 0;
                        break block7;
                    }
                    catch (Exception exception) {
                        throw StoredContainer.convertException(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    this.closeCursor(dataCursor);
                    throw throwable;
                }
            }
            this.closeCursor(dataCursor);
            return n2;
        }
        Object var5_7 = null;
        this.closeCursor(dataCursor);
        return n;
    }

    Object makeIteratorData(StoredIterator storedIterator, DataCursor dataCursor) throws DbException, IOException {
        return dataCursor.getCurrentValue();
    }

    boolean hasValues() {
        return true;
    }
}

