/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.collection.StoredCollection;
import com.sleepycat.bdb.collection.StoredContainer;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.bdb.collection.StoredMapEntry;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StoredEntrySet
extends StoredCollection
implements Set {
    StoredEntrySet(DataView dataView) {
        super(dataView);
    }

    public boolean add(Object object) {
        Map.Entry entry = (Map.Entry)object;
        return this.add(entry.getKey(), entry.getValue());
    }

    public boolean remove(Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)object;
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            int n = dataCursor.get(entry.getKey(), entry.getValue(), Db.DB_GET_BOTH, true);
            if (n == 0) {
                dataCursor.delete();
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return n == 0;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(Object object) {
        boolean bl;
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)object;
        DataCursor dataCursor = null;
        try {
            try {
                dataCursor = new DataCursor(this.view, false);
                int n = dataCursor.get(entry.getKey(), entry.getValue(), Db.DB_GET_BOTH, false);
                bl = n == 0;
                Object var7_7 = null;
            }
            catch (Exception exception) {
                throw StoredContainer.convertException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeCursor(dataCursor);
            throw throwable;
        }
        this.closeCursor(dataCursor);
        return bl;
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                Object k = object.getKey();
                Object v = object.getValue();
                if (k != null) {
                    stringBuffer.append(k.toString());
                }
                stringBuffer.append('=');
                if (v == null) continue;
                stringBuffer.append(v.toString());
            }
            stringBuffer.append(']');
            object = stringBuffer.toString();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            StoredIterator.close(iterator);
            throw throwable;
        }
        StoredIterator.close(iterator);
        return object;
    }

    Object makeIteratorData(StoredIterator storedIterator, DataCursor dataCursor) throws DbException, IOException {
        return new StoredMapEntry(dataCursor.getCurrentKey(), dataCursor.getCurrentValue(), this, storedIterator);
    }

    boolean hasValues() {
        return true;
    }
}

