### Name: iconv
### Title: Convert Character Vector between Encodings
### Aliases: iconv iconvlist
### Keywords: character utilities

### ** Examples
## Not run: 
##D iconvlist()
##D 
##D ## convert from Latin-2 to UTF-8: two of the glibc iconv variants.
##D iconv(x, "ISO_8859-2", "UTF-8")
##D iconv(x, "LATIN2", "UTF-8")
##D 
##D ## Both x below are in latin1 and will only display correctly in a
##D ## latin1 locale.
##D (x <- "fa\xE7ile")
##D charToRaw(xx <- iconv(x, "latin1", "UTF-8"))
##D ## in a UTF-8 locale, print(xx)
##D 
##D iconv(x, "latin1", "ASCII")          #   NA
##D iconv(x, "latin1", "ASCII", "?")     # "fa?ile"
##D iconv(x, "latin1", "ASCII", "")      # "faile"
##D iconv(x, "latin1", "ASCII", "byte")  # "fa<e7>ile"
##D 
##D # Extracts from R help files
##D (x <- c("Ekstr\xf8m", "J\xf6reskog", "bi\xdfchen Z\xfcrcher"))
##D iconv(x, "latin1", "ASCII//TRANSLIT")
##D iconv(x, "latin1", "ASCII", sub="byte")
## End(Not run)


