-module(megaco_text_parser_prev3b).
-export([parse/1, parse_and_scan/1, format_error/1]).
-file("megaco_text_parser_prev3b.yrl", 1557).

%% The following directive is needed for (significantly) faster compilation
%% of the generated .erl file by the HiPE compiler.  Please do not remove.
-compile([{hipe,[{regalloc,linear_scan}]}]).

-include("megaco_text_parser_prev3b.hrl").



-file("/usr/obj/ports/erlang-11b.3/otp_src_R11B-3/bootstrap/lib/parsetools/include/yeccpre.hrl", 0).
%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved via the world wide web at http://www.erlang.org/.
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Initial Developer of the Original Code is Ericsson Utvecklings AB.
%% Portions created by Ericsson are Copyright 1999, Ericsson Utvecklings
%% AB. All Rights Reserved.''
%% 
%%     $Id $
%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The parser generator will insert appropriate declarations before this line.%

parse(Tokens) ->
    yeccpars0(Tokens, false).

parse_and_scan({F, A}) -> % Fun or {M, F}
    yeccpars0([], {F, A});
parse_and_scan({M, F, A}) ->
    yeccpars0([], {{M, F}, A}).

format_error(Message) ->
    case io_lib:deep_char_list(Message) of
	true ->
	    Message;
	_ ->
	    io_lib:write(Message)
    end.

% To be used in grammar files to throw an error message to the parser
% toplevel. Doesn't have to be exported!
-compile({nowarn_unused_function,{return_error,2}}).
return_error(Line, Message) ->
    throw({error, {Line, ?MODULE, Message}}).

yeccpars0(Tokens, MFA) ->
    try yeccpars1(Tokens, MFA, 0, [], [])
    catch 
        throw: {error, {_Line, ?MODULE, _M}} = Error -> 
                   Error % probably from return_error/1
    end.

% Don't change yeccpars1/6 too much, it is called recursively by yeccpars2/8!
yeccpars1([Token | Tokens], Tokenizer, State, States, Vstack) ->
    yeccpars2(State, element(1, Token), States, Vstack, Token, Tokens,
	      Tokenizer);
yeccpars1([], {F, A}, State, States, Vstack) ->
    case apply(F, A) of
        {ok, Tokens, _Endline} ->
	    yeccpars1(Tokens, {F, A}, State, States, Vstack);
        {eof, _Endline} ->
            yeccpars1([], false, State, States, Vstack);
        {error, Descriptor, _Endline} ->
            {error, Descriptor}
    end;
yeccpars1([], false, State, States, Vstack) ->
    yeccpars2(State, '$end', States, Vstack, {'$end', 999999}, [], false).

% For internal use only.
yeccerror(Token) ->
    {error,
     {element(2, Token), ?MODULE,
      ["syntax error before: ", yecctoken2string(Token)]}}.

yecctoken2string({atom, _, A}) -> io_lib:write(A);
yecctoken2string({integer,_,N}) -> io_lib:write(N);
yecctoken2string({float,_,F}) -> io_lib:write(F);
yecctoken2string({char,_,C}) -> io_lib:write_char(C);
yecctoken2string({var,_,V}) -> io_lib:format('~s', [V]);
yecctoken2string({string,_,S}) -> io_lib:write_string(S);
yecctoken2string({reserved_symbol, _, A}) -> io_lib:format('~w', [A]);
yecctoken2string({_Cat, _, Val}) -> io_lib:format('~w', [Val]);
yecctoken2string({'dot', _}) -> io_lib:format('~w', ['.']);
yecctoken2string({'$end', _}) ->
    [];
yecctoken2string({Other, _}) when is_atom(Other) ->
    io_lib:format('~w', [Other]);
yecctoken2string(Other) ->
    io_lib:write(Other).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



-file("./megaco_text_parser_prev3b.erl", 106).

yeccpars2(0, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [0 | __Ss], [__T | __Stack]);
yeccpars2(0, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_0_(__Stack),
 yeccpars2(1, __Cat, [0 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(1, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 5, [1 | __Ss], [__T | __Stack]);
yeccpars2(1, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_1_(__Stack),
 yeccpars2(4, __Cat, [1 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(2, '$end', _, __Stack, _, _, _) ->
 {ok, hd(__Stack)};
yeccpars2(2, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(3, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_3_(__Stack),
 yeccpars2(yeccgoto(optSep, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(4, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(5, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 6, [5 | __Ss], [__T | __Stack]);
yeccpars2(5, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(6, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(7, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [7 | __Ss], [__T | __Stack]);
yeccpars2(7, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(8, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_8_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(9, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_9_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(10, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_10_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(11, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_11_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(12, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_12_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(13, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_13_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(14, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_14_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(15, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_15_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(16, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_16_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(17, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_17_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(18, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_18_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(19, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_19_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(20, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_20_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(21, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_21_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(22, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_22_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(23, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_23_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(24, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_24_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(25, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_25_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(26, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_26_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(27, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_27_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(28, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_28_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(29, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_29_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(30, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_30_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(31, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_31_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(32, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_32_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(33, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_33_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(34, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_34_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(35, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_35_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(36, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_36_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(37, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_37_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(38, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_38_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(39, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_39_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(40, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_40_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(41, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_41_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(42, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_42_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(43, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_43_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(44, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_44_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(45, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_45_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(46, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_46_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(47, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_47_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(48, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_48_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(49, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_49_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(50, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_50_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(51, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_51_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(52, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_52_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(53, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_53_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(54, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_54_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(55, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_55_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(56, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_56_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(57, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_57_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(58, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_58_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(59, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_59_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(60, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_60_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(61, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_61_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(62, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_62_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(63, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_63_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(64, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_64_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(65, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_65_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(66, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_66_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(67, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_67_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(68, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_68_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(69, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_69_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(70, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_70_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(71, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_71_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(72, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_72_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(73, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_73_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(74, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_74_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(75, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_75_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(76, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_76_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(77, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_77_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(78, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_78_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(79, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_79_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(80, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_80_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(81, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_81_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(82, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_82_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(83, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_83_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(84, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_84_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(85, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_85_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(86, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_86_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(87, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_87_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(88, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [88 | __Ss], [__T | __Stack]);
yeccpars2(88, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(89, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [89 | __Ss], [__T | __Stack]);
yeccpars2(89, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(90, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [90 | __Ss], [__T | __Stack]);
yeccpars2(90, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(91, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [91 | __Ss], [__T | __Stack]);
yeccpars2(91, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_91_(__Stack),
 yeccpars2(92, __Cat, [91 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(92, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_92_(__Stack),
 __Nss = lists:nthtail(7, __Ss),
 yeccpars2(yeccgoto(authenticationHeader, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(93, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [93 | __Ss], [__T | __Stack]);
yeccpars2(93, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_93_(__Stack),
 yeccpars2(96, __Cat, [93 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(94, endOfMessage, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [94 | __Ss], [__T | __Stack]);
yeccpars2(94, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(95, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_95_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(megacoMessage, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(96, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'MtpAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 904, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(97, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 125, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 126, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 127, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 128, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 129, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(98, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(mId, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(99, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(mId, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(100, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(101, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 104, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_101_(__Stack),
 yeccpars2(103, __Cat, [101 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(102, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 104, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_102_(__Stack),
 yeccpars2(111, __Cat, [102 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(103, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 106, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(104, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 104, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_104_(__Stack),
 yeccpars2(105, __Cat, [104 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(105, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_105_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(daddr, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(106, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 107, [106 | __Ss], [__T | __Stack]);
yeccpars2(106, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_106_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(domainAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(107, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(108, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_108_(__Stack),
 yeccpars2(yeccgoto(portNumber, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(109, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_109_(__Stack),
 yeccpars2(110, __Cat, [109 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(110, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_110_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(domainAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(111, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_111_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(daddr, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(112, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 113, [112 | __Ss], [__T | __Stack]);
yeccpars2(112, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(113, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 114, [113 | __Ss], [__T | __Stack]);
yeccpars2(113, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_113_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(domainName, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(114, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(115, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_115_(__Stack),
 yeccpars2(116, __Cat, [115 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(116, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_116_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(domainName, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(117, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_117_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(118, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_118_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(119, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_119_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(120, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_120_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(121, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_121_(__Stack),
 yeccpars2(yeccgoto(messageBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(122, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 126, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 127, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 128, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 129, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_122_(__Stack),
 yeccpars2(yeccgoto(transactionList, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(123, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_123_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(message, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(124, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_124_(__Stack),
 yeccpars2(yeccgoto(messageBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(125, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 833, [125 | __Ss], [__T | __Stack]);
yeccpars2(125, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(126, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 895, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(127, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 763, [127 | __Ss], [__T | __Stack]);
yeccpars2(127, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(128, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 755, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(129, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 130, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 131, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(130, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 747, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [130 | __Ss], [__T | __Stack]);
yeccpars2(130, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(131, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 133, [131 | __Ss], [__T | __Stack]);
yeccpars2(131, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(132, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 741, [132 | __Ss], [__T | __Stack]);
yeccpars2(132, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_132_(__Stack),
 yeccpars2(740, __Cat, [132 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(133, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 134, [133 | __Ss], [__T | __Stack]);
yeccpars2(133, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(134, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(135, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_135_(__Stack),
 yeccpars2(yeccgoto(contextID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(136, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 137, [136 | __Ss], [__T | __Stack]);
yeccpars2(136, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(137, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 153, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 154, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 155, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ContextAttrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 156, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 157, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 158, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 159, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'IEPSToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 160, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 161, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 162, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 163, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 164, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 165, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 166, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 167, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(138, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_138_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(139, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(140, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(141, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_141_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(142, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(143, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_143_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(144, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_144_(__Stack),
 yeccpars2(yeccgoto(actionRequestItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(145, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_145_(__Stack),
 yeccpars2(yeccgoto(actionRequestItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(146, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(147, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_147_(__Stack),
 yeccpars2(yeccgoto(actionRequestItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(148, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(149, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 520, [149 | __Ss], [__T | __Stack]);
yeccpars2(149, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(150, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(151, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 517, [151 | __Ss], [__T | __Stack]);
yeccpars2(151, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_151_(__Stack),
 yeccpars2(516, __Cat, [151 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(152, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 515, [152 | __Ss], [__T | __Stack]);
yeccpars2(152, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(153, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_153_(__Stack),
 yeccpars2(yeccgoto(ammToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(154, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 512, [154 | __Ss], [__T | __Stack]);
yeccpars2(154, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(155, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 509, [155 | __Ss], [__T | __Stack]);
yeccpars2(155, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(156, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 488, [156 | __Ss], [__T | __Stack]);
yeccpars2(156, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(157, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 472, [157 | __Ss], [__T | __Stack]);
yeccpars2(157, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(158, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_158_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(159, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_159_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(160, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 468, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(161, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_161_(__Stack),
 yeccpars2(yeccgoto(ammToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(162, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_162_(__Stack),
 yeccpars2(yeccgoto(ammToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(163, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 432, [163 | __Ss], [__T | __Stack]);
yeccpars2(163, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(164, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 430, [164 | __Ss], [__T | __Stack]);
yeccpars2(164, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(165, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 380, [165 | __Ss], [__T | __Stack]);
yeccpars2(165, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(166, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 186, [166 | __Ss], [__T | __Stack]);
yeccpars2(166, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(167, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 168, [167 | __Ss], [__T | __Stack]);
yeccpars2(167, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(168, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(169, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 182, [169 | __Ss], [__T | __Stack]);
yeccpars2(169, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_169_(__Stack),
 yeccpars2(181, __Cat, [169 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(170, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(terminationA, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(171, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 173, [171 | __Ss], [__T | __Stack]);
yeccpars2(171, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(172, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_172_(__Stack),
 yeccpars2(yeccgoto(terminationID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(173, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(174, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(terminationB, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(175, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 176, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(176, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 178, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 179, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 180, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(177, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_177_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(topologyTriple, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(178, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_178_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(179, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_179_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(180, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_180_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(181, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 185, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(182, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [182 | __Ss], [__T | __Stack]);
yeccpars2(182, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(183, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 182, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_183_(__Stack),
 yeccpars2(184, __Cat, [183 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(184, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_184_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(topologyTripleList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(185, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_185_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(topologyDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(186, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [186 | __Ss], [__T | __Stack]);
yeccpars2(186, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(187, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 189, [187 | __Ss], [__T | __Stack]);
yeccpars2(187, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_187_(__Stack),
 yeccpars2(188, __Cat, [187 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(188, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_188_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(subtractRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(189, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 191, [189 | __Ss], [__T | __Stack]);
yeccpars2(189, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(190, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 379, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(191, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 192, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(192, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 205, [192 | __Ss], [__T | __Stack]);
yeccpars2(192, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 206, [192 | __Ss], [__T | __Stack]);
yeccpars2(192, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [192 | __Ss], [__T | __Stack]);
yeccpars2(192, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 208, [192 | __Ss], [__T | __Stack]);
yeccpars2(192, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 209, [192 | __Ss], [__T | __Stack]);
yeccpars2(192, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 210, [192 | __Ss], [__T | __Stack]);
yeccpars2(192, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 211, [192 | __Ss], [__T | __Stack]);
yeccpars2(192, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 212, [192 | __Ss], [__T | __Stack]);
yeccpars2(192, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 213, [192 | __Ss], [__T | __Stack]);
yeccpars2(192, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 214, [192 | __Ss], [__T | __Stack]);
yeccpars2(192, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 215, [192 | __Ss], [__T | __Stack]);
yeccpars2(192, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_192_(__Stack),
 yeccpars2(204, __Cat, [192 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(193, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_193_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(194, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_194_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(195, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_195_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(196, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_196_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(197, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_197_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(198, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_198_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(199, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_199_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(200, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_200_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(201, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 371, [201 | __Ss], [__T | __Stack]);
yeccpars2(201, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_201_(__Stack),
 yeccpars2(370, __Cat, [201 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(202, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(203, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 367, [203 | __Ss], [__T | __Stack]);
yeccpars2(203, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_203_(__Stack),
 yeccpars2(366, __Cat, [203 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(204, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 365, [204 | __Ss], [__T | __Stack]);
yeccpars2(204, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(205, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_205_(__Stack),
 yeccpars2(yeccgoto(indAuddigitMapDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(206, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_206_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(207, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 351, [207 | __Ss], [__T | __Stack]);
yeccpars2(207, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_207_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(208, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 345, [208 | __Ss], [__T | __Stack]);
yeccpars2(208, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_208_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(209, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 312, [209 | __Ss], [__T | __Stack]);
yeccpars2(209, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_209_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(210, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_210_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(211, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_211_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(212, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_212_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(213, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 308, [213 | __Ss], [__T | __Stack]);
yeccpars2(213, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_213_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(214, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 221, [214 | __Ss], [__T | __Stack]);
yeccpars2(214, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_214_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(215, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 216, [215 | __Ss], [__T | __Stack]);
yeccpars2(215, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_215_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(216, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(217, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_217_(__Stack),
 yeccpars2(yeccgoto(pkgdName, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(218, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 219, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(219, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_219_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudstatisticsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(220, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_220_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(indAudsignalsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(221, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 227, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 228, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(222, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_222_(__Stack),
 yeccpars2(yeccgoto(indAudsignalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(223, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 237, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_223_(__Stack),
 yeccpars2(yeccgoto(signalRequest, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(224, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(signalName, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(225, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 236, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(226, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_226_(__Stack),
 yeccpars2(yeccgoto(indAudsignalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(227, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_227_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(optIndAudsignalParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(228, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 229, [228 | __Ss], [__T | __Stack]);
yeccpars2(228, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_228_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(229, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [229 | __Ss], [__T | __Stack]);
yeccpars2(229, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(230, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 232, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(231, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_231_(__Stack),
 yeccpars2(yeccgoto(signalListId, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(232, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(233, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(signalListParm, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(234, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 235, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(235, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_235_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(indAudsignalList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(236, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_236_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(optIndAudsignalParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(237, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 240, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 241, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 242, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 243, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 244, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 245, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 246, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [237 | __Ss], [__T | __Stack]);
yeccpars2(237, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(238, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 304, [238 | __Ss], [__T | __Stack]);
yeccpars2(238, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_238_(__Stack),
 yeccpars2(303, __Cat, [238 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(239, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 278, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 279, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 280, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 281, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(240, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 272, [240 | __Ss], [__T | __Stack]);
yeccpars2(240, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_240_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(241, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 270, [241 | __Ss], [__T | __Stack]);
yeccpars2(241, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_241_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(242, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_242_COMMA(__Stack),
 yeccpars2(yeccgoto(sigParameter, hd(__Ss)), 'COMMA', __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(242, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_242_RBRKT(__Stack),
 yeccpars2(yeccgoto(sigParameter, hd(__Ss)), 'RBRKT', __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(242, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_242_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(243, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 258, [243 | __Ss], [__T | __Stack]);
yeccpars2(243, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_243_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(244, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 255, [244 | __Ss], [__T | __Stack]);
yeccpars2(244, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_244_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(245, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 250, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_245_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(246, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 247, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_246_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(247, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(248, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_248_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(249, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_249_(__Stack),
 yeccpars2(yeccgoto(streamID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(250, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 252, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 253, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(251, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_251_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(252, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_252_(__Stack),
 yeccpars2(yeccgoto(signalType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(253, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_253_(__Stack),
 yeccpars2(yeccgoto(signalType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(254, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_254_(__Stack),
 yeccpars2(yeccgoto(signalType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(255, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(256, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_256_(__Stack),
 yeccpars2(yeccgoto(requestID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(257, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_257_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(258, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 259, [258 | __Ss], [__T | __Stack]);
yeccpars2(258, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(259, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 261, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 262, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 263, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 264, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(260, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 266, [260 | __Ss], [__T | __Stack]);
yeccpars2(260, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_260_(__Stack),
 yeccpars2(265, __Cat, [260 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(261, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_261_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(262, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_262_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(263, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_263_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(264, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_264_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(265, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 269, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(266, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 261, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 262, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 263, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 264, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(267, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 266, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_267_(__Stack),
 yeccpars2(268, __Cat, [267 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(268, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_268_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(notificationReasons, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(269, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_269_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(270, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(271, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_271_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(272, 'BothToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 274, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ExternalToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 275, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'InternalToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 276, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(273, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_273_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(274, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_274_(__Stack),
 yeccpars2(yeccgoto(direction, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(275, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_275_(__Stack),
 yeccpars2(yeccgoto(direction, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(276, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_276_(__Stack),
 yeccpars2(yeccgoto(direction, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(277, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_277_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(278, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 289, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 290, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(279, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(280, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [280 | __Ss], [__T | __Stack]);
yeccpars2(280, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(281, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(282, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_282_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(283, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_283_(__Stack),
 yeccpars2(yeccgoto(value, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(284, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_284_(__Stack),
 yeccpars2(yeccgoto(value, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(285, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_285_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(286, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_286_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(287, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_287_(__Stack),
 yeccpars2(yeccgoto(alternativeValue, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(288, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_288_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(289, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(290, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [290 | __Ss], [__T | __Stack]);
yeccpars2(290, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(291, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 293, [291 | __Ss], [__T | __Stack]);
yeccpars2(291, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 294, [291 | __Ss], [__T | __Stack]);
yeccpars2(291, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_291_(__Stack),
 yeccpars2(292, __Cat, [291 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(292, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 299, [292 | __Ss], [__T | __Stack]);
yeccpars2(292, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(293, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(294, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [294 | __Ss], [__T | __Stack]);
yeccpars2(294, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(295, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 294, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_295_(__Stack),
 yeccpars2(296, __Cat, [295 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(296, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_296_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(valueList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(297, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 298, [297 | __Ss], [__T | __Stack]);
yeccpars2(297, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(298, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_298_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(alternativeValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(299, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_299_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(alternativeValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(300, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 294, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_300_(__Stack),
 yeccpars2(301, __Cat, [300 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(301, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 302, [301 | __Ss], [__T | __Stack]);
yeccpars2(301, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(302, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_302_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(alternativeValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(303, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 307, [303 | __Ss], [__T | __Stack]);
yeccpars2(303, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(304, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 240, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 241, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 242, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 243, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 244, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 245, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 246, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(305, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 304, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_305_(__Stack),
 yeccpars2(306, __Cat, [305 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(306, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_306_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameters, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(307, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_307_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(signalRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(308, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(309, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_309_(__Stack),
 yeccpars2(yeccgoto(packagesItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(310, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 311, [310 | __Ss], [__T | __Stack]);
yeccpars2(310, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(311, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_311_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudpackagesDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(312, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 319, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 320, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 321, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 322, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(313, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_313_(__Stack),
 yeccpars2(yeccgoto(indAudmediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(314, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_314_(__Stack),
 yeccpars2(yeccgoto(indAudmediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(315, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_315_(__Stack),
 yeccpars2(yeccgoto(indAudmediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(316, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_316_(__Stack),
 yeccpars2(yeccgoto(indAudstreamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(317, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 341, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_317_(__Stack),
 yeccpars2(340, __Cat, [317 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(318, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_318_(__Stack),
 yeccpars2(yeccgoto(indAudstreamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(319, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 332, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(320, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 216, [320 | __Ss], [__T | __Stack]);
yeccpars2(320, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(321, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 327, [321 | __Ss], [__T | __Stack]);
yeccpars2(321, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(322, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 323, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(323, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(324, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_324_(__Stack),
 yeccpars2(yeccgoto(indAudterminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(325, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 326, [325 | __Ss], [__T | __Stack]);
yeccpars2(325, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(326, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_326_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudterminationStateDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(327, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(328, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 329, [328 | __Ss], [__T | __Stack]);
yeccpars2(328, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(329, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 319, [329 | __Ss], [__T | __Stack]);
yeccpars2(329, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 320, [329 | __Ss], [__T | __Stack]);
yeccpars2(329, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(330, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 331, [330 | __Ss], [__T | __Stack]);
yeccpars2(330, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(331, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_331_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(indAudstreamDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(332, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [332 | __Ss], [__T | __Stack]);
yeccpars2(332, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(333, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_333_(__Stack),
 yeccpars2(yeccgoto(indAudlocalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(334, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 336, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_334_(__Stack),
 yeccpars2(335, __Cat, [334 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(335, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 339, [335 | __Ss], [__T | __Stack]);
yeccpars2(335, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(336, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(337, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 336, [337 | __Ss], [__T | __Stack]);
yeccpars2(337, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_337_(__Stack),
 yeccpars2(338, __Cat, [337 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(338, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_338_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(indAudlocalParmList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(339, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_339_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(indAudlocalControlDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(340, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 344, [340 | __Ss], [__T | __Stack]);
yeccpars2(340, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(341, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 319, [341 | __Ss], [__T | __Stack]);
yeccpars2(341, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 320, [341 | __Ss], [__T | __Stack]);
yeccpars2(341, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 321, [341 | __Ss], [__T | __Stack]);
yeccpars2(341, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 322, [341 | __Ss], [__T | __Stack]);
yeccpars2(341, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(342, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 341, [342 | __Ss], [__T | __Stack]);
yeccpars2(342, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_342_(__Stack),
 yeccpars2(343, __Cat, [342 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(343, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_343_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(indAudmediaParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(344, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_344_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(indAudmediaDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(345, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(346, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 347, [346 | __Ss], [__T | __Stack]);
yeccpars2(346, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(347, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(348, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(indAudrequestedEvent, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(349, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 350, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(350, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_350_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(indAudeventsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(351, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(352, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 356, [352 | __Ss], [__T | __Stack]);
yeccpars2(352, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_352_(__Stack),
 yeccpars2(355, __Cat, [352 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(353, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 354, [353 | __Ss], [__T | __Stack]);
yeccpars2(353, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(354, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_354_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudeventBufferDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(355, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_355_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(indAudeventSpec, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(356, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 361, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(357, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_357_(__Stack),
 yeccpars2(yeccgoto(eventParameterName, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(358, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 364, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(359, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_359_(__Stack),
 yeccpars2(yeccgoto(indAudeventSpecParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(360, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_360_(__Stack),
 yeccpars2(yeccgoto(indAudeventSpecParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(361, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 362, [361 | __Ss], [__T | __Stack]);
yeccpars2(361, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_361_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(362, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(363, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_363_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(eventStream, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(364, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_364_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(optIndAudeventSpecParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(365, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_365_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(auditDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(366, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_366_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(auditDescriptorBody, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(367, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 205, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 206, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 208, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 209, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 210, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 211, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 212, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 213, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 214, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 215, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(368, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 367, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_368_(__Stack),
 yeccpars2(369, __Cat, [368 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(369, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_369_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(auditItemList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(370, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_370_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(indAudterminationAudit, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(371, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 205, [371 | __Ss], [__T | __Stack]);
yeccpars2(371, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 373, [371 | __Ss], [__T | __Stack]);
yeccpars2(371, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 374, [371 | __Ss], [__T | __Stack]);
yeccpars2(371, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 375, [371 | __Ss], [__T | __Stack]);
yeccpars2(371, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 376, [371 | __Ss], [__T | __Stack]);
yeccpars2(371, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 377, [371 | __Ss], [__T | __Stack]);
yeccpars2(371, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 320, [371 | __Ss], [__T | __Stack]);
yeccpars2(371, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(372, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 371, [372 | __Ss], [__T | __Stack]);
yeccpars2(372, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_372_(__Stack),
 yeccpars2(378, __Cat, [372 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(373, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 351, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(374, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 345, [374 | __Ss], [__T | __Stack]);
yeccpars2(374, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(375, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 312, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(376, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 308, [376 | __Ss], [__T | __Stack]);
yeccpars2(376, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(377, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 221, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(378, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_378_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(indAudterminationAuditList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(379, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_379_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(optAuditDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(380, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [380 | __Ss], [__T | __Stack]);
yeccpars2(380, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(381, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 382, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(382, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 384, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(383, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 429, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(384, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 385, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(385, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 399, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 205, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 206, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 208, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 209, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 400, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 401, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 210, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 211, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 212, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 213, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 402, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 403, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 404, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ServiceChangeIncompleteToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 405, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 214, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 215, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 406, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 407, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(386, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_386_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(387, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_387_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(388, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_388_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(389, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_389_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(390, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 425, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_390_(__Stack),
 yeccpars2(424, __Cat, [390 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(391, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_391_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(392, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_392_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(393, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_393_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(394, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_394_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(395, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_395_(__Stack),
 yeccpars2(yeccgoto(extensionParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(396, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 278, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 279, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 280, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 281, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(397, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_397_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(398, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_398_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(399, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 421, [399 | __Ss], [__T | __Stack]);
yeccpars2(399, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_399_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(400, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 419, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_400_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(401, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 417, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_401_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(402, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 415, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_402_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(403, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 413, [403 | __Ss], [__T | __Stack]);
yeccpars2(403, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_403_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(404, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 410, [404 | __Ss], [__T | __Stack]);
yeccpars2(404, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_404_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(405, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_405_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(406, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_406_(__Stack),
 yeccpars2(yeccgoto(timeStamp, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(407, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 408, [407 | __Ss], [__T | __Stack]);
yeccpars2(407, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_407_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(408, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(409, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_409_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeVersion, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(410, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_410_(__Stack),
 yeccpars2(96, __Cat, [410 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(411, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_411_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(412, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_412_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(413, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(414, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_414_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeReason, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(415, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [415 | __Ss], [__T | __Stack]);
yeccpars2(415, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(416, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_416_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeProfile, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(417, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_417_(__Stack),
 yeccpars2(96, __Cat, [417 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(418, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_418_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeMgcId, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(419, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(420, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_420_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeMethod, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(421, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(422, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_422_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeDelay, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(423, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_423_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(extension, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(424, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 428, [424 | __Ss], [__T | __Stack]);
yeccpars2(424, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(425, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 399, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 205, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 206, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 208, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 209, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 400, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 401, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 210, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 211, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 212, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 213, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 402, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 403, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 404, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ServiceChangeIncompleteToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 405, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 214, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 215, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 406, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 407, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(426, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 425, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_426_(__Stack),
 yeccpars2(427, __Cat, [426 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(427, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_427_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(428, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_428_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(serviceChangeDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(429, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_429_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(serviceChangeRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(430, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(431, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_431_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(priority, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(432, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [432 | __Ss], [__T | __Stack]);
yeccpars2(432, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(433, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 434, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(434, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 125, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 438, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(435, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_435_(__Stack),
 yeccpars2(yeccgoto(notifyRequestBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(436, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 467, [436 | __Ss], [__T | __Stack]);
yeccpars2(436, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(437, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_437_(__Stack),
 yeccpars2(yeccgoto(notifyRequestBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(438, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 439, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(439, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(440, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 441, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(441, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 406, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_441_(__Stack),
 yeccpars2(443, __Cat, [441 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(442, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_442_(__Stack),
 yeccpars2(462, __Cat, [442 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(443, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(444, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 446, [444 | __Ss], [__T | __Stack]);
yeccpars2(444, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_444_(__Stack),
 yeccpars2(445, __Cat, [444 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(445, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 449, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(446, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 406, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_446_(__Stack),
 yeccpars2(443, __Cat, [446 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(447, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 446, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_447_(__Stack),
 yeccpars2(448, __Cat, [447 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(448, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_448_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(observedEvents, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(449, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_449_(__Stack),
 __Nss = lists:nthtail(6, __Ss),
 yeccpars2(yeccgoto(observedEventsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(450, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 452, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_450_(__Stack),
 yeccpars2(451, __Cat, [450 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(451, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_451_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(observedEvent, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(452, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(453, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 458, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_453_(__Stack),
 yeccpars2(457, __Cat, [453 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(454, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(observedEventParameter, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(455, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 278, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 279, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 280, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 281, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(456, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_456_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(eventStreamOrOther, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(457, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 461, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(458, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [458 | __Ss], [__T | __Stack]);
yeccpars2(458, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(459, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 458, [459 | __Ss], [__T | __Stack]);
yeccpars2(459, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_459_(__Stack),
 yeccpars2(460, __Cat, [459 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(460, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_460_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(observedEventParameters, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(461, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_461_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(observedEventBody, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(462, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 463, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(463, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [463 | __Ss], [__T | __Stack]);
yeccpars2(463, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_463_(__Stack),
 yeccpars2(464, __Cat, [463 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(464, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(465, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 452, [465 | __Ss], [__T | __Stack]);
yeccpars2(465, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_465_(__Stack),
 yeccpars2(466, __Cat, [465 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(466, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_466_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(observedEvent, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(467, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_467_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(notifyRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(468, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 470, [468 | __Ss], [__T | __Stack]);
yeccpars2(468, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 471, [468 | __Ss], [__T | __Stack]);
yeccpars2(468, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(469, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_469_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(iepsValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(470, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_470_(__Stack),
 yeccpars2(yeccgoto(onOrOff, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(471, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_471_(__Stack),
 yeccpars2(yeccgoto(onOrOff, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(472, 'ContextAttrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 474, [472 | __Ss], [__T | __Stack]);
yeccpars2(472, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(473, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 487, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(474, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 475, [474 | __Ss], [__T | __Stack]);
yeccpars2(474, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(475, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 478, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'IEPSToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 479, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 480, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 481, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(476, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_476_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(477, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 483, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_477_(__Stack),
 yeccpars2(482, __Cat, [477 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(478, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_478_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(479, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_479_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(480, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_480_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(481, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_481_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(482, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 486, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(483, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 478, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'IEPSToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 479, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 480, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 481, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(484, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 483, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_484_(__Stack),
 yeccpars2(485, __Cat, [484 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(485, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_485_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(contextAuditProperties, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(486, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_486_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(indAudcontextAttrDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(487, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_487_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(contextAudit, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(488, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ContextListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 493, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [488 | __Ss], [__T | __Stack]);
yeccpars2(488, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(489, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 508, [489 | __Ss], [__T | __Stack]);
yeccpars2(489, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(490, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 505, [490 | __Ss], [__T | __Stack]);
yeccpars2(490, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_490_(__Stack),
 yeccpars2(504, __Cat, [490 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(491, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 278, [491 | __Ss], [__T | __Stack]);
yeccpars2(491, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 279, [491 | __Ss], [__T | __Stack]);
yeccpars2(491, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 280, [491 | __Ss], [__T | __Stack]);
yeccpars2(491, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 281, [491 | __Ss], [__T | __Stack]);
yeccpars2(491, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(492, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 502, [492 | __Ss], [__T | __Stack]);
yeccpars2(492, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(493, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 494, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(494, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 495, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(495, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(496, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 498, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_496_(__Stack),
 yeccpars2(497, __Cat, [496 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(497, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 501, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(498, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(499, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 498, [499 | __Ss], [__T | __Stack]);
yeccpars2(499, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_499_(__Stack),
 yeccpars2(500, __Cat, [499 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(500, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_500_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(contextIDs, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(501, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_501_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(contextIdList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(502, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_502_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(contextAttrDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(503, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_503_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(propertyParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(504, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_504_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(propertyParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(505, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(506, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 505, [506 | __Ss], [__T | __Stack]);
yeccpars2(506, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_506_(__Stack),
 yeccpars2(507, __Cat, [506 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(507, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_507_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(propertyParmList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(508, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_508_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(contextAttrDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(509, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(510, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 189, [510 | __Ss], [__T | __Stack]);
yeccpars2(510, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_510_(__Stack),
 yeccpars2(511, __Cat, [510 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(511, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_511_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(auditRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(512, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(513, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 189, [513 | __Ss], [__T | __Stack]);
yeccpars2(513, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_513_(__Stack),
 yeccpars2(514, __Cat, [513 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(514, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_514_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(auditRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(515, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_515_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(actionRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(516, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_516_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(actionRequestBody, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(517, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 153, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 154, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 155, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, 'ContextAttrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 156, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 157, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 158, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 159, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, 'IEPSToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 160, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 161, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 162, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 163, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 164, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 165, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 166, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 167, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(518, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 517, [518 | __Ss], [__T | __Stack]);
yeccpars2(518, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_518_(__Stack),
 yeccpars2(519, __Cat, [518 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(519, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_519_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(actionRequestItems, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(520, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(521, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 523, [521 | __Ss], [__T | __Stack]);
yeccpars2(521, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_521_(__Stack),
 yeccpars2(522, __Cat, [521 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(522, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_522_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(ammRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(523, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 191, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 534, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 535, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 536, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 537, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 538, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 539, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 540, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 541, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(524, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_524_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(525, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_525_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(526, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_526_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(527, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_527_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(528, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_528_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(529, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_529_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(530, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_530_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(531, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_531_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(532, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_532_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(533, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 736, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_533_(__Stack),
 yeccpars2(735, __Cat, [533 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(534, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_534_(__Stack),
 yeccpars2(yeccgoto(digitMapDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(535, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 727, [535 | __Ss], [__T | __Stack]);
yeccpars2(535, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_535_(__Stack),
 yeccpars2(yeccgoto(eventBufferDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(536, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 667, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_536_(__Stack),
 yeccpars2(yeccgoto(eventsDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(537, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 598, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(538, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 582, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 583, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(539, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 571, [539 | __Ss], [__T | __Stack]);
yeccpars2(539, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(540, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 552, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_540_(__Stack),
 yeccpars2(yeccgoto(signalsDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(541, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 542, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(542, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(543, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 548, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_543_(__Stack),
 yeccpars2(547, __Cat, [543 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(544, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 545, [544 | __Ss], [__T | __Stack]);
yeccpars2(544, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_544_(__Stack),
 yeccpars2(yeccgoto(statisticsParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(545, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 284, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [545 | __Ss], [__T | __Stack]);
yeccpars2(545, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(546, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_546_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(statisticsParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(547, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 551, [547 | __Ss], [__T | __Stack]);
yeccpars2(547, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(548, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(549, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 548, [549 | __Ss], [__T | __Stack]);
yeccpars2(549, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_549_(__Stack),
 yeccpars2(550, __Cat, [549 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(550, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_550_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(statisticsParameters, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(551, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_551_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(statisticsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(552, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 556, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(553, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_553_(__Stack),
 yeccpars2(yeccgoto(signalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(554, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 567, [554 | __Ss], [__T | __Stack]);
yeccpars2(554, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_554_(__Stack),
 yeccpars2(566, __Cat, [554 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(555, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_555_(__Stack),
 yeccpars2(yeccgoto(signalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(556, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 557, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_556_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(557, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(558, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 559, [558 | __Ss], [__T | __Stack]);
yeccpars2(558, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(559, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(560, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 562, [560 | __Ss], [__T | __Stack]);
yeccpars2(560, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_560_(__Stack),
 yeccpars2(561, __Cat, [560 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(561, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 565, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(562, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [562 | __Ss], [__T | __Stack]);
yeccpars2(562, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(563, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 562, [563 | __Ss], [__T | __Stack]);
yeccpars2(563, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_563_(__Stack),
 yeccpars2(564, __Cat, [563 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(564, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_564_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(signalListParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(565, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_565_(__Stack),
 __Nss = lists:nthtail(6, __Ss),
 yeccpars2(yeccgoto(signalList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(566, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 570, [566 | __Ss], [__T | __Stack]);
yeccpars2(566, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(567, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 556, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [567 | __Ss], [__T | __Stack]);
yeccpars2(567, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(568, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 567, [568 | __Ss], [__T | __Stack]);
yeccpars2(568, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_568_(__Stack),
 yeccpars2(569, __Cat, [568 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(569, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_569_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(signalParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(570, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_570_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(signalsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(571, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(572, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_572_(__Stack),
 yeccpars2(yeccgoto(muxType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(573, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 575, [573 | __Ss], [__T | __Stack]);
yeccpars2(573, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(574, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_574_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(muxDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(575, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(576, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 578, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_576_(__Stack),
 yeccpars2(577, __Cat, [576 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(577, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 581, [577 | __Ss], [__T | __Stack]);
yeccpars2(577, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(578, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [578 | __Ss], [__T | __Stack]);
yeccpars2(578, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(579, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 578, [579 | __Ss], [__T | __Stack]);
yeccpars2(579, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_579_(__Stack),
 yeccpars2(580, __Cat, [579 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(580, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_580_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(terminationIDListRepeat, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(581, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_581_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(terminationIDList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(582, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(583, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(584, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_584_(__Stack),
 yeccpars2(yeccgoto(modemType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(585, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 587, [585 | __Ss], [__T | __Stack]);
yeccpars2(585, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_585_(__Stack),
 yeccpars2(586, __Cat, [585 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(586, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 590, [586 | __Ss], [__T | __Stack]);
yeccpars2(586, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(587, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [587 | __Ss], [__T | __Stack]);
yeccpars2(587, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(588, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 587, [588 | __Ss], [__T | __Stack]);
yeccpars2(588, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_588_(__Stack),
 yeccpars2(589, __Cat, [588 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(589, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_589_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(modemTypeList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(590, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 592, [590 | __Ss], [__T | __Stack]);
yeccpars2(590, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_590_(__Stack),
 yeccpars2(591, __Cat, [590 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(591, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_591_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(modemDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(592, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'RequestIDToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [592 | __Ss], [__T | __Stack]);
yeccpars2(592, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(593, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 505, [593 | __Ss], [__T | __Stack]);
yeccpars2(593, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_593_(__Stack),
 yeccpars2(594, __Cat, [593 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(594, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 595, [594 | __Ss], [__T | __Stack]);
yeccpars2(594, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(595, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_595_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(optPropertyParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(596, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 592, [596 | __Ss], [__T | __Stack]);
yeccpars2(596, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_596_(__Stack),
 yeccpars2(597, __Cat, [596 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(597, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_597_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(modemDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(598, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 605, [598 | __Ss], [__T | __Stack]);
yeccpars2(598, 'LocalDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 606, [598 | __Ss], [__T | __Stack]);
yeccpars2(598, 'RemoteDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 607, [598 | __Ss], [__T | __Stack]);
yeccpars2(598, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 541, [598 | __Ss], [__T | __Stack]);
yeccpars2(598, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 608, [598 | __Ss], [__T | __Stack]);
yeccpars2(598, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 609, [598 | __Ss], [__T | __Stack]);
yeccpars2(598, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(599, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_599_(__Stack),
 yeccpars2(yeccgoto(mediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(600, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_600_(__Stack),
 yeccpars2(yeccgoto(mediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(601, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_601_(__Stack),
 yeccpars2(yeccgoto(mediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(602, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_602_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(603, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 663, [603 | __Ss], [__T | __Stack]);
yeccpars2(603, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_603_(__Stack),
 yeccpars2(662, __Cat, [603 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(604, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_604_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(605, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 640, [605 | __Ss], [__T | __Stack]);
yeccpars2(605, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(606, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_606_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(607, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_607_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(608, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 631, [608 | __Ss], [__T | __Stack]);
yeccpars2(608, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(609, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 610, [609 | __Ss], [__T | __Stack]);
yeccpars2(609, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(610, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 615, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'DirectionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [610 | __Ss], [__T | __Stack]);
yeccpars2(610, 'FailoverToken', __Ss, __Stack, __T, __Ts, _