/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DbAppendRecno;
import com.sleepycat.db.DbBtreeCompare;
import com.sleepycat.db.DbBtreePrefix;
import com.sleepycat.db.DbDeadlockException;
import com.sleepycat.db.DbDupCompare;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbErrcall;
import com.sleepycat.db.DbErrorHandler;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbFeedback;
import com.sleepycat.db.DbFeedbackHandler;
import com.sleepycat.db.DbHash;
import com.sleepycat.db.DbKeyRange;
import com.sleepycat.db.DbLockNotGrantedException;
import com.sleepycat.db.DbMpoolFile;
import com.sleepycat.db.DbPanicHandler;
import com.sleepycat.db.DbSecondaryKeyCreate;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import com.sleepycat.db.db_java;
import com.sleepycat.db.db_javaJNI;
import java.io.FileNotFoundException;
import java.io.OutputStream;

public class Db {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    static final int GIGABYTE = 0x40000000;
    private Object db_ref;
    private DbEnv dbenv;
    private boolean private_dbenv;
    private DbAppendRecno append_recno_handler;
    private DbBtreeCompare bt_compare_handler;
    private DbBtreePrefix bt_prefix_handler;
    private DbDupCompare dup_compare_handler;
    private DbFeedbackHandler db_feedback_handler;
    private DbHash h_hash_handler;
    private DbSecondaryKeyCreate seckey_create_handler;
    public static final int DB_BTREE = 1;
    public static final int DB_DONOTINDEX = -30999;
    public static final int DB_FILEOPEN = -30998;
    public static final int DB_HASH = 2;
    public static final int DB_KEYEMPTY = -30997;
    public static final int DB_KEYEXIST = -30996;
    public static final int DB_LOCK_DEADLOCK = -30995;
    public static final int DB_LOCK_NOTGRANTED = -30994;
    public static final int DB_NOSERVER = -30993;
    public static final int DB_NOSERVER_HOME = -30992;
    public static final int DB_NOSERVER_ID = -30991;
    public static final int DB_NOTFOUND = -30990;
    public static final int DB_OLD_VERSION = -30989;
    public static final int DB_PAGE_NOTFOUND = -30988;
    public static final int DB_QUEUE = 4;
    public static final int DB_RECNO = 3;
    public static final int DB_REP_DUPMASTER = -30987;
    public static final int DB_REP_HANDLE_DEAD = -30986;
    public static final int DB_REP_HOLDELECTION = -30985;
    public static final int DB_REP_NEWMASTER = -30983;
    public static final int DB_REP_NEWSITE = -30982;
    public static final int DB_REP_OUTDATED = -30980;
    public static final int DB_RUNRECOVERY = -30978;
    public static final int DB_SECONDARY_BAD = -30977;
    public static final int DB_TXN_ABORT = 0;
    public static final int DB_TXN_APPLY = 1;
    public static final int DB_TXN_BACKWARD_ROLL = 3;
    public static final int DB_TXN_FORWARD_ROLL = 4;
    public static final int DB_TXN_PRINT = 8;
    public static final int DB_UNKNOWN = 5;
    public static final int DB_VERIFY_BAD = -30976;
    public static final int DB_AFTER = 1;
    public static final int DB_AGGRESSIVE = 1;
    public static final int DB_APPEND = 2;
    public static final int DB_ARCH_ABS = 1;
    public static final int DB_ARCH_DATA = 2;
    public static final int DB_ARCH_LOG = 4;
    public static final int DB_ARCH_REMOVE = 8;
    public static final int DB_AUTO_COMMIT = 0x1000000;
    public static final int DB_BEFORE = 3;
    public static final int DB_CACHED_COUNTS = 4;
    public static final int DB_CDB_ALLDB = 4096;
    public static final int DB_CHKSUM = 1;
    public static final int DB_CONSUME = 5;
    public static final int DB_CONSUME_WAIT = 6;
    public static final int DB_CREATE = 1;
    public static final int DB_CURRENT = 7;
    public static final int DB_CXX_NO_EXCEPTIONS = 2;
    public static final int DB_DBT_MALLOC = 4;
    public static final int DB_DBT_PARTIAL = 8;
    public static final int DB_DBT_REALLOC = 16;
    public static final int DB_DBT_USERMEM = 32;
    public static final int DB_DIRECT_DB = 8192;
    public static final int DB_DIRECT_LOG = 16384;
    public static final int DB_DIRTY_READ = 0x2000000;
    public static final int DB_DUP = 2;
    public static final int DB_DUPSORT = 4;
    public static final int DB_EID_BROADCAST = -1;
    public static final int DB_EID_INVALID = -2;
    public static final int DB_ENCRYPT = 8;
    public static final int DB_ENCRYPT_AES = 1;
    public static final int DB_EXCL = 4096;
    public static final int DB_FAST_STAT = 8;
    public static final int DB_FIRST = 9;
    public static final int DB_FLUSH = 1;
    public static final int DB_FORCE = 4;
    public static final int DB_GET_BOTH = 10;
    public static final int DB_GET_BOTH_RANGE = 12;
    public static final int DB_GET_RECNO = 13;
    public static final int DB_INIT_CDB = 4096;
    public static final int DB_INIT_LOCK = 8192;
    public static final int DB_INIT_LOG = 16384;
    public static final int DB_INIT_MPOOL = 32768;
    public static final int DB_INIT_REP = 65536;
    public static final int DB_INIT_TXN = 131072;
    public static final int DB_JOINENV = 262144;
    public static final int DB_JOIN_ITEM = 14;
    public static final int DB_JOIN_NOSORT = 1;
    public static final int DB_KEYFIRST = 15;
    public static final int DB_KEYLAST = 16;
    public static final int DB_LAST = 17;
    public static final int DB_LOCKDOWN = 524288;
    public static final int DB_LOCK_DEFAULT = 1;
    public static final int DB_LOCK_EXPIRE = 2;
    public static final int DB_LOCK_GET = 1;
    public static final int DB_LOCK_GET_TIMEOUT = 2;
    public static final int DB_LOCK_IREAD = 5;
    public static final int DB_LOCK_IWR = 6;
    public static final int DB_LOCK_IWRITE = 4;
    public static final int DB_LOCK_MAXLOCKS = 3;
    public static final int DB_LOCK_MINLOCKS = 4;
    public static final int DB_LOCK_MINWRITE = 5;
    public static final int DB_LOCK_NOWAIT = 1;
    public static final int DB_LOCK_OLDEST = 6;
    public static final int DB_LOCK_PUT = 4;
    public static final int DB_LOCK_PUT_ALL = 5;
    public static final int DB_LOCK_PUT_OBJ = 6;
    public static final int DB_LOCK_RANDOM = 7;
    public static final int DB_LOCK_READ = 1;
    public static final int DB_LOCK_TIMEOUT = 8;
    public static final int DB_LOCK_WRITE = 2;
    public static final int DB_LOCK_YOUNGEST = 8;
    public static final int DB_LOG_AUTOREMOVE = 32768;
    public static final int DB_MPOOL_NOFILE = 1;
    public static final int DB_MULTIPLE = 0x4000000;
    public static final int DB_MULTIPLE_KEY = 0x8000000;
    public static final int DB_NEXT = 18;
    public static final int DB_NEXT_DUP = 19;
    public static final int DB_NEXT_NODUP = 20;
    public static final int DB_NODUPDATA = 21;
    public static final int DB_NOLOCKING = 65536;
    public static final int DB_NOMMAP = 8;
    public static final int DB_NOORDERCHK = 2;
    public static final int DB_NOOVERWRITE = 22;
    public static final int DB_NOPANIC = 131072;
    public static final int DB_NOSYNC = 23;
    public static final int DB_ORDERCHKONLY = 4;
    public static final int DB_OVERWRITE = 262144;
    public static final int DB_PANIC_ENVIRONMENT = 524288;
    public static final int DB_POSITION = 24;
    public static final int DB_PREV = 25;
    public static final int DB_PREV_NODUP = 26;
    public static final int DB_PRINTABLE = 32;
    public static final int DB_PRIORITY_DEFAULT = 3;
    public static final int DB_PRIORITY_HIGH = 4;
    public static final int DB_PRIORITY_LOW = 2;
    public static final int DB_PRIORITY_VERY_HIGH = 5;
    public static final int DB_PRIORITY_VERY_LOW = 1;
    public static final int DB_PRIVATE = 0x100000;
    public static final int DB_RDONLY = 16;
    public static final int DB_RECNUM = 16;
    public static final int DB_RECORDCOUNT = 27;
    public static final int DB_RECOVER = 32;
    public static final int DB_RECOVER_FATAL = 0x200000;
    public static final int DB_REGION_INIT = 0x100000;
    public static final int DB_RENUMBER = 32;
    public static final int DB_REP_CLIENT = 1;
    public static final int DB_REP_ISPERM = -30984;
    public static final int DB_REP_LOGSONLY = 2;
    public static final int DB_REP_MASTER = 4;
    public static final int DB_REP_NOBUFFER = 1;
    public static final int DB_REP_NOTPERM = -30981;
    public static final int DB_REP_PERMANENT = 2;
    public static final int DB_REP_UNAVAIL = -30979;
    public static final int DB_REVSPLITOFF = 64;
    public static final int DB_RMW = 0x10000000;
    public static final int DB_RPCCLIENT = 1;
    public static final int DB_SALVAGE = 64;
    public static final int DB_SET = 28;
    public static final int DB_SET_LOCK_TIMEOUT = 29;
    public static final int DB_SET_RANGE = 30;
    public static final int DB_SET_RECNO = 31;
    public static final int DB_SET_TXN_TIMEOUT = 33;
    public static final int DB_SNAPSHOT = 128;
    public static final int DB_STAT_CLEAR = 1;
    public static final int DB_SYSTEM_MEM = 0x400000;
    public static final int DB_THREAD = 64;
    public static final int DB_TIME_NOTGRANTED = 0x200000;
    public static final int DB_TRUNCATE = 128;
    public static final int DB_TXN_NOSYNC = 256;
    public static final int DB_TXN_NOT_DURABLE = 512;
    public static final int DB_TXN_NOWAIT = 4096;
    public static final int DB_TXN_SYNC = 8192;
    public static final int DB_TXN_WRITE_NOSYNC = 0x400000;
    public static final int DB_UPGRADE = 1;
    public static final int DB_USE_ENVIRON = 1024;
    public static final int DB_USE_ENVIRON_ROOT = 2048;
    public static final int DB_VERB_CHKPOINT = 1;
    public static final int DB_VERB_DEADLOCK = 2;
    public static final int DB_VERB_RECOVERY = 4;
    public static final int DB_VERB_REPLICATION = 8;
    public static final int DB_VERB_WAITSFOR = 16;
    public static final int DB_VERIFY = 2;
    public static final int DB_VERSION_MAJOR = 4;
    public static final int DB_VERSION_MINOR = 2;
    public static final int DB_VERSION_PATCH = 52;
    public static final int DB_WRITECURSOR = 35;
    public static final int DB_XA_CREATE = 2;
    public static final int DB_XIDDATASIZE = 128;
    public static final int DB_YIELDCPU = 0x800000;

    protected Db(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected Db() {
        this(0L, false);
    }

    protected void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(Db db) {
        return db == null ? 0L : db.swigCPtr;
    }

    private void initialize(DbEnv dbEnv) {
        if (dbEnv == null) {
            this.private_dbenv = true;
            dbEnv = db_java.getDbEnv0(this);
            dbEnv.initialize();
        }
        this.dbenv = dbEnv;
        this.db_ref = db_java.initDbRef0(this, this);
    }

    private void cleanup() {
        this.swigCPtr = 0L;
        db_java.deleteRef0(this.db_ref);
        this.db_ref = null;
        if (this.private_dbenv) {
            this.dbenv.cleanup();
        }
        this.dbenv = null;
    }

    public synchronized void close(int n) throws DbException {
        try {
            this.close0(n);
            Object var3_2 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public DbEnv get_env() throws DbException {
        return this.getDbEnv();
    }

    public DbEnv getDbEnv() throws DbException {
        return this.dbenv;
    }

    private final void handle_append_recno(Dbt dbt, int n) throws DbException {
        this.append_recno_handler.dbAppendRecno(this, dbt, n);
    }

    private final int handle_bt_compare(Dbt dbt, Dbt dbt2) {
        return this.bt_compare_handler.compare(this, dbt, dbt2);
    }

    private final int handle_bt_prefix(Dbt dbt, Dbt dbt2) {
        return this.bt_prefix_handler.prefix(this, dbt, dbt2);
    }

    private final void handle_db_feedback(int n, int n2) {
        this.db_feedback_handler.feedback(this, n, n2);
    }

    private final int handle_dup_compare(Dbt dbt, Dbt dbt2) {
        return this.dup_compare_handler.compareDuplicates(this, dbt, dbt2);
    }

    private final int handle_h_hash(byte[] byArray, int n) {
        return this.h_hash_handler.hash(this, byArray, n);
    }

    private final int handle_seckey_create(Dbt dbt, Dbt dbt2, Dbt dbt3) throws DbException {
        return this.seckey_create_handler.secondaryKeyCreate(this, dbt, dbt2, dbt3);
    }

    public boolean isEncrypted() throws DbException {
        return this.get_encrypt_flags() != 0;
    }

    public void open(DbTxn dbTxn, String string, String string2, int n, int n2, int n3) throws DbException, FileNotFoundException, DbDeadlockException, DbLockNotGrantedException {
        this.open0(dbTxn, string, string2, n, n2 |= DB_THREAD, n3);
    }

    public int pget(DbTxn dbTxn, Dbt dbt, Dbt dbt2, Dbt dbt3, int n) throws DbException {
        return this.get(dbTxn, dbt, dbt2, dbt3, n);
    }

    public synchronized void remove(String string, String string2, int n) throws DbException, FileNotFoundException {
        try {
            this.remove0(string, string2, n);
            Object var5_4 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public synchronized void rename(String string, String string2, String string3, int n) throws DbException, FileNotFoundException {
        try {
            this.rename0(string, string2, string3, n);
            Object var6_5 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public synchronized void verify(String string, String string2, OutputStream outputStream, int n) throws DbException, FileNotFoundException {
        try {
            this.verify0(string, string2, outputStream, n);
            Object var6_5 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public void set_cachesize(int n, int n2, int n3) throws DbException {
        this.set_cachesize((long)n * 0x40000000L + (long)n2, n3);
    }

    public void set_errcall(DbErrcall dbErrcall) {
        final DbErrcall dbErrcall2 = dbErrcall;
        try {
            this.dbenv.setErrorHandler(new DbErrorHandler(){

                public void error(String string, String string2) {
                    dbErrcall2.errcall(string, string2);
                }
            });
        }
        catch (DbException dbException) {
            System.err.println("Exception during DbEnv.setErrorHandler: " + dbException);
            dbException.printStackTrace(System.err);
        }
    }

    public void setErrorHandler(DbErrorHandler dbErrorHandler) throws DbException {
        this.dbenv.setErrorHandler(dbErrorHandler);
    }

    public String get_errpfx() {
        return this.getErrorPrefix();
    }

    public String getErrorPrefix() {
        return this.dbenv.get_errpfx();
    }

    public void set_errpfx(String string) {
        this.setErrorPrefix(string);
    }

    public void setErrorPrefix(String string) {
        this.dbenv.set_errpfx(string);
    }

    public void set_error_stream(OutputStream outputStream) {
        this.setErrorStream(outputStream);
    }

    public void setErrorStream(OutputStream outputStream) {
        this.dbenv.set_error_stream(outputStream);
    }

    public void set_feedback(DbFeedback dbFeedback) throws DbException {
        final DbFeedback dbFeedback2 = dbFeedback;
        this.setFeedbackHandler(new DbFeedbackHandler(){

            public void feedback(Db db, int n, int n2) {
                dbFeedback2.feedback(db, n, n2);
            }
        });
    }

    public void setPanicHandler(DbPanicHandler dbPanicHandler) throws DbException {
        this.dbenv.setPanicHandler(dbPanicHandler);
    }

    public Db(DbEnv dbEnv, int n) throws DbException {
        this(db_javaJNI.new_Db(DbEnv.getCPtr(dbEnv), n), true);
        this.initialize(dbEnv);
    }

    public void associate(DbTxn dbTxn, Db db, DbSecondaryKeyCreate dbSecondaryKeyCreate, int n) throws DbException {
        db.seckey_create_handler = dbSecondaryKeyCreate;
        db_javaJNI.Db_associate(this.swigCPtr, DbTxn.getCPtr(dbTxn), Db.getCPtr(db), db.seckey_create_handler, n);
    }

    int close0(int n) {
        return db_javaJNI.Db_close0(this.swigCPtr, n);
    }

    public Dbc cursor(DbTxn dbTxn, int n) throws DbException {
        long l = db_javaJNI.Db_cursor(this.swigCPtr, DbTxn.getCPtr(dbTxn), n);
        return l == 0L ? null : new Dbc(l, false);
    }

    public int del(DbTxn dbTxn, Dbt dbt, int n) throws DbException {
        return this.delete(dbTxn, dbt, n);
    }

    public int delete(DbTxn dbTxn, Dbt dbt, int n) throws DbException {
        return db_javaJNI.Db_del(this.swigCPtr, DbTxn.getCPtr(dbTxn), dbt, n);
    }

    public void err(int n, String string) {
        db_javaJNI.Db_err(this.swigCPtr, n, string);
    }

    public void errx(String string) {
        db_javaJNI.Db_errx(this.swigCPtr, string);
    }

    public int get(DbTxn dbTxn, Dbt dbt, Dbt dbt2, int n) throws DbException {
        return db_javaJNI.Db_get__SWIG_0(this.swigCPtr, DbTxn.getCPtr(dbTxn), dbt, dbt2, n);
    }

    public boolean get_byteswapped() throws DbException {
        return this.isByteSwapped();
    }

    public boolean isByteSwapped() throws DbException {
        return db_javaJNI.Db_get_byteswapped(this.swigCPtr);
    }

    public long get_cachesize() throws DbException {
        return this.getCacheSize();
    }

    public long getCacheSize() throws DbException {
        return db_javaJNI.Db_get_cachesize(this.swigCPtr);
    }

    public int get_cachesize_ncache() throws DbException {
        return this.getCacheSizeNcache();
    }

    public int getCacheSizeNcache() throws DbException {
        return db_javaJNI.Db_get_cachesize_ncache(this.swigCPtr);
    }

    public String get_filename() throws DbException {
        return this.getFileName();
    }

    public String getFileName() throws DbException {
        return db_javaJNI.Db_get_filename(this.swigCPtr);
    }

    public String get_dbname() throws DbException {
        return this.getDatabaseName();
    }

    public String getDatabaseName() throws DbException {
        return db_javaJNI.Db_get_dbname(this.swigCPtr);
    }

    public int get_encrypt_flags() throws DbException {
        return this.getEncryptFlags();
    }

    public int getEncryptFlags() throws DbException {
        return db_javaJNI.Db_get_encrypt_flags(this.swigCPtr);
    }

    public int get_flags() throws DbException {
        return this.getFlags();
    }

    public int getFlags() throws DbException {
        return db_javaJNI.Db_get_flags(this.swigCPtr);
    }

    public int get_lorder() throws DbException {
        return this.getByteOrder();
    }

    public int getByteOrder() throws DbException {
        return db_javaJNI.Db_get_lorder(this.swigCPtr);
    }

    public DbMpoolFile get_mpf() throws DbException {
        long l = db_javaJNI.Db_get_mpf(this.swigCPtr);
        return l == 0L ? null : new DbMpoolFile(l, false);
    }

    public int get_open_flags() throws DbException {
        return this.getOpenFlags();
    }

    public int getOpenFlags() throws DbException {
        return db_javaJNI.Db_get_open_flags(this.swigCPtr);
    }

    public int get_pagesize() throws DbException {
        return this.getPageSize();
    }

    public int getPageSize() throws DbException {
        return db_javaJNI.Db_get_pagesize(this.swigCPtr);
    }

    public int get_bt_minkey() throws DbException {
        return this.getBtreeMinKey();
    }

    public int getBtreeMinKey() throws DbException {
        return db_javaJNI.Db_get_bt_minkey(this.swigCPtr);
    }

    public int get_h_ffactor() throws DbException {
        return this.getHashFillFactor();
    }

    public int getHashFillFactor() throws DbException {
        return db_javaJNI.Db_get_h_ffactor(this.swigCPtr);
    }

    public int get_h_nelem() throws DbException {
        return this.getHashNumElements();
    }

    public int getHashNumElements() throws DbException {
        return db_javaJNI.Db_get_h_nelem(this.swigCPtr);
    }

    public int get_re_delim() throws DbException {
        return this.getRecordDelimiter();
    }

    public int getRecordDelimiter() throws DbException {
        return db_javaJNI.Db_get_re_delim(this.swigCPtr);
    }

    public int get_re_len() throws DbException {
        return this.getRecordLength();
    }

    public int getRecordLength() throws DbException {
        return db_javaJNI.Db_get_re_len(this.swigCPtr);
    }

    public int get_re_pad() throws DbException {
        return this.getRecordPad();
    }

    public int getRecordPad() throws DbException {
        return db_javaJNI.Db_get_re_pad(this.swigCPtr);
    }

    public String get_re_source() throws DbException {
        return this.getRecordSource();
    }

    public String getRecordSource() throws DbException {
        return db_javaJNI.Db_get_re_source(this.swigCPtr);
    }

    public int get_q_extentsize() throws DbException {
        return this.getQueueExtentSize();
    }

    public int getQueueExtentSize() throws DbException {
        return db_javaJNI.Db_get_q_extentsize(this.swigCPtr);
    }

    public int get_flags_raw() throws DbException {
        return db_javaJNI.Db_get_flags_raw(this.swigCPtr);
    }

    public boolean get_transactional() throws DbException {
        return this.isTransactional();
    }

    public boolean isTransactional() throws DbException {
        return db_javaJNI.Db_get_transactional(this.swigCPtr);
    }

    public int get_type() throws DbException {
        return this.getDbType();
    }

    public int getDbType() throws DbException {
        return db_javaJNI.Db_get_type(this.swigCPtr);
    }

    public Dbc join(Dbc[] dbcArray, int n) throws DbException {
        long l = db_javaJNI.Db_join(this.swigCPtr, dbcArray, n);
        return l == 0L ? null : new Dbc(l, true);
    }

    public void key_range(DbTxn dbTxn, Dbt dbt, DbKeyRange dbKeyRange, int n) throws DbException {
        this.keyRange(dbTxn, dbt, dbKeyRange, n);
    }

    public void keyRange(DbTxn dbTxn, Dbt dbt, DbKeyRange dbKeyRange, int n) throws DbException {
        db_javaJNI.Db_key_range(this.swigCPtr, DbTxn.getCPtr(dbTxn), dbt, dbKeyRange, n);
    }

    void open0(DbTxn dbTxn, String string, String string2, int n, int n2, int n3) {
        db_javaJNI.Db_open0(this.swigCPtr, DbTxn.getCPtr(dbTxn), string, string2, n, n2, n3);
    }

    public int get(DbTxn dbTxn, Dbt dbt, Dbt dbt2, Dbt dbt3, int n) throws DbException {
        return db_javaJNI.Db_get__SWIG_1(this.swigCPtr, DbTxn.getCPtr(dbTxn), dbt, dbt2, dbt3, n);
    }

    public int put(DbTxn dbTxn, Dbt dbt, Dbt dbt2, int n) throws DbException {
        return db_javaJNI.Db_put(this.swigCPtr, DbTxn.getCPtr(dbTxn), dbt, dbt2, n);
    }

    void remove0(String string, String string2, int n) {
        db_javaJNI.Db_remove0(this.swigCPtr, string, string2, n);
    }

    void rename0(String string, String string2, String string3, int n) {
        db_javaJNI.Db_rename0(this.swigCPtr, string, string2, string3, n);
    }

    public void set_append_recno(DbAppendRecno dbAppendRecno) throws DbException {
        this.setAppendRecno(dbAppendRecno);
    }

    public void setAppendRecno(DbAppendRecno dbAppendRecno) throws DbException {
        this.append_recno_handler = dbAppendRecno;
        db_javaJNI.Db_set_append_recno(this.swigCPtr, this.append_recno_handler);
    }

    public void set_bt_compare(DbBtreeCompare dbBtreeCompare) throws DbException {
        this.setBtreeCompare(dbBtreeCompare);
    }

    public void setBtreeCompare(DbBtreeCompare dbBtreeCompare) throws DbException {
        this.bt_compare_handler = dbBtreeCompare;
        db_javaJNI.Db_set_bt_compare(this.swigCPtr, this.bt_compare_handler);
    }

    public void set_bt_maxkey(int n) throws DbException {
        db_javaJNI.Db_set_bt_maxkey(this.swigCPtr, n);
    }

    public void set_bt_minkey(int n) throws DbException {
        this.setBtreeMinKey(n);
    }

    public void setBtreeMinKey(int n) throws DbException {
        db_javaJNI.Db_set_bt_minkey(this.swigCPtr, n);
    }

    public void set_bt_prefix(DbBtreePrefix dbBtreePrefix) throws DbException {
        this.setBtreePrefix(dbBtreePrefix);
    }

    public void setBtreePrefix(DbBtreePrefix dbBtreePrefix) throws DbException {
        this.bt_prefix_handler = dbBtreePrefix;
        db_javaJNI.Db_set_bt_prefix(this.swigCPtr, this.bt_prefix_handler);
    }

    public void set_cachesize(long l, int n) throws DbException {
        this.setCacheSize(l, n);
    }

    public void setCacheSize(long l, int n) throws DbException {
        db_javaJNI.Db_set_cachesize(this.swigCPtr, l, n);
    }

    public void set_dup_compare(DbDupCompare dbDupCompare) throws DbException {
        this.setDuplicateCompare(dbDupCompare);
    }

    public void setDuplicateCompare(DbDupCompare dbDupCompare) throws DbException {
        this.dup_compare_handler = dbDupCompare;
        db_javaJNI.Db_set_dup_compare(this.swigCPtr, this.dup_compare_handler);
    }

    public void set_encrypt(String string, int n) throws DbException {
        this.setEncrypted(string, n);
    }

    public void setEncrypted(String string, int n) throws DbException {
        db_javaJNI.Db_set_encrypt(this.swigCPtr, string, n);
    }

    public void setFeedbackHandler(DbFeedbackHandler dbFeedbackHandler) throws DbException {
        this.db_feedback_handler = dbFeedbackHandler;
        db_javaJNI.Db_setFeedbackHandler(this.swigCPtr, this.db_feedback_handler);
    }

    public void set_flags(int n) throws DbException {
        this.setFlags(n);
    }

    public void setFlags(int n) throws DbException {
        db_javaJNI.Db_set_flags(this.swigCPtr, n);
    }

    public void set_h_ffactor(int n) throws DbException {
        this.setHashFillFactor(n);
    }

    public void setHashFillFactor(int n) throws DbException {
        db_javaJNI.Db_set_h_ffactor(this.swigCPtr, n);
    }

    public void set_h_hash(DbHash dbHash) throws DbException {
        this.setHash(dbHash);
    }

    public void setHash(DbHash dbHash) throws DbException {
        this.h_hash_handler = dbHash;
        db_javaJNI.Db_set_h_hash(this.swigCPtr, this.h_hash_handler);
    }

    public void set_h_nelem(int n) throws DbException {
        this.setHashNumElements(n);
    }

    public void setHashNumElements(int n) throws DbException {
        db_javaJNI.Db_set_h_nelem(this.swigCPtr, n);
    }

    public void set_lorder(int n) throws DbException {
        this.setByteOrder(n);
    }

    public void setByteOrder(int n) throws DbException {
        db_javaJNI.Db_set_lorder(this.swigCPtr, n);
    }

    public void set_pagesize(long l) throws DbException {
        this.setPageSize(l);
    }

    public void setPageSize(long l) throws DbException {
        db_javaJNI.Db_set_pagesize(this.swigCPtr, l);
    }

    public void set_re_delim(int n) throws DbException {
        this.setRecordDelimiter(n);
    }

    public void setRecordDelimiter(int n) throws DbException {
        db_javaJNI.Db_set_re_delim(this.swigCPtr, n);
    }

    public void set_re_len(int n) throws DbException {
        this.setRecordLength(n);
    }

    public void setRecordLength(int n) throws DbException {
        db_javaJNI.Db_set_re_len(this.swigCPtr, n);
    }

    public void set_re_pad(int n) throws DbException {
        this.setRecordPad(n);
    }

    public void setRecordPad(int n) throws DbException {
        db_javaJNI.Db_set_re_pad(this.swigCPtr, n);
    }

    public void set_re_source(String string) throws DbException {
        this.setRecordSource(string);
    }

    public void setRecordSource(String string) throws DbException {
        db_javaJNI.Db_set_re_source(this.swigCPtr, string);
    }

    public void set_q_extentsize(int n) throws DbException {
        this.setQueueExtentSize(n);
    }

    public void setQueueExtentSize(int n) throws DbException {
        db_javaJNI.Db_set_q_extentsize(this.swigCPtr, n);
    }

    public Object stat(int n) throws DbException {
        return db_javaJNI.Db_stat(this.swigCPtr, n);
    }

    public void sync(int n) throws DbException {
        db_javaJNI.Db_sync(this.swigCPtr, n);
    }

    public int truncate(DbTxn dbTxn, int n) throws DbException {
        return db_javaJNI.Db_truncate(this.swigCPtr, DbTxn.getCPtr(dbTxn), n);
    }

    public void upgrade(String string, int n) throws DbException {
        db_javaJNI.Db_upgrade(this.swigCPtr, string, n);
    }

    void verify0(String string, String string2, OutputStream outputStream, int n) {
        db_javaJNI.Db_verify0(this.swigCPtr, string, string2, outputStream, n);
    }
}

