/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataDb;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.IntegrityConstraintException;
import com.sleepycat.bdb.RecordNumberFormat;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.KeyExtractor;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.Dbc;
import java.io.IOException;

public class DataIndex {
    DataDb db;
    DataStore store;
    DataFormat keyFormat;
    KeyExtractor keyExtractor;

    public DataIndex(DataStore dataStore, Db db, DataFormat dataFormat, KeyExtractor keyExtractor) {
        this.store = dataStore;
        this.keyFormat = dataFormat;
        this.keyExtractor = keyExtractor;
        this.db = new DataDb(db);
        if (dataStore.db.isTransactional() != this.db.isTransactional()) {
            throw new IllegalArgumentException(this.db + " and " + dataStore.db + " must must both be transactional or non-transactional");
        }
        if (this.db.areDuplicatesAllowed() && !this.db.areDuplicatesOrdered()) {
            throw new IllegalArgumentException(this.db + " must use sorted duplicates for index");
        }
        if (!dataFormat.equals(keyExtractor.getIndexKeyFormat())) {
            throw new IllegalArgumentException(this.db + " extractor index key format mismatch");
        }
        if (keyExtractor.getPrimaryKeyFormat() != null && !dataStore.keyFormat.equals(keyExtractor.getPrimaryKeyFormat())) {
            throw new IllegalArgumentException(this.db + " extractor primary key format mismatch");
        }
        if (keyExtractor.getValueFormat() != null && !dataStore.valueFormat.equals(keyExtractor.getValueFormat())) {
            throw new IllegalArgumentException(this.db + " extractor value format mismatch");
        }
        if (dataFormat instanceof RecordNumberFormat && !this.db.hasRecNumAccess()) {
            throw new IllegalArgumentException(this.db + " RecordNumberFormat is only allowed when the" + " access method has record number keys");
        }
        dataStore.addIndex(this);
    }

    public final DataStore getStore() {
        return this.store;
    }

    public final DataFormat getKeyFormat() {
        return this.keyFormat;
    }

    public final KeyExtractor getKeyExtractor() {
        return this.keyExtractor;
    }

    public String toString() {
        return this.db.toString();
    }

    void applyChange(DataThang dataThang, DataThang dataThang2, DataThang dataThang3) throws DbException, IOException {
        DataThang dataThang4 = null;
        if (dataThang2 != null) {
            dataThang4 = new DataThang();
            this.keyExtractor.extractIndexKey(this.keyExtractor.getPrimaryKeyFormat() != null ? dataThang : null, this.keyExtractor.getValueFormat() != null ? dataThang2 : null, dataThang4);
            if (dataThang4.getDataLength() == 0) {
                dataThang4 = null;
            }
        }
        DataThang dataThang5 = null;
        if (dataThang3 != null) {
            dataThang5 = new DataThang();
            this.keyExtractor.extractIndexKey(this.keyExtractor.getPrimaryKeyFormat() != null ? dataThang : null, this.keyExtractor.getValueFormat() != null ? dataThang3 : null, dataThang5);
            if (dataThang5.getDataLength() == 0) {
                dataThang5 = null;
            }
        }
        if (dataThang4 == null && dataThang5 == null) {
            return;
        }
        if (dataThang4 != null && dataThang5 != null && dataThang4.compareTo(dataThang5) == 0) {
            return;
        }
        if (dataThang4 != null) {
            this.applyIndexDelete(dataThang, dataThang4);
        }
        if (dataThang5 != null) {
            this.applyIndexInsert(dataThang, dataThang5);
        }
    }

    void applyIndexDelete(DataThang dataThang, DataThang dataThang2) throws DbException, IOException {
        Dbc dbc = this.db.openCursor(true);
        try {
            int n = dbc.get(dataThang2, dataThang, Db.DB_GET_BOTH | this.store.db.env.getWriteLockFlag());
            if (n != 0) {
                throw new IntegrityConstraintException("Index entry not found");
            }
            dbc.delete(0);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.db.closeCursor(dbc);
            throw throwable;
        }
        this.db.closeCursor(dbc);
    }

    void applyIndexInsert(DataThang dataThang, DataThang dataThang2) throws DbException, IOException {
        int n = this.db.put(dataThang2, dataThang, Db.DB_NODUPDATA);
        if (n != 0) {
            throw new IntegrityConstraintException("Index entry already exists");
        }
    }
}

