/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataDb;
import com.sleepycat.bdb.DataEnvironment;
import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.KeyRange;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbc;
import java.io.IOException;

public final class DataCursor {
    private Dbc cursor;
    private DbTxn txn;
    private DataView view;
    private DataEnvironment env;
    private DataDb db;
    private KeyRange range;
    private boolean writeAllowed;
    private boolean dirtyRead;
    private DataThang keyThang;
    private DataThang valueThang;
    private DataThang primaryKeyThang;
    private DataThang otherThang;
    private int cursorDbType;
    private DataCursor[] indexCursorsToClose;
    private boolean closeDirect;
    private boolean isJoinCursor;

    public DataCursor(DataView dataView, boolean bl) throws DbException, IOException {
        this.init(dataView, bl, null, null);
    }

    public DataCursor(DataView dataView, boolean bl, Object object) throws DbException, IOException {
        this.init(dataView, bl, dataView.subRange(object), null);
    }

    public DataCursor(DataView dataView, boolean bl, Object object, boolean bl2, Object object2, boolean bl3) throws DbException, IOException {
        this.init(dataView, bl, dataView.subRange(object, bl2, object2, bl3), null);
    }

    public DataCursor(DataCursor dataCursor) throws DbException, IOException {
        this.view = dataCursor.view;
        this.env = dataCursor.env;
        this.db = dataCursor.db;
        this.writeAllowed = dataCursor.writeAllowed;
        this.dirtyRead = dataCursor.dirtyRead;
        this.initThangs();
        this.keyThang.copy(dataCursor.keyThang);
        this.valueThang.copy(dataCursor.valueThang);
        if (this.primaryKeyThang != this.keyThang) {
            this.primaryKeyThang.copy(dataCursor.primaryKeyThang);
        }
        this.range = dataCursor.range;
        this.cursor = this.db.dupCursor(dataCursor.cursor, this.writeAllowed, Db.DB_POSITION);
        this.txn = dataCursor.txn;
        this.closeDirect = false;
    }

    DataCursor(DataView dataView, DataCursor[] dataCursorArray, boolean bl, boolean bl2) throws DbException, IOException {
        Object object;
        this.isJoinCursor = true;
        if (dataView.index != null) {
            throw new IllegalArgumentException("Primary view in join must not be indexed");
        }
        Dbc[] dbcArray = new Dbc[dataCursorArray.length];
        int n = 0;
        while (n < dbcArray.length) {
            object = dataCursorArray[n].view.index;
            if (object == null || ((DataIndex)object).store != dataView.store) {
                throw new IllegalArgumentException("Join cursor for view " + object + " is not indexed on primary store " + dataView.store);
            }
            dbcArray[n] = dataCursorArray[n].cursor;
            ++n;
        }
        object = dataView.store.db.db.join(dbcArray, bl ? Db.DB_JOIN_NOSORT : 0);
        this.init(dataView, false, null, (Dbc)object);
        if (bl2) {
            this.indexCursorsToClose = dataCursorArray;
        }
    }

    private void init(DataView dataView, boolean bl, KeyRange keyRange, Dbc dbc) throws DbException, IOException {
        this.view = dataView;
        this.env = dataView.store.db.env;
        this.range = keyRange != null ? keyRange : new KeyRange(dataView.range);
        this.writeAllowed = bl && dataView.isWriteAllowed();
        this.dirtyRead = dataView.dirtyRead;
        this.initThangs();
        this.db = dataView.index != null ? dataView.index.db : dataView.store.db;
        this.cursorDbType = this.db.db.getDbType();
        if (dbc != null) {
            this.cursor = dbc;
            this.closeDirect = true;
        } else {
            this.cursor = this.db.openCursor(this.writeAllowed);
            this.closeDirect = false;
        }
    }

    private void initThangs() throws DbException, IOException {
        this.keyThang = new DataThang();
        this.primaryKeyThang = this.view.index != null ? new DataThang() : this.keyThang;
        this.valueThang = new DataThang();
    }

    public void close() throws DbException, IOException {
        DataCursor[] dataCursorArray;
        if (this.cursor != null) {
            dataCursorArray = this.cursor;
            this.cursor = null;
            if (this.closeDirect) {
                dataCursorArray.close();
            } else {
                this.db.closeCursor((Dbc)dataCursorArray);
            }
        }
        if (this.indexCursorsToClose != null) {
            dataCursorArray = this.indexCursorsToClose;
            this.indexCursorsToClose = null;
            int n = 0;
            while (n < dataCursorArray.length) {
                dataCursorArray[n].close();
                ++n;
            }
        }
    }

    public DataView getView() {
        return this.view;
    }

    KeyRange getRange() {
        return this.range;
    }

    public boolean isWriteAllowed() {
        return this.writeAllowed;
    }

    public Object getCurrentKey() throws DbException, IOException {
        if (this.view.keyBinding == null) {
            throw new UnsupportedOperationException("getCurrentKey requires keyBinding");
        }
        return this.view.makeKey(this.keyThang);
    }

    public Object getCurrentValue() throws DbException, IOException {
        return this.view.makeValue(this.primaryKeyThang, this.valueThang);
    }

    public boolean hasRecNumAccess() {
        return this.db.hasRecNumAccess();
    }

    public int getCurrentRecordNumber() throws DbException, IOException {
        if (this.cursorDbType == 1) {
            if (this.otherThang == null) {
                this.otherThang = new DataThang();
            }
            DataThang dataThang = DataThang.getDiscardDataThang();
            this.cursor.get(dataThang, this.otherThang, Db.DB_GET_RECNO);
            return this.otherThang.get_recno_key_data();
        }
        return this.keyThang.get_recno_key_data();
    }

    public int get(Object object, Object object2, int n, boolean bl) throws DbException, IOException {
        int n2 = 0;
        if (this.view.btreeRecNumAccess && n == Db.DB_SET) {
            n = Db.DB_SET_RECNO;
        }
        int n3 = n;
        int n4 = 0;
        if (n == Db.DB_GET_BOTH) {
            this.view.useValue(object2, this.valueThang, null);
            n2 = this.view.useKey(object, object2, this.keyThang, this.range);
            n3 = Db.DB_SET;
            n4 = n;
        } else if (n == Db.DB_SET || n == Db.DB_SET_RANGE || n == Db.DB_SET_RECNO) {
            n2 = this.view.useKey(object, object2, this.keyThang, this.range);
        } else {
            if (n == Db.DB_GET_RECNO || n == Db.DB_JOIN_ITEM) {
                throw new IllegalArgumentException("flag not supported: " + n);
            }
            if (object != null || object2 != null) {
                throw new IllegalArgumentException("key and value must be null");
            }
        }
        if (n2 == 0) {
            n2 = this.lowLevelGet(n, n3, n4, bl);
        }
        return n2;
    }

    public int find(Object object, boolean bl) throws DbException, IOException {
        int n;
        if (this.isJoinCursor) {
            throw new UnsupportedOperationException();
        }
        this.view.useValue(object, this.valueThang, null);
        if (this.view.entityBinding != null && this.view.index == null && (bl || !this.view.areDuplicatesAllowed())) {
            n = this.view.useKey(null, object, this.keyThang, this.range);
            if (n == 0) {
                n = this.lowLevelGet(Db.DB_GET_BOTH, Db.DB_SET, Db.DB_GET_BOTH, false);
            }
        } else {
            if (this.otherThang == null) {
                this.otherThang = new DataThang();
            }
            this.otherThang.copy(this.valueThang);
            int n2 = bl ? Db.DB_FIRST : Db.DB_LAST;
            n = 0;
            while (n == 0) {
                n = this.get(null, null, n2, false);
                if (n == 0 && this.valueThang.compareTo(this.otherThang) == 0) break;
                int n3 = n2 = bl ? Db.DB_NEXT : Db.DB_PREV;
            }
        }
        return n;
    }

    public int count() throws DbException, IOException {
        if (this.isJoinCursor) {
            throw new UnsupportedOperationException();
        }
        return this.cursor.count(0);
    }

    public int put(Object object, Object object2, int n, Object[] objectArray) throws DbException, IOException {
        return this.put(object, object2, n, objectArray, false);
    }

    public int put(Object object, Object object2, int n, Object[] objectArray, boolean bl) throws DbException, IOException {
        DataThang dataThang;
        if (this.isJoinCursor) {
            throw new UnsupportedOperationException();
        }
        if (this.view.index != null) {
            throw new UnsupportedOperationException("put with index not allowed");
        }
        boolean bl2 = false;
        int n2 = 0;
        if (n == Db.DB_CURRENT) {
            bl2 = true;
        } else if (n != Db.DB_AFTER && n != Db.DB_BEFORE) {
            if (!bl && (n2 = this.view.useKey(object, object2, this.keyThang, this.range)) != 0) {
                throw new IllegalArgumentException("key out of range");
            }
            if (n == 0) {
                int n3 = n = this.view.areDuplicatesOrdered() ? Db.DB_NODUPDATA : Db.DB_KEYFIRST;
            }
            if (n == Db.DB_KEYFIRST || n == Db.DB_KEYLAST) {
                if (!this.view.areDuplicatesAllowed() && (n2 = this.lowLevelGet(Db.DB_SET, 0, 0, true)) == 0) {
                    bl2 = true;
                }
            } else if (n != Db.DB_NODUPDATA) {
                throw new IllegalArgumentException("flag unknown: " + n);
            }
        }
        if (bl2) {
            if (objectArray != null) {
                objectArray[0] = this.getCurrentValue();
            }
            if (this.otherThang == null) {
                this.otherThang = new DataThang();
            }
            this.otherThang.copy(this.valueThang);
            dataThang = this.otherThang;
        } else {
            if (objectArray != null) {
                objectArray[0] = null;
            }
            dataThang = null;
        }
        DataThang dataThang2 = n == Db.DB_AFTER ? null : this.keyThang;
        this.view.useValue(object2, this.valueThang, dataThang2);
        n2 = this.db.put(this.cursor, this.keyThang, this.valueThang, n);
        if (n2 == 0) {
            this.view.store.applyChange(this.primaryKeyThang, dataThang, this.valueThang);
        }
        return n2;
    }

    public int delete() throws DbException, IOException {
        if (this.isJoinCursor || !this.writeAllowed) {
            throw new UnsupportedOperationException();
        }
        int n = this.view.index != null ? this.view.store.db.delete(this.primaryKeyThang, 0) : this.cursor.delete(0);
        if (n == 0) {
            this.view.store.applyChange(this.primaryKeyThang, this.valueThang, null);
        }
        return n;
    }

    private int lowLevelGet(int n, int n2, int n3, boolean bl) throws DbException {
        int n4;
        int n5 = 0;
        if (this.dirtyRead) {
            n5 |= Db.DB_DIRTY_READ;
        }
        if (bl && !this.dirtyRead && !this.env.isDirtyRead()) {
            n5 |= this.env.getWriteLockFlag();
        }
        this.keyThang.clearDataFormation();
        this.primaryKeyThang.clearDataFormation();
        this.valueThang.clearDataFormation();
        if (this.view.index != null) {
            if (this.isJoinCursor) {
                throw new UnsupportedOperationException();
            }
            if (this.view.btreeRecNumAccess && n2 == Db.DB_SET) {
                n2 = Db.DB_SET_RECNO;
            }
            if ((n4 = this.range.get(this.db, this.cursor, this.keyThang, this.primaryKeyThang, n2 | n5)) == 0) {
                n4 = this.view.store.db.get(this.primaryKeyThang, this.valueThang, n3 | n5);
            }
        } else {
            if (this.isJoinCursor) {
                if (n != Db.DB_FIRST && n != Db.DB_NEXT && n != Db.DB_NEXT_NODUP) {
                    throw new UnsupportedOperationException();
                }
                n = 0;
                n5 = 0;
            }
            if (this.view.btreeRecNumAccess && n == Db.DB_SET) {
                n = Db.DB_SET_RECNO;
            }
            n4 = this.range.get(this.db, this.cursor, this.keyThang, this.valueThang, n | n5);
        }
        return n4;
    }
}

