/*
 *  Copyright (C) 2005  Andreas Volz
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File: VertexVector.h
 *  Andreas Volz <linux@brachttal.net>
 *   
 */

#ifndef VERTEXVECTOR_H
#define VERTEXVECTOR_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <iostream>
#include <fstream>
#include "Vertex.h"
#include "FileReader.h"

namespace Animorph {

/*!
The format of Vertices file:
\verbatim
<float>,<float>,<float>
...
\endverbatim
*/
class VertexVector : public std::vector <Vertex>
{
private:
  void fromStream (std::ifstream &in_stream);


public:
  bool load (const std::string& filename);

  int setCoordinates (std::vector <Vector3f> &vertexvector);
};

}

#endif	// VERTEXVECTOR_H
